/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer.metrics.internals;

import com.linkedin.kafka.cruisecontrol.common.CellResource;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.model.Tenant;
import io.confluent.databalancer.metrics.CellOverloadMetrics;
import io.confluent.databalancer.metrics.internals.TenantResourceStats;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public final class TenantUtilizationMetricHandler {
    private static final String TENANT_UTILIZATION_METRIC_PREFIX = "tenant-utilization-";
    private static final int NUM_TENANT_PER_RESOURCE = 10;
    private final long maxReplicasPerBroker;
    private final CellOverloadMetrics cellOverloadMetrics;
    private final Map<CellResource, Map<String, TenantResourceStats>> resourceStatsByResourceAndTenantId;

    public TenantUtilizationMetricHandler(KafkaCruiseControlConfig config, CellOverloadMetrics cellOverloadMetrics) {
        this.maxReplicasPerBroker = config.getLong("max.replicas");
        this.cellOverloadMetrics = cellOverloadMetrics;
        this.resourceStatsByResourceAndTenantId = new ConcurrentHashMap<CellResource, Map<String, TenantResourceStats>>();
    }

    public void update(ClusterModel clusterModel) {
        CellResource.cachedValues().forEach(resource -> {
            Map<String, TenantResourceStats> resourceStatsOfTenantsWithMostUsedResource = this.resourceStatsOfTenantsWithMostUsedResource(clusterModel, (CellResource)((Object)resource));
            this.refreshResourceMetrics((CellResource)((Object)resource), resourceStatsOfTenantsWithMostUsedResource);
        });
    }

    private void refreshResourceMetrics(CellResource resource, Map<String, TenantResourceStats> newResourceStatsByTenantId) {
        String tenantId;
        Map resourceStatsByTenantId = this.resourceStatsByResourceAndTenantId.computeIfAbsent(resource, k -> new ConcurrentHashMap());
        ArrayList<String> tenantIdsToRemove = new ArrayList<String>();
        for (Map.Entry entry : resourceStatsByTenantId.entrySet()) {
            tenantId = (String)entry.getKey();
            if (newResourceStatsByTenantId.containsKey(tenantId)) continue;
            this.cellOverloadMetrics.removeMetrics(resource, tenantId);
            tenantIdsToRemove.add(tenantId);
        }
        for (String string : tenantIdsToRemove) {
            resourceStatsByTenantId.remove(string);
        }
        for (Map.Entry<Object, Object> entry : newResourceStatsByTenantId.entrySet()) {
            tenantId = (String)entry.getKey();
            TenantResourceStats newTenantResourceStats = (TenantResourceStats)entry.getValue();
            if (!resourceStatsByTenantId.containsKey(tenantId)) {
                this.cellOverloadMetrics.newTenantGauge(resource, tenantId, this.tenantUtilizationMetricName(resource), () -> this.resourceUtilizationValue(resource, tenantId));
            }
            resourceStatsByTenantId.put(tenantId, newTenantResourceStats);
        }
    }

    private double resourceUtilizationValue(CellResource resource, String tenantId) {
        return Optional.ofNullable(this.resourceStatsByResourceAndTenantId.get((Object)resource)).map(resourceStatsByTenantId -> (TenantResourceStats)resourceStatsByTenantId.get(tenantId)).map(TenantResourceStats::utilizationValue).orElse(0.0);
    }

    private Map<String, TenantResourceStats> resourceStatsOfTenantsWithMostUsedResource(ClusterModel clusterModel, CellResource resource) {
        List<Tenant> sortedTenants = clusterModel.tenantsSortedByCellResource(resource);
        return sortedTenants.stream().limit(10L).collect(Collectors.toMap(Tenant::tenantId, tenant -> this.resourceStats(clusterModel, (Tenant)tenant, resource)));
    }

    private TenantResourceStats resourceStats(ClusterModel clusterModel, Tenant tenant, CellResource resource) {
        double utilizationValue;
        double cellCapacityValue;
        int cellId = tenant.cellId();
        switch (resource) {
            case REPLICA_COUNT: {
                cellCapacityValue = Optional.ofNullable(clusterModel.cell(cellId)).map(cell -> (double)this.maxReplicasPerBroker * (double)cell.brokers().size()).orElse(0.0);
                utilizationValue = tenant.replicaCount();
                break;
            }
            default: {
                cellCapacityValue = Optional.ofNullable(clusterModel.cell(cellId)).map(cell -> cell.eligibleDestinationCapacityValue(resource.resource())).orElse(0.0);
                utilizationValue = tenant.eligibleSourceUtilizationValue(resource.resource());
            }
        }
        return new TenantResourceStats(cellId, tenant.tenantId(), resource, cellCapacityValue, utilizationValue);
    }

    private String tenantUtilizationMetricName(CellResource resource) {
        return TENANT_UTILIZATION_METRIC_PREFIX + resource.name().toLowerCase(Locale.ROOT);
    }
}

