/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer.operation;

import io.confluent.databalancer.ConfluentDataBalanceEngine;
import io.confluent.databalancer.metrics.DataBalancerMetricsUtils;
import io.confluent.databalancer.metrics.GeneralSBCMetricsRegistry;
import io.confluent.databalancer.operation.BrokerAdditionStateMachine;
import io.confluent.databalancer.operation.BrokerAdditionStateManager;
import io.confluent.databalancer.operation.SingleBrokerBalancerOperationProgressListener;
import io.confluent.databalancer.operation.SingleBrokerBalancerOperationTerminationListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import kafka.common.BrokerAdditionDescriptionInternal;
import org.apache.kafka.common.protocol.BalancerOperationOverriddenException;
import org.apache.kafka.common.utils.SystemTime;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerAdditionV1Context {
    public static final String BROKER_ADDITION_STATE_METRIC_NAME = "BrokerAdditionOperationState";
    private static final Logger LOG = LoggerFactory.getLogger(BrokerAdditionV1Context.class);
    private final SingleBrokerBalancerOperationTerminationListener<BrokerAdditionStateMachine.BrokerAdditionState> additionTerminationListener;
    private final SingleBrokerBalancerOperationProgressListener<BrokerAdditionStateMachine.BrokerAdditionState> additionProgressListener;
    private final Map<Integer, BrokerAdditionStateManager> brokerAdditionsStateManagers;
    private final GeneralSBCMetricsRegistry generalSBCMetricsRegistry;

    public BrokerAdditionV1Context(GeneralSBCMetricsRegistry generalSBCMetricsRegistry) {
        this.generalSBCMetricsRegistry = generalSBCMetricsRegistry;
        this.additionTerminationListener = (brokerId, state, e) -> LOG.info("Addition operation for broker {} reached terminal state {}", new Object[]{brokerId, state, e});
        this.additionProgressListener = (brokerId, state, e) -> LOG.info("Addition status for broker {} changed to {}", new Object[]{brokerId, state, e});
        this.brokerAdditionsStateManagers = new ConcurrentHashMap<Integer, BrokerAdditionStateManager>();
    }

    public BrokerAdditionStateManager initializeAddition(int brokerId) {
        BrokerAdditionStateManager stateManager = new BrokerAdditionStateManager(brokerId, this.additionProgressListener, this.additionTerminationListener, this.registerBrokerAdditionMetric(brokerId), (Time)new SystemTime());
        stateManager.initialize();
        this.brokerAdditionsStateManagers.put(brokerId, stateManager);
        return stateManager;
    }

    public void overrideAllPendingBrokerAdditions(BrokerAdditionStateMachine.BrokerAdditionEvent event, String cause) {
        if (!event.canCancel()) {
            throw new IllegalArgumentException(String.format("Cannot override broker additions with event %s (cause %s)", event, cause));
        }
        ArrayList<Integer> cancelledAdditions = new ArrayList<Integer>();
        int brokerId = -1;
        try {
            for (BrokerAdditionStateManager stateManager : this.brokerAdditionsStateManagers.values()) {
                brokerId = stateManager.brokerId();
                if (stateManager.isAtATerminalState()) continue;
                String errMsg = String.format("The broker addition operation for broker %d was cancelled due to a %s which overrode it", brokerId, cause);
                stateManager.registerEvent(event, (Exception)new BalancerOperationOverriddenException(errMsg));
                cancelledAdditions.add(brokerId);
            }
        }
        catch (Exception e) {
            LOG.error("Received exception when trying to cancel the addition for broker {}", (Object)brokerId, (Object)e);
        }
        if (!cancelledAdditions.isEmpty()) {
            LOG.info("Cancelled broker additions for brokers {} due to a {}", cancelledAdditions, (Object)cause);
        }
    }

    public List<BrokerAdditionDescriptionInternal> brokerAdditions() {
        return this.brokerAdditionsStateManagers.values().stream().map(brokerAdditionStateManager -> new BrokerAdditionDescriptionInternal(brokerAdditionStateManager.brokerId(), brokerAdditionStateManager.currentState().status(), BrokerAdditionStateMachine.convertBrokerAdditionStatus(brokerAdditionStateManager.currentState().status()), brokerAdditionStateManager.creationTimeMs(), brokerAdditionStateManager.lastUpdateTimeMs(), (Exception)brokerAdditionStateManager.exception().orElse(null))).collect(Collectors.toList());
    }

    public Set<Integer> brokersBeingAdded() {
        return this.brokerAdditionsStateManagers.values().stream().filter(manager -> !manager.isAtATerminalState()).map(BrokerAdditionStateManager::brokerId).collect(Collectors.toSet());
    }

    private AtomicReference<String> registerBrokerAdditionMetric(int brokerId) {
        AtomicReference<String> stateReference = new AtomicReference<String>("NOT_STARTED");
        this.generalSBCMetricsRegistry.newGauge(ConfluentDataBalanceEngine.class, BROKER_ADDITION_STATE_METRIC_NAME, stateReference::get, true, DataBalancerMetricsUtils.brokerIdMetricTag(brokerId));
        return stateReference;
    }
}

