/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer.startup;

import com.linkedin.kafka.cruisecontrol.KafkaCruiseControl;
import com.linkedin.kafka.cruisecontrol.client.BlockingSendClient;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import io.confluent.databalancer.ConfluentDataBalanceEngineContext;
import io.confluent.databalancer.DatabalancerUtils;
import io.confluent.databalancer.EngineInitializationContext;
import io.confluent.databalancer.metrics.CellOverloadMetrics;
import io.confluent.databalancer.metrics.GeneralSBCMetricsRegistry;
import io.confluent.databalancer.startup.StartupComponents;
import io.confluent.databalancer.utils.OperationRetryer;
import io.confluent.telemetry.ConfluentTelemetryConfig;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Semaphore;
import kafka.server.KafkaConfig;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.internals.BalancerConfigs;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.errors.BalancerJbodEnabledMisconfigurationException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CruiseControlStartable {
    private static final Logger LOG = LoggerFactory.getLogger(CruiseControlStartable.class);
    private static final String SHUTDOWN_MANAGER_CLIENT_ID = "SBC-broker-shutdown-manager";
    private final ConfluentDataBalanceEngineContext confluentDataBalanceEngineContext;
    private final EngineInitializationContext engineInitializationContext;
    private final KafkaCruiseControlConfig kccConfig;

    public CruiseControlStartable(ConfluentDataBalanceEngineContext confluentDataBalanceEngineContext, EngineInitializationContext engineInitializationContext) {
        this.confluentDataBalanceEngineContext = Objects.requireNonNull(confluentDataBalanceEngineContext);
        this.engineInitializationContext = Objects.requireNonNull(engineInitializationContext);
        this.kccConfig = this.generateCruiseControlConfig();
    }

    public KafkaCruiseControlConfig kafkaCruiseControlConfig() {
        return this.kccConfig;
    }

    public OperationRetryer<KafkaCruiseControl> createStartupRetryer() {
        return new OperationRetryer<KafkaCruiseControl>(this.confluentDataBalanceEngineContext.getTime(), Duration.ofHours(this.kccConfig.getInt("startup.retry.max.hours").intValue()), Duration.ofMinutes(this.kccConfig.getInt("startup.retry.delay.minutes").intValue()), "Starting DataBalanceEngine");
    }

    public KafkaCruiseControl createKafkaCruiseControl(Semaphore abortStartupCheck) {
        KafkaConfig kafkaConfig = this.engineInitializationContext.kafkaConfig();
        Time time = this.confluentDataBalanceEngineContext.getTime();
        GeneralSBCMetricsRegistry generalSBCMetricsRegistry = this.confluentDataBalanceEngineContext.getDataBalancerMetricsRegistry();
        CellOverloadMetrics cellOverloadMetrics = this.confluentDataBalanceEngineContext.getCellOverloadMetrics();
        EngineInitializationContext.EngineStartupType howStarted = this.engineInitializationContext.engineStartupType();
        BlockingSendClient.Builder blockingSendClientBuilder = new BlockingSendClient.Builder(kafkaConfig, time, SHUTDOWN_MANAGER_CLIENT_ID, new LogContext());
        StartupComponents components = new StartupComponents.Builder(abortStartupCheck).build(this.kccConfig);
        LOG.info("DataBalancer: Checking startup components");
        components.checkStartupCondition();
        LOG.info("DataBalancer: Creating CruiseControl");
        return new KafkaCruiseControl(DatabalancerUtils.getBrokerId(kafkaConfig), this.kccConfig, generalSBCMetricsRegistry, cellOverloadMetrics, blockingSendClientBuilder, howStarted.ccStartupMode());
    }

    public final KafkaCruiseControlConfig generateCruiseControlConfig() {
        String topicKey;
        Map kccProps;
        String metricsReporterTopic;
        KafkaConfig config = this.engineInitializationContext.kafkaConfig();
        HashMap<String, Object> ccConfigProps = new HashMap<String, Object>(config.originalsWithPrefix("confluent.balancer."));
        ccConfigProps.putIfAbsent("zookeeper.connect", config.get("zookeeper.connect"));
        List<String> logDirs = DatabalancerUtils.getConfiguredLogDirs(config);
        if (logDirs == null || logDirs.size() == 0) {
            throw new ConfigException("Broker configured with null or empty log directory");
        }
        if (logDirs.size() > 1) {
            throw new BalancerJbodEnabledMisconfigurationException("SBK configured with multiple log directories");
        }
        ccConfigProps.put("log.dirs", logDirs.get(0));
        ccConfigProps.putIfAbsent("zookeeper.security.enabled", config.zkEnableSecureAcls());
        Object enableCells = Optional.ofNullable(config.get("confluent.cells.enable")).orElse(false);
        ccConfigProps.put("confluent.cells.enable", enableCells);
        this.configureCruiseControlSelfHealing(ccConfigProps);
        if (ccConfigProps.get("bootstrap.servers") == null) {
            ccConfigProps.putAll(this.generateClientConfigs());
        }
        LOG.info("DataBalancer: BOOTSTRAP_SERVERS determined to be {}", ccConfigProps.get("bootstrap.servers"));
        List rebalanceGoals = config.getList("confluent.balancer.rebalancing.goals");
        List triggerGoals = config.getList("confluent.balancer.triggering.goals");
        if (this.validateGoalsConfig(rebalanceGoals, triggerGoals)) {
            LOG.info("DataBalancer: SBC Goals defined to be {}->({}), {}->({})", new Object[]{"confluent.balancer.rebalancing.goals", rebalanceGoals, "confluent.balancer.triggering.goals", triggerGoals});
            ccConfigProps.put(KafkaCruiseControlConfig.internalGoalsConfigName("confluent.balancer.rebalancing.goals"), rebalanceGoals);
            ccConfigProps.put(KafkaCruiseControlConfig.internalGoalsConfigName("confluent.balancer.triggering.goals"), triggerGoals);
        }
        boolean incrementalBalancingEnabled = config.getBoolean("confluent.balancer.incremental.balancing.enabled");
        List incrementalBalancingGoals = config.getList("confluent.balancer.incremental.balancing.goals");
        ccConfigProps.put("incremental.balancing.enabled", incrementalBalancingEnabled);
        if (incrementalBalancingGoals != null && !incrementalBalancingGoals.isEmpty()) {
            ccConfigProps.put("incremental.balancing.goals", incrementalBalancingGoals);
        }
        if ((metricsReporterTopic = (String)(kccProps = config.originals()).get(topicKey = ConfluentTelemetryConfig.exporterPrefixForName((String)"_local") + "topic.name")) != null && metricsReporterTopic.length() > 0) {
            ccConfigProps.putIfAbsent("confluent.telemetry.reporter.topic", metricsReporterTopic);
        }
        ccConfigProps.put("topics.excluded.from.partition.movement", DatabalancerUtils.generateCcTopicExclusionRegex(config));
        return new KafkaCruiseControlConfig(ccConfigProps);
    }

    private boolean validateGoalsConfig(List<String> providedRebalancingGoals, List<String> providedTriggeringGoals) {
        if (providedRebalancingGoals.isEmpty() && providedTriggeringGoals.isEmpty()) {
            return false;
        }
        BalancerConfigs.validateGoalsConfig(providedRebalancingGoals, providedTriggeringGoals);
        return true;
    }

    private void configureCruiseControlSelfHealing(Map<String, Object> cruiseControlProps) {
        KafkaConfig config = this.engineInitializationContext.kafkaConfig();
        Long brokerFailureSelfHealingThreshold = config.getLong("confluent.balancer.heal.broker.failure.threshold.ms");
        boolean brokerFailureSelfHealingEnabled = !brokerFailureSelfHealingThreshold.equals(ConfluentConfigs.BALANCER_BROKER_FAILURE_THRESHOLD_DISABLED);
        cruiseControlProps.putIfAbsent("self.healing.broker.failure.enabled", brokerFailureSelfHealingEnabled);
        if (brokerFailureSelfHealingEnabled) {
            cruiseControlProps.putIfAbsent("broker.failure.self.healing.threshold.ms", brokerFailureSelfHealingThreshold);
        }
        if (config.getString("confluent.balancer.heal.uneven.load.trigger").equals(ConfluentConfigs.BalancerSelfHealMode.ANY_UNEVEN_LOAD.toString())) {
            cruiseControlProps.putIfAbsent("self.healing.goal.violation.enabled", true);
        } else {
            cruiseControlProps.putIfAbsent("self.healing.goal.violation.enabled", false);
        }
    }

    public final Map<String, Object> generateClientConfigs() {
        Endpoint bootstrapServerEndpoint;
        KafkaConfig config = this.engineInitializationContext.kafkaConfig();
        ListenerName interBrokerListenerName = config.interBrokerListenerName();
        Optional bootstrapServerEndpointFromAliveBrokersMetadata = this.engineInitializationContext.aliveBrokersMetadata().flatMap(aliveBrokersMetadata -> aliveBrokersMetadata.endpointFor(interBrokerListenerName));
        Optional<Endpoint> bootstrapServerEndpointFromEngineInitializationContext = this.engineInitializationContext.bootstrapServerEndpoint();
        if (bootstrapServerEndpointFromAliveBrokersMetadata.isPresent()) {
            bootstrapServerEndpoint = (Endpoint)bootstrapServerEndpointFromAliveBrokersMetadata.get();
        } else if (bootstrapServerEndpointFromEngineInitializationContext.isPresent()) {
            bootstrapServerEndpoint = bootstrapServerEndpointFromEngineInitializationContext.get();
        } else {
            throw new IllegalArgumentException(String.format("Bootstrap server endpoint was not provided in engine initialization context and could not be found with a listener name %s from the broker metadata", interBrokerListenerName));
        }
        LOG.info("DataBalancer: Bootstrap server endpoint is {}", (Object)bootstrapServerEndpoint);
        return ConfluentConfigs.clientConfigsForEndpoint((AbstractConfig)config, (Endpoint)bootstrapServerEndpoint);
    }
}

