/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.secretregistry.rest;

import io.confluent.kafka.secretregistry.rest.SecretRegistryConfig;
import io.confluent.kafka.secretregistry.rest.SecretRegistryRestApplication;
import io.confluent.rest.RestConfigException;
import java.io.IOException;
import org.eclipse.jetty.server.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecretRegistryMain {
    private static final Logger log = LoggerFactory.getLogger(SecretRegistryMain.class);

    public static void main(String[] args) throws IOException {
        try {
            if (args.length != 1) {
                log.error("Properties file is required to start the secret registry REST instance");
                System.exit(1);
            }
            SecretRegistryConfig config = new SecretRegistryConfig(args[0]);
            SecretRegistryRestApplication app = new SecretRegistryRestApplication(config);
            Server server = app.createServer();
            server.start();
            log.info("Server started, listening for requests...");
            server.join();
        }
        catch (RestConfigException e) {
            log.error("Server configuration failed: ", (Throwable)e);
            System.exit(1);
        }
        catch (Exception e) {
            log.error("Server died unexpectedly: ", (Throwable)e);
            System.exit(1);
        }
    }
}

