/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.secretregistry.rest.exceptions;

import io.confluent.kafka.secretregistry.rest.exceptions.RestInvalidKeyException;
import io.confluent.kafka.secretregistry.rest.exceptions.RestInvalidVersionException;
import io.confluent.kafka.secretregistry.rest.exceptions.RestOperationNotPermittedException;
import io.confluent.kafka.secretregistry.rest.exceptions.RestRequestForwardingException;
import io.confluent.kafka.secretregistry.rest.exceptions.RestSecretRegistryException;
import io.confluent.kafka.secretregistry.rest.exceptions.RestSecretRegistryStoreException;
import io.confluent.kafka.secretregistry.rest.exceptions.RestSecretRegistryTimeoutException;
import io.confluent.kafka.secretregistry.rest.exceptions.RestUnknownMasterException;
import io.confluent.rest.exceptions.RestException;
import io.confluent.rest.exceptions.RestNotFoundException;

public class Errors {
    public static final String PATH_NOT_FOUND_MESSAGE = "Path not found.";
    public static final int PATH_NOT_FOUND_ERROR_CODE = 40401;
    public static final String VERSION_NOT_FOUND_MESSAGE = "Version not found.";
    public static final int VERSION_NOT_FOUND_ERROR_CODE = 40402;
    public static final String KEY_NOT_FOUND_MESSAGE = "Key not found.";
    public static final int KEY_NOT_FOUND_ERROR_CODE = 40403;
    public static final String SECRET_NOT_FOUND_MESSAGE = "Secret not found";
    public static final int SECRET_NOT_FOUND_ERROR_CODE = 40404;
    public static final int INVALID_VERSION_ERROR_CODE = 42201;
    public static final int OPERATION_NOT_PERMITTED_ERROR_CODE = 42202;
    public static final int INVALID_KEY_ERROR_CODE = 42203;
    public static final int STORE_ERROR_CODE = 50001;
    public static final int OPERATION_TIMEOUT_ERROR_CODE = 50002;
    public static final int REQUEST_FORWARDING_FAILED_ERROR_CODE = 50003;
    public static final int UNKNOWN_MASTER_ERROR_CODE = 50004;

    public static RestException pathNotFoundException() {
        return new RestNotFoundException(PATH_NOT_FOUND_MESSAGE, 40401);
    }

    public static RestException keyNotFoundException() {
        return new RestNotFoundException(KEY_NOT_FOUND_MESSAGE, 40403);
    }

    public static RestException versionNotFoundException() {
        return new RestNotFoundException(VERSION_NOT_FOUND_MESSAGE, 40402);
    }

    public static RestException secretNotFoundException() {
        return new RestNotFoundException(SECRET_NOT_FOUND_MESSAGE, 40404);
    }

    public static RestInvalidVersionException invalidVersionException() {
        return new RestInvalidVersionException();
    }

    public static RestInvalidKeyException invalidKeyException(String message) {
        return new RestInvalidKeyException(message);
    }

    public static RestException secretRegistryException(String message, Throwable cause) {
        return new RestSecretRegistryException(message, cause);
    }

    public static RestException storeException(String message, Throwable cause) {
        return new RestSecretRegistryStoreException(message, cause);
    }

    public static RestException operationTimeoutException(String message, Throwable cause) {
        return new RestSecretRegistryTimeoutException(message, cause);
    }

    public static RestOperationNotPermittedException operationNotPermittedException(String message) {
        return new RestOperationNotPermittedException(message);
    }

    public static RestException requestForwardingFailedException(String message, Throwable cause) {
        return new RestRequestForwardingException(message, cause);
    }

    public static RestException unknownMasterException(String message, Throwable cause) {
        return new RestUnknownMasterException(message, cause);
    }
}

