/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.secretregistry.rest.resources;

import io.confluent.kafka.secretregistry.client.rest.entities.Secret;
import io.confluent.kafka.secretregistry.client.rest.entities.requests.RegisterSecretRequest;
import io.confluent.kafka.secretregistry.client.rest.entities.requests.RegisterSecretResponse;
import io.confluent.kafka.secretregistry.exceptions.InvalidVersionException;
import io.confluent.kafka.secretregistry.exceptions.OperationNotPermittedException;
import io.confluent.kafka.secretregistry.exceptions.SecretRegistryException;
import io.confluent.kafka.secretregistry.exceptions.SecretRegistryRequestForwardingException;
import io.confluent.kafka.secretregistry.exceptions.SecretRegistryStoreException;
import io.confluent.kafka.secretregistry.exceptions.SecretRegistryTimeoutException;
import io.confluent.kafka.secretregistry.exceptions.UnknownMasterException;
import io.confluent.kafka.secretregistry.rest.VersionId;
import io.confluent.kafka.secretregistry.rest.exceptions.Errors;
import io.confluent.kafka.secretregistry.rest.resources.RequestHeaderBuilder;
import io.confluent.kafka.secretregistry.storage.KafkaSecretRegistry;
import io.confluent.rest.annotations.PerformanceMetric;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.SecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/secret/paths/{path}/keys/{key}/versions")
@Produces(value={"application/vnd.secretregistry.v1+json", "application/vnd.secretregistry+json; qs=0.9", "application/json; qs=0.5"})
@Consumes(value={"application/vnd.secretregistry.v1+json", "application/vnd.secretregistry+json", "application/json", "application/octet-stream"})
public class PathKeyVersionResource {
    private static final Logger log = LoggerFactory.getLogger(PathKeyVersionResource.class);
    private final KafkaSecretRegistry secretRegistry;
    private final RequestHeaderBuilder requestHeaderBuilder = new RequestHeaderBuilder();

    public PathKeyVersionResource(KafkaSecretRegistry registry) {
        this.secretRegistry = registry;
    }

    @GET
    @Path(value="/{version}")
    @PerformanceMetric(value="paths.keys.versions.get-secret")
    public Secret getSecret(@Context SecurityContext securityContext, @PathParam(value="path") String path, @PathParam(value="key") String key, @PathParam(value="version") String version) {
        if (securityContext.getUserPrincipal() != null) {
            String name = securityContext.getUserPrincipal().getName();
            log.info("User '{}' getting secret '{}:{}' version {}", new Object[]{name, path, key, version});
        } else {
            log.info("Unknown user getting secret '{}:{}' version {}", new Object[]{path, key, version});
        }
        VersionId versionId = null;
        try {
            versionId = new VersionId(version);
        }
        catch (InvalidVersionException e) {
            throw Errors.invalidVersionException();
        }
        Secret secret = null;
        String errorMessage = null;
        try {
            secret = this.secretRegistry.validateAndGetSecret(path, key, versionId);
        }
        catch (SecretRegistryStoreException e) {
            errorMessage = "Error while retrieving secret for path " + path + " with key " + key + " with version " + version + " from the secret registry";
            log.debug(errorMessage, (Throwable)e);
            throw Errors.storeException(errorMessage, e);
        }
        catch (InvalidVersionException e) {
            throw Errors.invalidVersionException();
        }
        catch (SecretRegistryException e) {
            throw Errors.secretRegistryException(errorMessage, e);
        }
        return secret;
    }

    @GET
    @Path(value="/{version}/secret")
    @PerformanceMetric(value="paths.keys.versions.get-secret.only")
    public String getSecretOnly(@Context SecurityContext securityContext, @PathParam(value="path") String path, @PathParam(value="key") String key, @PathParam(value="version") String version) {
        return this.getSecret(securityContext, path, key, version).getSecret();
    }

    @GET
    @PerformanceMetric(value="paths.keys.versions.list")
    public List<Integer> list(@Context SecurityContext securityContext, @PathParam(value="path") String path, @PathParam(value="key") String key) {
        if (securityContext.getUserPrincipal() != null) {
            String name = securityContext.getUserPrincipal().getName();
            log.info("User '{}' listing versions for '{}:{}'", new Object[]{name, path, key});
        } else {
            log.info("Unknown user listing versions for '{}:{}'", (Object)path, (Object)key);
        }
        String errorMessage = "Error while validating that path " + path + " and key " + key + " exist in the registry";
        try {
            if (!this.secretRegistry.listPaths().contains(path)) {
                throw Errors.pathNotFoundException();
            }
            if (!this.secretRegistry.listKeys(path).contains(key)) {
                throw Errors.keyNotFoundException();
            }
        }
        catch (SecretRegistryStoreException e) {
            throw Errors.storeException(errorMessage, e);
        }
        catch (SecretRegistryException e) {
            throw Errors.secretRegistryException(errorMessage, e);
        }
        errorMessage = "Error while listing all versions for path " + path + " and key " + key;
        try {
            return this.secretRegistry.listVersions(path, key);
        }
        catch (SecretRegistryStoreException e) {
            throw Errors.storeException(errorMessage, e);
        }
        catch (SecretRegistryException e) {
            throw Errors.secretRegistryException(errorMessage, e);
        }
    }

    @POST
    @PerformanceMetric(value="paths.keys.versions.register")
    public void register(@Suspended AsyncResponse asyncResponse, @Context SecurityContext securityContext, @Context HttpHeaders headers, @PathParam(value="path") String path, @PathParam(value="key") String key, @NotNull RegisterSecretRequest request) {
        int id;
        if (securityContext.getUserPrincipal() != null) {
            String name = securityContext.getUserPrincipal().getName();
            log.info("User '{}' registering secret '{}:{}'", new Object[]{name, path, key});
        } else {
            log.info("Unknown user registering secret '{}:{}'", (Object)path, (Object)key);
        }
        if (!this.isKeyValid(key)) {
            throw Errors.invalidKeyException("Key must start from a-z or A-Z");
        }
        Map<String, String> headerProperties = this.requestHeaderBuilder.buildRequestHeaders(headers, this.secretRegistry.config().whitelistHeaders());
        Secret secret = new Secret(path, key, Integer.valueOf(0), request.getSecret());
        try {
            id = this.secretRegistry.registerOrForward(secret, headerProperties);
        }
        catch (OperationNotPermittedException e) {
            throw Errors.operationNotPermittedException(e.getMessage());
        }
        catch (SecretRegistryTimeoutException e) {
            throw Errors.operationTimeoutException("Register operation timed out", e);
        }
        catch (SecretRegistryStoreException e) {
            throw Errors.storeException("Register secret operation failed while writing to the Kafka store", e);
        }
        catch (SecretRegistryRequestForwardingException e) {
            throw Errors.requestForwardingFailedException("Error while forwarding register secret request to the master", e);
        }
        catch (UnknownMasterException e) {
            throw Errors.unknownMasterException("Master not known.", e);
        }
        catch (SecretRegistryException e) {
            throw Errors.secretRegistryException("Error while registering secret", e);
        }
        RegisterSecretResponse registerSecretResponse = new RegisterSecretResponse();
        registerSecretResponse.setVersion(id);
        asyncResponse.resume((Object)registerSecretResponse);
    }

    @DELETE
    @Path(value="/{version}")
    @PerformanceMetric(value="paths.keys.versions.delete-secret")
    public void deleteSecretVersion(@Suspended AsyncResponse asyncResponse, @Context SecurityContext securityContext, @Context HttpHeaders headers, @PathParam(value="path") String path, @PathParam(value="key") String key, @PathParam(value="version") String version) {
        if (securityContext.getUserPrincipal() != null) {
            String name = securityContext.getUserPrincipal().getName();
            log.info("User '{}' deleting secret '{}:{}' version {}", new Object[]{name, path, key, version});
        } else {
            log.info("Unknown user deleting secret '{}:{}' version {}", new Object[]{path, key, version});
        }
        VersionId versionId = null;
        try {
            versionId = new VersionId(version);
        }
        catch (InvalidVersionException e) {
            throw Errors.invalidVersionException();
        }
        Secret secret = null;
        String errorMessage = null;
        try {
            secret = this.secretRegistry.validateAndGetSecret(path, key, versionId);
        }
        catch (SecretRegistryStoreException e) {
            errorMessage = "Error while retrieving secret for path " + path + " with key " + key + " with version " + version + " from the secret registry";
            log.debug(errorMessage, (Throwable)e);
            throw Errors.storeException(errorMessage, e);
        }
        catch (InvalidVersionException e) {
            throw Errors.invalidVersionException();
        }
        catch (SecretRegistryException e) {
            throw Errors.secretRegistryException(errorMessage, e);
        }
        try {
            Map<String, String> headerProperties = this.requestHeaderBuilder.buildRequestHeaders(headers, this.secretRegistry.config().whitelistHeaders());
            this.secretRegistry.deleteVersionOrForward(headerProperties, secret.getPath(), secret.getKey(), secret.getVersion());
        }
        catch (SecretRegistryTimeoutException e) {
            throw Errors.operationTimeoutException("Delete Secret Version operation timed out", e);
        }
        catch (SecretRegistryStoreException e) {
            throw Errors.storeException("Delete Secret Version operation failed while writing to the Kafka store", e);
        }
        catch (SecretRegistryRequestForwardingException e) {
            throw Errors.requestForwardingFailedException("Error while forwarding delete secret version request to the master", e);
        }
        catch (UnknownMasterException e) {
            throw Errors.unknownMasterException("Master not known.", e);
        }
        catch (SecretRegistryException e) {
            throw Errors.secretRegistryException("Error while deleting Secret Version", e);
        }
        asyncResponse.resume((Object)versionId.getVersionId());
    }

    private boolean isKeyValid(String key) {
        if (key != null) {
            char firstChar = key.charAt(0);
            return firstChar >= 'A' && firstChar <= 'Z' || firstChar >= 'a' && firstChar <= 'z';
        }
        return false;
    }
}

