/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.secretregistry.storage.serialization;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.kafka.secretregistry.storage.NoopKey;
import io.confluent.kafka.secretregistry.storage.SecretKey;
import io.confluent.kafka.secretregistry.storage.SecretRegistryKey;
import io.confluent.kafka.secretregistry.storage.SecretRegistryKeyType;
import io.confluent.kafka.secretregistry.storage.SecretRegistryValue;
import io.confluent.kafka.secretregistry.storage.SecretValue;
import io.confluent.kafka.secretregistry.storage.exceptions.SerializationException;
import io.confluent.kafka.secretregistry.storage.serialization.Serializer;
import java.io.IOException;
import java.util.Map;

public class SecretRegistrySerializer
implements Serializer<SecretRegistryKey, SecretRegistryValue> {
    @Override
    public byte[] serializeKey(SecretRegistryKey key) throws SerializationException {
        try {
            return new ObjectMapper().writeValueAsBytes((Object)key);
        }
        catch (IOException e) {
            throw new SerializationException("Error while serializing secret key" + key.toString(), e);
        }
    }

    @Override
    public byte[] serializeValue(SecretRegistryValue value) throws SerializationException {
        try {
            return new ObjectMapper().writeValueAsBytes((Object)value);
        }
        catch (IOException e) {
            throw new SerializationException("Error while serializing value secret value " + value.toString(), e);
        }
    }

    @Override
    public SecretRegistryKey deserializeKey(byte[] key) throws SerializationException {
        SecretRegistryKey secretKey = null;
        Enum keyType = null;
        try {
            try {
                Map keyObj = null;
                keyObj = (Map)new ObjectMapper().readValue(key, (TypeReference)new TypeReference<Map<Object, Object>>(){});
                keyType = SecretRegistryKeyType.forName((String)keyObj.get("keytype"));
                if (keyType == SecretRegistryKeyType.NOOP) {
                    secretKey = (SecretRegistryKey)new ObjectMapper().readValue(key, NoopKey.class);
                } else if (keyType == SecretRegistryKeyType.SECRET) {
                    secretKey = (SecretRegistryKey)new ObjectMapper().readValue(key, SecretKey.class);
                    this.validateMagicByte((SecretKey)secretKey);
                }
            }
            catch (JsonProcessingException e) {
                String type = "unknown";
                if (keyType != null) {
                    type = keyType.name();
                }
                throw new SerializationException("Failed to deserialize " + type + " key", e);
            }
        }
        catch (IOException e) {
            throw new SerializationException("Error while deserializing secret key", e);
        }
        return secretKey;
    }

    @Override
    public SecretRegistryValue deserializeValue(SecretRegistryKey key, byte[] value) throws SerializationException {
        SecretRegistryValue secretRegistryValue = null;
        if (key.getKeyType().equals((Object)SecretRegistryKeyType.SECRET)) {
            try {
                this.validateMagicByte((SecretKey)key);
                secretRegistryValue = (SecretRegistryValue)new ObjectMapper().readValue(value, SecretValue.class);
            }
            catch (IOException e) {
                throw new SerializationException("Error while deserializing secret", e);
            }
        } else {
            throw new SerializationException("Unrecognized key type. Must be one of secret or config");
        }
        return secretRegistryValue;
    }

    @Override
    public void close() {
    }

    public void configure(Map<String, ?> stringMap) {
    }

    private void validateMagicByte(SecretKey secretKey) throws SerializationException {
        if (secretKey.getMagicByte() != 0 && secretKey.getMagicByte() != 1) {
            throw new SerializationException("Can't deserialize secret for the magic byte " + secretKey.getMagicByte());
        }
    }
}

