/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.events.exporter.kafka;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import io.cloudevents.core.message.Encoding;
import io.confluent.telemetry.events.exporter.ExporterConfig;
import io.confluent.telemetry.events.exporter.kafka.RandomBrokerPartitionSubsetPartitioner;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Utils;

public class KafkaExporterConfig
extends ExporterConfig {
    static final String ACKS_CONFIG = "all";
    static final String COMPRESSION_TYPE_CONFIG = "lz4";
    static final String INTERCEPTOR_CLASSES_CONFIG = "";
    static final String KEY_SERIALIZER_CLASS_CONFIG = "org.apache.kafka.common.serialization.StringSerializer";
    static final String LINGER_MS_CONFIG = "500";
    static final int MAX_IN_FLIGHT_REQUESTS_PER_CONNECTION = 1;
    static final long RETRY_BACKOFF_MS_CONFIG = 500L;
    static final String VALUE_SERIALIZER_CLASS_CONFIG = "org.apache.kafka.common.serialization.ByteArraySerializer";
    public static final int MAX_REQUEST_SIZE = 0x800000;
    public static final int DEFAULT_MIN_ISR = 1;
    public static final Map<String, Object> PRODUCER_CONFIG_DEFAULTS = ImmutableMap.builder().put((Object)"acks", (Object)"all").put((Object)"compression.type", (Object)"lz4").put((Object)"key.serializer", (Object)"org.apache.kafka.common.serialization.StringSerializer").put((Object)"value.serializer", (Object)"org.apache.kafka.common.serialization.ByteArraySerializer").put((Object)"linger.ms", (Object)"500").put((Object)"interceptor.classes", (Object)"").put((Object)"retry.backoff.ms", (Object)500L).put((Object)"max.in.flight.requests.per.connection", (Object)1).put((Object)"max.request.size", (Object)0x800000).put((Object)"enable.idempotence", (Object)"false").build();
    public static final String PREFIX_PRODUCER = "producer.";
    public static final String PREFIX_TOPIC = "topic.";
    public static final String BOOTSTRAP_SERVERS_CONFIG = "producer.bootstrap.servers";
    public static final String BOOTSTRAP_SERVERS_DOC = "Bootstrap servers for the Kafka cluster telemetry will be published to. The target cluster may be different from the cluster(s) whose telemetry is being collected. Several production Kafka clusters can publish to a single target Kafka cluster, for example.";
    public static final String TOPIC_NAME_CONFIG = "topic.name";
    public static final String TOPIC_NAME_DOC = "Topic to which telemetry data will be written.";
    public static final String DEFAULT_TOPIC_NAME = "_confluent-telemetry-events";
    public static final String TOPIC_CREATE_CONFIG = "topic.create";
    public static final String TOPIC_CREATE_DOC = "Create the topic if it does not exist.";
    public static final boolean DEFAULT_TOPIC_CREATE = true;
    public static final String TOPIC_PARTITIONS_CONFIG = "topic.partitions";
    public static final String TOPIC_PARTITIONS_DOC = "Number of partitions in the events topic.";
    public static final int DEFAULT_TOPIC_PARTITIONS = 12;
    public static final String TOPIC_REPLICAS_CONFIG = "topic.replicas";
    public static final String TOPIC_REPLICAS_DOC = "Number of replicas in the telemetry topic. It must not be higher than the number of brokers in the destination Kafka cluster.";
    public static final int DEFAULT_TOPIC_REPLICAS = 3;
    public static final String TOPIC_RETENTION_MS_CONFIG = "topic.retention.ms";
    public static final String TOPIC_RETENTION_MS_DOC = "Retention time for the topic.";
    public static final long DEFAULT_TOPIC_RETENTION_MS = TimeUnit.DAYS.toMillis(3L);
    public static final String TOPIC_RETENTION_BYTES_CONFIG = "topic.retention.bytes";
    public static final String TOPIC_RETENTION_BYTES_DOC = "Retention bytes for the topic.";
    public static final long DEFAULT_TOPIC_RETENTION_BYTES = -1L;
    public static final String TOPIC_ROLL_MS_CONFIG = "topic.roll.ms";
    public static final String TOPIC_ROLL_MS_DOC = "Log rolling time for the topic.";
    public static final long DEFAULT_TOPIC_ROLL_MS = TimeUnit.HOURS.toMillis(4L);
    public static final String TOPIC_MAX_MESSAGE_BYTES_CONFIG = "topic.max.message.bytes";
    public static final String TOPIC_MAX_MESSAGE_BYTES_DOC = "Maximum message size for the topic.";
    public static final int DEFAULT_TOPIC_MAX_MESSAGE_BYTES = 0x800000;
    public static final String CLOUD_EVENT_STRUCTURED_ENCODING = "structured";
    public static final String CLOUD_EVENT_BINARY_ENCODING = "binary";
    public static final String CLOUD_EVENT_ENCODING_CONFIG = "cloudevent.codec";
    public static final String DEFAULT_CLOUD_EVENT_ENCODING_CONFIG = "binary";
    public static final String CLOUD_EVENT_ENCODING_DOC = "Which cloudevent encoding to use. Use binary encoding by default";
    public static final String EVENT_QUEUE_SIZE = "event.queue.size";
    public static final String EVENT_QUEUE_SIZE_DOC = "Size of event queue";
    public static final int DEFAULT_EVENT_QUEUE_SIZE = 500;
    private static final int MIN_EVENT_QUEUE_SIZE = 1;
    private static final int MAX_EVENT_QUEUE_SIZE = 0x40000000;
    public static final Set<String> RECONFIGURABLE_CONFIGS = Utils.mkSet((Object[])new String[0]);
    public static final int DEFAULT_PRODUCER_CLOSE_TIMEOUT = 15;
    public static final String SUBSET_PARTITIONER_ENABLED = "subset.partitioner.enabled";
    public static final String SUBSET_PARTITIONER_ENABLED_DOC = "Boolean value. True if the Kafka exporter's producer should use RandomBrokerPartitionSubsetPartitionerby default";
    public static final boolean DEFAULT_SUBSET_PARTITIONER_ENABLED = true;
    public static final String FILTERING_ENABLED = "filtering.enabled";
    public static final String FILTERING_ENABLED_DOC = "If true, only forward the events satisfy the filtering conditions";
    public static final boolean DEFAULT_FILTERING_ENABLED = false;
    public static final String ROUTES_ALLOWED = "filtering.routes.allowed";
    public static final String ROUTES_ALLOWED_DOC = "If set and filtering is enabled, forward the events that were routed to one of these destinations. An empty list will drop all events.";
    public static final List<String> DEFAULT_ROUTES_ALLOWED = Collections.emptyList();
    private static final ConfigDef CONFIG = new ConfigDef().define("producer.bootstrap.servers", ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, "Bootstrap servers for the Kafka cluster telemetry will be published to. The target cluster may be different from the cluster(s) whose telemetry is being collected. Several production Kafka clusters can publish to a single target Kafka cluster, for example.").define("topic.name", ConfigDef.Type.STRING, ConfigDef.Importance.LOW, "Topic to which telemetry data will be written.").define("topic.create", ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, "Create the topic if it does not exist.").define("topic.partitions", ConfigDef.Type.INT, (Object)12, ConfigDef.Importance.LOW, "Number of partitions in the events topic.").define("topic.replicas", ConfigDef.Type.INT, (Object)3, ConfigDef.Importance.LOW, "Number of replicas in the telemetry topic. It must not be higher than the number of brokers in the destination Kafka cluster.").define("topic.retention.ms", ConfigDef.Type.LONG, (Object)DEFAULT_TOPIC_RETENTION_MS, ConfigDef.Importance.LOW, "Retention time for the topic.").define("topic.retention.bytes", ConfigDef.Type.LONG, (Object)-1L, ConfigDef.Importance.LOW, "Retention bytes for the topic.").define("topic.roll.ms", ConfigDef.Type.LONG, (Object)DEFAULT_TOPIC_ROLL_MS, ConfigDef.Importance.LOW, "Log rolling time for the topic.").define("topic.max.message.bytes", ConfigDef.Type.INT, (Object)0x800000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, "Maximum message size for the topic.").define("cloudevent.codec", ConfigDef.Type.STRING, (Object)"binary", ConfigDef.Importance.LOW, "Which cloudevent encoding to use. Use binary encoding by default").define("event.queue.size", ConfigDef.Type.INT, (Object)500, (ConfigDef.Validator)ConfigDef.LambdaValidator.with((name, value) -> KafkaExporterConfig.validateQueueSize(name, (Integer)value), () -> "Positive number, if not provided, will use default value"), ConfigDef.Importance.LOW, "Size of event queue").define("subset.partitioner.enabled", ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, "Boolean value. True if the Kafka exporter's producer should use RandomBrokerPartitionSubsetPartitionerby default").define("filtering.enabled", ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, "If true, only forward the events satisfy the filtering conditions").define("filtering.routes.allowed", ConfigDef.Type.LIST, DEFAULT_ROUTES_ALLOWED, (ConfigDef.Validator)new AllowedRoutesValidator(), ConfigDef.Importance.LOW, "If set and filtering is enabled, forward the events that were routed to one of these destinations. An empty list will drop all events.");
    private Encoding encoding;

    public KafkaExporterConfig(Map<String, ?> originals) {
        super(CONFIG, originals);
        String encodingConfig;
        switch (encodingConfig = this.getString(CLOUD_EVENT_ENCODING_CONFIG)) {
            case "structured": {
                this.encoding = Encoding.STRUCTURED;
                break;
            }
            case "binary": {
                this.encoding = Encoding.BINARY;
                break;
            }
            default: {
                throw new RuntimeException("unknown encoding " + encodingConfig);
            }
        }
    }

    public static void main(String[] args) {
        System.out.println(CONFIG.toRst());
    }

    private Map<String, Object> producerConfigDefaults() {
        HashMap<String, Object> defaults = new HashMap<String, Object>(PRODUCER_CONFIG_DEFAULTS);
        defaults.put("client.id", "confluent-telemetry-events-reporter");
        return defaults;
    }

    Properties getProducerProperties() {
        Properties props = new Properties();
        props.putAll(this.producerConfigDefaults());
        props.putAll((Map<?, ?>)this.originalsWithPrefix(PREFIX_PRODUCER));
        if (!props.containsKey("bootstrap.servers")) {
            throw new ConfigException("Missing required property producer.bootstrap.servers");
        }
        if (this.getBoolean(SUBSET_PARTITIONER_ENABLED).booleanValue()) {
            props.put("partitioner.class", RandomBrokerPartitionSubsetPartitioner.class);
        }
        return props;
    }

    Map<String, String> getTopicConfig() {
        HashMap<String, String> topicConfig = new HashMap<String, String>();
        topicConfig.put("min.insync.replicas", Integer.toString(1));
        topicConfig.put("retention.ms", this.getLong(TOPIC_RETENTION_MS_CONFIG).toString());
        topicConfig.put("retention.bytes", this.getLong(TOPIC_RETENTION_BYTES_CONFIG).toString());
        topicConfig.put("segment.ms", this.getLong(TOPIC_ROLL_MS_CONFIG).toString());
        topicConfig.put("max.message.bytes", this.getInt(TOPIC_MAX_MESSAGE_BYTES_CONFIG).toString());
        topicConfig.put("message.timestamp.type", TimestampType.CREATE_TIME.name);
        return topicConfig;
    }

    boolean isCreateTopic() {
        return this.getBoolean(TOPIC_CREATE_CONFIG);
    }

    int getTopicReplicas() {
        Integer topicReplicas = this.getInt(TOPIC_REPLICAS_CONFIG);
        Verify.verify((topicReplicas > 0 ? 1 : 0) != 0, (String)"topic needs at least 1 replica", (Object[])new Object[0]);
        return topicReplicas;
    }

    int getTopicPartitions() {
        Integer topicPartitions = this.getInt(TOPIC_PARTITIONS_CONFIG);
        Verify.verify((topicPartitions > 0 ? 1 : 0) != 0, (String)"topic needs at least 1 partition", (Object[])new Object[0]);
        return topicPartitions;
    }

    String getTopicName() {
        return this.getString(TOPIC_NAME_CONFIG);
    }

    public boolean isFilteringEnabled() {
        return this.getBoolean(FILTERING_ENABLED);
    }

    public Set<String> getAllowedRoutes() {
        if (this.isFilteringEnabled()) {
            return new HashSet<String>(this.getList(ROUTES_ALLOWED));
        }
        return Collections.emptySet();
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    private static void validateQueueSize(String name, int queueSize) {
        if (queueSize < 1 || queueSize > 0x40000000) {
            throw new ConfigException(String.format("Invalid queue size for exporter '%s' (value: %s). Value must be between %s and %s.", name, queueSize, 1, 0x40000000));
        }
    }

    private static class AllowedRoutesValidator
    implements ConfigDef.Validator {
        private AllowedRoutesValidator() {
        }

        public void ensureValid(String name, Object value) {
            if (!(value instanceof List)) {
                throw new ConfigException("Invalid value type for allowed routes. Expected list");
            }
            List items = (List)value;
            for (Object item : items) {
                if (!(item instanceof String)) {
                    throw new ConfigException("Invalid type for allowed route (expected String).");
                }
                if (Utils.isBlank((String)((String)item))) {
                    throw new ConfigException("Route may not be empty. Found: " + value);
                }
                if (Topic.isValid((String)((String)item))) continue;
                throw new ConfigException("Invalid topic name: " + item);
            }
        }

        public String toString() {
            return "List of comma-separated routes, for example: foo, bar, baz";
        }
    }
}

