/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.events.exporter.kafka.async;

import io.confluent.telemetry.events.exporter.kafka.async.TopicSupplier;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleTopicSupplier<T>
implements TopicSupplier<T> {
    private static final Logger log = LoggerFactory.getLogger(SingleTopicSupplier.class);
    private final NewTopic newTopic;
    private final Properties adminClientProperties;
    private boolean isTopicCreated = false;

    public SingleTopicSupplier(NewTopic newTopic, Properties adminClientProperties) {
        this.newTopic = Objects.requireNonNull(newTopic, "Must provide a Kafka topic");
        this.adminClientProperties = Objects.requireNonNull(adminClientProperties, "Must provide non-null admin client properties");
    }

    @Override
    public Optional<String> topic(T data) {
        if (this.maybeCreateTopic()) {
            return Optional.of(this.newTopic.name());
        }
        return Optional.empty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean ensureTopic(NewTopic newTopic) {
        try (AdminClient adminClient = AdminClient.create((Properties)this.adminClientProperties);){
            try {
                adminClient.describeTopics(Collections.singleton(newTopic.name())).allTopicNames().get();
                log.debug("Telemetry topic {} already exists", (Object)newTopic.name());
            }
            catch (ExecutionException e) {
                if (!(e.getCause() instanceof UnknownTopicOrPartitionException)) {
                    log.warn(e.getMessage());
                    throw e;
                }
                adminClient.createTopics(Collections.singleton(newTopic)).all().get();
                log.info("Created telemetry topic {}", (Object)newTopic.name());
            }
            boolean bl = true;
            return bl;
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof TopicExistsException) {
                log.info("Attempted to create telemetry topic {} but the topic was already created. This may happen the first time the reporter is started and multiple brokers attempt to create the topic simultaneously.", (Object)newTopic.name());
                return true;
            }
            log.error("Error checking or creating telemetry topic {}", (Object)newTopic.name(), (Object)e.getCause());
            return false;
        }
        catch (InterruptedException e) {
            log.warn("Topic initialization interrupted", e.getCause());
            return false;
        }
    }

    private boolean maybeCreateTopic() {
        if (!this.isTopicCreated) {
            this.isTopicCreated = this.ensureTopic(this.newTopic);
        }
        return this.isTopicCreated;
    }
}

