/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.json.diff;

import io.confluent.kafka.schemaregistry.json.diff.Context;
import io.confluent.kafka.schemaregistry.json.diff.Difference;
import io.confluent.kafka.schemaregistry.json.diff.SchemaDiff;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.everit.json.schema.EmptySchema;
import org.everit.json.schema.FalseSchema;
import org.everit.json.schema.ObjectSchema;
import org.everit.json.schema.Schema;

public class ObjectSchemaDiff {
    static void compare(Context ctx, ObjectSchema original, ObjectSchema update) {
        ObjectSchemaDiff.compareRequired(ctx, original, update);
        ObjectSchemaDiff.compareProperties(ctx, original, update);
        ObjectSchemaDiff.compareDependencies(ctx, original, update);
        ObjectSchemaDiff.compareAdditionalProperties(ctx, original, update);
        ObjectSchemaDiff.compareAttributes(ctx, original, update);
    }

    private static void compareAttributes(Context ctx, ObjectSchema original, ObjectSchema update) {
        if (!Objects.equals(original.getMaxProperties(), update.getMaxProperties())) {
            if (original.getMaxProperties() == null && update.getMaxProperties() != null) {
                ctx.addDifference("maxProperties", Difference.Type.MAX_PROPERTIES_ADDED);
            } else if (original.getMaxProperties() != null && update.getMaxProperties() == null) {
                ctx.addDifference("maxProperties", Difference.Type.MAX_PROPERTIES_REMOVED);
            } else if (original.getMaxProperties() < update.getMaxProperties()) {
                ctx.addDifference("maxProperties", Difference.Type.MAX_PROPERTIES_INCREASED);
            } else if (original.getMaxProperties() > update.getMaxProperties()) {
                ctx.addDifference("maxProperties", Difference.Type.MAX_PROPERTIES_DECREASED);
            }
        }
        if (!Objects.equals(original.getMinProperties(), update.getMinProperties())) {
            if (original.getMinProperties() == null && update.getMinProperties() != null) {
                ctx.addDifference("minProperties", Difference.Type.MIN_PROPERTIES_ADDED);
            } else if (original.getMinProperties() != null && update.getMinProperties() == null) {
                ctx.addDifference("minProperties", Difference.Type.MIN_PROPERTIES_REMOVED);
            } else if (original.getMinProperties() < update.getMinProperties()) {
                ctx.addDifference("minProperties", Difference.Type.MIN_PROPERTIES_INCREASED);
            } else if (original.getMinProperties() > update.getMinProperties()) {
                ctx.addDifference("minProperties", Difference.Type.MIN_PROPERTIES_DECREASED);
            }
        }
    }

    private static void compareAdditionalProperties(Context ctx, ObjectSchema original, ObjectSchema update) {
        try (Context.PathScope pathScope = ctx.enterPath("additionalProperties");){
            if (original.permitsAdditionalProperties() != update.permitsAdditionalProperties()) {
                if (update.permitsAdditionalProperties()) {
                    ctx.addDifference(Difference.Type.ADDITIONAL_PROPERTIES_ADDED);
                } else {
                    ctx.addDifference(Difference.Type.ADDITIONAL_PROPERTIES_REMOVED);
                }
            } else if (original.getSchemaOfAdditionalProperties() == null && update.getSchemaOfAdditionalProperties() != null) {
                ctx.addDifference(Difference.Type.ADDITIONAL_PROPERTIES_NARROWED);
            } else if (update.getSchemaOfAdditionalProperties() == null && original.getSchemaOfAdditionalProperties() != null) {
                ctx.addDifference(Difference.Type.ADDITIONAL_PROPERTIES_EXTENDED);
            } else {
                SchemaDiff.compare(ctx, original.getSchemaOfAdditionalProperties(), update.getSchemaOfAdditionalProperties());
            }
        }
    }

    private static void compareDependencies(Context ctx, ObjectSchema original, ObjectSchema update) {
        try (Context.PathScope pathScope = ctx.enterPath("dependencies");){
            Throwable throwable;
            Context.PathScope pathScope2;
            HashSet propertyKeys = new HashSet(original.getPropertyDependencies().keySet());
            propertyKeys.addAll(update.getPropertyDependencies().keySet());
            for (String propertyKey : propertyKeys) {
                pathScope2 = ctx.enterPath(propertyKey);
                throwable = null;
                try {
                    Set originalDependencies = (Set)original.getPropertyDependencies().get(propertyKey);
                    Set updateDependencies = (Set)update.getPropertyDependencies().get(propertyKey);
                    if (updateDependencies == null) {
                        ctx.addDifference(Difference.Type.DEPENDENCY_ARRAY_REMOVED);
                        continue;
                    }
                    if (originalDependencies == null) {
                        ctx.addDifference(Difference.Type.DEPENDENCY_ARRAY_ADDED);
                        continue;
                    }
                    if (originalDependencies.equals(updateDependencies)) continue;
                    if (updateDependencies.containsAll(originalDependencies)) {
                        ctx.addDifference(Difference.Type.DEPENDENCY_ARRAY_EXTENDED);
                        continue;
                    }
                    if (originalDependencies.containsAll(updateDependencies)) {
                        ctx.addDifference(Difference.Type.DEPENDENCY_ARRAY_NARROWED);
                        continue;
                    }
                    ctx.addDifference(Difference.Type.DEPENDENCY_ARRAY_CHANGED);
                }
                catch (Throwable originalDependencies) {
                    throwable = originalDependencies;
                    throw originalDependencies;
                }
                finally {
                    if (pathScope2 == null) continue;
                    if (throwable != null) {
                        try {
                            pathScope2.close();
                        }
                        catch (Throwable originalDependencies) {
                            throwable.addSuppressed(originalDependencies);
                        }
                        continue;
                    }
                    pathScope2.close();
                }
            }
            propertyKeys = new HashSet(original.getSchemaDependencies().keySet());
            propertyKeys.addAll(update.getSchemaDependencies().keySet());
            for (String propertyKey : propertyKeys) {
                pathScope2 = ctx.enterPath(propertyKey);
                throwable = null;
                try {
                    Schema originalSchema = (Schema)original.getSchemaDependencies().get(propertyKey);
                    Schema updateSchema = (Schema)update.getSchemaDependencies().get(propertyKey);
                    if (updateSchema == null) {
                        ctx.addDifference(Difference.Type.DEPENDENCY_SCHEMA_REMOVED);
                        continue;
                    }
                    if (originalSchema == null) {
                        ctx.addDifference(Difference.Type.DEPENDENCY_SCHEMA_ADDED);
                        continue;
                    }
                    SchemaDiff.compare(ctx, originalSchema, updateSchema);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (pathScope2 == null) continue;
                    if (throwable != null) {
                        try {
                            pathScope2.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    pathScope2.close();
                }
            }
        }
    }

    private static void compareProperties(Context ctx, ObjectSchema original, ObjectSchema update) {
        try (Context.PathScope pathScope = ctx.enterPath("properties");){
            HashSet propertyKeys = new HashSet(original.getPropertySchemas().keySet());
            propertyKeys.addAll(update.getPropertySchemas().keySet());
            for (String propertyKey : propertyKeys) {
                Context.PathScope pathScope2 = ctx.enterPath(propertyKey);
                Throwable throwable = null;
                try {
                    Context subctx;
                    Schema schemaFromPartial;
                    Schema originalSchema = (Schema)original.getPropertySchemas().get(propertyKey);
                    Schema updateSchema = (Schema)update.getPropertySchemas().get(propertyKey);
                    if (updateSchema == null) {
                        if (ObjectSchemaDiff.isOpenContentModel(update)) {
                            ctx.addDifference(Difference.Type.PROPERTY_REMOVED_FROM_OPEN_CONTENT_MODEL);
                            continue;
                        }
                        schemaFromPartial = ObjectSchemaDiff.schemaFromPartiallyOpenContentModel(update, propertyKey);
                        if (schemaFromPartial != null) {
                            subctx = ctx.getSubcontext();
                            SchemaDiff.compare(subctx, originalSchema, schemaFromPartial);
                            ctx.addDifferences(subctx.getDifferences());
                            if (subctx.isCompatible()) {
                                ctx.addDifference(Difference.Type.PROPERTY_REMOVED_IS_COVERED_BY_PARTIALLY_OPEN_CONTENT_MODEL);
                                continue;
                            }
                            ctx.addDifference(Difference.Type.PROPERTY_REMOVED_NOT_COVERED_BY_PARTIALLY_OPEN_CONTENT_MODEL);
                            continue;
                        }
                        if (originalSchema instanceof FalseSchema) {
                            ctx.addDifference(Difference.Type.PROPERTY_WITH_FALSE_REMOVED_FROM_CLOSED_CONTENT_MODEL);
                            continue;
                        }
                        ctx.addDifference(Difference.Type.PROPERTY_REMOVED_FROM_CLOSED_CONTENT_MODEL);
                        continue;
                    }
                    if (originalSchema == null) {
                        if (ObjectSchemaDiff.isOpenContentModel(original)) {
                            if (updateSchema instanceof EmptySchema) {
                                ctx.addDifference(Difference.Type.PROPERTY_WITH_EMPTY_SCHEMA_ADDED_TO_OPEN_CONTENT_MODEL);
                                continue;
                            }
                            ctx.addDifference(Difference.Type.PROPERTY_ADDED_TO_OPEN_CONTENT_MODEL);
                            continue;
                        }
                        schemaFromPartial = ObjectSchemaDiff.schemaFromPartiallyOpenContentModel(original, propertyKey);
                        if (schemaFromPartial != null) {
                            subctx = ctx.getSubcontext();
                            SchemaDiff.compare(subctx, schemaFromPartial, updateSchema);
                            ctx.addDifferences(subctx.getDifferences());
                            if (subctx.isCompatible()) {
                                ctx.addDifference(Difference.Type.PROPERTY_ADDED_IS_COVERED_BY_PARTIALLY_OPEN_CONTENT_MODEL);
                            } else {
                                ctx.addDifference(Difference.Type.PROPERTY_ADDED_NOT_COVERED_BY_PARTIALLY_OPEN_CONTENT_MODEL);
                            }
                        }
                        if (update.getRequiredProperties().contains(propertyKey)) {
                            if (((Schema)update.getPropertySchemas().get(propertyKey)).hasDefaultValue()) {
                                ctx.addDifference(Difference.Type.REQUIRED_PROPERTY_WITH_DEFAULT_ADDED_TO_UNOPEN_CONTENT_MODEL);
                                continue;
                            }
                            ctx.addDifference(Difference.Type.REQUIRED_PROPERTY_ADDED_TO_UNOPEN_CONTENT_MODEL);
                            continue;
                        }
                        ctx.addDifference(Difference.Type.OPTIONAL_PROPERTY_ADDED_TO_UNOPEN_CONTENT_MODEL);
                        continue;
                    }
                    SchemaDiff.compare(ctx, originalSchema, updateSchema);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (pathScope2 == null) continue;
                    if (throwable != null) {
                        try {
                            pathScope2.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    pathScope2.close();
                }
            }
        }
    }

    private static void compareRequired(Context ctx, ObjectSchema original, ObjectSchema update) {
        try (Context.PathScope pathScope = ctx.enterPath("required");){
            for (String propertyKey : original.getPropertySchemas().keySet()) {
                if (!update.getPropertySchemas().containsKey(propertyKey)) continue;
                Context.PathScope pathScope2 = ctx.enterPath(propertyKey);
                Throwable throwable = null;
                try {
                    boolean originalRequired = original.getRequiredProperties().contains(propertyKey);
                    boolean updateRequired = update.getRequiredProperties().contains(propertyKey);
                    if (originalRequired && !updateRequired) {
                        ctx.addDifference(Difference.Type.REQUIRED_ATTRIBUTE_REMOVED);
                        continue;
                    }
                    if (originalRequired || !updateRequired) continue;
                    if (((Schema)update.getPropertySchemas().get(propertyKey)).hasDefaultValue()) {
                        ctx.addDifference(Difference.Type.REQUIRED_ATTRIBUTE_WITH_DEFAULT_ADDED);
                        continue;
                    }
                    ctx.addDifference(Difference.Type.REQUIRED_ATTRIBUTE_ADDED);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (pathScope2 == null) continue;
                    if (throwable != null) {
                        try {
                            pathScope2.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    pathScope2.close();
                }
            }
        }
    }

    private static boolean isOpenContentModel(ObjectSchema schema) {
        return schema.getPatternProperties().size() == 0 && schema.getSchemaOfAdditionalProperties() == null && schema.permitsAdditionalProperties();
    }

    private static Schema schemaFromPartiallyOpenContentModel(ObjectSchema schema, String propertyKey) {
        for (Map.Entry entry : schema.getPatternProperties().entrySet()) {
            Pattern pattern = (Pattern)entry.getKey();
            if (!pattern.matcher(propertyKey).find()) continue;
            return (Schema)entry.getValue();
        }
        return schema.getSchemaOfAdditionalProperties();
    }
}

