/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.audit.kafka;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.Struct;
import com.google.protobuf.util.JsonFormat;
import io.confluent.protobuf.events.auditlog.v2.AuditLog;
import io.confluent.protobuf.events.auditlog.v2.Result;
import io.confluent.protobuf.events.auditlog.v2.TypedCloudResourceRef;
import io.confluent.security.audit.AuditLogUtils;
import io.confluent.security.audit.kafka.AuditExtractorOptions;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.common.message.AlterMirrorsRequestData;
import org.apache.kafka.common.message.AlterMirrorsRequestDataJsonConverter;
import org.apache.kafka.common.message.AlterMirrorsResponseData;
import org.apache.kafka.common.message.AlterMirrorsResponseDataJsonConverter;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.server.audit.KafkaRequestEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlterMirrorsRequestAuditExtractor {
    private static final Logger log = LoggerFactory.getLogger(AlterMirrorsRequestAuditExtractor.class);

    public static List<AuditLog> extract(KafkaRequestEvent requestEvent, AuditExtractorOptions extractorOptions) throws Exception {
        ArrayList<AuditLog> extractedAuditLogs = new ArrayList<AuditLog>();
        AlterMirrorsRequestData alterMirrorsRequestData = AlterMirrorsRequestDataJsonConverter.read((JsonNode)requestEvent.requestPayload(), (short)((short)requestEvent.requestContext().requestVersion()));
        AlterMirrorsResponseData alterMirrorsResponseData = AlterMirrorsResponseDataJsonConverter.read((JsonNode)requestEvent.responsePayload(), (short)((short)requestEvent.requestContext().requestVersion()));
        boolean hasAuthorizationFailure = AlterMirrorsRequestAuditExtractor.hasAuthorizationFailure(alterMirrorsResponseData);
        boolean validateOnly = alterMirrorsRequestData.validateOnly();
        Struct requestData = AlterMirrorsRequestAuditExtractor.requestData(alterMirrorsRequestData, requestEvent);
        Result.Status status = AlterMirrorsRequestAuditExtractor.status(alterMirrorsResponseData);
        Struct resultData = AlterMirrorsRequestAuditExtractor.resultData(alterMirrorsResponseData, requestEvent);
        List<TypedCloudResourceRef> typedCloudResourceRefList = AuditLogUtils.typedCloudResourceRefList(requestEvent);
        String resourceCrn = AuditLogUtils.requestCrn(extractorOptions.crnAuthority(), requestEvent);
        AuditLog auditLog = AuditLogUtils.auditLog(requestEvent, extractorOptions, hasAuthorizationFailure, validateOnly, requestData, status, resultData, typedCloudResourceRefList, resourceCrn);
        extractedAuditLogs.add(auditLog);
        return extractedAuditLogs;
    }

    private static boolean hasAuthorizationFailure(AlterMirrorsResponseData alterMirrorsResponseData) {
        return alterMirrorsResponseData.results().stream().anyMatch(alterMirrorResult -> AuditLogUtils.hasAuthorizationFailure(alterMirrorResult.errorCode()));
    }

    private static Struct requestData(AlterMirrorsRequestData alterMirrorsRequestData, KafkaRequestEvent requestEvent) throws Exception {
        Struct.Builder builder = Struct.newBuilder();
        ObjectNode jsonNode = (ObjectNode)AlterMirrorsRequestDataJsonConverter.write((AlterMirrorsRequestData)alterMirrorsRequestData, (short)((short)requestEvent.requestContext().requestVersion()), (boolean)true);
        if (requestEvent.requestContext().requestVersion() >= 2) {
            for (JsonNode mirrorOperation : jsonNode.get("mirrorOperations")) {
                ((ObjectNode)mirrorOperation).set("operationCode", (JsonNode)new TextNode(AlterMirrorOp.forId((byte)((byte)mirrorOperation.get("operationCode").shortValue())).name()));
            }
        }
        JsonFormat.parser().merge(jsonNode.toString(), (Message.Builder)builder);
        return builder.build();
    }

    private static Result.Status status(AlterMirrorsResponseData alterMirrorsResponseData) {
        if (alterMirrorsResponseData.results().stream().anyMatch(alterMirrorResult -> alterMirrorResult.errorCode() != Errors.NONE.code())) {
            return Result.Status.FAILURE;
        }
        return Result.Status.SUCCESS;
    }

    private static Struct resultData(AlterMirrorsResponseData alterMirrorsResponseData, KafkaRequestEvent requestEvent) throws InvalidProtocolBufferException {
        Struct.Builder builder = Struct.newBuilder();
        ObjectNode jsonNode = (ObjectNode)AlterMirrorsResponseDataJsonConverter.write((AlterMirrorsResponseData)alterMirrorsResponseData, (short)((short)requestEvent.requestContext().requestVersion()), (boolean)true);
        jsonNode.remove("throttleTimeMs");
        JsonFormat.parser().merge(jsonNode.toString(), (Message.Builder)builder);
        return builder.build();
    }
}

