/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.audit.router;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.confluent.security.audit.AuditLogEntry;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditLogRouterUtils {
    private static final Logger log = LoggerFactory.getLogger(AuditLogRouterUtils.class);
    @Deprecated
    public static final String OTHER_CATEGORY = "other";
    public static final String UNAUDITED = "unaudited";
    public static final String MANAGEMENT_CATEGORY = "management";
    public static final String PRODUCE_CATEGORY = "produce";
    public static final String CONSUME_CATEGORY = "consume";
    public static final String INTERBROKER_CATEGORY = "interbroker";
    public static final String AUTHORIZE_CATEGORY = "authorize";
    public static final String DESCRIBE_CATEGORY = "describe";
    public static final String HEARTBEAT_CATEGORY = "heartbeat";
    public static final String AUTHENTICATION_CATEGORY = "authentication";
    public static final Set<String> DEFAULT_ENABLED_CATEGORIES = Utils.mkSet((Object[])new String[]{"authorize", "management", "authentication"});
    public static final Map<String, String> METHOD_CATEGORIES;
    public static final Set<String> CATEGORIES;

    private static Map.Entry<String, String> entry(ApiKeys k, String category) {
        return Maps.immutableEntry((Object)("kafka." + k.name), (Object)category);
    }

    private static Map.Entry<String, String> entry(RequestNameOverrides override) {
        return Maps.immutableEntry((Object)(override.prefix + override.name), (Object)override.category);
    }

    public static String category(AuditLogEntry entry) {
        return AuditLogRouterUtils.category(entry.getMethodName());
    }

    public static String category(String methodName) {
        return METHOD_CATEGORIES.getOrDefault(methodName, UNAUDITED);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ApiKeys apiKey : ApiKeys.zkBrokerApis()) {
            String category;
            switch (apiKey) {
                case ALTER_CLIENT_QUOTAS: 
                case ALTER_CONFIGS: 
                case ALTER_MIRRORS: 
                case ALTER_PARTITION_REASSIGNMENTS: 
                case ALTER_REPLICA_LOG_DIRS: 
                case ALTER_USER_SCRAM_CREDENTIALS: 
                case ALTER_PARTITION: 
                case CREATE_ACLS: 
                case CREATE_CLUSTER_LINKS: 
                case CREATE_PARTITIONS: 
                case CREATE_TOPICS: 
                case DELETE_ACLS: 
                case DELETE_CLUSTER_LINKS: 
                case DELETE_GROUPS: 
                case DELETE_RECORDS: 
                case DELETE_TOPICS: 
                case ELECT_LEADERS: 
                case INCREMENTAL_ALTER_CONFIGS: 
                case INITIATE_SHUTDOWN: 
                case OFFSET_DELETE: 
                case REMOVE_BROKERS: 
                case ALTER_BROKER_HEALTH: 
                case ALTER_BROKER_REPLICA_EXCLUSIONS: 
                case DESCRIBE_BROKER_REPLICA_EXCLUSIONS: 
                case TRIGGER_EVEN_CLUSTER_LOAD: 
                case DESCRIBE_CELL_LOAD: 
                case CREATE_CELL: 
                case ALTER_CELL: 
                case DRAIN_CELL: 
                case DELETE_CELL: 
                case ASSIGN_BROKERS_TO_CELL: 
                case UN_ASSIGN_BROKERS_FROM_CELL: 
                case ASSIGN_TENANTS_TO_CELL: 
                case DELETE_TENANTS: 
                case DESCRIBE_CELLS: 
                case DESCRIBE_TENANTS: 
                case ALTER_CELL_MIGRATION: 
                case DESCRIBE_CELL_MIGRATION: 
                case DESCRIBE_NETWORK: 
                case UPDATE_FEATURES: {
                    category = MANAGEMENT_CATEGORY;
                    break;
                }
                case ADD_PARTITIONS_TO_TXN: 
                case END_TXN: 
                case INIT_PRODUCER_ID: 
                case PRODUCE: {
                    category = PRODUCE_CATEGORY;
                    break;
                }
                case ADD_OFFSETS_TO_TXN: 
                case JOIN_GROUP: 
                case LEAVE_GROUP: 
                case LIST_OFFSETS: 
                case OFFSET_COMMIT: 
                case OFFSET_FETCH: 
                case SYNC_GROUP: 
                case TXN_OFFSET_COMMIT: {
                    category = CONSUME_CATEGORY;
                    break;
                }
                case CONTROLLED_SHUTDOWN: 
                case LEADER_AND_ISR: 
                case STOP_REPLICA: 
                case UPDATE_METADATA: 
                case ALLOCATE_PRODUCER_IDS: 
                case WRITE_TXN_MARKERS: 
                case REPORT_QUOTA_CONSUMPTION: 
                case PUBLISH_QUOTA_TARGET: 
                case APPEND_RECORDS: 
                case ENVELOPE: {
                    category = INTERBROKER_CATEGORY;
                    break;
                }
                case INITIATE_REVERSE_CONNECTIONS: 
                case REVERSE_CONNECTION: {
                    category = INTERBROKER_CATEGORY;
                    break;
                }
                case DESCRIBE_ACLS: 
                case DESCRIBE_BROKER_REMOVALS: 
                case DESCRIBE_BROKER_ADDITIONS: 
                case DESCRIBE_BALANCER_STATUS: 
                case DESCRIBE_EVEN_CLUSTER_LOAD_STATUS: 
                case DESCRIBE_CLIENT_QUOTAS: 
                case DESCRIBE_CONFIGS: 
                case DESCRIBE_CLUSTER: 
                case DESCRIBE_CLUSTER_LINKS: 
                case DESCRIBE_GROUPS: 
                case DESCRIBE_LOG_DIRS: 
                case DESCRIBE_MIRRORS: 
                case DESCRIBE_USER_SCRAM_CREDENTIALS: 
                case FIND_COORDINATOR: 
                case LIST_CLUSTER_LINKS: 
                case LIST_GROUPS: 
                case LIST_MIRRORS: 
                case LIST_PARTITION_REASSIGNMENTS: 
                case METADATA: 
                case OFFSET_FOR_LEADER_EPOCH: 
                case DESCRIBE_PRODUCERS: 
                case DESCRIBE_BROKER_HEALTH: 
                case DESCRIBE_TRANSACTIONS: 
                case LIST_TRANSACTIONS: 
                case REPLICA_STATUS: 
                case COMPUTE_EVEN_CLUSTER_LOAD_PLAN: 
                case CONSUMER_GROUP_DESCRIBE: 
                case LIST_CLIENT_METRICS_RESOURCES: {
                    category = DESCRIBE_CATEGORY;
                    break;
                }
                case CONSUMER_GROUP_HEARTBEAT: 
                case HEARTBEAT: {
                    category = HEARTBEAT_CATEGORY;
                    break;
                }
                case API_VERSIONS: 
                case CREATE_DELEGATION_TOKEN: 
                case DESCRIBE_DELEGATION_TOKEN: 
                case EXPIRE_DELEGATION_TOKEN: 
                case FETCH: 
                case RENEW_DELEGATION_TOKEN: 
                case SASL_AUTHENTICATE: 
                case SASL_HANDSHAKE: {
                    category = UNAUDITED;
                    break;
                }
                default: {
                    UnsupportedOperationException e = new UnsupportedOperationException(apiKey.name);
                    log.error("BUG: AuditLogCategoryResultRouter needs to be updated!", (Throwable)e);
                    throw e;
                }
            }
            builder.put(AuditLogRouterUtils.entry(apiKey, category));
        }
        builder.put((Object)"kafka.Authentication", (Object)AUTHENTICATION_CATEGORY);
        for (RequestNameOverrides override : RequestNameOverrides.values()) {
            builder.put(AuditLogRouterUtils.entry(override));
        }
        METHOD_CATEGORIES = builder.build();
        CATEGORIES = new HashSet<String>(METHOD_CATEGORIES.values());
    }

    public static enum RequestNameOverrides {
        MDS_AUTHORIZE("mds", "Authorize", "authorize"),
        KAFKA_FETCH_CONSUMER("kafka", "FetchConsumer", "consume"),
        KAFKA_FETCH_FOLLOWER("kafka", "FetchFollower", "interbroker");

        public final String prefix;
        public final String name;
        public final String category;

        private RequestNameOverrides(String context, String name, String category) {
            this.prefix = context + ".";
            this.name = name;
            this.category = category;
        }
    }
}

