/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.audit.telemetry.exporter.config.remote.polling;

import io.confluent.security.audit.telemetry.exporter.config.remote.RemoteConfigConfiguration;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.config.ConfigDef;

public class PollingRemoteConfigurationConfig
extends RemoteConfigConfiguration {
    public static final String REFRESH_INTERVAL_SEC_CONFIG = "refresh.interval.sec";
    public static final Long DEFAULT_REFRESH_INTERVAL = TimeUnit.MINUTES.toSeconds(1L);
    public static final String REFRESH_INTERVAL_SEC_DOC = "The configured remote configuration source will poll its source for a remote configuration for the Auditlog Provider in intervals defined by this setting. The default is a reasonable value for production environments  and it typically does not need to be changed.";

    public static ConfigDef defineConfigs(ConfigDef base) {
        return Optional.ofNullable(base).map(ConfigDef::new).orElse(new ConfigDef()).defineInternal(REFRESH_INTERVAL_SEC_CONFIG, ConfigDef.Type.LONG, (Object)DEFAULT_REFRESH_INTERVAL, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.LOW, REFRESH_INTERVAL_SEC_DOC);
    }

    public PollingRemoteConfigurationConfig(ConfigDef config, Map<?, ?> originals, boolean doLog) {
        super(PollingRemoteConfigurationConfig.defineConfigs(config), originals, doLog);
    }

    public Long getRefreshIntervalMs() {
        return 1000L * this.getLong(REFRESH_INTERVAL_SEC_CONFIG);
    }
}

