/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.audit.telemetry.exporter.config.remote.polling.kubernetes;

import io.confluent.security.audit.telemetry.exporter.config.remote.polling.PollingRemoteConfigurationConfig;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.config.ConfigDef;

public class KubernetesConfigMapRemoteConfigurationConfig
extends PollingRemoteConfigurationConfig {
    public static final String NAMESPACE_CONFIG = "namespace";
    public static final String DEFAULT_NAMESPACE = "audit-config";
    public static final String NAMESPACE_DOC = "The configured KubernetesConfigMapRemoteConfiguration will watch for ConfigMap changes in this configured namespace";
    public static final String CONFIG_MAP_NAME_CONFIG = "configmap.name";
    public static final String CONFIG_MAP_NAME_DOC = "The name of the Kubernetes ConfigMap to watch for changes to remotely configure if the override cluster named ConfigMap is not present";
    public static final String RETRY_BACKOFF_MS = "retry.backoff.ms";
    public static final long DEFAULT_RETRY_BACKOFF_MS = TimeUnit.SECONDS.toMillis(5L);
    public static final String RETRY_BACKOFF_MS_DOC = "The duration of time to wait (back off) before attempting to retry a failed request during startup";
    public static final String MAX_RETRY_BACKOFF_MS = "max.retry.backoff.ms";
    public static final long DEFAULT_MAX_RETRY_BACKOFF_MS = TimeUnit.SECONDS.toMillis(60L);
    public static final String MAX_RETRY_BACKOFF_MS_DOC = "The maximum duration of time to wait (back off) attempting to retry a failed request during startup";
    private static final ConfigDef CONFIG_DEF = new ConfigDef().define("namespace", ConfigDef.Type.STRING, (Object)"audit-config", ConfigDef.Importance.LOW, "The configured KubernetesConfigMapRemoteConfiguration will watch for ConfigMap changes in this configured namespace").define("configmap.name", ConfigDef.Type.STRING, ConfigDef.NO_DEFAULT_VALUE, ConfigDef.Importance.MEDIUM, "The name of the Kubernetes ConfigMap to watch for changes to remotely configure if the override cluster named ConfigMap is not present").define("retry.backoff.ms", ConfigDef.Type.LONG, (Object)DEFAULT_RETRY_BACKOFF_MS, ConfigDef.Importance.MEDIUM, "The duration of time to wait (back off) before attempting to retry a failed request during startup").define("max.retry.backoff.ms", ConfigDef.Type.LONG, (Object)DEFAULT_MAX_RETRY_BACKOFF_MS, ConfigDef.Importance.MEDIUM, "The maximum duration of time to wait (back off) attempting to retry a failed request during startup");

    public KubernetesConfigMapRemoteConfigurationConfig(Map<?, ?> originals, boolean doLog) {
        super(CONFIG_DEF, originals, doLog);
    }

    String getNamespace() {
        return this.getString(NAMESPACE_CONFIG);
    }

    String getConfigMapNameConfig() {
        return this.getString(CONFIG_MAP_NAME_CONFIG);
    }

    public long getRetryBackoffMs() {
        return this.getLong(RETRY_BACKOFF_MS);
    }

    public long getMaxRetryBackoffMs() {
        return this.getLong(MAX_RETRY_BACKOFF_MS);
    }
}

