/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.monitoring.clients.interceptor;

import io.confluent.monitoring.clients.interceptor.MonitoringInterceptor;
import io.confluent.monitoring.clients.interceptor.RecordChecksum;
import io.confluent.shaded.com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.kafka.clients.producer.ProducerInterceptor;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.ClusterResource;
import org.apache.kafka.common.ClusterResourceListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitoringProducerInterceptor<K, V>
implements ProducerInterceptor<K, V>,
ClusterResourceListener {
    private static final Logger log = LoggerFactory.getLogger(MonitoringProducerInterceptor.class);
    private Map<String, ?> configs;
    private volatile ClusterResource clusterResource;
    private volatile MonitoringInterceptor monitoringInterceptor;
    protected boolean enabled = true;

    public void configure(Map<String, ?> configs) {
        this.configs = configs;
        if (configs.containsKey("transactional.id")) {
            log.error("setting {} not supported. disabling monitoring", (Object)"transactional.id");
            this.enabled = false;
        }
        log.debug("configure=finished");
    }

    public ProducerRecord<K, V> onSend(ProducerRecord<K, V> record) {
        return record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAcknowledgement(RecordMetadata metadata, Exception exception) {
        if (this.enabled) {
            if (this.monitoringInterceptor == null) {
                MonitoringProducerInterceptor monitoringProducerInterceptor = this;
                synchronized (monitoringProducerInterceptor) {
                    if (this.monitoringInterceptor == null) {
                        log.info("creating interceptor");
                        Preconditions.checkState(this.clusterResource != null, "clusterResource is not defined");
                        Preconditions.checkState(this.configs != null, "producer interceptor is not configured");
                        MonitoringInterceptor interceptor = MonitoringInterceptor.createForProducer(this.clusterResource.clusterId(), this.configs);
                        interceptor.start();
                        this.monitoringInterceptor = interceptor;
                    }
                }
            }
            if (metadata != null && exception == null) {
                int size = Math.max(metadata.serializedKeySize(), 0) + Math.max(metadata.serializedValueSize(), 0);
                this.monitoringInterceptor.recordMessageMetric(metadata.topic(), metadata.partition(), metadata.timestamp(), size, RecordChecksum.computePartialChecksum(metadata.timestamp(), metadata.serializedKeySize(), metadata.serializedValueSize()), 0L);
            }
        }
    }

    public void onUpdate(ClusterResource clusterResource) {
        log.debug("cluster updated");
        this.clusterResource = clusterResource;
    }

    public void close() {
        log.debug("closing");
        if (this.monitoringInterceptor != null) {
            this.monitoringInterceptor.shutdown();
        }
    }
}

