/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.serializers;

import io.confluent.shaded.com.google.common.collect.ImmutableList;
import io.confluent.shaded.com.google.common.collect.ImmutableMap;
import io.confluent.shaded.com.google.gson.Gson;
import io.confluent.shaded.com.google.gson.JsonElement;
import io.confluent.shaded.com.google.gson.JsonObject;
import io.confluent.shaded.com.google.gson.JsonParser;
import io.confluent.shaded.com.google.gson.JsonPrimitive;
import io.confluent.shaded.com.google.protobuf.Descriptors;
import io.confluent.shaded.com.google.protobuf.Message;
import io.confluent.shaded.com.google.protobuf.ProtocolMessageEnum;
import io.confluent.shaded.serializers.OrderedBytes;
import io.confluent.shaded.serializers.OrderedKeyPrefixedSerde;
import io.confluent.shaded.serializers.OrderedKeyProtoSerde;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Map;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.utils.Bytes;

public class OrderedKeyPrefixedProtoSerde<E extends Enum<E>, T extends Message>
extends OrderedKeyProtoSerde<T>
implements OrderedKeyPrefixedSerde<E, T> {
    private E prefix;
    private ImmutableMap<E, ImmutableList<Descriptors.FieldDescriptor>> fieldMap;

    private static <E extends Enum<E>, T extends Message> ImmutableMap<E, ImmutableList<Descriptors.FieldDescriptor>> getFieldMap(T instance, ImmutableMap<E, ImmutableList<Integer>> fieldIdsMap) {
        Descriptors.Descriptor desc = instance.getDescriptorForType();
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (Map.Entry entry : fieldIdsMap.entrySet()) {
            ImmutableList.Builder listBuilder = ImmutableList.builder();
            Iterator iterator = ((ImmutableList)entry.getValue()).iterator();
            while (iterator.hasNext()) {
                int fieldNumber = (Integer)iterator.next();
                listBuilder.add(desc.findFieldByNumber(fieldNumber));
            }
            mapBuilder.put(entry.getKey(), listBuilder.build());
        }
        return mapBuilder.build();
    }

    public static <E extends Enum<E>, T extends Message> OrderedKeyPrefixedSerde<E, T> create(E prefix, T instance, ImmutableMap<E, ImmutableList<Integer>> fieldIdsMap) {
        return new OrderedKeyPrefixedProtoSerde<E, T>(prefix, instance, OrderedKeyPrefixedProtoSerde.getFieldMap(instance, fieldIdsMap));
    }

    public OrderedKeyPrefixedProtoSerde(E prefix, T instance, ImmutableMap<E, ImmutableList<Descriptors.FieldDescriptor>> fieldMap) {
        super(instance, fieldMap.get(prefix));
        this.prefix = prefix;
        this.fieldMap = fieldMap;
    }

    public OrderedKeyPrefixedProtoSerde(E prefix, T instance, ImmutableMap<E, ImmutableList<Descriptors.FieldDescriptor>> fieldMap, int numFields) {
        super(instance, (ImmutableList<Descriptors.FieldDescriptor>)fieldMap.get(prefix).subList(0, numFields));
        this.prefix = prefix;
        this.fieldMap = fieldMap;
    }

    @Override
    public E prefix() {
        return this.prefix;
    }

    @Override
    public E extractPrefix(Bytes key) {
        ByteBuffer buffer = ByteBuffer.wrap(key.get());
        OrderedKeyPrefixedProtoSerde.readMagicByte(buffer);
        return this.readPrefix(buffer);
    }

    protected E readPrefix(ByteBuffer buffer) {
        Short num = OrderedBytes.readShort(buffer);
        if (num == null) {
            return null;
        }
        Object value = Enum.valueOf(this.prefix.getClass(), ((ProtocolMessageEnum)this.prefix).getDescriptorForType().findValueByNumber(num.shortValue()).getName());
        return (E)value;
    }

    @Override
    public OrderedKeyPrefixedSerde<E, T> prefixKeySerde(int numFields) {
        if (numFields <= 0) {
            throw new IllegalArgumentException(String.format("Fields requested %d must be greater than zero", numFields));
        }
        if (numFields > this.fields.size()) {
            throw new IllegalArgumentException(String.format("Fields requested %d is higher than total %d", numFields, this.fields.size()));
        }
        return new OrderedKeyPrefixedProtoSerde<E, Message>(this.prefix, this.instance, this.fieldMap, numFields);
    }

    @Override
    public Bytes key(T message) {
        return Bytes.wrap((byte[])this.protoToBytes(message, this.fields, this.fields.size()));
    }

    @Override
    protected byte[] protoToBytes(T message, ImmutableList<Descriptors.FieldDescriptor> fields, int numFields) {
        if (message == null) {
            return null;
        }
        try {
            ByteBuffer buffer = ByteBuffer.allocate(3 + OrderedKeyPrefixedProtoSerde.getMaxSerializedBytes(message, fields));
            OrderedKeyPrefixedProtoSerde.writeMagicByte(buffer);
            OrderedKeyPrefixedProtoSerde.encodeEnum(buffer, ((ProtocolMessageEnum)this.prefix).getNumber());
            OrderedKeyPrefixedProtoSerde.writeProto(buffer, message, fields, fields.size());
            byte[] result = new byte[buffer.position()];
            buffer.flip();
            buffer.get(result, 0, result.length);
            return result;
        }
        catch (Exception e) {
            String errMsg = "Error serializing key message";
            log.error(errMsg, (Throwable)e);
            throw new SerializationException(errMsg, (Throwable)e);
        }
    }

    @Override
    public T toProto(Bytes key) {
        if (key == null) {
            return null;
        }
        try {
            ByteBuffer buffer = ByteBuffer.wrap(key.get());
            OrderedKeyPrefixedProtoSerde.readMagicByte(buffer);
            E msgPrefix = this.readPrefix(buffer);
            ImmutableList<Descriptors.FieldDescriptor> msgFields = this.fieldMap.get(msgPrefix);
            return (T)OrderedKeyPrefixedProtoSerde.readProto(buffer, this.instance, msgFields);
        }
        catch (SerializationException e) {
            throw e;
        }
        catch (Exception e) {
            String errMsg = "Error deserializing key message";
            log.error(errMsg, (Throwable)e);
            throw new SerializationException(errMsg, (Throwable)e);
        }
    }

    @Override
    public byte[] fromJson(String json) {
        Gson gson = new Gson();
        try {
            JsonObject root = JsonParser.parseString(json).getAsJsonObject();
            JsonElement protoJson = root.get("proto");
            String protoJsonStr = gson.toJson(protoJson);
            String prefixStr = root.get("prefix").getAsString();
            Object msgPrefix = Enum.valueOf(this.prefix.getClass(), prefixStr);
            ImmutableList<Descriptors.FieldDescriptor> msgFields = this.fieldMap.get(msgPrefix);
            Message msg = OrderedKeyPrefixedProtoSerde.jsonToProto(protoJsonStr, this.instance);
            return this.protoToBytes(msg, msgFields, msgFields.size());
        }
        catch (SerializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SerializationException("JSON parsing failed", (Throwable)e);
        }
    }

    @Override
    public String toJson(Bytes key) {
        Gson gson = new Gson();
        E msgPrefix = this.extractPrefix(key);
        Object msg = this.toProto(key);
        JsonObject root = new JsonObject();
        root.add("prefix", new JsonPrimitive(((ProtocolMessageEnum)msgPrefix).getValueDescriptor().getName()));
        root.add("proto", JsonParser.parseString(OrderedKeyPrefixedProtoSerde.protoToJson(msg)));
        return gson.toJson(root);
    }
}

