/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime;

import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;

public class DynamicWorkerConfig
extends AbstractConfig {
    public static final String MAX_TASKS_PER_WORKER = "confluent.max.tasks.per.worker";
    public static final Integer MAX_TASKS_PER_WORKER_DEFAULT = Integer.MAX_VALUE;
    private static final String MAX_TASKS_PER_WORKER_DOC = "Maximum number of tasks assigned to a Connect worker";
    public static final DynamicWorkerConfig DEFAULT = new DynamicWorkerConfig(Collections.emptyMap());

    public DynamicWorkerConfig(Map<?, ?> originals) {
        super(DynamicWorkerConfig.configDef(), originals, true);
    }

    static ConfigDef configDef() {
        return new ConfigDef().define(MAX_TASKS_PER_WORKER, ConfigDef.Type.INT, (Object)MAX_TASKS_PER_WORKER_DEFAULT, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.LOW, MAX_TASKS_PER_WORKER_DOC);
    }

    public Integer maxTasksPerWorker() {
        return this.getInt(MAX_TASKS_PER_WORKER);
    }

    static void validateProperties(Map<String, String> properties) {
        DynamicWorkerConfig.configDef().parse(properties);
    }
}

