/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.isolation;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.kafka.connect.runtime.isolation.LazyLoadScanner;
import org.apache.kafka.connect.runtime.isolation.PluginClassLoader;
import org.apache.kafka.connect.runtime.isolation.PluginDesc;
import org.apache.kafka.connect.runtime.isolation.PluginScanResult;
import org.apache.kafka.connect.runtime.isolation.PluginUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatingClassLoader
extends URLClassLoader {
    private static final Logger log = LoggerFactory.getLogger(DelegatingClassLoader.class);
    private final ConcurrentMap<String, SortedMap<PluginDesc<?>, ClassLoader>> pluginLoaders;
    private final ConcurrentMap<String, String> aliases;
    private final ConcurrentMap<String, Object> lazyLoadLocks = new ConcurrentHashMap<String, Object>();
    private LazyLoadScanner lazyLoadScanner;

    public DelegatingClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
        this.pluginLoaders = new ConcurrentHashMap();
        this.aliases = new ConcurrentHashMap<String, String>();
    }

    public DelegatingClassLoader() {
        this(DelegatingClassLoader.class.getClassLoader());
    }

    PluginClassLoader pluginClassLoader(String name) {
        if (!PluginUtils.shouldLoadInIsolation(name)) {
            return null;
        }
        this.lazyLoadIfRequired(name);
        SortedMap inner = (SortedMap)this.pluginLoaders.get(name);
        if (inner == null) {
            return null;
        }
        ClassLoader pluginLoader = (ClassLoader)inner.get(inner.lastKey());
        return pluginLoader instanceof PluginClassLoader ? (PluginClassLoader)pluginLoader : null;
    }

    ClassLoader connectorLoader(String connectorClassOrAlias) {
        String fullName = this.aliases.getOrDefault(connectorClassOrAlias, connectorClassOrAlias);
        URLClassLoader classLoader = this.pluginClassLoader(fullName);
        if (classLoader == null) {
            classLoader = this;
        }
        log.debug("Getting plugin class loader: '{}' for connector: {}", (Object)classLoader, (Object)connectorClassOrAlias);
        return classLoader;
    }

    public void installDiscoveredPlugins(PluginScanResult scanResult) {
        Map<String, SortedMap<PluginDesc<?>, ClassLoader>> computedLoaders = DelegatingClassLoader.computePluginLoaders(scanResult);
        computedLoaders.forEach((name, pluginDesc) -> this.pluginLoaders.computeIfAbsent((String)name, k -> new TreeMap()).putAll(pluginDesc));
        for (String pluginClassName : computedLoaders.keySet()) {
            log.info("Added plugin '{}':{}", (Object)pluginClassName, computedLoaders.get(pluginClassName).lastKey());
        }
        Map<String, String> computedAliases = PluginUtils.computeAliases(scanResult);
        this.aliases.putAll(computedAliases);
        for (Map.Entry<String, String> alias : computedAliases.entrySet()) {
            log.info("Added alias '{}' to plugin '{}'", (Object)alias.getKey(), (Object)alias.getValue());
        }
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        String fullName = this.aliases.getOrDefault(name, name);
        PluginClassLoader pluginLoader = this.pluginClassLoader(fullName);
        if (pluginLoader != null) {
            log.trace("Retrieving loaded class '{}' from '{}'", (Object)fullName, (Object)pluginLoader);
            return pluginLoader.loadClass(fullName, resolve);
        }
        return super.loadClass(fullName, resolve);
    }

    private static Map<String, SortedMap<PluginDesc<?>, ClassLoader>> computePluginLoaders(PluginScanResult plugins) {
        HashMap pluginLoaders = new HashMap();
        plugins.forEach(pluginDesc -> pluginLoaders.computeIfAbsent(pluginDesc.className(), k -> new TreeMap()).put(pluginDesc, pluginDesc.loader()));
        return pluginLoaders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyLoadIfRequired(String name) {
        if (this.lazyLoadScanner == null || this.lazyLoadScanner.pluginSource(name) == null) {
            return;
        }
        String pluginSourceLocation = this.lazyLoadScanner.pluginSource(name).toString();
        Object lock = this.lazyLoadLocks.putIfAbsent(pluginSourceLocation, new Object());
        Object v = this.lazyLoadLocks.get(pluginSourceLocation);
        synchronized (v) {
            if (lock == null) {
                this.installDiscoveredPlugins(this.lazyLoadScanner.discoverPlugins(name));
            } else {
                log.info("Plugins from locations {} already lazy loaded not reloading the plugin", (Object)pluginSourceLocation);
            }
        }
    }

    public void lazyLoadPlugins(LazyLoadScanner lazyLoadScanner) {
        this.lazyLoadScanner = lazyLoadScanner;
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

