/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.isolation;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.common.Configurable;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.provider.ConfigProvider;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.connect.components.Versioned;
import org.apache.kafka.connect.connector.Connector;
import org.apache.kafka.connect.connector.Task;
import org.apache.kafka.connect.connector.policy.ConnectorClientConfigOverridePolicy;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.runtime.WorkerConfig;
import org.apache.kafka.connect.runtime.isolation.ClassLoaderFactory;
import org.apache.kafka.connect.runtime.isolation.DelegatingClassLoader;
import org.apache.kafka.connect.runtime.isolation.LazyLoadScanner;
import org.apache.kafka.connect.runtime.isolation.LazyPluginInfo;
import org.apache.kafka.connect.runtime.isolation.LoaderSwap;
import org.apache.kafka.connect.runtime.isolation.PluginClassLoaderFactory;
import org.apache.kafka.connect.runtime.isolation.PluginDesc;
import org.apache.kafka.connect.runtime.isolation.PluginDiscoveryMode;
import org.apache.kafka.connect.runtime.isolation.PluginScanResult;
import org.apache.kafka.connect.runtime.isolation.PluginSource;
import org.apache.kafka.connect.runtime.isolation.PluginType;
import org.apache.kafka.connect.runtime.isolation.PluginUtils;
import org.apache.kafka.connect.runtime.isolation.ReflectionScanner;
import org.apache.kafka.connect.runtime.isolation.ServiceLoaderScanner;
import org.apache.kafka.connect.sink.SinkConnector;
import org.apache.kafka.connect.source.SourceConnector;
import org.apache.kafka.connect.storage.Converter;
import org.apache.kafka.connect.storage.ConverterType;
import org.apache.kafka.connect.storage.HeaderConverter;
import org.apache.kafka.connect.transforms.Transformation;
import org.apache.kafka.connect.transforms.predicates.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Plugins {
    private static final Logger log = LoggerFactory.getLogger(Plugins.class);
    private final DelegatingClassLoader delegatingLoader;
    private final PluginScanResult scanResult;
    private final Path lazyLoadManifestPath;
    private Map<PluginType, Map<String, LazyPluginInfo>> lazyLoadPluginDesc;

    public Plugins(Map<String, String> props) {
        this(props, Plugins.class.getClassLoader(), new ClassLoaderFactory());
    }

    Plugins(Map<String, String> props, ClassLoader parent, ClassLoaderFactory factory) {
        String pluginPath = WorkerConfig.pluginPath(props);
        this.lazyLoadManifestPath = WorkerConfig.lazyLoadPluginManifestPath(props);
        PluginDiscoveryMode discoveryMode = WorkerConfig.pluginDiscovery(props);
        Set<Path> pluginLocations = PluginUtils.pluginLocations(pluginPath, false, this.lazyLoadManifestPath != null);
        this.delegatingLoader = factory.newDelegatingClassLoader(parent);
        Set<PluginSource> pluginSources = PluginUtils.pluginSources(pluginLocations, this.delegatingLoader, factory);
        this.scanResult = this.initLoaders(pluginSources, discoveryMode);
        this.maybeInitLazyLoader(factory, discoveryMode);
    }

    public PluginScanResult initLoaders(Set<PluginSource> pluginSources, PluginDiscoveryMode discoveryMode) {
        PluginScanResult serviceLoadingScanResult;
        PluginScanResult empty = new PluginScanResult(Collections.emptyList());
        try {
            serviceLoadingScanResult = discoveryMode.serviceLoad() ? new ServiceLoaderScanner().discoverPlugins(pluginSources) : empty;
        }
        catch (Throwable t) {
            throw new ConnectException(String.format("Unable to perform ServiceLoader scanning as requested by %s=%s. It may be possible to fix this issue by reconfiguring %s=%s", new Object[]{"plugin.discovery", discoveryMode, "plugin.discovery", PluginDiscoveryMode.ONLY_SCAN}), t);
        }
        PluginScanResult reflectiveScanResult = discoveryMode.reflectivelyScan() ? new ReflectionScanner().discoverPlugins(pluginSources) : empty;
        PluginScanResult scanResult = new PluginScanResult(Arrays.asList(reflectiveScanResult, serviceLoadingScanResult));
        Plugins.maybeReportHybridDiscoveryIssue(discoveryMode, serviceLoadingScanResult, scanResult);
        this.delegatingLoader.installDiscoveredPlugins(scanResult);
        return scanResult;
    }

    private void maybeInitLazyLoader(PluginClassLoaderFactory factory, PluginDiscoveryMode discoveryMode) {
        if (this.lazyLoadManifestPath == null) {
            return;
        }
        try (InputStream is = Files.newInputStream(Paths.get(this.lazyLoadManifestPath.toUri()), new OpenOption[0]);){
            this.lazyLoadPluginDesc = (Map)new ObjectMapper().readValue(is, (TypeReference)new TypeReference<Map<PluginType, Map<String, LazyPluginInfo>>>(){});
            log.info("Lazy Manifest listed following plugins {}", this.lazyLoadPluginDesc);
        }
        catch (IOException e2) {
            log.error("Failed to read lazyLoadManifest file at {}", (Object)this.lazyLoadManifestPath, (Object)e2);
            throw new ConnectException("Failed to read lazyLoadManifest", (Throwable)e2);
        }
        Function<LazyPluginInfo, PluginSource> lazyPluginSource = pluginInfo -> {
            try {
                return PluginUtils.isolatedPluginSource(Paths.get(pluginInfo.location().toURI()), this.delegatingLoader, factory);
            }
            catch (MalformedURLException | URISyntaxException | InvalidPathException e) {
                log.error("Invalid path in Lazy plugin path: {}. Ignoring.", pluginInfo, (Object)e);
            }
            catch (IOException e) {
                log.error("Could not get listing for Lazy plugin path: {}. Ignoring.", pluginInfo, (Object)e);
            }
            return null;
        };
        HashMap pluginSourceLocationMap = new HashMap();
        this.lazyLoadPluginDesc.values().stream().flatMap(pluginInfoMap -> pluginInfoMap.values().stream()).distinct().forEach(pluginInfo -> {
            String location = pluginInfo.location().toString();
            pluginSourceLocationMap.computeIfAbsent(location, k -> (PluginSource)lazyPluginSource.apply((LazyPluginInfo)pluginInfo));
        });
        ConcurrentMap<String, PluginSource> lazyLoadPluginSourcesMap = this.lazyLoadPluginDesc.values().stream().flatMap(map -> map.entrySet().stream()).collect(Collectors.toConcurrentMap(Map.Entry::getKey, e -> (PluginSource)pluginSourceLocationMap.get(((LazyPluginInfo)e.getValue()).location().toString())));
        this.delegatingLoader.lazyLoadPlugins(new LazyLoadScanner(lazyLoadPluginSourcesMap, discoveryMode));
    }

    static void maybeReportHybridDiscoveryIssue(PluginDiscoveryMode discoveryMode, PluginScanResult serviceLoadingScanResult, PluginScanResult mergedResult) {
        TreeSet missingPlugins = new TreeSet();
        mergedResult.forEach(missingPlugins::add);
        serviceLoadingScanResult.forEach(missingPlugins::remove);
        if (missingPlugins.isEmpty()) {
            if (discoveryMode == PluginDiscoveryMode.HYBRID_WARN || discoveryMode == PluginDiscoveryMode.HYBRID_FAIL) {
                log.warn("All plugins have ServiceLoader manifests, consider reconfiguring {}={}", (Object)"plugin.discovery", (Object)PluginDiscoveryMode.SERVICE_LOAD);
            }
        } else {
            String message = String.format("One or more plugins are missing ServiceLoader manifests may not be usable with %s=%s: %s%nRead the documentation at %s for instructions on migrating your plugins to take advantage of the performance improvements of %s mode.", new Object[]{"plugin.discovery", PluginDiscoveryMode.SERVICE_LOAD, missingPlugins.stream().map(pluginDesc -> pluginDesc.location() + "\t" + pluginDesc.className() + "\t" + (Object)((Object)pluginDesc.type()) + "\t" + pluginDesc.version()).collect(Collectors.joining("\n", "[\n", "\n]")), "https://kafka.apache.org/documentation.html#connect_plugindiscovery", PluginDiscoveryMode.SERVICE_LOAD});
            if (discoveryMode == PluginDiscoveryMode.HYBRID_WARN) {
                log.warn("{} To silence this warning, set {}={} in the worker config.", new Object[]{message, "plugin.discovery", PluginDiscoveryMode.ONLY_SCAN});
            } else if (discoveryMode == PluginDiscoveryMode.HYBRID_FAIL) {
                throw new ConnectException(String.format("%s To silence this error, set %s=%s in the worker config.", new Object[]{message, "plugin.discovery", PluginDiscoveryMode.HYBRID_WARN}));
            }
        }
    }

    private static <T> String pluginNames(Collection<PluginDesc<T>> plugins) {
        return plugins.stream().map(PluginDesc::toString).collect(Collectors.joining(", "));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T newPlugin(Class<T> klass) {
        try (LoaderSwap loaderSwap = this.withClassLoader(klass.getClassLoader());){
            Object object = Utils.newInstance(klass);
            return (T)object;
        }
        catch (Throwable t) {
            throw new ConnectException("Instantiation error", t);
        }
    }

    protected <U> Class<? extends U> pluginClassFromConfig(AbstractConfig config, String propertyName, Class<U> pluginClass, Collection<PluginDesc<U>> plugins) {
        Class klass = config.getClass(propertyName);
        if (pluginClass.isAssignableFrom(klass)) {
            return klass;
        }
        throw new ConnectException("Failed to find any class that implements " + pluginClass.getSimpleName() + " for the config " + propertyName + ", available classes are: " + Plugins.pluginNames(plugins));
    }

    protected static <U> Class<? extends U> pluginClass(DelegatingClassLoader loader, String classOrAlias, Class<U> pluginClass) throws ClassNotFoundException {
        Class<?> klass = loader.loadClass(classOrAlias, false);
        if (pluginClass.isAssignableFrom(klass)) {
            return klass;
        }
        throw new ClassNotFoundException("Requested class: " + classOrAlias + " does not extend " + pluginClass.getSimpleName());
    }

    public Class<?> pluginClass(String classOrAlias) throws ClassNotFoundException {
        return Plugins.pluginClass(this.delegatingLoader, classOrAlias, Object.class);
    }

    public static ClassLoader compareAndSwapLoaders(ClassLoader loader) {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        if (!current.equals(loader)) {
            Thread.currentThread().setContextClassLoader(loader);
        }
        return current;
    }

    public ClassLoader compareAndSwapWithDelegatingLoader() {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        if (!current.equals(this.delegatingLoader)) {
            Thread.currentThread().setContextClassLoader(this.delegatingLoader);
        }
        return current;
    }

    public LoaderSwap withClassLoader(ClassLoader loader) {
        ClassLoader savedLoader = Plugins.compareAndSwapLoaders(loader);
        try {
            return new LoaderSwap(savedLoader);
        }
        catch (Throwable t) {
            Plugins.compareAndSwapLoaders(savedLoader);
            throw t;
        }
    }

    public Runnable withClassLoader(ClassLoader classLoader, Runnable operation) {
        return () -> {
            try (LoaderSwap loaderSwap = this.withClassLoader(classLoader);){
                operation.run();
            }
        };
    }

    public DelegatingClassLoader delegatingLoader() {
        return this.delegatingLoader;
    }

    public ClassLoader connectorLoader(String connectorClassOrAlias) {
        return this.delegatingLoader.connectorLoader(connectorClassOrAlias);
    }

    public Set<PluginDesc<Connector>> connectors() {
        TreeSet<PluginDesc<Connector>> connectors = new TreeSet<PluginDesc<Connector>>(this.sinkConnectors());
        connectors.addAll(this.sourceConnectors());
        return connectors;
    }

    public Set<PluginDesc<SinkConnector>> sinkConnectors() {
        return this.scanResult.sinkConnectors();
    }

    public Set<PluginDesc<SourceConnector>> sourceConnectors() {
        return this.scanResult.sourceConnectors();
    }

    public Set<PluginDesc<Converter>> converters() {
        return this.scanResult.converters();
    }

    public Set<PluginDesc<HeaderConverter>> headerConverters() {
        return this.scanResult.headerConverters();
    }

    public Set<PluginDesc<Transformation<?>>> transformations() {
        return this.scanResult.transformations();
    }

    public Set<PluginDesc<Predicate<?>>> predicates() {
        return this.scanResult.predicates();
    }

    public Set<PluginDesc<ConnectorClientConfigOverridePolicy>> connectorClientConfigPolicies() {
        return this.scanResult.connectorClientConfigPolicies();
    }

    public PluginScanResult scanResult() {
        return this.scanResult;
    }

    public Object newPlugin(String classOrAlias) throws ClassNotFoundException {
        Class<Object> klass = Plugins.pluginClass(this.delegatingLoader, classOrAlias, Object.class);
        return this.newPlugin(klass);
    }

    public Connector newConnector(String connectorClassOrAlias) {
        Class<? extends Connector> klass = this.connectorClass(connectorClassOrAlias);
        return this.newPlugin(klass);
    }

    public Class<? extends Connector> connectorClass(String connectorClassOrAlias) {
        Class<Object> klass;
        try {
            klass = Plugins.pluginClass(this.delegatingLoader, connectorClassOrAlias, Connector.class);
        }
        catch (ClassNotFoundException e) {
            ArrayList<PluginDesc<Connector>> matches = new ArrayList<PluginDesc<Connector>>();
            Set<PluginDesc<Connector>> connectors = this.connectors();
            for (PluginDesc<Connector> plugin : connectors) {
                Class<Connector> pluginClass = plugin.pluginClass();
                String simpleName = pluginClass.getSimpleName();
                if (!simpleName.equals(connectorClassOrAlias) && !simpleName.equals(connectorClassOrAlias + "Connector")) continue;
                matches.add(plugin);
            }
            if (matches.isEmpty()) {
                throw new ConnectException("Failed to find any class that implements Connector and which name matches " + connectorClassOrAlias + ", available connectors are: " + connectors.stream().map(PluginDesc::toString).collect(Collectors.joining(", ")));
            }
            if (matches.size() > 1) {
                throw new ConnectException("More than one connector matches alias " + connectorClassOrAlias + ". Please use full package and class name instead. Classes found: " + connectors.stream().map(PluginDesc::toString).collect(Collectors.joining(", ")));
            }
            PluginDesc entry = (PluginDesc)matches.get(0);
            klass = entry.pluginClass();
        }
        return klass;
    }

    public Task newTask(Class<? extends Task> taskClass) {
        return this.newPlugin(taskClass);
    }

    public Converter newConverter(AbstractConfig config, String classPropertyName, ClassLoaderUsage classLoaderUsage) {
        Converter plugin;
        if (!config.originals().containsKey(classPropertyName)) {
            return null;
        }
        Class<Converter> klass = null;
        switch (classLoaderUsage) {
            case CURRENT_CLASSLOADER: {
                klass = this.pluginClassFromConfig(config, classPropertyName, Converter.class, this.scanResult.converters());
                break;
            }
            case PLUGINS: {
                String converterClassOrAlias = config.getClass(classPropertyName).getName();
                try {
                    klass = Plugins.pluginClass(this.delegatingLoader, converterClassOrAlias, Converter.class);
                    break;
                }
                catch (ClassNotFoundException e) {
                    throw new ConnectException("Failed to find any class that implements Converter and which name matches " + converterClassOrAlias + ", available converters are: " + Plugins.pluginNames(this.scanResult.converters()));
                }
            }
        }
        if (klass == null) {
            throw new ConnectException("Unable to initialize the Converter specified in '" + classPropertyName + "'");
        }
        boolean isKeyConverter = "key.converter".equals(classPropertyName);
        String configPrefix = classPropertyName + ".";
        Map converterConfig = config.originalsWithPrefix(configPrefix);
        log.debug("Configuring the {} converter with configuration keys:{}{}", new Object[]{isKeyConverter ? "key" : "value", System.lineSeparator(), converterConfig.keySet()});
        try (LoaderSwap loaderSwap = this.withClassLoader(klass.getClassLoader());){
            plugin = this.newPlugin(klass);
            plugin.configure(converterConfig, isKeyConverter);
        }
        return plugin;
    }

    public Converter newInternalConverter(boolean isKey, String className, Map<String, String> converterConfig) {
        Converter plugin;
        Class<Converter> klass;
        try {
            klass = Plugins.pluginClass(this.delegatingLoader, className, Converter.class);
        }
        catch (ClassNotFoundException e) {
            throw new ConnectException("Failed to load internal converter class " + className);
        }
        try (LoaderSwap loaderSwap = this.withClassLoader(klass.getClassLoader());){
            plugin = this.newPlugin(klass);
            plugin.configure(converterConfig, isKey);
        }
        return plugin;
    }

    public HeaderConverter newHeaderConverter(AbstractConfig config, String classPropertyName, ClassLoaderUsage classLoaderUsage) {
        HeaderConverter plugin;
        Class<HeaderConverter> klass = null;
        switch (classLoaderUsage) {
            case CURRENT_CLASSLOADER: {
                if (!config.originals().containsKey(classPropertyName)) {
                    return null;
                }
                klass = this.pluginClassFromConfig(config, classPropertyName, HeaderConverter.class, this.scanResult.headerConverters());
                break;
            }
            case PLUGINS: {
                String converterClassOrAlias = config.getClass(classPropertyName).getName();
                try {
                    klass = Plugins.pluginClass(this.delegatingLoader, converterClassOrAlias, HeaderConverter.class);
                    break;
                }
                catch (ClassNotFoundException e) {
                    throw new ConnectException("Failed to find any class that implements HeaderConverter and which name matches " + converterClassOrAlias + ", available header converters are: " + Plugins.pluginNames(this.scanResult.headerConverters()));
                }
            }
        }
        if (klass == null) {
            throw new ConnectException("Unable to initialize the HeaderConverter specified in '" + classPropertyName + "'");
        }
        String configPrefix = classPropertyName + ".";
        Map converterConfig = config.originalsWithPrefix(configPrefix);
        converterConfig.put("converter.type", ConverterType.HEADER.getName());
        log.debug("Configuring the header converter with configuration keys:{}{}", (Object)System.lineSeparator(), converterConfig.keySet());
        try (LoaderSwap loaderSwap = this.withClassLoader(klass.getClassLoader());){
            plugin = this.newPlugin(klass);
            plugin.configure(converterConfig);
        }
        return plugin;
    }

    public ConfigProvider newConfigProvider(AbstractConfig config, String providerPrefix, ClassLoaderUsage classLoaderUsage) {
        ConfigProvider plugin;
        String classPropertyName = providerPrefix + ".class";
        Map originalConfig = config.originalsStrings();
        if (!originalConfig.containsKey(classPropertyName)) {
            return null;
        }
        Class<ConfigProvider> klass = null;
        switch (classLoaderUsage) {
            case CURRENT_CLASSLOADER: {
                klass = this.pluginClassFromConfig(config, classPropertyName, ConfigProvider.class, this.scanResult.configProviders());
                break;
            }
            case PLUGINS: {
                String configProviderClassOrAlias = (String)originalConfig.get(classPropertyName);
                try {
                    klass = Plugins.pluginClass(this.delegatingLoader, configProviderClassOrAlias, ConfigProvider.class);
                    break;
                }
                catch (ClassNotFoundException e) {
                    throw new ConnectException("Failed to find any class that implements ConfigProvider and which name matches " + configProviderClassOrAlias + ", available ConfigProviders are: " + Plugins.pluginNames(this.scanResult.configProviders()));
                }
            }
        }
        if (klass == null) {
            throw new ConnectException("Unable to initialize the ConfigProvider specified in '" + classPropertyName + "'");
        }
        String configPrefix = providerPrefix + ".param.";
        Map configProviderConfig = config.originalsWithPrefix(configPrefix);
        try (LoaderSwap loaderSwap = this.withClassLoader(klass.getClassLoader());){
            plugin = this.newPlugin(klass);
            plugin.configure(configProviderConfig);
        }
        return plugin;
    }

    public <T> List<T> newPlugins(List<String> klassNames, AbstractConfig config, Class<T> pluginKlass) {
        ArrayList<T> plugins = new ArrayList<T>();
        if (klassNames != null) {
            for (String klassName : klassNames) {
                plugins.add(this.newPlugin(klassName, config, pluginKlass));
            }
        }
        return plugins;
    }

    public <T> T newPlugin(String klassName, AbstractConfig config, Class<T> pluginKlass) {
        T plugin;
        Class<T> klass;
        try {
            klass = Plugins.pluginClass(this.delegatingLoader, klassName, pluginKlass);
        }
        catch (ClassNotFoundException e) {
            String msg = String.format("Failed to find any class that implements %s and which name matches %s", pluginKlass, klassName);
            throw new ConnectException(msg);
        }
        try (LoaderSwap loaderSwap = this.withClassLoader(klass.getClassLoader());){
            Versioned versionedPlugin;
            plugin = this.newPlugin(klass);
            if (plugin instanceof Versioned && Utils.isBlank((String)(versionedPlugin = (Versioned)plugin).version())) {
                throw new ConnectException("Version not defined for '" + klassName + "'");
            }
            if (plugin instanceof Configurable) {
                ((Configurable)plugin).configure(config.originals());
            }
        }
        return plugin;
    }

    public boolean lazyLoadEnabled() {
        return this.lazyLoadManifestPath != null;
    }

    public Map<PluginType, Map<String, LazyPluginInfo>> lazyLoadPluginDesc() {
        return this.lazyLoadPluginDesc;
    }

    public static enum ClassLoaderUsage {
        CURRENT_CLASSLOADER,
        PLUGINS;

    }
}

