/*
 * Decompiled with CFR 0.152.
 */
package io.kcache;

import io.kcache.KeyValue;
import io.kcache.KeyValueIterator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.kafka.common.serialization.Serde;

public class KeyValueIterators {
    private static final KeyValueIterator<?, ?> EMPTY_ITERATOR = new EmptyKeyValueIterator();

    public static <K, V> KeyValueIterator<K, V> limit(final KeyValueIterator<K, V> iterator, final int limit) {
        return new KeyValueIterator<K, V>(){
            private int count = 0;

            @Override
            public boolean hasNext() {
                return iterator.hasNext() && this.count < limit;
            }

            @Override
            public void remove() {
                iterator.remove();
            }

            @Override
            public KeyValue<K, V> next() {
                if (this.count++ >= limit) {
                    throw new NoSuchElementException();
                }
                return (KeyValue)iterator.next();
            }

            @Override
            public void close() {
                iterator.close();
            }
        };
    }

    public static <K, V> KeyValueIterator<K, V> filter(final KeyValueIterator<K, V> iterator, final Predicate<KeyValue<K, V>> predicate) {
        return new KeyValueIterator<K, V>(){
            KeyValue<K, V> nextResult = null;

            @Override
            public boolean hasNext() {
                if (null != this.nextResult) {
                    return true;
                }
                this.advance();
                return null != this.nextResult;
            }

            @Override
            public void remove() {
                iterator.remove();
            }

            @Override
            public KeyValue<K, V> next() {
                try {
                    if (null != this.nextResult) {
                        KeyValue keyValue = this.nextResult;
                        return keyValue;
                    }
                    this.advance();
                    if (null != this.nextResult) {
                        KeyValue keyValue = this.nextResult;
                        return keyValue;
                    }
                    throw new NoSuchElementException();
                }
                finally {
                    this.nextResult = null;
                }
            }

            private void advance() {
                this.nextResult = null;
                while (iterator.hasNext()) {
                    KeyValue s = (KeyValue)iterator.next();
                    if (!predicate.test(s)) continue;
                    this.nextResult = s;
                    return;
                }
            }

            @Override
            public void close() {
                iterator.close();
            }
        };
    }

    public static <K, V, E> Iterator<E> flatMap(final KeyValueIterator<K, V> iterator, final Function<KeyValue<K, V>, Iterator<E>> function) {
        return new Iterator<E>(){
            private Iterator<E> currentIterator = Collections.emptyIterator();

            @Override
            public boolean hasNext() {
                if (this.currentIterator.hasNext()) {
                    return true;
                }
                while (iterator.hasNext()) {
                    this.currentIterator = (Iterator)function.apply((KeyValue)iterator.next());
                    if (!this.currentIterator.hasNext()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void remove() {
                iterator.remove();
            }

            @Override
            public E next() {
                if (this.hasNext()) {
                    return this.currentIterator.next();
                }
                throw new NoSuchElementException();
            }
        };
    }

    @SafeVarargs
    public static <K, V> KeyValueIterator<K, V> concat(KeyValueIterator<K, V> ... iterators) {
        MultiIterator<K, V> iterator = new MultiIterator<K, V>();
        for (KeyValueIterator<K, V> itty : iterators) {
            iterator.addIterator(itty);
        }
        return iterator;
    }

    public static <K, V> KeyValueIterator<K, V> emptyIterator() {
        return EMPTY_ITERATOR;
    }

    public static <K, V> KeyValueIterator<K, V> singletonIterator(KeyValue<K, V> keyValue) {
        return new SingletonKeyValueIterator<K, V>(keyValue);
    }

    public static <K, V> KeyValueIterator<K, V> transformRawIterator(Serde<K> keySerde, Serde<V> valueSerde, Iterator<Map.Entry<byte[], byte[]>> rawIterator) {
        return new TransformedRawEntryIterator<K, V>(keySerde, valueSerde, rawIterator);
    }

    public static <K, V> KeyValueIterator<K, V> transformRawIterator(Serde<K> keySerde, Serde<V> valueSerde, KeyValueIterator<byte[], byte[]> rawIterator) {
        return new TransformedRawKeyValueIterator<K, V>(keySerde, valueSerde, rawIterator);
    }

    private static class TransformedRawKeyValueIterator<K, V>
    implements KeyValueIterator<K, V> {
        private final Serde<K> keySerde;
        private final Serde<V> valueSerde;
        private final KeyValueIterator<byte[], byte[]> rawIterator;

        TransformedRawKeyValueIterator(Serde<K> keySerde, Serde<V> valueSerde, KeyValueIterator<byte[], byte[]> rawIterator) {
            this.keySerde = keySerde;
            this.valueSerde = valueSerde;
            this.rawIterator = rawIterator;
        }

        @Override
        public final boolean hasNext() {
            return this.rawIterator.hasNext();
        }

        @Override
        public final KeyValue<K, V> next() {
            KeyValue keyValue = (KeyValue)this.rawIterator.next();
            return new KeyValue<Object, Object>(this.keySerde.deserializer().deserialize(null, (byte[])keyValue.key), this.valueSerde.deserializer().deserialize(null, (byte[])keyValue.value));
        }

        @Override
        public final void remove() {
            this.rawIterator.remove();
        }

        @Override
        public final void close() {
            this.rawIterator.close();
        }
    }

    private static class TransformedRawEntryIterator<K, V>
    implements KeyValueIterator<K, V> {
        private final Serde<K> keySerde;
        private final Serde<V> valueSerde;
        private final Iterator<Map.Entry<byte[], byte[]>> rawIterator;

        TransformedRawEntryIterator(Serde<K> keySerde, Serde<V> valueSerde, Iterator<Map.Entry<byte[], byte[]>> rawIterator) {
            this.keySerde = keySerde;
            this.valueSerde = valueSerde;
            this.rawIterator = rawIterator;
        }

        @Override
        public final boolean hasNext() {
            return this.rawIterator.hasNext();
        }

        @Override
        public final KeyValue<K, V> next() {
            Map.Entry<byte[], byte[]> keyValue = this.rawIterator.next();
            return new KeyValue<Object, Object>(this.keySerde.deserializer().deserialize(null, keyValue.getKey()), this.valueSerde.deserializer().deserialize(null, keyValue.getValue()));
        }

        @Override
        public final void remove() {
            this.rawIterator.remove();
        }

        @Override
        public final void close() {
        }
    }

    private static class SingletonKeyValueIterator<K, V>
    implements KeyValueIterator<K, V> {
        private boolean beforeFirst = true;
        private final KeyValue<K, V> keyValue;

        public SingletonKeyValueIterator(KeyValue<K, V> keyValue) {
            this.keyValue = keyValue;
        }

        @Override
        public boolean hasNext() {
            return this.beforeFirst;
        }

        @Override
        public KeyValue<K, V> next() {
            if (this.beforeFirst) {
                this.beforeFirst = false;
                return this.keyValue;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() {
        }
    }

    private static class EmptyKeyValueIterator<K, V>
    implements KeyValueIterator<K, V> {
        private EmptyKeyValueIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public KeyValue<K, V> next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() {
        }
    }

    private static class MultiIterator<K, V>
    implements KeyValueIterator<K, V>,
    Serializable {
        private final List<KeyValueIterator<K, V>> iterators = new ArrayList<KeyValueIterator<K, V>>();
        private int current = 0;

        private MultiIterator() {
        }

        public void addIterator(KeyValueIterator<K, V> iterator) {
            this.iterators.add(iterator);
        }

        @Override
        public boolean hasNext() {
            if (this.current >= this.iterators.size()) {
                return false;
            }
            KeyValueIterator<K, V> currentIterator = this.iterators.get(this.current);
            while (true) {
                if (currentIterator.hasNext()) {
                    return true;
                }
                ++this.current;
                if (this.current >= this.iterators.size()) break;
                currentIterator = this.iterators.get(this.current);
            }
            return false;
        }

        @Override
        public void remove() {
            this.iterators.get(this.current).remove();
        }

        @Override
        public KeyValue<K, V> next() {
            if (this.iterators.isEmpty()) {
                throw new NoSuchElementException();
            }
            KeyValueIterator<K, V> currentIterator = this.iterators.get(this.current);
            while (true) {
                if (currentIterator.hasNext()) {
                    return (KeyValue)currentIterator.next();
                }
                ++this.current;
                if (this.current >= this.iterators.size()) break;
                currentIterator = this.iterators.get(this.current);
            }
            throw new NoSuchElementException();
        }

        public void clear() {
            this.iterators.clear();
            this.current = 0;
        }

        @Override
        public void close() {
            this.iterators.forEach(KeyValueIterator::close);
        }
    }
}

