/*
 * Decompiled with CFR 0.152.
 */
package io.kcache.utils;

import com.google.common.util.concurrent.Striped;
import io.kcache.Cache;
import io.kcache.KeyValueIterator;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class Caches {
    public static <K, V> Cache<K, V> concurrentCache(Cache<K, V> m) {
        return new ConcurrentCache<K, V>(m);
    }

    static class ConcurrentSet<E>
    extends ConcurrentCollection<E>
    implements Set<E> {
        private static final long serialVersionUID = 487447009682186044L;

        ConcurrentSet(Set<E> s, Striped<ReadWriteLock> striped) {
            super(s, striped);
        }

        @Override
        public boolean equals(Object o) {
            return this.c.equals(o);
        }

        @Override
        public int hashCode() {
            return this.c.hashCode();
        }
    }

    static class ConcurrentCollection<E>
    implements Collection<E>,
    Serializable {
        private static final long serialVersionUID = 3053995032091335093L;
        final Collection<E> c;
        final transient Striped<ReadWriteLock> striped;

        ConcurrentCollection(Collection<E> c, Striped<ReadWriteLock> striped) {
            this.c = Objects.requireNonNull(c);
            this.striped = Objects.requireNonNull(striped);
        }

        @Override
        public int size() {
            return this.c.size();
        }

        @Override
        public boolean isEmpty() {
            return this.c.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object o) {
            Lock lock = ((ReadWriteLock)this.striped.get(o)).readLock();
            lock.lock();
            try {
                boolean bl = this.c.contains(o);
                return bl;
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        public Object[] toArray() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<E> iterator() {
            return this.c.iterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean add(E e) {
            Lock lock = ((ReadWriteLock)this.striped.get(e)).writeLock();
            lock.lock();
            try {
                boolean bl = this.c.add(e);
                return bl;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object o) {
            Lock lock = ((ReadWriteLock)this.striped.get(o)).writeLock();
            lock.lock();
            try {
                boolean bl = this.c.remove(o);
                return bl;
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        public boolean containsAll(Collection<?> coll) {
            for (Object o : coll) {
                if (this.contains(o)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends E> coll) {
            boolean changed = false;
            for (E e : coll) {
                changed |= this.c.add(e);
            }
            return changed;
        }

        @Override
        public boolean removeAll(Collection<?> coll) {
            boolean changed = false;
            for (Object o : coll) {
                changed |= this.c.remove(o);
            }
            return changed;
        }

        @Override
        public boolean retainAll(Collection<?> coll) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.c.toString();
        }

        @Override
        public void forEach(Consumer<? super E> consumer) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeIf(Predicate<? super E> filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Spliterator<E> spliterator() {
            return this.c.spliterator();
        }

        @Override
        public Stream<E> stream() {
            return this.c.stream();
        }

        @Override
        public Stream<E> parallelStream() {
            return this.c.parallelStream();
        }
    }

    private static class ConcurrentCache<K, V>
    implements Cache<K, V>,
    Serializable {
        private static final long serialVersionUID = 1978198479659022715L;
        private final Cache<K, V> m;
        final transient Striped<ReadWriteLock> striped;
        private transient Set<K> keySet;
        private transient Set<Map.Entry<K, V>> entrySet;
        private transient Collection<V> values;

        ConcurrentCache(Cache<K, V> m) {
            this.m = Objects.requireNonNull(m);
            this.striped = Striped.readWriteLock((int)128);
        }

        ConcurrentCache(Cache<K, V> m, Striped<ReadWriteLock> striped) {
            this.m = m;
            this.striped = striped;
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.m.comparator();
        }

        @Override
        public boolean isPersistent() {
            return this.m.isPersistent();
        }

        @Override
        public synchronized void init() {
            this.m.init();
        }

        @Override
        public void reset() {
            this.m.reset();
        }

        @Override
        public void sync() {
            this.m.sync();
        }

        @Override
        public int size() {
            return this.m.size();
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsKey(Object key) {
            Lock lock = ((ReadWriteLock)this.striped.get(key)).readLock();
            lock.lock();
            try {
                boolean bl = this.m.containsKey(key);
                return bl;
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        public boolean containsValue(Object value) {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V get(Object key) {
            Lock lock = ((ReadWriteLock)this.striped.get(key)).readLock();
            lock.lock();
            try {
                Object v = this.m.get(key);
                return v;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V put(K key, V value) {
            Lock lock = ((ReadWriteLock)this.striped.get(key)).writeLock();
            lock.lock();
            try {
                V v = this.m.put(key, value);
                return v;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V remove(Object key) {
            Lock lock = ((ReadWriteLock)this.striped.get(key)).writeLock();
            lock.lock();
            try {
                Object v = this.m.remove(key);
                return v;
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            this.m.putAll(map);
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public K firstKey() {
            return this.m.firstKey();
        }

        @Override
        public K lastKey() {
            return this.m.lastKey();
        }

        @Override
        public Cache<K, V> subCache(K from, boolean fromInclusive, K to, boolean toInclusive) {
            return this.m.subCache(from, fromInclusive, to, toInclusive);
        }

        @Override
        public KeyValueIterator<K, V> range(K from, boolean fromInclusive, K to, boolean toInclusive) {
            return this.m.range(from, fromInclusive, to, toInclusive);
        }

        @Override
        public KeyValueIterator<K, V> all() {
            return this.m.all();
        }

        @Override
        public Cache<K, V> descendingCache() {
            return this.m.descendingCache();
        }

        @Override
        public void flush() {
            this.m.flush();
        }

        @Override
        public synchronized void close() throws IOException {
            this.m.close();
        }

        @Override
        public synchronized void destroy() throws IOException {
            this.m.destroy();
        }

        @Override
        public Set<K> keySet() {
            return new ConcurrentSet(this.m.keySet(), this.striped);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new ConcurrentSet(this.m.entrySet(), this.striped);
        }

        @Override
        public Collection<V> values() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return this.m.equals(o);
        }

        @Override
        public int hashCode() {
            return this.m.hashCode();
        }

        public String toString() {
            return this.m.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V getOrDefault(Object k, V defaultValue) {
            Lock lock = ((ReadWriteLock)this.striped.get(k)).readLock();
            lock.lock();
            try {
                V v = this.m.getOrDefault(k, defaultValue);
                return v;
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        public void forEach(BiConsumer<? super K, ? super V> action) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V putIfAbsent(K key, V value) {
            Lock lock = ((ReadWriteLock)this.striped.get(key)).writeLock();
            lock.lock();
            try {
                V v = this.m.putIfAbsent(key, value);
                return v;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object key, Object value) {
            Lock lock = ((ReadWriteLock)this.striped.get(key)).writeLock();
            lock.lock();
            try {
                boolean bl = this.m.remove(key, value);
                return bl;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean replace(K key, V oldValue, V newValue) {
            Lock lock = ((ReadWriteLock)this.striped.get(key)).writeLock();
            lock.lock();
            try {
                boolean bl = this.m.replace(key, oldValue, newValue);
                return bl;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V replace(K key, V value) {
            Lock lock = ((ReadWriteLock)this.striped.get(key)).writeLock();
            lock.lock();
            try {
                V v = this.m.replace(key, value);
                return v;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V computeIfAbsent(K key, Function<? super K, ? extends V> MappingFunction) {
            Lock lock = ((ReadWriteLock)this.striped.get(key)).writeLock();
            lock.lock();
            try {
                V v = this.m.computeIfAbsent((K)key, MappingFunction);
                return v;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
            Lock lock = ((ReadWriteLock)this.striped.get(key)).writeLock();
            lock.lock();
            try {
                V v = this.m.computeIfPresent((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
                return v;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
            Lock lock = ((ReadWriteLock)this.striped.get(key)).writeLock();
            lock.lock();
            try {
                V v = this.m.compute((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
                return v;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
            Lock lock = ((ReadWriteLock)this.striped.get(key)).writeLock();
            lock.lock();
            try {
                V v = this.m.merge(key, (V)value, (BiFunction<? extends V, ? extends V, ? extends V>)remappingFunction);
                return v;
            }
            finally {
                lock.unlock();
            }
        }
    }
}

