/*
 * Decompiled with CFR 0.152.
 */
package io.kcache.utils;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.kcache.CacheLoader;
import io.kcache.utils.InMemoryCache;
import java.time.Duration;
import java.util.Comparator;
import java.util.Map;
import javax.annotation.Nullable;

public class InMemoryBoundedCache<K, V>
extends InMemoryCache<K, V> {
    private final Cache<K, V> cache;
    private final CacheLoader<K, V> loader;

    public InMemoryBoundedCache(Comparator<? super K> comparator) {
        this(null, null, null, comparator);
    }

    public InMemoryBoundedCache(Integer maximumSize, Duration expireAfterWrite, CacheLoader<K, V> loader) {
        this.loader = loader;
        this.cache = this.createCache(maximumSize, expireAfterWrite);
    }

    public InMemoryBoundedCache(Integer maximumSize, Duration expireAfterWrite, CacheLoader<K, V> loader, Comparator<? super K> comparator) {
        super(comparator);
        this.loader = loader;
        this.cache = this.createCache(maximumSize, expireAfterWrite);
    }

    private Cache<K, V> createCache(Integer maximumSize, Duration expireAfterWrite) {
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder().removalListener(entry -> this.delegate().remove(entry.getKey(), entry.getValue()));
        if (maximumSize != null && maximumSize >= 0) {
            cacheBuilder = cacheBuilder.maximumSize((long)maximumSize.intValue());
        }
        if (expireAfterWrite != null && !expireAfterWrite.isNegative()) {
            cacheBuilder = cacheBuilder.expireAfterWrite(expireAfterWrite);
        }
        if (this.loader != null) {
            return cacheBuilder.build(new com.google.common.cache.CacheLoader<K, V>(){

                @Nullable
                public V load(K key) throws Exception {
                    Object value = InMemoryBoundedCache.this.loader.load(key);
                    if (value != null) {
                        InMemoryBoundedCache.this.delegate().put(key, value);
                    }
                    return value;
                }
            });
        }
        return cacheBuilder.build();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public V get(Object key) {
        if (this.loader != null) {
            try {
                return (V)((LoadingCache)this.cache).getUnchecked(key);
            }
            catch (CacheLoader.InvalidCacheLoadException e) {
                return null;
            }
        }
        return (V)super.get(key);
    }

    @Override
    public V put(K key, V value) {
        this.cache.put(key, value);
        return (V)super.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> entries) {
        this.cache.putAll(entries);
        super.putAll(entries);
    }

    @Override
    public V remove(Object key) {
        if (key != null) {
            this.cache.invalidate(key);
        }
        return (V)super.remove(key);
    }

    @Override
    public void clear() {
        this.cache.invalidateAll();
        super.clear();
    }
}

