/*
 * Decompiled with CFR 0.152.
 */
package io.kcache.utils;

import com.google.common.primitives.SignedBytes;
import io.kcache.Cache;
import io.kcache.KeyValue;
import io.kcache.KeyValueIterator;
import io.kcache.exceptions.CacheException;
import io.kcache.exceptions.CacheInitializationException;
import io.kcache.utils.KeyComparator;
import io.kcache.utils.Streams;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.kafka.common.Configurable;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PersistentCache<K, V>
implements Cache<K, V>,
Configurable {
    private static final Logger log = LoggerFactory.getLogger(PersistentCache.class);
    public static final String DELETEME_FILE_NAME = "deleteme";
    public static final String MOVEME_FILE_NAME = "moveme";
    private static final Comparator<byte[]> BYTES_COMPARATOR = SignedBytes.lexicographicalComparator();
    private final String name;
    private final String parentDir;
    private final String rootDir;
    private final File dbDir;
    private final Serde<K> keySerde;
    private final Serde<V> valueSerde;
    private final Comparator<K> comparator;
    private volatile boolean open = false;

    public PersistentCache(String name, String parentDir, String rootDir, Serde<K> keySerde, Serde<V> valueSerde, Comparator<K> comparator) {
        this.name = name;
        this.parentDir = parentDir;
        this.rootDir = rootDir;
        this.dbDir = new File(new File(rootDir, parentDir), name);
        this.keySerde = keySerde;
        this.valueSerde = valueSerde;
        this.comparator = comparator != null ? comparator : new KeyComparator<K>(keySerde, BYTES_COMPARATOR);
    }

    @Override
    public boolean isPersistent() {
        return true;
    }

    public String name() {
        return this.name;
    }

    public String parentDir() {
        return this.parentDir;
    }

    public String rootDir() {
        return this.rootDir;
    }

    public File dbDir() {
        return this.dbDir;
    }

    public Serde<K> keySerde() {
        return this.keySerde;
    }

    public Serde<V> valueSerde() {
        return this.valueSerde;
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.comparator;
    }

    @Override
    public synchronized void init() {
        try {
            this.checkForDeleteOrMove();
            Files.createDirectories(this.dbDir.getParentFile().toPath(), new FileAttribute[0]);
            Files.createDirectories(this.dbDir.getAbsoluteFile().toPath(), new FileAttribute[0]);
        }
        catch (IOException fatal) {
            throw new CacheInitializationException("Could not create directories", fatal);
        }
        this.openDB();
        this.open = true;
    }

    private void checkForDeleteOrMove() throws IOException {
        File deleteme = new File(this.rootDir, DELETEME_FILE_NAME);
        File moveme = new File(this.rootDir, MOVEME_FILE_NAME);
        if (deleteme.exists()) {
            File dir = new File(this.rootDir);
            if (!PersistentCache.deleteDirectory(dir)) {
                log.error("Could not delete root dir: {}", (Object)dir);
            }
        } else if (moveme.exists()) {
            File backupDir = new File(this.rootDir + ".bak");
            if (backupDir.exists()) {
                if (!PersistentCache.deleteDirectory(backupDir)) {
                    log.error("Could not delete backup dir: {}", (Object)backupDir);
                } else {
                    Files.move(Paths.get(this.rootDir, new String[0]), backupDir.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
            } else {
                Files.move(Paths.get(this.rootDir, new String[0]), backupDir.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
        }
    }

    private static boolean deleteDirectory(File directoryToBeDeleted) {
        File[] allContents = directoryToBeDeleted.listFiles();
        if (allContents != null) {
            for (File file : allContents) {
                PersistentCache.deleteDirectory(file);
            }
        }
        return directoryToBeDeleted.delete();
    }

    protected abstract void openDB();

    @Override
    public void reset() {
    }

    @Override
    public void sync() {
    }

    protected void validateStoreOpen() {
        if (!this.open) {
            throw new CacheException("Cache is currently closed");
        }
    }

    @Override
    public boolean isEmpty() {
        this.validateStoreOpen();
        try (KeyValueIterator<K, V> iter = this.all();){
            boolean bl = iter.hasNext();
            return bl;
        }
    }

    @Override
    public boolean containsKey(Object key) {
        this.validateStoreOpen();
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V putIfAbsent(K key, V value) {
        Objects.requireNonNull(key, "key cannot be null");
        Object originalValue = this.get(key);
        if (originalValue == null) {
            this.put(key, value);
        }
        return originalValue;
    }

    @Override
    public Cache<K, V> subCache(K from, boolean fromInclusive, K to, boolean toInclusive) {
        return new SubCache(this, from, fromInclusive, to, toInclusive, false);
    }

    @Override
    public Cache<K, V> descendingCache() {
        return new SubCache(this, null, false, null, false, true);
    }

    @Override
    public Set<K> keySet() {
        try (KeyValueIterator<K, V> iter = this.all();){
            Set set = Streams.streamOf(iter).map(kv -> kv.key).collect(Collectors.toCollection(() -> new TreeSet<K>(this.comparator())));
            return set;
        }
    }

    @Override
    public Collection<V> values() {
        try (KeyValueIterator<K, V> iter = this.all();){
            Collection collection = Streams.streamOf(iter).map(kv -> kv.value).collect(Collectors.toList());
            return collection;
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        try (KeyValueIterator<K, V> iter = this.all();){
            Set set = Streams.streamOf(iter).map(kv -> new AbstractMap.SimpleEntry(kv.key, kv.value)).collect(Collectors.toCollection(() -> new TreeSet((e1, e2) -> this.comparator().compare(e1.getKey(), e2.getKey()))));
            return set;
        }
    }

    @Override
    public K firstKey() {
        try (KeyValueIterator<K, V> iter = this.all(false);){
            if (!iter.hasNext()) {
                throw new NoSuchElementException();
            }
            Object k = ((KeyValue)iter.next()).key;
            return k;
        }
    }

    @Override
    public K lastKey() {
        try (KeyValueIterator<K, V> iter = this.all(true);){
            if (!iter.hasNext()) {
                throw new NoSuchElementException();
            }
            Object k = ((KeyValue)iter.next()).key;
            return k;
        }
    }

    @Override
    public KeyValueIterator<K, V> range(K from, boolean fromInclusive, K to, boolean toInclusive) {
        return this.range(from, fromInclusive, to, toInclusive, false);
    }

    protected abstract KeyValueIterator<K, V> range(K var1, boolean var2, K var3, boolean var4, boolean var5);

    @Override
    public KeyValueIterator<K, V> all() {
        return this.all(false);
    }

    protected abstract KeyValueIterator<K, V> all(boolean var1);

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void close() {
        if (!this.open) {
            return;
        }
        this.open = false;
        this.closeDB();
    }

    protected abstract void closeDB();

    @Override
    public synchronized void destroy() throws IOException {
        Utils.delete((File)this.dbDir());
    }

    static int cpr(Comparator c, Object x, Object y) {
        return c != null ? c.compare(x, y) : ((Comparable)x).compareTo(y);
    }

    static final class SubCache<K, V>
    implements Cache<K, V> {
        private final PersistentCache<K, V> m;
        private final K lo;
        private final K hi;
        private final boolean loInclusive;
        private final boolean hiInclusive;
        private final boolean isDescending;

        SubCache(PersistentCache<K, V> map, K fromKey, boolean fromInclusive, K toKey, boolean toInclusive, boolean isDescending) {
            Comparator cmp = ((PersistentCache)map).comparator;
            if (fromKey != null && toKey != null && PersistentCache.cpr(cmp, fromKey, toKey) > 0) {
                throw new IllegalArgumentException("inconsistent range");
            }
            this.m = map;
            this.lo = fromKey;
            this.hi = toKey;
            this.loInclusive = fromInclusive;
            this.hiInclusive = toInclusive;
            this.isDescending = isDescending;
        }

        @Override
        public void init() {
        }

        @Override
        public void reset() {
        }

        @Override
        public void sync() {
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }

        @Override
        public void destroy() {
        }

        boolean tooLow(Object key, Comparator<? super K> cmp) {
            int c;
            return this.lo != null && ((c = PersistentCache.cpr(cmp, key, this.lo)) < 0 || c == 0 && !this.loInclusive);
        }

        boolean tooHigh(Object key, Comparator<? super K> cmp) {
            int c;
            return this.hi != null && ((c = PersistentCache.cpr(cmp, key, this.hi)) > 0 || c == 0 && !this.hiInclusive);
        }

        boolean inBounds(Object key, Comparator<? super K> cmp) {
            return !this.tooLow(key, cmp) && !this.tooHigh(key, cmp);
        }

        void checkKeyBounds(K key, Comparator<? super K> cmp) {
            if (key == null) {
                throw new NullPointerException();
            }
            if (!this.inBounds(key, cmp)) {
                throw new IllegalArgumentException("key out of range");
            }
        }

        @Override
        public boolean containsKey(Object key) {
            if (key == null) {
                throw new NullPointerException();
            }
            return this.inBounds(key, ((PersistentCache)this.m).comparator) && this.m.containsKey(key);
        }

        @Override
        public V get(Object key) {
            if (key == null) {
                throw new NullPointerException();
            }
            return !this.inBounds(key, ((PersistentCache)this.m).comparator) ? null : (V)this.m.get(key);
        }

        @Override
        public V put(K key, V value) {
            this.checkKeyBounds(key, ((PersistentCache)this.m).comparator);
            return this.m.put(key, value);
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> entries) {
            for (Map.Entry<K, V> e : entries.entrySet()) {
                this.put(e.getKey(), e.getValue());
            }
        }

        @Override
        public V remove(Object key) {
            return !this.inBounds(key, ((PersistentCache)this.m).comparator) ? null : (V)this.m.remove(key);
        }

        @Override
        public int size() {
            try (KeyValueIterator<K, V> iter = this.all();){
                int n = (int)Streams.streamOf(iter).count();
                return n;
            }
        }

        @Override
        public boolean isEmpty() {
            try (KeyValueIterator<K, V> iter = this.all();){
                boolean bl = iter.hasNext();
                return bl;
            }
        }

        @Override
        public boolean containsValue(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public V putIfAbsent(K key, V value) {
            this.checkKeyBounds(key, ((PersistentCache)this.m).comparator);
            return this.m.putIfAbsent(key, value);
        }

        @Override
        public boolean remove(Object key, Object value) {
            return this.inBounds(key, ((PersistentCache)this.m).comparator) && this.m.remove(key, value);
        }

        @Override
        public boolean replace(K key, V oldValue, V newValue) {
            this.checkKeyBounds(key, ((PersistentCache)this.m).comparator);
            return this.m.replace(key, oldValue, newValue);
        }

        @Override
        public V replace(K key, V value) {
            this.checkKeyBounds(key, ((PersistentCache)this.m).comparator);
            return this.m.replace(key, value);
        }

        @Override
        public Comparator<? super K> comparator() {
            Comparator<K> cmp = this.m.comparator();
            if (this.isDescending) {
                return Collections.reverseOrder(cmp);
            }
            return cmp;
        }

        SubCache<K, V> newSubCache(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
            Comparator cmp = ((PersistentCache)this.m).comparator;
            if (this.isDescending) {
                K tk = fromKey;
                fromKey = toKey;
                toKey = tk;
                boolean ti = fromInclusive;
                fromInclusive = toInclusive;
                toInclusive = ti;
            }
            if (this.lo != null) {
                if (fromKey == null) {
                    fromKey = this.lo;
                    fromInclusive = this.loInclusive;
                } else {
                    int c = PersistentCache.cpr(cmp, fromKey, this.lo);
                    if (c < 0 || c == 0 && !this.loInclusive && fromInclusive) {
                        throw new IllegalArgumentException("key out of range");
                    }
                }
            }
            if (this.hi != null) {
                if (toKey == null) {
                    toKey = this.hi;
                    toInclusive = this.hiInclusive;
                } else {
                    int c = PersistentCache.cpr(cmp, toKey, this.hi);
                    if (c > 0 || c == 0 && !this.hiInclusive && toInclusive) {
                        throw new IllegalArgumentException("key out of range");
                    }
                }
            }
            return new SubCache<K, V>(this.m, fromKey, fromInclusive, toKey, toInclusive, this.isDescending);
        }

        @Override
        public SubCache<K, V> subCache(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
            return this.newSubCache(fromKey, fromInclusive, toKey, toInclusive);
        }

        @Override
        public SubCache<K, V> descendingCache() {
            return new SubCache<K, V>(this.m, this.lo, this.loInclusive, this.hi, this.hiInclusive, !this.isDescending);
        }

        @Override
        public K firstKey() {
            try (KeyValueIterator<K, V> iter = this.all(false);){
                if (!iter.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object k = ((KeyValue)iter.next()).key;
                return k;
            }
        }

        @Override
        public K lastKey() {
            try (KeyValueIterator<K, V> iter = this.all(true);){
                if (!iter.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object k = ((KeyValue)iter.next()).key;
                return k;
            }
        }

        @Override
        public Set<K> keySet() {
            try (KeyValueIterator<K, V> iter = this.all();){
                Set set = Streams.streamOf(iter).map(kv -> kv.key).collect(Collectors.toCollection(() -> new TreeSet<K>(this.comparator())));
                return set;
            }
        }

        @Override
        public Collection<V> values() {
            try (KeyValueIterator<K, V> iter = this.all();){
                Collection collection = Streams.streamOf(iter).map(kv -> kv.value).collect(Collectors.toList());
                return collection;
            }
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            try (KeyValueIterator<K, V> iter = this.all();){
                Set set = Streams.streamOf(iter).map(kv -> new AbstractMap.SimpleEntry(kv.key, kv.value)).collect(Collectors.toCollection(() -> new TreeSet((e1, e2) -> this.comparator().compare(e1.getKey(), e2.getKey()))));
                return set;
            }
        }

        @Override
        public KeyValueIterator<K, V> all() {
            return this.all(false);
        }

        KeyValueIterator<K, V> all(boolean isDescending) {
            if (isDescending == this.isDescending) {
                return this.m.range(this.lo, this.loInclusive, this.hi, this.hiInclusive, false);
            }
            return this.m.range(this.hi, this.hiInclusive, this.lo, this.loInclusive, true);
        }

        @Override
        public KeyValueIterator<K, V> range(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
            int c;
            Comparator cmp = ((PersistentCache)this.m).comparator;
            if (this.lo != null) {
                if (fromKey == null) {
                    fromKey = this.lo;
                    fromInclusive = this.loInclusive;
                } else {
                    c = PersistentCache.cpr(cmp, fromKey, this.lo);
                    if (c < 0 || c == 0 && !this.loInclusive && fromInclusive) {
                        throw new IllegalArgumentException("key out of range");
                    }
                }
            }
            if (this.hi != null) {
                if (toKey == null) {
                    toKey = this.hi;
                    toInclusive = this.hiInclusive;
                } else {
                    c = PersistentCache.cpr(cmp, toKey, this.hi);
                    if (c > 0 || c == 0 && !this.hiInclusive && toInclusive) {
                        throw new IllegalArgumentException("key out of range");
                    }
                }
            }
            return this.m.range(fromKey, fromInclusive, toKey, toInclusive, this.isDescending);
        }
    }
}

