/*
 * Decompiled with CFR 0.152.
 */
package io.kcache.utils;

import io.kcache.Cache;
import io.kcache.KeyValueIterator;
import io.kcache.KeyValueIterators;
import io.kcache.utils.Streams;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.kafka.common.serialization.Serde;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformedRawCache<K, V>
implements Cache<K, V> {
    private static final Logger log = LoggerFactory.getLogger(TransformedRawCache.class);
    private final Serde<K> keySerde;
    private final Serde<V> valueSerde;
    private final Cache<byte[], byte[]> rawCache;
    private final Comparator<K> comparator;

    public TransformedRawCache(Serde<K> keySerde, Serde<V> valueSerde, Cache<byte[], byte[]> rawCache) {
        this.keySerde = keySerde;
        this.valueSerde = valueSerde;
        this.rawCache = rawCache;
        Comparator rawComparator = rawCache.comparator();
        this.comparator = rawComparator == null ? null : (k1, k2) -> {
            byte[] b1 = keySerde.serializer().serialize(null, k1);
            byte[] b2 = keySerde.serializer().serialize(null, k2);
            return rawComparator.compare(b1, b2);
        };
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.comparator;
    }

    @Override
    public boolean isPersistent() {
        return this.rawCache.isPersistent();
    }

    @Override
    public void init() {
        this.rawCache.init();
    }

    @Override
    public void reset() {
        this.rawCache.reset();
    }

    @Override
    public void sync() {
        this.rawCache.sync();
    }

    @Override
    public int size() {
        return this.rawCache.size();
    }

    @Override
    public boolean isEmpty() {
        return this.rawCache.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        byte[] keyBytes = this.keySerde.serializer().serialize(null, key);
        return this.rawCache.containsKey(keyBytes);
    }

    @Override
    public boolean containsValue(Object value) {
        byte[] valueBytes = this.valueSerde.serializer().serialize(null, value);
        return this.rawCache.containsValue(valueBytes);
    }

    @Override
    public V put(K key, V value) {
        Objects.requireNonNull(key, "key cannot be null");
        byte[] keyBytes = this.keySerde.serializer().serialize(null, key);
        byte[] valueBytes = this.valueSerde.serializer().serialize(null, value);
        byte[] originalValueBytes = this.rawCache.put(keyBytes, valueBytes);
        return (V)this.valueSerde.deserializer().deserialize(null, originalValueBytes);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        Objects.requireNonNull(key, "key cannot be null");
        byte[] keyBytes = this.keySerde.serializer().serialize(null, key);
        byte[] valueBytes = this.valueSerde.serializer().serialize(null, value);
        byte[] originalValueBytes = this.rawCache.putIfAbsent(keyBytes, valueBytes);
        return (V)this.valueSerde.deserializer().deserialize(null, originalValueBytes);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> entries) {
        Map<byte[], byte[]> rawEntries = entries.entrySet().stream().collect(Collectors.toMap(e -> this.keySerde.serializer().serialize(null, e.getKey()), e -> this.valueSerde.serializer().serialize(null, e.getValue())));
        this.rawCache.putAll(rawEntries);
    }

    @Override
    public V get(Object key) {
        byte[] keyBytes = this.keySerde.serializer().serialize(null, key);
        byte[] valueBytes = (byte[])this.rawCache.get(keyBytes);
        return (V)this.valueSerde.deserializer().deserialize(null, valueBytes);
    }

    @Override
    public V remove(Object key) {
        Objects.requireNonNull(key, "key cannot be null");
        byte[] keyBytes = this.keySerde.serializer().serialize(null, key);
        byte[] valueBytes = (byte[])this.rawCache.remove(keyBytes);
        return (V)this.valueSerde.deserializer().deserialize(null, valueBytes);
    }

    @Override
    public void clear() {
        this.rawCache.clear();
    }

    @Override
    public Set<K> keySet() {
        try (KeyValueIterator<K, V> iter = this.all();){
            Set set = Streams.streamOf(iter).map(kv -> kv.key).collect(Collectors.toCollection(() -> new TreeSet<K>(this.comparator())));
            return set;
        }
    }

    @Override
    public Collection<V> values() {
        try (KeyValueIterator<K, V> iter = this.all();){
            Collection collection = Streams.streamOf(iter).map(kv -> kv.value).collect(Collectors.toList());
            return collection;
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        try (KeyValueIterator<K, V> iter = this.all();){
            Set set = Streams.streamOf(iter).map(kv -> new AbstractMap.SimpleEntry(kv.key, kv.value)).collect(Collectors.toCollection(() -> new TreeSet((e1, e2) -> this.comparator().compare(e1.getKey(), e2.getKey()))));
            return set;
        }
    }

    @Override
    public K firstKey() {
        return (K)this.keySerde.deserializer().deserialize(null, (byte[])this.rawCache.firstKey());
    }

    @Override
    public K lastKey() {
        return (K)this.keySerde.deserializer().deserialize(null, (byte[])this.rawCache.lastKey());
    }

    @Override
    public Cache<K, V> subCache(K from, boolean fromInclusive, K to, boolean toInclusive) {
        byte[] fromBytes = this.keySerde.serializer().serialize(null, from);
        byte[] toBytes = this.keySerde.serializer().serialize(null, to);
        return new TransformedRawCache<K, V>(this.keySerde, this.valueSerde, this.rawCache.subCache(fromBytes, fromInclusive, toBytes, toInclusive));
    }

    @Override
    public KeyValueIterator<K, V> range(K from, boolean fromInclusive, K to, boolean toInclusive) {
        byte[] fromBytes = this.keySerde.serializer().serialize(null, from);
        byte[] toBytes = this.keySerde.serializer().serialize(null, to);
        KeyValueIterator<byte[], byte[]> rawIterator = this.rawCache.range(fromBytes, fromInclusive, toBytes, toInclusive);
        return KeyValueIterators.transformRawIterator(this.keySerde, this.valueSerde, rawIterator);
    }

    @Override
    public KeyValueIterator<K, V> all() {
        KeyValueIterator<byte[], byte[]> rawIterator = this.rawCache.all();
        return KeyValueIterators.transformRawIterator(this.keySerde, this.valueSerde, rawIterator);
    }

    @Override
    public Cache<K, V> descendingCache() {
        return new TransformedRawCache<K, V>(this.keySerde, this.valueSerde, this.rawCache.descendingCache());
    }

    @Override
    public void flush() {
        this.rawCache.flush();
    }

    @Override
    public void close() throws IOException {
        this.rawCache.close();
    }

    @Override
    public void destroy() throws IOException {
        this.rawCache.destroy();
    }
}

