/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.flink.apiserver.client;

import com.google.gson.reflect.TypeToken;
import io.confluent.flink.apiserver.client.ApiCallback;
import io.confluent.flink.apiserver.client.ApiClient;
import io.confluent.flink.apiserver.client.ApiException;
import io.confluent.flink.apiserver.client.ApiResponse;
import io.confluent.flink.apiserver.client.Configuration;
import io.confluent.flink.apiserver.client.Pair;
import io.confluent.flink.apiserver.client.model.FlinkV2Deployment;
import io.confluent.flink.apiserver.client.model.FlinkV2DeploymentList;
import io.confluent.flink.apiserver.client.model.FlinkV2Job;
import io.confluent.flink.apiserver.client.model.FlinkV2JobList;
import io.confluent.flink.apiserver.client.model.FlinkV2Savepoint;
import io.confluent.flink.apiserver.client.model.FlinkV2SavepointList;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class FlinkV2Api {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public FlinkV2Api() {
        this(Configuration.getDefaultApiClient());
    }

    public FlinkV2Api(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createFlinkV2DeploymentCall(String environment, String org, FlinkV2Deployment flinkV2Deployment, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        FlinkV2Deployment localVarPostBody = flinkV2Deployment;
        String localVarPath = "/apis/flink/v2/orgs/{org}/environments/{environment}/deployments".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createFlinkV2DeploymentValidateBeforeCall(String environment, String org, FlinkV2Deployment flinkV2Deployment, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling createFlinkV2Deployment(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling createFlinkV2Deployment(Async)");
        }
        if (flinkV2Deployment == null) {
            throw new ApiException("Missing the required parameter 'flinkV2Deployment' when calling createFlinkV2Deployment(Async)");
        }
        return this.createFlinkV2DeploymentCall(environment, org, flinkV2Deployment, _callback);
    }

    public FlinkV2Deployment createFlinkV2Deployment(String environment, String org, FlinkV2Deployment flinkV2Deployment) throws ApiException {
        ApiResponse<FlinkV2Deployment> localVarResp = this.createFlinkV2DeploymentWithHttpInfo(environment, org, flinkV2Deployment);
        return localVarResp.getData();
    }

    public ApiResponse<FlinkV2Deployment> createFlinkV2DeploymentWithHttpInfo(String environment, String org, FlinkV2Deployment flinkV2Deployment) throws ApiException {
        Call localVarCall = this.createFlinkV2DeploymentValidateBeforeCall(environment, org, flinkV2Deployment, null);
        Type localVarReturnType = new TypeToken<FlinkV2Deployment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createFlinkV2DeploymentAsync(String environment, String org, FlinkV2Deployment flinkV2Deployment, ApiCallback<FlinkV2Deployment> _callback) throws ApiException {
        Call localVarCall = this.createFlinkV2DeploymentValidateBeforeCall(environment, org, flinkV2Deployment, _callback);
        Type localVarReturnType = new TypeToken<FlinkV2Deployment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createFlinkV2JobCall(String environment, String org, FlinkV2Job flinkV2Job, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        FlinkV2Job localVarPostBody = flinkV2Job;
        String localVarPath = "/apis/flink/v2/orgs/{org}/environments/{environment}/jobs".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createFlinkV2JobValidateBeforeCall(String environment, String org, FlinkV2Job flinkV2Job, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling createFlinkV2Job(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling createFlinkV2Job(Async)");
        }
        if (flinkV2Job == null) {
            throw new ApiException("Missing the required parameter 'flinkV2Job' when calling createFlinkV2Job(Async)");
        }
        return this.createFlinkV2JobCall(environment, org, flinkV2Job, _callback);
    }

    public FlinkV2Job createFlinkV2Job(String environment, String org, FlinkV2Job flinkV2Job) throws ApiException {
        ApiResponse<FlinkV2Job> localVarResp = this.createFlinkV2JobWithHttpInfo(environment, org, flinkV2Job);
        return localVarResp.getData();
    }

    public ApiResponse<FlinkV2Job> createFlinkV2JobWithHttpInfo(String environment, String org, FlinkV2Job flinkV2Job) throws ApiException {
        Call localVarCall = this.createFlinkV2JobValidateBeforeCall(environment, org, flinkV2Job, null);
        Type localVarReturnType = new TypeToken<FlinkV2Job>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createFlinkV2JobAsync(String environment, String org, FlinkV2Job flinkV2Job, ApiCallback<FlinkV2Job> _callback) throws ApiException {
        Call localVarCall = this.createFlinkV2JobValidateBeforeCall(environment, org, flinkV2Job, _callback);
        Type localVarReturnType = new TypeToken<FlinkV2Job>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createFlinkV2SavepointCall(String environment, String org, FlinkV2Savepoint flinkV2Savepoint, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        FlinkV2Savepoint localVarPostBody = flinkV2Savepoint;
        String localVarPath = "/apis/flink/v2/orgs/{org}/environments/{environment}/savepoints".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createFlinkV2SavepointValidateBeforeCall(String environment, String org, FlinkV2Savepoint flinkV2Savepoint, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling createFlinkV2Savepoint(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling createFlinkV2Savepoint(Async)");
        }
        if (flinkV2Savepoint == null) {
            throw new ApiException("Missing the required parameter 'flinkV2Savepoint' when calling createFlinkV2Savepoint(Async)");
        }
        return this.createFlinkV2SavepointCall(environment, org, flinkV2Savepoint, _callback);
    }

    public FlinkV2Savepoint createFlinkV2Savepoint(String environment, String org, FlinkV2Savepoint flinkV2Savepoint) throws ApiException {
        ApiResponse<FlinkV2Savepoint> localVarResp = this.createFlinkV2SavepointWithHttpInfo(environment, org, flinkV2Savepoint);
        return localVarResp.getData();
    }

    public ApiResponse<FlinkV2Savepoint> createFlinkV2SavepointWithHttpInfo(String environment, String org, FlinkV2Savepoint flinkV2Savepoint) throws ApiException {
        Call localVarCall = this.createFlinkV2SavepointValidateBeforeCall(environment, org, flinkV2Savepoint, null);
        Type localVarReturnType = new TypeToken<FlinkV2Savepoint>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createFlinkV2SavepointAsync(String environment, String org, FlinkV2Savepoint flinkV2Savepoint, ApiCallback<FlinkV2Savepoint> _callback) throws ApiException {
        Call localVarCall = this.createFlinkV2SavepointValidateBeforeCall(environment, org, flinkV2Savepoint, _callback);
        Type localVarReturnType = new TypeToken<FlinkV2Savepoint>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteFlinkV2DeploymentCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/flink/v2/orgs/{org}/environments/{environment}/deployments/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (uid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("uid", uid));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteFlinkV2DeploymentValidateBeforeCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling deleteFlinkV2Deployment(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteFlinkV2Deployment(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling deleteFlinkV2Deployment(Async)");
        }
        return this.deleteFlinkV2DeploymentCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
    }

    public FlinkV2Deployment deleteFlinkV2Deployment(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        ApiResponse<FlinkV2Deployment> localVarResp = this.deleteFlinkV2DeploymentWithHttpInfo(environment, name, org, propagationPolicy, resourceVersion, uid);
        return localVarResp.getData();
    }

    public ApiResponse<FlinkV2Deployment> deleteFlinkV2DeploymentWithHttpInfo(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        Call localVarCall = this.deleteFlinkV2DeploymentValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, null);
        Type localVarReturnType = new TypeToken<FlinkV2Deployment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteFlinkV2DeploymentAsync(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback<FlinkV2Deployment> _callback) throws ApiException {
        Call localVarCall = this.deleteFlinkV2DeploymentValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
        Type localVarReturnType = new TypeToken<FlinkV2Deployment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteFlinkV2JobCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/flink/v2/orgs/{org}/environments/{environment}/jobs/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (uid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("uid", uid));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteFlinkV2JobValidateBeforeCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling deleteFlinkV2Job(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteFlinkV2Job(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling deleteFlinkV2Job(Async)");
        }
        return this.deleteFlinkV2JobCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
    }

    public FlinkV2Job deleteFlinkV2Job(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        ApiResponse<FlinkV2Job> localVarResp = this.deleteFlinkV2JobWithHttpInfo(environment, name, org, propagationPolicy, resourceVersion, uid);
        return localVarResp.getData();
    }

    public ApiResponse<FlinkV2Job> deleteFlinkV2JobWithHttpInfo(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        Call localVarCall = this.deleteFlinkV2JobValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, null);
        Type localVarReturnType = new TypeToken<FlinkV2Job>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteFlinkV2JobAsync(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback<FlinkV2Job> _callback) throws ApiException {
        Call localVarCall = this.deleteFlinkV2JobValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
        Type localVarReturnType = new TypeToken<FlinkV2Job>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteFlinkV2SavepointCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/flink/v2/orgs/{org}/environments/{environment}/savepoints/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (uid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("uid", uid));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteFlinkV2SavepointValidateBeforeCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling deleteFlinkV2Savepoint(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteFlinkV2Savepoint(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling deleteFlinkV2Savepoint(Async)");
        }
        return this.deleteFlinkV2SavepointCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
    }

    public FlinkV2Savepoint deleteFlinkV2Savepoint(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        ApiResponse<FlinkV2Savepoint> localVarResp = this.deleteFlinkV2SavepointWithHttpInfo(environment, name, org, propagationPolicy, resourceVersion, uid);
        return localVarResp.getData();
    }

    public ApiResponse<FlinkV2Savepoint> deleteFlinkV2SavepointWithHttpInfo(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        Call localVarCall = this.deleteFlinkV2SavepointValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, null);
        Type localVarReturnType = new TypeToken<FlinkV2Savepoint>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteFlinkV2SavepointAsync(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback<FlinkV2Savepoint> _callback) throws ApiException {
        Call localVarCall = this.deleteFlinkV2SavepointValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
        Type localVarReturnType = new TypeToken<FlinkV2Savepoint>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listFlinkV2DeploymentsCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/flink/v2/orgs/{org}/environments/{environment}/deployments".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listFlinkV2DeploymentsValidateBeforeCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling listFlinkV2Deployments(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listFlinkV2Deployments(Async)");
        }
        return this.listFlinkV2DeploymentsCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public FlinkV2DeploymentList listFlinkV2Deployments(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<FlinkV2DeploymentList> localVarResp = this.listFlinkV2DeploymentsWithHttpInfo(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<FlinkV2DeploymentList> listFlinkV2DeploymentsWithHttpInfo(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listFlinkV2DeploymentsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<FlinkV2DeploymentList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listFlinkV2DeploymentsAsync(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<FlinkV2DeploymentList> _callback) throws ApiException {
        Call localVarCall = this.listFlinkV2DeploymentsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<FlinkV2DeploymentList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listFlinkV2DeploymentsForAllEnvironmentsCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/flink/v2/orgs/{org}/deployments".replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listFlinkV2DeploymentsForAllEnvironmentsValidateBeforeCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listFlinkV2DeploymentsForAllEnvironments(Async)");
        }
        return this.listFlinkV2DeploymentsForAllEnvironmentsCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public FlinkV2DeploymentList listFlinkV2DeploymentsForAllEnvironments(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<FlinkV2DeploymentList> localVarResp = this.listFlinkV2DeploymentsForAllEnvironmentsWithHttpInfo(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<FlinkV2DeploymentList> listFlinkV2DeploymentsForAllEnvironmentsWithHttpInfo(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listFlinkV2DeploymentsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<FlinkV2DeploymentList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listFlinkV2DeploymentsForAllEnvironmentsAsync(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<FlinkV2DeploymentList> _callback) throws ApiException {
        Call localVarCall = this.listFlinkV2DeploymentsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<FlinkV2DeploymentList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listFlinkV2JobsCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/flink/v2/orgs/{org}/environments/{environment}/jobs".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listFlinkV2JobsValidateBeforeCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling listFlinkV2Jobs(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listFlinkV2Jobs(Async)");
        }
        return this.listFlinkV2JobsCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public FlinkV2JobList listFlinkV2Jobs(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<FlinkV2JobList> localVarResp = this.listFlinkV2JobsWithHttpInfo(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<FlinkV2JobList> listFlinkV2JobsWithHttpInfo(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listFlinkV2JobsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<FlinkV2JobList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listFlinkV2JobsAsync(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<FlinkV2JobList> _callback) throws ApiException {
        Call localVarCall = this.listFlinkV2JobsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<FlinkV2JobList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listFlinkV2JobsForAllEnvironmentsCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/flink/v2/orgs/{org}/jobs".replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listFlinkV2JobsForAllEnvironmentsValidateBeforeCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listFlinkV2JobsForAllEnvironments(Async)");
        }
        return this.listFlinkV2JobsForAllEnvironmentsCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public FlinkV2JobList listFlinkV2JobsForAllEnvironments(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<FlinkV2JobList> localVarResp = this.listFlinkV2JobsForAllEnvironmentsWithHttpInfo(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<FlinkV2JobList> listFlinkV2JobsForAllEnvironmentsWithHttpInfo(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listFlinkV2JobsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<FlinkV2JobList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listFlinkV2JobsForAllEnvironmentsAsync(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<FlinkV2JobList> _callback) throws ApiException {
        Call localVarCall = this.listFlinkV2JobsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<FlinkV2JobList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listFlinkV2SavepointsCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/flink/v2/orgs/{org}/environments/{environment}/savepoints".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listFlinkV2SavepointsValidateBeforeCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling listFlinkV2Savepoints(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listFlinkV2Savepoints(Async)");
        }
        return this.listFlinkV2SavepointsCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public FlinkV2SavepointList listFlinkV2Savepoints(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<FlinkV2SavepointList> localVarResp = this.listFlinkV2SavepointsWithHttpInfo(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<FlinkV2SavepointList> listFlinkV2SavepointsWithHttpInfo(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listFlinkV2SavepointsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<FlinkV2SavepointList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listFlinkV2SavepointsAsync(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<FlinkV2SavepointList> _callback) throws ApiException {
        Call localVarCall = this.listFlinkV2SavepointsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<FlinkV2SavepointList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listFlinkV2SavepointsForAllEnvironmentsCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/flink/v2/orgs/{org}/savepoints".replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listFlinkV2SavepointsForAllEnvironmentsValidateBeforeCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listFlinkV2SavepointsForAllEnvironments(Async)");
        }
        return this.listFlinkV2SavepointsForAllEnvironmentsCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public FlinkV2SavepointList listFlinkV2SavepointsForAllEnvironments(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<FlinkV2SavepointList> localVarResp = this.listFlinkV2SavepointsForAllEnvironmentsWithHttpInfo(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<FlinkV2SavepointList> listFlinkV2SavepointsForAllEnvironmentsWithHttpInfo(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listFlinkV2SavepointsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<FlinkV2SavepointList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listFlinkV2SavepointsForAllEnvironmentsAsync(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<FlinkV2SavepointList> _callback) throws ApiException {
        Call localVarCall = this.listFlinkV2SavepointsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<FlinkV2SavepointList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchFlinkV2DeploymentCall(String environment, String name, String org, FlinkV2Deployment flinkV2Deployment, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        FlinkV2Deployment localVarPostBody = flinkV2Deployment;
        String localVarPath = "/apis/flink/v2/orgs/{org}/environments/{environment}/deployments/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchFlinkV2DeploymentValidateBeforeCall(String environment, String name, String org, FlinkV2Deployment flinkV2Deployment, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchFlinkV2Deployment(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchFlinkV2Deployment(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchFlinkV2Deployment(Async)");
        }
        if (flinkV2Deployment == null) {
            throw new ApiException("Missing the required parameter 'flinkV2Deployment' when calling patchFlinkV2Deployment(Async)");
        }
        return this.patchFlinkV2DeploymentCall(environment, name, org, flinkV2Deployment, _callback);
    }

    public FlinkV2Deployment patchFlinkV2Deployment(String environment, String name, String org, FlinkV2Deployment flinkV2Deployment) throws ApiException {
        ApiResponse<FlinkV2Deployment> localVarResp = this.patchFlinkV2DeploymentWithHttpInfo(environment, name, org, flinkV2Deployment);
        return localVarResp.getData();
    }

    public ApiResponse<FlinkV2Deployment> patchFlinkV2DeploymentWithHttpInfo(String environment, String name, String org, FlinkV2Deployment flinkV2Deployment) throws ApiException {
        Call localVarCall = this.patchFlinkV2DeploymentValidateBeforeCall(environment, name, org, flinkV2Deployment, null);
        Type localVarReturnType = new TypeToken<FlinkV2Deployment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchFlinkV2DeploymentAsync(String environment, String name, String org, FlinkV2Deployment flinkV2Deployment, ApiCallback<FlinkV2Deployment> _callback) throws ApiException {
        Call localVarCall = this.patchFlinkV2DeploymentValidateBeforeCall(environment, name, org, flinkV2Deployment, _callback);
        Type localVarReturnType = new TypeToken<FlinkV2Deployment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchFlinkV2DeploymentFinalizersCall(String environment, String name, String org, FlinkV2Deployment flinkV2Deployment, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        FlinkV2Deployment localVarPostBody = flinkV2Deployment;
        String localVarPath = "/apis/flink/v2/orgs/{org}/environments/{environment}/deployments/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchFlinkV2DeploymentFinalizersValidateBeforeCall(String environment, String name, String org, FlinkV2Deployment flinkV2Deployment, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchFlinkV2DeploymentFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchFlinkV2DeploymentFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchFlinkV2DeploymentFinalizers(Async)");
        }
        if (flinkV2Deployment == null) {
            throw new ApiException("Missing the required parameter 'flinkV2Deployment' when calling patchFlinkV2DeploymentFinalizers(Async)");
        }
        return this.patchFlinkV2DeploymentFinalizersCall(environment, name, org, flinkV2Deployment, _callback);
    }

    public FlinkV2Deployment patchFlinkV2DeploymentFinalizers(String environment, String name, String org, FlinkV2Deployment flinkV2Deployment) throws ApiException {
        ApiResponse<FlinkV2Deployment> localVarResp = this.patchFlinkV2DeploymentFinalizersWithHttpInfo(environment, name, org, flinkV2Deployment);
        return localVarResp.getData();
    }

    public ApiResponse<FlinkV2Deployment> patchFlinkV2DeploymentFinalizersWithHttpInfo(String environment, String name, String org, FlinkV2Deployment flinkV2Deployment) throws ApiException {
        Call localVarCall = this.patchFlinkV2DeploymentFinalizersValidateBeforeCall(environment, name, org, flinkV2Deployment, null);
        Type localVarReturnType = new TypeToken<FlinkV2Deployment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchFlinkV2DeploymentFinalizersAsync(String environment, String name, String org, FlinkV2Deployment flinkV2Deployment, ApiCallback<FlinkV2Deployment> _callback) throws ApiException {
        Call localVarCall = this.patchFlinkV2DeploymentFinalizersValidateBeforeCall(environment, name, org, flinkV2Deployment, _callback);
        Type localVarReturnType = new TypeToken<FlinkV2Deployment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchFlinkV2DeploymentStatusCall(String environment, String name, String org, FlinkV2Deployment flinkV2Deployment, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        FlinkV2Deployment localVarPostBody = flinkV2Deployment;
        String localVarPath = "/apis/flink/v2/orgs/{org}/environments/{environment}/deployments/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchFlinkV2DeploymentStatusValidateBeforeCall(String environment, String name, String org, FlinkV2Deployment flinkV2Deployment, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchFlinkV2DeploymentStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchFlinkV2DeploymentStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchFlinkV2DeploymentStatus(Async)");
        }
        if (flinkV2Deployment == null) {
            throw new ApiException("Missing the required parameter 'flinkV2Deployment' when calling patchFlinkV2DeploymentStatus(Async)");
        }
        return this.patchFlinkV2DeploymentStatusCall(environment, name, org, flinkV2Deployment, _callback);
    }

    public FlinkV2Deployment patchFlinkV2DeploymentStatus(String environment, String name, String org, FlinkV2Deployment flinkV2Deployment) throws ApiException {
        ApiResponse<FlinkV2Deployment> localVarResp = this.patchFlinkV2DeploymentStatusWithHttpInfo(environment, name, org, flinkV2Deployment);
        return localVarResp.getData();
    }

    public ApiResponse<FlinkV2Deployment> patchFlinkV2DeploymentStatusWithHttpInfo(String environment, String name, String org, FlinkV2Deployment flinkV2Deployment) throws ApiException {
        Call localVarCall = this.patchFlinkV2DeploymentStatusValidateBeforeCall(environment, name, org, flinkV2Deployment, null);
        Type localVarReturnType = new TypeToken<FlinkV2Deployment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchFlinkV2DeploymentStatusAsync(String environment, String name, String org, FlinkV2Deployment flinkV2Deployment, ApiCallback<FlinkV2Deployment> _callback) throws ApiException {
        Call localVarCall = this.patchFlinkV2DeploymentStatusValidateBeforeCall(environment, name, org, flinkV2Deployment, _callback);
        Type localVarReturnType = new TypeToken<FlinkV2Deployment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchFlinkV2JobCall(String environment, String name, String org, FlinkV2Job flinkV2Job, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        FlinkV2Job localVarPostBody = flinkV2Job;
        String localVarPath = "/apis/flink/v2/orgs/{org}/environments/{environment}/jobs/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchFlinkV2JobValidateBeforeCall(String environment, String name, String org, FlinkV2Job flinkV2Job, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchFlinkV2Job(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchFlinkV2Job(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchFlinkV2Job(Async)");
        }
        if (flinkV2Job == null) {
            throw new ApiException("Missing the required parameter 'flinkV2Job' when calling patchFlinkV2Job(Async)");
        }
        return this.patchFlinkV2JobCall(environment, name, org, flinkV2Job, _callback);
    }

    public FlinkV2Job patchFlinkV2Job(String environment, String name, String org, FlinkV2Job flinkV2Job) throws ApiException {
        ApiResponse<FlinkV2Job> localVarResp = this.patchFlinkV2JobWithHttpInfo(environment, name, org, flinkV2Job);
        return localVarResp.getData();
    }

    public ApiResponse<FlinkV2Job> patchFlinkV2JobWithHttpInfo(String environment, String name, String org, FlinkV2Job flinkV2Job) throws ApiException {
        Call localVarCall = this.patchFlinkV2JobValidateBeforeCall(environment, name, org, flinkV2Job, null);
        Type localVarReturnType = new TypeToken<FlinkV2Job>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchFlinkV2JobAsync(String environment, String name, String org, FlinkV2Job flinkV2Job, ApiCallback<FlinkV2Job> _callback) throws ApiException {
        Call localVarCall = this.patchFlinkV2JobValidateBeforeCall(environment, name, org, flinkV2Job, _callback);
        Type localVarReturnType = new TypeToken<FlinkV2Job>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchFlinkV2JobStatusCall(String environment, String name, String org, FlinkV2Job flinkV2Job, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        FlinkV2Job localVarPostBody = flinkV2Job;
        String localVarPath = "/apis/flink/v2/orgs/{org}/environments/{environment}/jobs/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchFlinkV2JobStatusValidateBeforeCall(String environment, String name, String org, FlinkV2Job flinkV2Job, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchFlinkV2JobStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchFlinkV2JobStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchFlinkV2JobStatus(Async)");
        }
        if (flinkV2Job == null) {
            throw new ApiException("Missing the required parameter 'flinkV2Job' when calling patchFlinkV2JobStatus(Async)");
        }
        return this.patchFlinkV2JobStatusCall(environment, name, org, flinkV2Job, _callback);
    }

    public FlinkV2Job patchFlinkV2JobStatus(String environment, String name, String org, FlinkV2Job flinkV2Job) throws ApiException {
        ApiResponse<FlinkV2Job> localVarResp = this.patchFlinkV2JobStatusWithHttpInfo(environment, name, org, flinkV2Job);
        return localVarResp.getData();
    }

    public ApiResponse<FlinkV2Job> patchFlinkV2JobStatusWithHttpInfo(String environment, String name, String org, FlinkV2Job flinkV2Job) throws ApiException {
        Call localVarCall = this.patchFlinkV2JobStatusValidateBeforeCall(environment, name, org, flinkV2Job, null);
        Type localVarReturnType = new TypeToken<FlinkV2Job>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchFlinkV2JobStatusAsync(String environment, String name, String org, FlinkV2Job flinkV2Job, ApiCallback<FlinkV2Job> _callback) throws ApiException {
        Call localVarCall = this.patchFlinkV2JobStatusValidateBeforeCall(environment, name, org, flinkV2Job, _callback);
        Type localVarReturnType = new TypeToken<FlinkV2Job>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchFlinkV2SavepointCall(String environment, String name, String org, FlinkV2Savepoint flinkV2Savepoint, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        FlinkV2Savepoint localVarPostBody = flinkV2Savepoint;
        String localVarPath = "/apis/flink/v2/orgs/{org}/environments/{environment}/savepoints/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchFlinkV2SavepointValidateBeforeCall(String environment, String name, String org, FlinkV2Savepoint flinkV2Savepoint, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchFlinkV2Savepoint(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchFlinkV2Savepoint(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchFlinkV2Savepoint(Async)");
        }
        if (flinkV2Savepoint == null) {
            throw new ApiException("Missing the required parameter 'flinkV2Savepoint' when calling patchFlinkV2Savepoint(Async)");
        }
        return this.patchFlinkV2SavepointCall(environment, name, org, flinkV2Savepoint, _callback);
    }

    public FlinkV2Savepoint patchFlinkV2Savepoint(String environment, String name, String org, FlinkV2Savepoint flinkV2Savepoint) throws ApiException {
        ApiResponse<FlinkV2Savepoint> localVarResp = this.patchFlinkV2SavepointWithHttpInfo(environment, name, org, flinkV2Savepoint);
        return localVarResp.getData();
    }

    public ApiResponse<FlinkV2Savepoint> patchFlinkV2SavepointWithHttpInfo(String environment, String name, String org, FlinkV2Savepoint flinkV2Savepoint) throws ApiException {
        Call localVarCall = this.patchFlinkV2SavepointValidateBeforeCall(environment, name, org, flinkV2Savepoint, null);
        Type localVarReturnType = new TypeToken<FlinkV2Savepoint>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchFlinkV2SavepointAsync(String environment, String name, String org, FlinkV2Savepoint flinkV2Savepoint, ApiCallback<FlinkV2Savepoint> _callback) throws ApiException {
        Call localVarCall = this.patchFlinkV2SavepointValidateBeforeCall(environment, name, org, flinkV2Savepoint, _callback);
        Type localVarReturnType = new TypeToken<FlinkV2Savepoint>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchFlinkV2SavepointFinalizersCall(String environment, String name, String org, FlinkV2Savepoint flinkV2Savepoint, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        FlinkV2Savepoint localVarPostBody = flinkV2Savepoint;
        String localVarPath = "/apis/flink/v2/orgs/{org}/environments/{environment}/savepoints/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchFlinkV2SavepointFinalizersValidateBeforeCall(String environment, String name, String org, FlinkV2Savepoint flinkV2Savepoint, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchFlinkV2SavepointFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchFlinkV2SavepointFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchFlinkV2SavepointFinalizers(Async)");
        }
        if (flinkV2Savepoint == null) {
            throw new ApiException("Missing the required parameter 'flinkV2Savepoint' when calling patchFlinkV2SavepointFinalizers(Async)");
        }
        return this.patchFlinkV2SavepointFinalizersCall(environment, name, org, flinkV2Savepoint, _callback);
    }

    public FlinkV2Savepoint patchFlinkV2SavepointFinalizers(String environment, String name, String org, FlinkV2Savepoint flinkV2Savepoint) throws ApiException {
        ApiResponse<FlinkV2Savepoint> localVarResp = this.patchFlinkV2SavepointFinalizersWithHttpInfo(environment, name, org, flinkV2Savepoint);
        return localVarResp.getData();
    }

    public ApiResponse<FlinkV2Savepoint> patchFlinkV2SavepointFinalizersWithHttpInfo(String environment, String name, String org, FlinkV2Savepoint flinkV2Savepoint) throws ApiException {
        Call localVarCall = this.patchFlinkV2SavepointFinalizersValidateBeforeCall(environment, name, org, flinkV2Savepoint, null);
        Type localVarReturnType = new TypeToken<FlinkV2Savepoint>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchFlinkV2SavepointFinalizersAsync(String environment, String name, String org, FlinkV2Savepoint flinkV2Savepoint, ApiCallback<FlinkV2Savepoint> _callback) throws ApiException {
        Call localVarCall = this.patchFlinkV2SavepointFinalizersValidateBeforeCall(environment, name, org, flinkV2Savepoint, _callback);
        Type localVarReturnType = new TypeToken<FlinkV2Savepoint>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchFlinkV2SavepointStatusCall(String environment, String name, String org, FlinkV2Savepoint flinkV2Savepoint, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        FlinkV2Savepoint localVarPostBody = flinkV2Savepoint;
        String localVarPath = "/apis/flink/v2/orgs/{org}/environments/{environment}/savepoints/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchFlinkV2SavepointStatusValidateBeforeCall(String environment, String name, String org, FlinkV2Savepoint flinkV2Savepoint, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchFlinkV2SavepointStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchFlinkV2SavepointStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchFlinkV2SavepointStatus(Async)");
        }
        if (flinkV2Savepoint == null) {
            throw new ApiException("Missing the required parameter 'flinkV2Savepoint' when calling patchFlinkV2SavepointStatus(Async)");
        }
        return this.patchFlinkV2SavepointStatusCall(environment, name, org, flinkV2Savepoint, _callback);
    }

    public FlinkV2Savepoint patchFlinkV2SavepointStatus(String environment, String name, String org, FlinkV2Savepoint flinkV2Savepoint) throws ApiException {
        ApiResponse<FlinkV2Savepoint> localVarResp = this.patchFlinkV2SavepointStatusWithHttpInfo(environment, name, org, flinkV2Savepoint);
        return localVarResp.getData();
    }

    public ApiResponse<FlinkV2Savepoint> patchFlinkV2SavepointStatusWithHttpInfo(String environment, String name, String org, FlinkV2Savepoint flinkV2Savepoint) throws ApiException {
        Call localVarCall = this.patchFlinkV2SavepointStatusValidateBeforeCall(environment, name, org, flinkV2Savepoint, null);
        Type localVarReturnType = new TypeToken<FlinkV2Savepoint>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchFlinkV2SavepointStatusAsync(String environment, String name, String org, FlinkV2Savepoint flinkV2Savepoint, ApiCallback<FlinkV2Savepoint> _callback) throws ApiException {
        Call localVarCall = this.patchFlinkV2SavepointStatusValidateBeforeCall(environment, name, org, flinkV2Savepoint, _callback);
        Type localVarReturnType = new TypeToken<FlinkV2Savepoint>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readFlinkV2DeploymentCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/flink/v2/orgs/{org}/environments/{environment}/deployments/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readFlinkV2DeploymentValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readFlinkV2Deployment(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readFlinkV2Deployment(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readFlinkV2Deployment(Async)");
        }
        return this.readFlinkV2DeploymentCall(environment, name, org, resourceVersion, _callback);
    }

    public FlinkV2Deployment readFlinkV2Deployment(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<FlinkV2Deployment> localVarResp = this.readFlinkV2DeploymentWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<FlinkV2Deployment> readFlinkV2DeploymentWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readFlinkV2DeploymentValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<FlinkV2Deployment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readFlinkV2DeploymentAsync(String environment, String name, String org, String resourceVersion, ApiCallback<FlinkV2Deployment> _callback) throws ApiException {
        Call localVarCall = this.readFlinkV2DeploymentValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<FlinkV2Deployment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readFlinkV2DeploymentFinalizersCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/flink/v2/orgs/{org}/environments/{environment}/deployments/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readFlinkV2DeploymentFinalizersValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readFlinkV2DeploymentFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readFlinkV2DeploymentFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readFlinkV2DeploymentFinalizers(Async)");
        }
        return this.readFlinkV2DeploymentFinalizersCall(environment, name, org, resourceVersion, _callback);
    }

    public FlinkV2Deployment readFlinkV2DeploymentFinalizers(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<FlinkV2Deployment> localVarResp = this.readFlinkV2DeploymentFinalizersWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<FlinkV2Deployment> readFlinkV2DeploymentFinalizersWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readFlinkV2DeploymentFinalizersValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<FlinkV2Deployment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readFlinkV2DeploymentFinalizersAsync(String environment, String name, String org, String resourceVersion, ApiCallback<FlinkV2Deployment> _callback) throws ApiException {
        Call localVarCall = this.readFlinkV2DeploymentFinalizersValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<FlinkV2Deployment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readFlinkV2DeploymentStatusCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/flink/v2/orgs/{org}/environments/{environment}/deployments/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readFlinkV2DeploymentStatusValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readFlinkV2DeploymentStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readFlinkV2DeploymentStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readFlinkV2DeploymentStatus(Async)");
        }
        return this.readFlinkV2DeploymentStatusCall(environment, name, org, resourceVersion, _callback);
    }

    public FlinkV2Deployment readFlinkV2DeploymentStatus(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<FlinkV2Deployment> localVarResp = this.readFlinkV2DeploymentStatusWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<FlinkV2Deployment> readFlinkV2DeploymentStatusWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readFlinkV2DeploymentStatusValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<FlinkV2Deployment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readFlinkV2DeploymentStatusAsync(String environment, String name, String org, String resourceVersion, ApiCallback<FlinkV2Deployment> _callback) throws ApiException {
        Call localVarCall = this.readFlinkV2DeploymentStatusValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<FlinkV2Deployment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readFlinkV2JobCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/flink/v2/orgs/{org}/environments/{environment}/jobs/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readFlinkV2JobValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readFlinkV2Job(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readFlinkV2Job(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readFlinkV2Job(Async)");
        }
        return this.readFlinkV2JobCall(environment, name, org, resourceVersion, _callback);
    }

    public FlinkV2Job readFlinkV2Job(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<FlinkV2Job> localVarResp = this.readFlinkV2JobWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<FlinkV2Job> readFlinkV2JobWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readFlinkV2JobValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<FlinkV2Job>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readFlinkV2JobAsync(String environment, String name, String org, String resourceVersion, ApiCallback<FlinkV2Job> _callback) throws ApiException {
        Call localVarCall = this.readFlinkV2JobValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<FlinkV2Job>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readFlinkV2JobProxyForNonRootCall(String environment, String name, String org, String path, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/flink/v2/orgs/{org}/environments/{environment}/jobs/{name}/proxy/{path}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString())).replace("{path}", this.localVarApiClient.escapeString(path.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "text/html"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readFlinkV2JobProxyForNonRootValidateBeforeCall(String environment, String name, String org, String path, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readFlinkV2JobProxyForNonRoot(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readFlinkV2JobProxyForNonRoot(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readFlinkV2JobProxyForNonRoot(Async)");
        }
        if (path == null) {
            throw new ApiException("Missing the required parameter 'path' when calling readFlinkV2JobProxyForNonRoot(Async)");
        }
        return this.readFlinkV2JobProxyForNonRootCall(environment, name, org, path, _callback);
    }

    public void readFlinkV2JobProxyForNonRoot(String environment, String name, String org, String path) throws ApiException {
        this.readFlinkV2JobProxyForNonRootWithHttpInfo(environment, name, org, path);
    }

    public ApiResponse<Void> readFlinkV2JobProxyForNonRootWithHttpInfo(String environment, String name, String org, String path) throws ApiException {
        Call localVarCall = this.readFlinkV2JobProxyForNonRootValidateBeforeCall(environment, name, org, path, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call readFlinkV2JobProxyForNonRootAsync(String environment, String name, String org, String path, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.readFlinkV2JobProxyForNonRootValidateBeforeCall(environment, name, org, path, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call readFlinkV2JobProxyForRootCall(String environment, String name, String org, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/flink/v2/orgs/{org}/environments/{environment}/jobs/{name}/proxy".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "text/html"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readFlinkV2JobProxyForRootValidateBeforeCall(String environment, String name, String org, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readFlinkV2JobProxyForRoot(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readFlinkV2JobProxyForRoot(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readFlinkV2JobProxyForRoot(Async)");
        }
        return this.readFlinkV2JobProxyForRootCall(environment, name, org, _callback);
    }

    public void readFlinkV2JobProxyForRoot(String environment, String name, String org) throws ApiException {
        this.readFlinkV2JobProxyForRootWithHttpInfo(environment, name, org);
    }

    public ApiResponse<Void> readFlinkV2JobProxyForRootWithHttpInfo(String environment, String name, String org) throws ApiException {
        Call localVarCall = this.readFlinkV2JobProxyForRootValidateBeforeCall(environment, name, org, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call readFlinkV2JobProxyForRootAsync(String environment, String name, String org, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.readFlinkV2JobProxyForRootValidateBeforeCall(environment, name, org, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call readFlinkV2JobStatusCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/flink/v2/orgs/{org}/environments/{environment}/jobs/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readFlinkV2JobStatusValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readFlinkV2JobStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readFlinkV2JobStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readFlinkV2JobStatus(Async)");
        }
        return this.readFlinkV2JobStatusCall(environment, name, org, resourceVersion, _callback);
    }

    public FlinkV2Job readFlinkV2JobStatus(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<FlinkV2Job> localVarResp = this.readFlinkV2JobStatusWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<FlinkV2Job> readFlinkV2JobStatusWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readFlinkV2JobStatusValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<FlinkV2Job>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readFlinkV2JobStatusAsync(String environment, String name, String org, String resourceVersion, ApiCallback<FlinkV2Job> _callback) throws ApiException {
        Call localVarCall = this.readFlinkV2JobStatusValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<FlinkV2Job>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readFlinkV2SavepointCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/flink/v2/orgs/{org}/environments/{environment}/savepoints/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readFlinkV2SavepointValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readFlinkV2Savepoint(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readFlinkV2Savepoint(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readFlinkV2Savepoint(Async)");
        }
        return this.readFlinkV2SavepointCall(environment, name, org, resourceVersion, _callback);
    }

    public FlinkV2Savepoint readFlinkV2Savepoint(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<FlinkV2Savepoint> localVarResp = this.readFlinkV2SavepointWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<FlinkV2Savepoint> readFlinkV2SavepointWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readFlinkV2SavepointValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<FlinkV2Savepoint>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readFlinkV2SavepointAsync(String environment, String name, String org, String resourceVersion, ApiCallback<FlinkV2Savepoint> _callback) throws ApiException {
        Call localVarCall = this.readFlinkV2SavepointValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<FlinkV2Savepoint>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readFlinkV2SavepointFinalizersCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/flink/v2/orgs/{org}/environments/{environment}/savepoints/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readFlinkV2SavepointFinalizersValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readFlinkV2SavepointFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readFlinkV2SavepointFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readFlinkV2SavepointFinalizers(Async)");
        }
        return this.readFlinkV2SavepointFinalizersCall(environment, name, org, resourceVersion, _callback);
    }

    public FlinkV2Savepoint readFlinkV2SavepointFinalizers(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<FlinkV2Savepoint> localVarResp = this.readFlinkV2SavepointFinalizersWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<FlinkV2Savepoint> readFlinkV2SavepointFinalizersWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readFlinkV2SavepointFinalizersValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<FlinkV2Savepoint>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readFlinkV2SavepointFinalizersAsync(String environment, String name, String org, String resourceVersion, ApiCallback<FlinkV2Savepoint> _callback) throws ApiException {
        Call localVarCall = this.readFlinkV2SavepointFinalizersValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<FlinkV2Savepoint>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readFlinkV2SavepointStatusCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/flink/v2/orgs/{org}/environments/{environment}/savepoints/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readFlinkV2SavepointStatusValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readFlinkV2SavepointStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readFlinkV2SavepointStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readFlinkV2SavepointStatus(Async)");
        }
        return this.readFlinkV2SavepointStatusCall(environment, name, org, resourceVersion, _callback);
    }

    public FlinkV2Savepoint readFlinkV2SavepointStatus(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<FlinkV2Savepoint> localVarResp = this.readFlinkV2SavepointStatusWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<FlinkV2Savepoint> readFlinkV2SavepointStatusWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readFlinkV2SavepointStatusValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<FlinkV2Savepoint>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readFlinkV2SavepointStatusAsync(String environment, String name, String org, String resourceVersion, ApiCallback<FlinkV2Savepoint> _callback) throws ApiException {
        Call localVarCall = this.readFlinkV2SavepointStatusValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<FlinkV2Savepoint>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateFlinkV2DeploymentCall(String environment, String name, String org, FlinkV2Deployment flinkV2Deployment, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        FlinkV2Deployment localVarPostBody = flinkV2Deployment;
        String localVarPath = "/apis/flink/v2/orgs/{org}/environments/{environment}/deployments/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateFlinkV2DeploymentValidateBeforeCall(String environment, String name, String org, FlinkV2Deployment flinkV2Deployment, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateFlinkV2Deployment(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateFlinkV2Deployment(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateFlinkV2Deployment(Async)");
        }
        if (flinkV2Deployment == null) {
            throw new ApiException("Missing the required parameter 'flinkV2Deployment' when calling updateFlinkV2Deployment(Async)");
        }
        return this.updateFlinkV2DeploymentCall(environment, name, org, flinkV2Deployment, _callback);
    }

    public FlinkV2Deployment updateFlinkV2Deployment(String environment, String name, String org, FlinkV2Deployment flinkV2Deployment) throws ApiException {
        ApiResponse<FlinkV2Deployment> localVarResp = this.updateFlinkV2DeploymentWithHttpInfo(environment, name, org, flinkV2Deployment);
        return localVarResp.getData();
    }

    public ApiResponse<FlinkV2Deployment> updateFlinkV2DeploymentWithHttpInfo(String environment, String name, String org, FlinkV2Deployment flinkV2Deployment) throws ApiException {
        Call localVarCall = this.updateFlinkV2DeploymentValidateBeforeCall(environment, name, org, flinkV2Deployment, null);
        Type localVarReturnType = new TypeToken<FlinkV2Deployment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateFlinkV2DeploymentAsync(String environment, String name, String org, FlinkV2Deployment flinkV2Deployment, ApiCallback<FlinkV2Deployment> _callback) throws ApiException {
        Call localVarCall = this.updateFlinkV2DeploymentValidateBeforeCall(environment, name, org, flinkV2Deployment, _callback);
        Type localVarReturnType = new TypeToken<FlinkV2Deployment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateFlinkV2DeploymentFinalizersCall(String environment, String name, String org, FlinkV2Deployment flinkV2Deployment, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        FlinkV2Deployment localVarPostBody = flinkV2Deployment;
        String localVarPath = "/apis/flink/v2/orgs/{org}/environments/{environment}/deployments/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateFlinkV2DeploymentFinalizersValidateBeforeCall(String environment, String name, String org, FlinkV2Deployment flinkV2Deployment, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateFlinkV2DeploymentFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateFlinkV2DeploymentFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateFlinkV2DeploymentFinalizers(Async)");
        }
        if (flinkV2Deployment == null) {
            throw new ApiException("Missing the required parameter 'flinkV2Deployment' when calling updateFlinkV2DeploymentFinalizers(Async)");
        }
        return this.updateFlinkV2DeploymentFinalizersCall(environment, name, org, flinkV2Deployment, _callback);
    }

    public FlinkV2Deployment updateFlinkV2DeploymentFinalizers(String environment, String name, String org, FlinkV2Deployment flinkV2Deployment) throws ApiException {
        ApiResponse<FlinkV2Deployment> localVarResp = this.updateFlinkV2DeploymentFinalizersWithHttpInfo(environment, name, org, flinkV2Deployment);
        return localVarResp.getData();
    }

    public ApiResponse<FlinkV2Deployment> updateFlinkV2DeploymentFinalizersWithHttpInfo(String environment, String name, String org, FlinkV2Deployment flinkV2Deployment) throws ApiException {
        Call localVarCall = this.updateFlinkV2DeploymentFinalizersValidateBeforeCall(environment, name, org, flinkV2Deployment, null);
        Type localVarReturnType = new TypeToken<FlinkV2Deployment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateFlinkV2DeploymentFinalizersAsync(String environment, String name, String org, FlinkV2Deployment flinkV2Deployment, ApiCallback<FlinkV2Deployment> _callback) throws ApiException {
        Call localVarCall = this.updateFlinkV2DeploymentFinalizersValidateBeforeCall(environment, name, org, flinkV2Deployment, _callback);
        Type localVarReturnType = new TypeToken<FlinkV2Deployment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateFlinkV2DeploymentStatusCall(String environment, String name, String org, FlinkV2Deployment flinkV2Deployment, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        FlinkV2Deployment localVarPostBody = flinkV2Deployment;
        String localVarPath = "/apis/flink/v2/orgs/{org}/environments/{environment}/deployments/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateFlinkV2DeploymentStatusValidateBeforeCall(String environment, String name, String org, FlinkV2Deployment flinkV2Deployment, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateFlinkV2DeploymentStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateFlinkV2DeploymentStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateFlinkV2DeploymentStatus(Async)");
        }
        if (flinkV2Deployment == null) {
            throw new ApiException("Missing the required parameter 'flinkV2Deployment' when calling updateFlinkV2DeploymentStatus(Async)");
        }
        return this.updateFlinkV2DeploymentStatusCall(environment, name, org, flinkV2Deployment, _callback);
    }

    public FlinkV2Deployment updateFlinkV2DeploymentStatus(String environment, String name, String org, FlinkV2Deployment flinkV2Deployment) throws ApiException {
        ApiResponse<FlinkV2Deployment> localVarResp = this.updateFlinkV2DeploymentStatusWithHttpInfo(environment, name, org, flinkV2Deployment);
        return localVarResp.getData();
    }

    public ApiResponse<FlinkV2Deployment> updateFlinkV2DeploymentStatusWithHttpInfo(String environment, String name, String org, FlinkV2Deployment flinkV2Deployment) throws ApiException {
        Call localVarCall = this.updateFlinkV2DeploymentStatusValidateBeforeCall(environment, name, org, flinkV2Deployment, null);
        Type localVarReturnType = new TypeToken<FlinkV2Deployment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateFlinkV2DeploymentStatusAsync(String environment, String name, String org, FlinkV2Deployment flinkV2Deployment, ApiCallback<FlinkV2Deployment> _callback) throws ApiException {
        Call localVarCall = this.updateFlinkV2DeploymentStatusValidateBeforeCall(environment, name, org, flinkV2Deployment, _callback);
        Type localVarReturnType = new TypeToken<FlinkV2Deployment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateFlinkV2JobCall(String environment, String name, String org, FlinkV2Job flinkV2Job, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        FlinkV2Job localVarPostBody = flinkV2Job;
        String localVarPath = "/apis/flink/v2/orgs/{org}/environments/{environment}/jobs/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateFlinkV2JobValidateBeforeCall(String environment, String name, String org, FlinkV2Job flinkV2Job, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateFlinkV2Job(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateFlinkV2Job(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateFlinkV2Job(Async)");
        }
        if (flinkV2Job == null) {
            throw new ApiException("Missing the required parameter 'flinkV2Job' when calling updateFlinkV2Job(Async)");
        }
        return this.updateFlinkV2JobCall(environment, name, org, flinkV2Job, _callback);
    }

    public FlinkV2Job updateFlinkV2Job(String environment, String name, String org, FlinkV2Job flinkV2Job) throws ApiException {
        ApiResponse<FlinkV2Job> localVarResp = this.updateFlinkV2JobWithHttpInfo(environment, name, org, flinkV2Job);
        return localVarResp.getData();
    }

    public ApiResponse<FlinkV2Job> updateFlinkV2JobWithHttpInfo(String environment, String name, String org, FlinkV2Job flinkV2Job) throws ApiException {
        Call localVarCall = this.updateFlinkV2JobValidateBeforeCall(environment, name, org, flinkV2Job, null);
        Type localVarReturnType = new TypeToken<FlinkV2Job>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateFlinkV2JobAsync(String environment, String name, String org, FlinkV2Job flinkV2Job, ApiCallback<FlinkV2Job> _callback) throws ApiException {
        Call localVarCall = this.updateFlinkV2JobValidateBeforeCall(environment, name, org, flinkV2Job, _callback);
        Type localVarReturnType = new TypeToken<FlinkV2Job>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateFlinkV2JobStatusCall(String environment, String name, String org, FlinkV2Job flinkV2Job, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        FlinkV2Job localVarPostBody = flinkV2Job;
        String localVarPath = "/apis/flink/v2/orgs/{org}/environments/{environment}/jobs/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateFlinkV2JobStatusValidateBeforeCall(String environment, String name, String org, FlinkV2Job flinkV2Job, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateFlinkV2JobStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateFlinkV2JobStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateFlinkV2JobStatus(Async)");
        }
        if (flinkV2Job == null) {
            throw new ApiException("Missing the required parameter 'flinkV2Job' when calling updateFlinkV2JobStatus(Async)");
        }
        return this.updateFlinkV2JobStatusCall(environment, name, org, flinkV2Job, _callback);
    }

    public FlinkV2Job updateFlinkV2JobStatus(String environment, String name, String org, FlinkV2Job flinkV2Job) throws ApiException {
        ApiResponse<FlinkV2Job> localVarResp = this.updateFlinkV2JobStatusWithHttpInfo(environment, name, org, flinkV2Job);
        return localVarResp.getData();
    }

    public ApiResponse<FlinkV2Job> updateFlinkV2JobStatusWithHttpInfo(String environment, String name, String org, FlinkV2Job flinkV2Job) throws ApiException {
        Call localVarCall = this.updateFlinkV2JobStatusValidateBeforeCall(environment, name, org, flinkV2Job, null);
        Type localVarReturnType = new TypeToken<FlinkV2Job>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateFlinkV2JobStatusAsync(String environment, String name, String org, FlinkV2Job flinkV2Job, ApiCallback<FlinkV2Job> _callback) throws ApiException {
        Call localVarCall = this.updateFlinkV2JobStatusValidateBeforeCall(environment, name, org, flinkV2Job, _callback);
        Type localVarReturnType = new TypeToken<FlinkV2Job>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateFlinkV2SavepointCall(String environment, String name, String org, FlinkV2Savepoint flinkV2Savepoint, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        FlinkV2Savepoint localVarPostBody = flinkV2Savepoint;
        String localVarPath = "/apis/flink/v2/orgs/{org}/environments/{environment}/savepoints/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateFlinkV2SavepointValidateBeforeCall(String environment, String name, String org, FlinkV2Savepoint flinkV2Savepoint, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateFlinkV2Savepoint(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateFlinkV2Savepoint(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateFlinkV2Savepoint(Async)");
        }
        if (flinkV2Savepoint == null) {
            throw new ApiException("Missing the required parameter 'flinkV2Savepoint' when calling updateFlinkV2Savepoint(Async)");
        }
        return this.updateFlinkV2SavepointCall(environment, name, org, flinkV2Savepoint, _callback);
    }

    public FlinkV2Savepoint updateFlinkV2Savepoint(String environment, String name, String org, FlinkV2Savepoint flinkV2Savepoint) throws ApiException {
        ApiResponse<FlinkV2Savepoint> localVarResp = this.updateFlinkV2SavepointWithHttpInfo(environment, name, org, flinkV2Savepoint);
        return localVarResp.getData();
    }

    public ApiResponse<FlinkV2Savepoint> updateFlinkV2SavepointWithHttpInfo(String environment, String name, String org, FlinkV2Savepoint flinkV2Savepoint) throws ApiException {
        Call localVarCall = this.updateFlinkV2SavepointValidateBeforeCall(environment, name, org, flinkV2Savepoint, null);
        Type localVarReturnType = new TypeToken<FlinkV2Savepoint>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateFlinkV2SavepointAsync(String environment, String name, String org, FlinkV2Savepoint flinkV2Savepoint, ApiCallback<FlinkV2Savepoint> _callback) throws ApiException {
        Call localVarCall = this.updateFlinkV2SavepointValidateBeforeCall(environment, name, org, flinkV2Savepoint, _callback);
        Type localVarReturnType = new TypeToken<FlinkV2Savepoint>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateFlinkV2SavepointFinalizersCall(String environment, String name, String org, FlinkV2Savepoint flinkV2Savepoint, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        FlinkV2Savepoint localVarPostBody = flinkV2Savepoint;
        String localVarPath = "/apis/flink/v2/orgs/{org}/environments/{environment}/savepoints/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateFlinkV2SavepointFinalizersValidateBeforeCall(String environment, String name, String org, FlinkV2Savepoint flinkV2Savepoint, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateFlinkV2SavepointFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateFlinkV2SavepointFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateFlinkV2SavepointFinalizers(Async)");
        }
        if (flinkV2Savepoint == null) {
            throw new ApiException("Missing the required parameter 'flinkV2Savepoint' when calling updateFlinkV2SavepointFinalizers(Async)");
        }
        return this.updateFlinkV2SavepointFinalizersCall(environment, name, org, flinkV2Savepoint, _callback);
    }

    public FlinkV2Savepoint updateFlinkV2SavepointFinalizers(String environment, String name, String org, FlinkV2Savepoint flinkV2Savepoint) throws ApiException {
        ApiResponse<FlinkV2Savepoint> localVarResp = this.updateFlinkV2SavepointFinalizersWithHttpInfo(environment, name, org, flinkV2Savepoint);
        return localVarResp.getData();
    }

    public ApiResponse<FlinkV2Savepoint> updateFlinkV2SavepointFinalizersWithHttpInfo(String environment, String name, String org, FlinkV2Savepoint flinkV2Savepoint) throws ApiException {
        Call localVarCall = this.updateFlinkV2SavepointFinalizersValidateBeforeCall(environment, name, org, flinkV2Savepoint, null);
        Type localVarReturnType = new TypeToken<FlinkV2Savepoint>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateFlinkV2SavepointFinalizersAsync(String environment, String name, String org, FlinkV2Savepoint flinkV2Savepoint, ApiCallback<FlinkV2Savepoint> _callback) throws ApiException {
        Call localVarCall = this.updateFlinkV2SavepointFinalizersValidateBeforeCall(environment, name, org, flinkV2Savepoint, _callback);
        Type localVarReturnType = new TypeToken<FlinkV2Savepoint>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateFlinkV2SavepointStatusCall(String environment, String name, String org, FlinkV2Savepoint flinkV2Savepoint, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        FlinkV2Savepoint localVarPostBody = flinkV2Savepoint;
        String localVarPath = "/apis/flink/v2/orgs/{org}/environments/{environment}/savepoints/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateFlinkV2SavepointStatusValidateBeforeCall(String environment, String name, String org, FlinkV2Savepoint flinkV2Savepoint, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateFlinkV2SavepointStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateFlinkV2SavepointStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateFlinkV2SavepointStatus(Async)");
        }
        if (flinkV2Savepoint == null) {
            throw new ApiException("Missing the required parameter 'flinkV2Savepoint' when calling updateFlinkV2SavepointStatus(Async)");
        }
        return this.updateFlinkV2SavepointStatusCall(environment, name, org, flinkV2Savepoint, _callback);
    }

    public FlinkV2Savepoint updateFlinkV2SavepointStatus(String environment, String name, String org, FlinkV2Savepoint flinkV2Savepoint) throws ApiException {
        ApiResponse<FlinkV2Savepoint> localVarResp = this.updateFlinkV2SavepointStatusWithHttpInfo(environment, name, org, flinkV2Savepoint);
        return localVarResp.getData();
    }

    public ApiResponse<FlinkV2Savepoint> updateFlinkV2SavepointStatusWithHttpInfo(String environment, String name, String org, FlinkV2Savepoint flinkV2Savepoint) throws ApiException {
        Call localVarCall = this.updateFlinkV2SavepointStatusValidateBeforeCall(environment, name, org, flinkV2Savepoint, null);
        Type localVarReturnType = new TypeToken<FlinkV2Savepoint>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateFlinkV2SavepointStatusAsync(String environment, String name, String org, FlinkV2Savepoint flinkV2Savepoint, ApiCallback<FlinkV2Savepoint> _callback) throws ApiException {
        Call localVarCall = this.updateFlinkV2SavepointStatusValidateBeforeCall(environment, name, org, flinkV2Savepoint, _callback);
        Type localVarReturnType = new TypeToken<FlinkV2Savepoint>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

