/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.flink.apiserver.client.gson;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.confluent.flink.apiserver.client.model.ApisMetaV1Status;
import io.gsonfire.PreProcessor;

public class V1StatusPreProcessor
implements PreProcessor<ApisMetaV1Status> {
    public void preDeserialize(Class<? extends ApisMetaV1Status> aClass, JsonElement jsonElement, Gson gson) {
        if (V1StatusPreProcessor.isLegitApiServerStatus(jsonElement)) {
            return;
        }
        JsonObject obj = jsonElement.getAsJsonObject();
        JsonElement statusField = obj.get("status");
        if (statusField != null && statusField.isJsonObject()) {
            obj.addProperty("status", (String)null);
        }
    }

    private static boolean isLegitApiServerStatus(JsonElement jsonElement) {
        String apiVersion = jsonElement.getAsJsonObject().get("apiVersion") != null ? jsonElement.getAsJsonObject().get("apiVersion").getAsString() : null;
        String kind = jsonElement.getAsJsonObject().get("kind") != null ? jsonElement.getAsJsonObject().get("kind").getAsString() : null;
        return "v1".equals(apiVersion) && "Status".equals(kind);
    }
}

