/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.log;

import java.util.Optional;
import org.apache.kafka.metadata.TopicPlacement;
import org.apache.kafka.storage.internals.log.LogConfig;

public class ConfluentLogConfig {
    public final long tierLocalHotsetBytes;
    public final long tierLocalHotsetMs;
    public final int tierSegmentHotsetRollMinBytes;
    public final long preferTierFetchMs;
    public final boolean segmentSpeculativePrefetchEnable;
    public final boolean tierCleanerEnable;
    public final int tierCleanerCompactSegmentMinBytes;
    public final boolean tierCleanerDualCompaction;
    public final Optional<TopicPlacement> topicPlacementConstraints;
    public final long minSegmentMs;
    public final long maxSegmentMs;
    public final long strayLogDeleteDelayMs;
    public final int strayLogMaxDeletionsPerRun;
    public final boolean systemTimeBasedRollEnable;
    public final boolean logCleanerTimestampValidationEnable;
    private final boolean tierEnable;
    private final double tierCleanerMinCleanableRatio;
    private final double tierCleanerCompactMinEfficiencyRatio;

    ConfluentLogConfig(LogConfig config, boolean compact) {
        this.tierEnable = config.getBoolean("confluent.tier.enable");
        this.tierLocalHotsetBytes = config.getLong("confluent.tier.local.hotset.bytes");
        this.tierLocalHotsetMs = config.getLong("confluent.tier.local.hotset.ms");
        this.tierSegmentHotsetRollMinBytes = config.getInt("confluent.tier.segment.hotset.roll.min.bytes");
        this.preferTierFetchMs = compact ? config.getLong("confluent.compacted.topic.prefer.tier.fetch.ms").longValue() : config.getLong("confluent.prefer.tier.fetch.ms").longValue();
        this.segmentSpeculativePrefetchEnable = config.getBoolean("confluent.segment.speculative.prefetch.enable");
        this.tierCleanerEnable = config.getBoolean("confluent.tier.cleaner.enable");
        this.tierCleanerMinCleanableRatio = config.getDouble("confluent.tier.cleaner.min.cleanable.ratio");
        this.tierCleanerCompactMinEfficiencyRatio = config.getDouble("confluent.tier.cleaner.compact.min.efficiency");
        this.tierCleanerCompactSegmentMinBytes = config.getInt("confluent.tier.cleaner.compact.segment.min.bytes");
        this.tierCleanerDualCompaction = config.getBoolean("confluent.tier.cleaner.dual.compaction");
        this.topicPlacementConstraints = TopicPlacement.parse((String)config.getString("confluent.placement.constraints"));
        this.strayLogDeleteDelayMs = config.getLong("confluent.stray.log.delete.delay.ms");
        this.strayLogMaxDeletionsPerRun = config.getInt("confluent.stray.log.max.deletions.per.run");
        this.minSegmentMs = config.getLong("confluent.min.segment.ms");
        this.maxSegmentMs = config.getLong("confluent.max.segment.ms");
        this.systemTimeBasedRollEnable = config.getBoolean("confluent.system.time.roll.enable");
        this.logCleanerTimestampValidationEnable = config.getBoolean("confluent.log.cleaner.timestamp.validation.enable");
    }

    public boolean tierEnable() {
        return this.tierEnable;
    }

    public double tierCleanerMinCleanableRatio() {
        return this.tierCleanerMinCleanableRatio;
    }

    public double tierCleanerCompactMinEfficiencyRatio() {
        return this.tierCleanerCompactMinEfficiencyRatio;
    }
}

