/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.log;

import java.util.Objects;
import java.util.OptionalLong;

public final class LastRecord {
    public final OptionalLong lastDataOffset;
    public final short producerEpoch;
    public final long lastTimestampMs;

    public LastRecord(OptionalLong lastDataOffset, short producerEpoch, long lastTimestampMs) {
        Objects.requireNonNull(lastDataOffset, "lastDataOffset must be non null");
        this.lastDataOffset = lastDataOffset;
        this.producerEpoch = producerEpoch;
        this.lastTimestampMs = lastTimestampMs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LastRecord that = (LastRecord)o;
        return this.producerEpoch == that.producerEpoch && this.lastDataOffset.equals(that.lastDataOffset) && this.lastTimestampMs == that.lastTimestampMs;
    }

    public int hashCode() {
        int result = this.lastDataOffset.hashCode();
        result = 31 * result + this.producerEpoch;
        result = 31 * result + Long.hashCode(this.lastTimestampMs);
        return result;
    }

    public String toString() {
        return "LastRecord(lastDataOffset=" + this.lastDataOffset + ", producerEpoch=" + this.producerEpoch + ", lastTimestampMs=" + this.lastTimestampMs + ')';
    }
}

