/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.utils;

import com.yammer.metrics.core.Meter;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Throttler {
    private static final Logger LOG = LoggerFactory.getLogger(Throttler.class);
    private static final long MS_PER_SEC = TimeUnit.SECONDS.toMillis(1L);
    private static final long NS_PER_SEC = TimeUnit.SECONDS.toNanos(1L);
    private final Object lock = new Object();
    private final long checkIntervalNs;
    private final Meter meter;
    private final Time time;
    private volatile double desiredRatePerSec;
    private long periodStartNs;
    private double observedSoFar;

    public Throttler(double desiredRatePerSec, long checkIntervalMs) {
        this(desiredRatePerSec, checkIntervalMs, "throttler", "entries", Time.SYSTEM);
    }

    public Throttler(double desiredRatePerSec, long checkIntervalMs, Time time) {
        this(desiredRatePerSec, checkIntervalMs, "throttler", "entries", time);
    }

    public Throttler(double desiredRatePerSec, long checkIntervalMs, String metricName, String units, Time time) {
        this.desiredRatePerSec = desiredRatePerSec;
        this.checkIntervalNs = TimeUnit.MILLISECONDS.toNanos(checkIntervalMs);
        this.meter = new KafkaMetricsGroup(Throttler.class).newMeter(metricName, units, TimeUnit.SECONDS);
        this.time = time;
        this.periodStartNs = time.nanoseconds();
    }

    public void updateDesiredRatePerSec(double updatedDesiredRatePerSec) {
        this.desiredRatePerSec = updatedDesiredRatePerSec;
    }

    public double desiredRatePerSec() {
        return this.desiredRatePerSec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long maybeThrottle(double observed) {
        double currentDesiredRatePerSec = this.desiredRatePerSec;
        long throttledTime = 0L;
        this.meter.mark((long)observed);
        Object object = this.lock;
        synchronized (object) {
            this.observedSoFar += observed;
            long now = this.time.nanoseconds();
            long elapsedNs = now - this.periodStartNs;
            if (elapsedNs > this.checkIntervalNs && this.observedSoFar > 0.0) {
                long elapsedMs;
                double desiredRateMs;
                long sleepTime;
                double rateInSecs = this.observedSoFar * (double)NS_PER_SEC / (double)elapsedNs;
                if (rateInSecs > currentDesiredRatePerSec && (sleepTime = Math.round(this.observedSoFar / (desiredRateMs = currentDesiredRatePerSec / (double)MS_PER_SEC) - (double)(elapsedMs = TimeUnit.NANOSECONDS.toMillis(elapsedNs)))) > 0L) {
                    LOG.trace("Natural rate is {} per second but desired rate is {}, sleeping for {} ms to compensate.", new Object[]{rateInSecs, currentDesiredRatePerSec, sleepTime});
                    this.time.sleep(sleepTime);
                    throttledTime = sleepTime;
                }
                this.periodStartNs = this.time.nanoseconds();
                this.observedSoFar = 0.0;
            }
        }
        return throttledTime;
    }
}

