/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.protobuf.Timestamp;
import io.confluent.protobuf.cloud.events.v1.LogicalCluster;
import java.time.Instant;
import java.util.Date;
import java.util.Objects;
import org.apache.kafka.server.multitenant.LogicalClusterMetadata;

@JsonIgnoreProperties(ignoreUnknown=true)
public class NonKafkaLogicalClusterMetadata
extends LogicalClusterMetadata {
    public static final String SCHEMA_REGISTRY_LOGICAL_CLUSTER_TYPE = "schema-registry";
    public static final String SCHEMA_REGISTRY_HEALTHCHECK_LOGICAL_CLUSTER_TYPE = "schema-registry-healthcheck";
    public static final String KSQL_LOGICAL_CLUSTER_TYPE = "ksql";
    public static final String KSQL_HEALTHCHECK_LOGICAL_CLUSTER_TYPE = "ksql-healthcheck";
    private final String logicalClusterId;
    private final String physicalClusterId;
    private final String logicalClusterName;
    private final String organizationId;
    private final String environmentId;
    private final String accountId;
    private final String k8sClusterId;
    private final String logicalClusterType;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX")
    private final Date creationDate;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX")
    private final Date deletionDate;
    private final String backingLogicalKafkaClusterId;

    @JsonCreator
    public NonKafkaLogicalClusterMetadata(@JsonProperty(value="logical_cluster_id") String logicalClusterId, @JsonProperty(value="physical_cluster_id") String physicalClusterId, @JsonProperty(value="logical_cluster_name") String logicalClusterName, @JsonProperty(value="account_id") String accountId, @JsonProperty(value="k8s_cluster_id") String k8sClusterId, @JsonProperty(value="logical_cluster_type") String logicalClusterType, @JsonProperty(value="org_resource_id") String organizationId, @JsonProperty(value="environment_id") String environmentId, @JsonProperty(value="creation_date") Date creationDate, @JsonProperty(value="deletion_date") Date deletionDate, @JsonProperty(value="backing_logical_kafka_cluster_id") String backingLogicalKafkaClusterId) {
        this.logicalClusterId = logicalClusterId;
        this.physicalClusterId = physicalClusterId;
        this.logicalClusterName = logicalClusterName;
        this.accountId = accountId;
        this.k8sClusterId = k8sClusterId;
        this.logicalClusterType = logicalClusterType;
        this.organizationId = organizationId;
        this.environmentId = environmentId != null ? environmentId : accountId;
        this.creationDate = creationDate;
        this.deletionDate = deletionDate;
        this.backingLogicalKafkaClusterId = backingLogicalKafkaClusterId;
    }

    public static NonKafkaLogicalClusterMetadata fromProtobuf(LogicalCluster lc) {
        return new NonKafkaLogicalClusterMetadata(NonKafkaLogicalClusterMetadata.firstNonEmpty(lc.getLogicalClusterId(), lc.getId()), lc.getPhysicalClusterId(), NonKafkaLogicalClusterMetadata.firstNonEmpty(lc.getLogicalClusterName(), lc.getName()), NonKafkaLogicalClusterMetadata.firstNonEmpty(lc.getAccountId(), lc.getEnvironmentId()), lc.getK8SClusterId(), NonKafkaLogicalClusterMetadata.firstNonEmpty(lc.getLogicalClusterType(), lc.getType()), lc.getOrgResourceId().isEmpty() ? null : lc.getOrgResourceId(), NonKafkaLogicalClusterMetadata.firstNonEmpty(lc.getEnvironmentId(), lc.getAccountId()), NonKafkaLogicalClusterMetadata.toDate(lc.getCreated()), lc.hasDeactivated() ? NonKafkaLogicalClusterMetadata.toDate(lc.getDeactivated()) : null, NonKafkaLogicalClusterMetadata.getBackingLKCId(lc));
    }

    @JsonProperty
    public String logicalClusterId() {
        return this.logicalClusterId;
    }

    @JsonProperty
    public String physicalClusterId() {
        return this.physicalClusterId;
    }

    @JsonProperty
    public String logicalClusterName() {
        return this.logicalClusterName;
    }

    @JsonProperty
    public String accountId() {
        return this.accountId;
    }

    @JsonProperty
    public String organizationId() {
        return this.organizationId;
    }

    @JsonProperty
    public String environmentId() {
        return this.environmentId;
    }

    @JsonProperty
    public String k8sClusterId() {
        return this.k8sClusterId;
    }

    @JsonProperty
    public String logicalClusterType() {
        return this.logicalClusterType;
    }

    @JsonProperty
    public Date creationDate() {
        return this.creationDate;
    }

    @JsonProperty
    public Date deletionDate() {
        return this.deletionDate;
    }

    @JsonProperty
    public String backingLogicalKafkaClusterId() {
        return this.backingLogicalKafkaClusterId;
    }

    public boolean isValid() {
        return this.isSchemaRegistryLogicalCluster() || this.isKsqlLogicalCluster() || this.isSchemaRegistryHealthcheckLogicalCluster() || this.isKsqlHealthcheckLogicalCluster();
    }

    public boolean isHealthcheckLogicalCluster() {
        return false;
    }

    boolean isSchemaRegistryLogicalCluster() {
        return SCHEMA_REGISTRY_LOGICAL_CLUSTER_TYPE.equals(this.logicalClusterType);
    }

    boolean isSchemaRegistryHealthcheckLogicalCluster() {
        return SCHEMA_REGISTRY_HEALTHCHECK_LOGICAL_CLUSTER_TYPE.equals(this.logicalClusterType);
    }

    boolean isKsqlLogicalCluster() {
        return KSQL_LOGICAL_CLUSTER_TYPE.equals(this.logicalClusterType);
    }

    boolean isKsqlHealthcheckLogicalCluster() {
        return KSQL_HEALTHCHECK_LOGICAL_CLUSTER_TYPE.equals(this.logicalClusterType);
    }

    public boolean isActive() {
        return this.deletionDate() == null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        NonKafkaLogicalClusterMetadata that = (NonKafkaLogicalClusterMetadata)((Object)o);
        return Objects.equals(this.logicalClusterId, that.logicalClusterId) && Objects.equals(this.physicalClusterId, that.physicalClusterId) && Objects.equals(this.logicalClusterName, that.logicalClusterName) && Objects.equals(this.accountId, that.accountId) && Objects.equals(this.k8sClusterId, that.k8sClusterId) && Objects.equals(this.logicalClusterType, that.logicalClusterType) && Objects.equals(this.organizationId, that.organizationId) && Objects.equals(this.environmentId, that.environmentId) && Objects.equals(this.creationDate, that.creationDate) && Objects.equals(this.deletionDate, that.deletionDate) && Objects.equals(this.backingLogicalKafkaClusterId, that.backingLogicalKafkaClusterId);
    }

    public int hashCode() {
        return Objects.hash(this.logicalClusterId, this.physicalClusterId, this.logicalClusterName, this.accountId, this.k8sClusterId, this.logicalClusterType, this.organizationId, this.environmentId, this.creationDate, this.deletionDate, this.backingLogicalKafkaClusterId);
    }

    public String toString() {
        return "LogicalClusterMetadata(logicalClusterId=" + this.logicalClusterId + ", physicalClusterId=" + this.physicalClusterId + ", logicalClusterName=" + this.logicalClusterName + ", organizationId=" + this.organizationId + ", environmentId=" + this.environmentId + ", accountId=" + this.accountId + ", k8sClusterId=" + this.k8sClusterId + ", logicalClusterType=" + this.logicalClusterType + ", creationDate=" + this.creationDate + ", deletionDate=" + this.deletionDate + ", backingLogicalKafkaClusterId=" + this.backingLogicalKafkaClusterId + ')';
    }

    private static String firstNonEmpty(String ... args) {
        for (String s : args) {
            if (s == null || s.isEmpty()) continue;
            return s;
        }
        return null;
    }

    private static Date toDate(Timestamp timestamp) {
        if (timestamp == null || timestamp.getSeconds() == 0L && timestamp.getNanos() == 0) {
            return null;
        }
        return Date.from(Instant.ofEpochSecond(timestamp.getSeconds(), timestamp.getNanos()));
    }

    private static String getBackingLKCId(LogicalCluster lc) {
        String type = NonKafkaLogicalClusterMetadata.firstNonEmpty(lc.getLogicalClusterType(), lc.getType());
        String backinglkcId = lc.getBackingLogicalKafkaClusterId();
        if ((backinglkcId == null || backinglkcId.isEmpty() && lc.hasLogicalClusterConfig()) && type != null) {
            switch (type) {
                case "ksql": {
                    if (!lc.getLogicalClusterConfig().hasKsql()) break;
                    backinglkcId = lc.getLogicalClusterConfig().getKsql().getKafkaClusterId();
                    break;
                }
                case "schema-registry": {
                    if (!lc.getLogicalClusterConfig().hasSchemaRegistry()) break;
                    backinglkcId = lc.getLogicalClusterConfig().getSchemaRegistry().getKafkaClusterId();
                }
            }
        }
        return backinglkcId;
    }
}

