/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.dataplane;

import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.security.auth.dataplane.DataplaneAuthStore;
import io.confluent.security.auth.metadata.AuthStore;
import io.confluent.security.auth.provider.ConfluentProvider;
import io.confluent.security.authorizer.Action;
import io.confluent.security.authorizer.ResourcePattern;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.authorizer.provider.AuthorizeRule;
import io.confluent.security.authorizer.provider.ResourceAuthorizeRules;
import io.confluent.security.roledefinitions.Operation;
import io.confluent.security.roledefinitions.ResourceType;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.server.authorizer.internals.ConfluentAuthorizerServerInfo;

public class DataplaneProvider
extends ConfluentProvider {
    public static final String PROVIDER_NAME = "CC_DATAPLANE_PLANE_MDS";

    @Override
    public String providerName() {
        return PROVIDER_NAME;
    }

    @Override
    public boolean providerConfigured(Map<String, ?> configs) {
        return true;
    }

    @Override
    public boolean usesMetadataFromThisKafkaCluster() {
        return true;
    }

    @Override
    protected AuthStore createAuthStore(Scope rootScope, ConfluentAuthorizerServerInfo serverInfo, Map<String, ?> configs) {
        DataplaneAuthStore authStore = new DataplaneAuthStore(rootScope, serverInfo);
        authStore.configure(configs);
        return authStore;
    }

    @Override
    protected List<URL> metadataServerAdvertisedListeners() {
        return Collections.emptyList();
    }

    @Override
    public Scope authStoreScope() {
        return Scope.ROOT_SCOPE;
    }

    @Override
    public boolean mayDeny() {
        return false;
    }

    @Override
    public AuthorizeRule findRule(KafkaPrincipal sessionPrincipal, Set<KafkaPrincipal> groupPrincipals, String host, Action action) {
        if (sessionPrincipal instanceof MultiTenantPrincipal) {
            String tenantPrefix = ((MultiTenantPrincipal)sessionPrincipal).tenantMetadata().tenantPrefix();
            Action newAction = this.removeTenantPrefixIfPresent(action, tenantPrefix);
            return super.findRule(sessionPrincipal, groupPrincipals, host, newAction);
        }
        return super.findRule(sessionPrincipal, groupPrincipals, host, action);
    }

    private Action removeTenantPrefixIfPresent(Action action, String tenantPrefix) {
        ResourcePattern nonPrefixedResource = new ResourcePattern(action.resourceType(), action.resourceName().startsWith(tenantPrefix) ? action.resourceName().substring(tenantPrefix.length()) : action.resourceName(), action.resourcePattern().patternType());
        return new Action(action.scope(), nonPrefixedResource, action.operation(), action.resourceReferenceCount(), action.logIfAllowed(), action.logIfDenied());
    }

    @Override
    public void addMatchingRules(ResourceAuthorizeRules matchingRules, KafkaPrincipal sessionPrincipal, Set<KafkaPrincipal> groupPrincipals, String host, Operation operation, Scope scope, ResourceType resourceType) {
        super.addMatchingRules(matchingRules, sessionPrincipal, groupPrincipals, host, operation, scope, resourceType);
    }

    @Override
    public Set<KafkaPrincipal> groups(KafkaPrincipal sessionPrincipal) {
        return Collections.emptySet();
    }
}

