/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.provider;

import io.confluent.security.auth.dataplane.AuthnzAuthStore;
import io.confluent.security.auth.metadata.AuthCache;
import io.confluent.security.auth.metadata.AuthStore;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.authorizer.provider.AccessRuleProvider;
import io.confluent.security.authorizer.provider.AuthorizeRule;
import io.confluent.security.authorizer.provider.ResourceAuthorizeRules;
import io.confluent.security.roledefinitions.Operation;
import io.confluent.security.roledefinitions.ResourceType;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclState;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.apache.kafka.server.authorizer.internals.ConfluentAuthorizerServerInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthnzProvider
implements AccessRuleProvider,
Authorizer {
    private static final Logger log = LoggerFactory.getLogger(AuthnzProvider.class);
    public static final String PROVIDER_NAME = "CC_DATAPLANE_PLANE_AUTHNZ";
    private Map<String, ?> configs;
    private Scope authScope = Scope.ROOT_SCOPE;
    private Scope authStoreScope;
    private AuthStore authStore;
    private AuthCache authCache;
    private Metrics kafkaMetrics = null;

    public void configure(Map<String, ?> configs) {
        this.configs = configs;
        this.authStoreScope = this.authStoreScope();
    }

    public Scope authStoreScope() {
        return Scope.ROOT_SCOPE;
    }

    public String providerName() {
        return PROVIDER_NAME;
    }

    public boolean usesMetadataFromThisKafkaCluster() {
        return false;
    }

    public CompletionStage<Void> start(ConfluentAuthorizerServerInfo serverInfo) {
        HashMap clientConfigs = new HashMap(this.configs);
        clientConfigs.putAll(serverInfo.interBrokerClientConfig());
        this.authStore = this.createAuthStore(this.authStoreScope, serverInfo, clientConfigs);
        this.authCache = this.authStore.authCache();
        this.kafkaMetrics = serverInfo.metrics();
        return this.authStore.startReader();
    }

    public boolean mayDeny() {
        return false;
    }

    public boolean isSuperUser(KafkaPrincipal principal, Scope scope) {
        return false;
    }

    public AuthorizeRule findRule(KafkaPrincipal sessionPrincipal, Set<KafkaPrincipal> groupPrincipals, String host, io.confluent.security.authorizer.Action action) {
        return this.authCache.findRule(sessionPrincipal, groupPrincipals, host, action);
    }

    public void addMatchingRules(ResourceAuthorizeRules matchingRules, KafkaPrincipal sessionPrincipal, Set<KafkaPrincipal> groupPrincipals, String host, Operation operation, Scope scope, ResourceType resourceType) {
        this.authCache.addMatchingRules(matchingRules, sessionPrincipal, groupPrincipals, host, operation, scope, resourceType);
    }

    public void close() {
        log.debug("Closing authnz provider");
        AtomicReference<Object> firstException = new AtomicReference<Object>();
        Utils.closeQuietly((AutoCloseable)this.authStore, (String)"authStore", firstException);
        Throwable exception = firstException.getAndSet(null);
        if (exception != null) {
            throw new KafkaException("ConfluentProvider could not be closed cleanly", exception);
        }
    }

    public AuthStore authStore() {
        return this.authStore;
    }

    protected AuthStore createAuthStore(Scope scope, ConfluentAuthorizerServerInfo serverInfo, Map<String, ?> configs) {
        AuthnzAuthStore authStore = new AuthnzAuthStore(scope, serverInfo.metrics());
        authStore.configure(configs);
        return authStore;
    }

    public Map<Endpoint, ? extends CompletionStage<Void>> start(AuthorizerServerInfo serverInfo) {
        return Collections.emptyMap();
    }

    public List<AuthorizationResult> authorize(AuthorizableRequestContext requestContext, List<Action> actions) {
        throw new IllegalStateException("This provider should be used for authorization only using the AccessRuleProvider interface");
    }

    public List<? extends CompletionStage<AclCreateResult>> createAcls(AuthorizableRequestContext requestContext, List<AclBinding> aclBindings) {
        return this.createAcls(requestContext, aclBindings, Optional.empty());
    }

    public List<? extends CompletionStage<AclCreateResult>> createAcls(AuthorizableRequestContext requestContext, List<AclBinding> aclBindings, Optional<String> aclClusterId) {
        throw new IllegalStateException("This provider should be used for RBAC authorization only");
    }

    public List<? extends CompletionStage<AclDeleteResult>> deleteAcls(AuthorizableRequestContext requestContext, List<AclBindingFilter> aclBindingFilters) {
        return this.deleteAcls(requestContext, aclBindingFilters, Optional.empty(), AclState.ANY);
    }

    public List<? extends CompletionStage<AclDeleteResult>> deleteAcls(AuthorizableRequestContext requestContext, List<AclBindingFilter> aclBindingFilters, Optional<String> aclClusterId, AclState aclState) {
        throw new IllegalStateException("This provider should be used for RBAC authorization only");
    }

    public Iterable<AclBinding> acls(AclBindingFilter filter) {
        throw new IllegalStateException("This provider should be used for RBAC authorization only");
    }

    public void setKafkaMetrics(Metrics metrics) {
        this.kafkaMetrics = metrics;
    }
}

