/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.json;

import io.confluent.connect.schema.AbstractDataConfig;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.connect.json.DecimalFormat;

public class JsonSchemaDataConfig
extends AbstractDataConfig {
    public static final String OBJECT_ADDITIONAL_PROPERTIES_CONFIG = "object.additional.properties";
    public static final boolean OBJECT_ADDITIONAL_PROPERTIES_DEFAULT = true;
    public static final String OBJECT_ADDITIONAL_PROPERTIES_DOC = "Whether to allow additional properties for object schemas.";
    public static final String USE_OPTIONAL_FOR_NON_REQUIRED_CONFIG = "use.optional.for.nonrequired";
    public static final boolean USE_OPTIONAL_FOR_NON_REQUIRED_DEFAULT = false;
    public static final String USE_OPTIONAL_FOR_NON_REQUIRED_DOC = "Whether to set non-required properties to be optional.";
    public static final String IGNORE_MODERN_DIALECTS_CONFIG = "ignore.modern.dialects";
    public static final boolean IGNORE_MODERN_DIALECTS_DEFAULT = false;
    public static final String IGNORE_MODERN_DIALECTS_DOC = "Whether to ignore modern dialects of JSON Schema after draft 7, in which case draft 7 will be used.";
    public static final String DECIMAL_FORMAT_CONFIG = "decimal.format";
    public static final String DECIMAL_FORMAT_DEFAULT = DecimalFormat.BASE64.name();
    public static final String DECIMAL_FORMAT_DOC = "Controls which format this converter will serialize decimals in. This value is case insensitive and can be either 'BASE64' (default) or 'NUMERIC'";
    public static final String FLATTEN_SINGLETON_UNIONS_CONFIG = "flatten.singleton.unions";
    public static final boolean FLATTEN_SINGLETON_UNIONS_DEFAULT = true;
    public static final String FLATTEN_SINGLETON_UNIONS_DOC = "Whether to flatten singleton unions";

    public static ConfigDef baseConfigDef() {
        return AbstractDataConfig.baseConfigDef().define(OBJECT_ADDITIONAL_PROPERTIES_CONFIG, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.MEDIUM, OBJECT_ADDITIONAL_PROPERTIES_DOC).define(USE_OPTIONAL_FOR_NON_REQUIRED_CONFIG, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.MEDIUM, USE_OPTIONAL_FOR_NON_REQUIRED_DOC).define(IGNORE_MODERN_DIALECTS_CONFIG, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, IGNORE_MODERN_DIALECTS_DOC).define(DECIMAL_FORMAT_CONFIG, ConfigDef.Type.STRING, (Object)DECIMAL_FORMAT_DEFAULT, (ConfigDef.Validator)CaseInsensitiveValidString.in(DecimalFormat.BASE64.name(), DecimalFormat.NUMERIC.name()), ConfigDef.Importance.LOW, DECIMAL_FORMAT_DOC).define(FLATTEN_SINGLETON_UNIONS_CONFIG, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, FLATTEN_SINGLETON_UNIONS_DOC);
    }

    public JsonSchemaDataConfig(Map<?, ?> props) {
        super(JsonSchemaDataConfig.baseConfigDef(), props);
    }

    public boolean allowAdditionalProperties() {
        return this.getBoolean(OBJECT_ADDITIONAL_PROPERTIES_CONFIG);
    }

    public boolean useOptionalForNonRequiredProperties() {
        return this.getBoolean(USE_OPTIONAL_FOR_NON_REQUIRED_CONFIG);
    }

    public DecimalFormat decimalFormat() {
        return DecimalFormat.valueOf((String)this.getString(DECIMAL_FORMAT_CONFIG).toUpperCase(Locale.ROOT));
    }

    public boolean ignoreModernDialects() {
        return this.getBoolean(IGNORE_MODERN_DIALECTS_CONFIG);
    }

    public boolean isFlattenSingletonUnions() {
        return this.getBoolean(FLATTEN_SINGLETON_UNIONS_CONFIG);
    }

    public static class CaseInsensitiveValidString
    implements ConfigDef.Validator {
        final Set<String> validStrings;

        private CaseInsensitiveValidString(List<String> validStrings) {
            this.validStrings = validStrings.stream().map(s -> s.toUpperCase(Locale.ROOT)).collect(Collectors.toSet());
        }

        public static CaseInsensitiveValidString in(String ... validStrings) {
            return new CaseInsensitiveValidString(Arrays.asList(validStrings));
        }

        public void ensureValid(String name, Object o) {
            String s = (String)o;
            if (s == null || !this.validStrings.contains(s.toUpperCase(Locale.ROOT))) {
                throw new ConfigException(name, o, "String must be one of (case insensitive): " + String.join((CharSequence)", ", this.validStrings));
            }
        }

        public String toString() {
            return "(case insensitive) [" + String.join((CharSequence)", ", this.validStrings) + "]";
        }
    }

    public static class Builder {
        private final Map<String, Object> props = new HashMap<String, Object>();

        public Builder with(String key, Object value) {
            this.props.put(key, value);
            return this;
        }

        public JsonSchemaDataConfig build() {
            return new JsonSchemaDataConfig(this.props);
        }
    }
}

