/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.k2.kafka;

import java.util.Objects;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.Uuid;

public class K2TopicMetadata {
    private final String topicName;
    private final Uuid topicId;
    private final int numPartitions;
    private K2TopicLifecycleState k2TopicLifecycleState;

    public K2TopicMetadata(String topicName, Uuid topicId, int numPartitions, K2TopicLifecycleState k2TopicLifecycleState) {
        this.topicName = topicName;
        this.topicId = topicId;
        this.numPartitions = numPartitions;
        this.k2TopicLifecycleState = k2TopicLifecycleState;
    }

    public String topicName() {
        return this.topicName;
    }

    public Uuid topicId() {
        return this.topicId;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public Stream<TopicIdPartition> partitions() {
        return IntStream.range(0, this.numPartitions).mapToObj(part -> new TopicIdPartition(this.topicId, part, this.topicName));
    }

    public K2TopicLifecycleState k2TopicLifecycleState() {
        return this.k2TopicLifecycleState;
    }

    public String toString() {
        return "K2TopicMetadata{topicName='" + this.topicName + '\'' + ", topicId=" + this.topicId + ", numPartitions=" + this.numPartitions + ", k2TopicLifecycleState=" + (Object)((Object)this.k2TopicLifecycleState) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        K2TopicMetadata that = (K2TopicMetadata)o;
        return this.numPartitions == that.numPartitions && Objects.equals(this.topicName, that.topicName) && Objects.equals(this.topicId, that.topicId) && this.k2TopicLifecycleState == that.k2TopicLifecycleState;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.topicName, this.topicId, this.numPartitions, this.k2TopicLifecycleState});
    }

    public static enum K2TopicLifecycleState {
        CREATING,
        ONLINE,
        DELETING;

    }
}

