/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import joptsimple.OptionSpec;
import kafka.admin.LeadershipPriorityCommandOptions;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterLeadershipPriorityOptions;
import org.apache.kafka.clients.admin.AlterLeadershipPrioritySpec;
import org.apache.kafka.clients.admin.BrokerLeadershipPriorityResult;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.DescribeLeadershipPriorityOptions;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.common.AdminOperationException;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;

public final class LeadershipPriorityCommand$
implements Logging {
    public static final LeadershipPriorityCommand$ MODULE$ = new LeadershipPriorityCommand$();
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public void main(String[] args) {
        int exitCode = 0;
        try {
            try {
                this.run(args, (Option<ConfluentAdmin>)None$.MODULE$);
            }
            catch (Throwable e) {
                exitCode = 1;
                this.printException(e);
            }
        }
        catch (Throwable throwable) {
            throw Exit$.MODULE$.exit(exitCode, (Option<String>)None$.MODULE$);
        }
        throw Exit$.MODULE$.exit(exitCode, (Option<String>)None$.MODULE$);
    }

    public void run(String[] args, Option<ConfluentAdmin> clientOption) {
        LeadershipPriorityCommandOptions opts = (LeadershipPriorityCommandOptions)((Object)new Some((Object)new LeadershipPriorityCommandOptions(args)).get());
        try (ConfluentAdmin client = (ConfluentAdmin)clientOption.getOrElse((Function0 & Serializable)() -> MODULE$.createAdminClient(opts));){
            try {
                if (opts.options.has((OptionSpec)opts.describeOpt())) {
                    this.describeLeadershipPriority(client);
                } else {
                    this.alterLeadershipPriority(client, opts);
                }
            }
            catch (ExecutionException e) {
                if (e.getCause() != null) {
                    throw e.getCause();
                }
                throw e;
            }
        }
    }

    public Option<ConfluentAdmin> run$default$2() {
        return None$.MODULE$;
    }

    private void printException(Throwable e) {
        Predef$.MODULE$.println((Object)new StringBuilder(50).append("Error while running leadership priority command : ").append(e.getMessage()).toString());
    }

    private void describeLeadershipPriority(ConfluentAdmin client) {
        ((Collection)client.describeLeadershipPriority(new DescribeLeadershipPriorityOptions()).future().get()).forEach(result -> {
            Predef$.MODULE$.print((Object)new StringBuilder(17).append("\tDemoted Broker: ").append(result.brokerId()).toString());
            Predef$.MODULE$.print((Object)new StringBuilder(10).append("\tReasons: ").append(CollectionConverters$.MODULE$.ListHasAsScala(result.reasons()).asScala().mkString(", ")).toString());
            Predef$.MODULE$.println();
        });
    }

    private void alterLeadershipPriority(ConfluentAdmin client, LeadershipPriorityCommandOptions opts) {
        int controllerId;
        AlterLeadershipPrioritySpec.PriorityOperationEnum priorityOperationEnum = opts.options.has((OptionSpec)opts.demoteOpt()) ? AlterLeadershipPrioritySpec.PriorityOperationEnum.DEMOTE : AlterLeadershipPrioritySpec.PriorityOperationEnum.PROMOTE;
        Set<Integer> brokerIds = this.parseBrokerIds((String)opts.options.valueOf(opts.brokerIdsOpt()));
        if (brokerIds.contains((Object)(controllerId = ((Node)client.describeCluster().controller().get()).id()))) {
            AlterLeadershipPrioritySpec.PriorityOperationEnum priorityOperationEnum2 = priorityOperationEnum;
            AlterLeadershipPrioritySpec.PriorityOperationEnum priorityOperationEnum3 = AlterLeadershipPrioritySpec.PriorityOperationEnum.DEMOTE;
            if (!(priorityOperationEnum2 != null ? !priorityOperationEnum2.equals(priorityOperationEnum3) : priorityOperationEnum3 != null)) {
                Predef$.MODULE$.println((Object)new StringBuilder(35).append("The controller:(").append(controllerId).append(") is being demoted.").toString());
            }
        }
        AlterLeadershipPrioritySpec requestData = new AlterLeadershipPrioritySpec(CollectionConverters$.MODULE$.SetHasAsJava(this.parseBrokerIds((String)opts.options.valueOf(opts.brokerIdsOpt()))).asJava(), priorityOperationEnum, (String)opts.options.valueOf(opts.reasonOpt()), opts.options.has((OptionSpec)opts.forceOpt()));
        client.alterLeadershipPriority(requestData, new AlterLeadershipPriorityOptions()).values().forEach((x0$1, x1$1) -> {
            try {
                BrokerLeadershipPriorityResult result = (BrokerLeadershipPriorityResult)x1$1.get();
                Predef$.MODULE$.print((Object)new StringBuilder(9).append("\tBroker: ").append(result.brokerId()).toString());
                Predef$.MODULE$.print((Object)new StringBuilder(15).append("\tBroker state: ").append(result.leadershipPriority()).toString());
                Predef$.MODULE$.println();
                return;
            }
            catch (ExecutionException e) {
                if (e.getCause() != null) {
                    MODULE$.printBrokerFailedMessage(e.getCause(), (Integer)x0$1);
                    return;
                }
                MODULE$.printBrokerFailedMessage(e, (Integer)x0$1);
                return;
            }
            catch (InterruptedException e) {
                MODULE$.printBrokerFailedMessage(e, (Integer)x0$1);
                return;
            }
        });
    }

    private void printBrokerFailedMessage(Throwable throwable, Integer brokerId) {
        Predef$.MODULE$.print((Object)new StringBuilder(19).append("\tBroker: ").append(brokerId).append("\tFailed: ").append(throwable.getMessage()).append("\n").toString());
    }

    private ConfluentAdmin createAdminClient(LeadershipPriorityCommandOptions opts) {
        Properties props = opts.options.has(opts.commandConfigOpt()) ? Utils.loadProps((String)((String)opts.options.valueOf(opts.commandConfigOpt())), null) : new Properties();
        props.setProperty("bootstrap.servers", (String)opts.options.valueOf(opts.bootstrapServer()));
        return (ConfluentAdmin)Admin.create((Properties)props);
    }

    private Set<Integer> parseBrokerIds(String brokerIdsString) {
        StringOps$.MODULE$.foreach$extension(Predef$.MODULE$.augmentString(brokerIdsString), (Function1 & Serializable)ch -> {
            LeadershipPriorityCommand$.$anonfun$parseBrokerIds$1(brokerIdsString, BoxesRunTime.unboxToChar((Object)ch));
            return BoxedUnit.UNIT;
        });
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])brokerIdsString.split(",")), (Function1 & Serializable)brokerId -> Predef$.MODULE$.int2Integer(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(brokerId))), ClassTag$.MODULE$.apply(Integer.class))).toSet();
    }

    public static final /* synthetic */ void $anonfun$parseBrokerIds$1(String brokerIdsString$1, char ch) {
        if (!((Object)BoxesRunTime.boxToCharacter((char)ch)).equals(BoxesRunTime.boxToCharacter((char)',')) && !RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(ch))) {
            throw new AdminOperationException(new StringBuilder(54).append("Broker ids: ").append(brokerIdsString$1).append(", must not include invalid character - '").append(ch).append("'.").toString());
        }
    }

    private LeadershipPriorityCommand$() {
    }
}

