/*
 * Decompiled with CFR 0.152.
 */
package kafka.catalog.event;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kafka.catalog.MetadataCollectorEventQueue;
import kafka.catalog.ZKMetadataCollector;
import kafka.catalog.ZKMetadataCollectorConfig;
import kafka.catalog.ZKMetadataCollectorContext;
import kafka.catalog.event.CacheBuildEvent;
import kafka.catalog.event.CollectorStopEvent;
import kafka.catalog.event.MetadataCollectorEvent;
import kafka.catalog.metadata.ClusterLinkInfo;
import kafka.catalog.metadata.TopicInfo;
import kafka.server.KafkaConfig;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;

public class CollectorStartupEvent
extends MetadataCollectorEvent {
    private final ZKMetadataCollectorConfig config;
    private final MetadataCollectorEventQueue eventQueue;
    private final KafkaZkClient zkClient;
    private final Metrics metrics;
    private final KafkaConfig originalConfig;
    private final int epoch;
    private final Map<String, TopicInfo> initialTopicsWithInfo;
    private final Map<String, ClusterLinkInfo> initialClusterLinksWithInfo;

    public CollectorStartupEvent(ZKMetadataCollector collector, ZKMetadataCollectorConfig config, Map<String, TopicInfo> initialTopicsWithInfo, Map<String, ClusterLinkInfo> initialClusterLinksWithInfo, MetadataCollectorEventQueue eventQueue, Metrics metrics, KafkaZkClient zkClient, KafkaConfig originalConfig, int epoch, Time time) {
        super(collector, time);
        this.config = config;
        this.initialTopicsWithInfo = initialTopicsWithInfo;
        this.initialClusterLinksWithInfo = initialClusterLinksWithInfo;
        this.eventQueue = eventQueue;
        this.zkClient = zkClient;
        this.metrics = metrics;
        this.originalConfig = originalConfig;
        this.epoch = epoch;
    }

    public void run() throws Exception {
        Map<String, TopicInfo> filteredTopicMap = this.initialTopicsWithInfo.entrySet().stream().filter(entry -> !Objects.equals(((TopicInfo)entry.getValue()).logicalClusterId(), "")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<String, ClusterLinkInfo> filteredClusterLinkMap = this.initialClusterLinksWithInfo.entrySet().stream().filter(entry -> !Objects.equals(((ClusterLinkInfo)entry.getValue()).logicalClusterId(), "")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        ZKMetadataCollectorContext context = new ZKMetadataCollectorContext(this.config, filteredTopicMap, filteredClusterLinkMap, this.eventQueue, this.metrics, this.zkClient, this.originalConfig, this.epoch, this.time);
        this.collector.setCollectorContext(Optional.of(context));
        this.eventQueue.appendWithTag("CACHE_BUILD_EVENT", new CacheBuildEvent(this.collector, this.config.maxNumTopicsProcess, this.time));
        LOG.info("Finished starting ZKMetadataCollector with epoch {}", (Object)this.epoch);
    }

    @Override
    public void handleException(Throwable e) {
        LOG.error("Error during starting ZKMetadataCollector", e);
        this.eventQueue.append(new CollectorStopEvent(this.collector, this.time));
    }

    public String toString() {
        return "CollectorStartupEvent(epoch=" + this.epoch + ')';
    }
}

