/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import kafka.cluster.Broker;
import kafka.controller.ControlMetadataAccumulator;
import kafka.controller.ControlMetadataBatch;
import kafka.controller.ControlMetadataBatchResult;
import kafka.controller.ControllerBrokerStateInfo;
import kafka.controller.ControllerChannelManager$;
import kafka.controller.ControllerContext;
import kafka.controller.QueueItem;
import kafka.controller.RequestSendThread;
import kafka.controller.StateChangeLogger;
import kafka.controller.UnhealthyBroker;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataRecoveryStrategy;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005ux!B\u0014)\u0011\u0003ic!B\u0018)\u0011\u0003\u0001\u0004\"B\u001c\u0002\t\u0003A\u0004bB\u001d\u0002\u0005\u0004%IA\u000f\u0005\u0007\u0007\u0006\u0001\u000b\u0011B\u001e\t\u000f\u0011\u000b!\u0019!C\u0005u!1Q)\u0001Q\u0001\nmBqAR\u0001C\u0002\u0013%!\b\u0003\u0004H\u0003\u0001\u0006Ia\u000f\u0005\b\u0011\u0006\t\n\u0011\"\u0001J\r\u0011y\u0003\u0006A1\t\u0011!T!\u0011!Q\u0001\n%D\u0001\u0002\u001c\u0006\u0003\u0002\u0003\u0006I!\u001c\u0005\tg*\u0011\t\u0011)A\u0005i\"Q\u0011\u0011\u0001\u0006\u0003\u0002\u0003\u0006I!a\u0001\t\u0015\u00055!B!A!\u0002\u0013\ty\u0001C\u0005\u0002\u0016)\u0011\t\u0011)A\u0005\u0017\"1qG\u0003C\u0001\u0003/A\u0011\"a\n\u000b\u0005\u0004%I!!\u000b\t\u0011\u0005]\"\u0002)A\u0005\u0003WA\u0011\"!\u000f\u000b\u0005\u0004%\t\"a\u000f\t\u0011\u0005e#\u0002)A\u0005\u0003{A\u0011\"a\u0017\u000b\u0005\u0004%I!!\u0018\t\u0011\u0005\u0015$\u0002)A\u0005\u0003?B\u0011\"a\u001a\u000b\u0005\u0004%\t!!\u001b\t\u0011\u0005]$\u0002)A\u0005\u0003WBq!!\u001f\u000b\t\u0013\tY\bC\u0004\u0002\f*!\t!!$\t\u000f\u0005=%\u0002\"\u0001\u0002\u0012\"9\u0011Q\u0013\u0006\u0005\u0002\u00055\u0005bBAL\u0015\u0011\u0005\u0011Q\u0012\u0005\b\u00033SA\u0011AAN\u0011%\tILCI\u0001\n\u0003\tY\fC\u0004\u0002@*!\t!!1\t\u000f\u0005M'\u0002\"\u0001\u0002V\"9\u0011\u0011\u001c\u0006\u0005\u0012\u0005m\u0007bBAp\u0015\u0011%\u0011\u0011\u001d\u0005\b\u0003_TA\u0011CAy\u0011\u001d\t9P\u0003C\t\u0003s\f\u0001dQ8oiJ|G\u000e\\3s\u0007\"\fgN\\3m\u001b\u0006t\u0017mZ3s\u0015\tI#&\u0001\u0006d_:$(o\u001c7mKJT\u0011aK\u0001\u0006W\u000647.Y\u0002\u0001!\tq\u0013!D\u0001)\u0005a\u0019uN\u001c;s_2dWM]\"iC:tW\r\\'b]\u0006<WM]\n\u0003\u0003E\u0002\"AM\u001b\u000e\u0003MR\u0011\u0001N\u0001\u0006g\u000e\fG.Y\u0005\u0003mM\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001.\u0003M\tV/Z;f'&TX-T3ue&\u001cg*Y7f+\u0005Y\u0004C\u0001\u001fB\u001b\u0005i$B\u0001 @\u0003\u0011a\u0017M\\4\u000b\u0003\u0001\u000bAA[1wC&\u0011!)\u0010\u0002\u0007'R\u0014\u0018N\\4\u0002)E+X-^3TSj,W*\u001a;sS\u000et\u0015-\\3!\u0003\u0005\u0012V-];fgR\u0014\u0016\r^3B]\u0012\fV/Z;f)&lW-T3ue&\u001cg*Y7f\u0003\t\u0012V-];fgR\u0014\u0016\r^3B]\u0012\fV/Z;f)&lW-T3ue&\u001cg*Y7fA\u0005\tSK\u001c5fC2$\b.\u001f\"s_.,'o\u00155vi\u0012|wO\\'fiJL7MT1nK\u0006\u0011SK\u001c5fC2$\b.\u001f\"s_.,'o\u00155vi\u0012|wO\\'fiJL7MT1nK\u0002\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u00122T#\u0001&+\u0005-C\u0006c\u0001\u001aM\u001d&\u0011Qj\r\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005=3fB\u0001)U!\t\t6'D\u0001S\u0015\t\u0019F&\u0001\u0004=e>|GOP\u0005\u0003+N\na\u0001\u0015:fI\u00164\u0017B\u0001\"X\u0015\t)6gK\u0001Z!\tQv,D\u0001\\\u0015\taV,A\u0005v]\u000eDWmY6fI*\u0011alM\u0001\u000bC:tw\u000e^1uS>t\u0017B\u00011\\\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\n\u0004\u0015E\u0012\u0007CA2g\u001b\u0005!'BA3+\u0003\u0015)H/\u001b7t\u0013\t9GMA\u0004M_\u001e<\u0017N\\4\u0002#\r|g\u000e\u001e:pY2,'oQ8oi\u0016DH\u000f\u0005\u0002/U&\u00111\u000e\u000b\u0002\u0012\u0007>tGO]8mY\u0016\u00148i\u001c8uKb$\u0018AB2p]\u001aLw\r\u0005\u0002oc6\tqN\u0003\u0002qU\u000511/\u001a:wKJL!A]8\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u0005i&lW\r\u0005\u0002v}6\taO\u0003\u0002fo*\u0011\u00010_\u0001\u0007G>lWn\u001c8\u000b\u0005-R(BA>}\u0003\u0019\t\u0007/Y2iK*\tQ0A\u0002pe\u001eL!a <\u0003\tQKW.Z\u0001\b[\u0016$(/[2t!\u0011\t)!!\u0003\u000e\u0005\u0005\u001d!bAA\u0001o&!\u00111BA\u0004\u0005\u001diU\r\u001e:jGN\f\u0011c\u001d;bi\u0016\u001c\u0005.\u00198hK2{wmZ3s!\rq\u0013\u0011C\u0005\u0004\u0003'A#!E*uCR,7\t[1oO\u0016dunZ4fe\u0006\u0001B\u000f\u001b:fC\u0012t\u0015-\\3Qe\u00164\u0017\u000e\u001f\u000b\u000f\u00033\tY\"!\b\u0002 \u0005\u0005\u00121EA\u0013!\tq#\u0002C\u0003i#\u0001\u0007\u0011\u000eC\u0003m#\u0001\u0007Q\u000eC\u0003t#\u0001\u0007A\u000fC\u0004\u0002\u0002E\u0001\r!a\u0001\t\u000f\u00055\u0011\u00031\u0001\u0002\u0010!A\u0011QC\t\u0011\u0002\u0003\u00071*\u0001\u0007nKR\u0014\u0018nY:He>,\b/\u0006\u0002\u0002,A!\u0011QFA\u001a\u001b\t\tyC\u0003\u0003\u0002\u0002\u0005E\"B\u00019z\u0013\u0011\t)$a\f\u0003#-\u000bgm[1NKR\u0014\u0018nY:He>,\b/A\u0007nKR\u0014\u0018nY:He>,\b\u000fI\u0001\u0010EJ|7.\u001a:Ti\u0006$X-\u00138g_V\u0011\u0011Q\b\t\t\u0003\u007f\tI%!\u0014\u0002T5\u0011\u0011\u0011\t\u0006\u0005\u0003\u0007\n)%A\u0004nkR\f'\r\\3\u000b\u0007\u0005\u001d3'\u0001\u0006d_2dWm\u0019;j_:LA!a\u0013\u0002B\t9\u0001*Y:i\u001b\u0006\u0004\bc\u0001\u001a\u0002P%\u0019\u0011\u0011K\u001a\u0003\u0007%sG\u000fE\u0002/\u0003+J1!a\u0016)\u0005e\u0019uN\u001c;s_2dWM\u001d\"s_.,'o\u0015;bi\u0016LeNZ8\u0002!\t\u0014xn[3s'R\fG/Z%oM>\u0004\u0013A\u00032s_.,'\u000fT8dWV\u0011\u0011q\f\t\u0004y\u0005\u0005\u0014bAA2{\t1qJ\u00196fGR\f1B\u0019:pW\u0016\u0014Hj\\2lA\u0005\u0011RO\u001c5fC2$\b.\u001f\"s_.,'/T1q+\t\tY\u0007\u0005\u0005\u0002@\u00055\u0014QJA9\u0013\u0011\ty'!\u0011\u0003\u00075\u000b\u0007\u000fE\u0002/\u0003gJ1!!\u001e)\u0005=)f\u000e[3bYRD\u0017P\u0011:pW\u0016\u0014\u0018aE;oQ\u0016\fG\u000e\u001e5z\u0005J|7.\u001a:NCB\u0004\u0013aI2sK\u0006$X-\u00168iK\u0006dG\u000f[=Ce>\\WM]*ikR$wn\u001e8NKR\u0014\u0018n\u0019\u000b\u0007\u0003{\n\u0019)a\"\u0011\u0007I\ny(C\u0002\u0002\u0002N\u0012A!\u00168ji\"9\u0011Q\u0011\u000eA\u0002\u00055\u0013\u0001\u00032s_.,'/\u00133\t\r\u0005%%\u00041\u0001O\u0003\u0019\u0011\u0018mY6JI\u0006i2\r\\3b]V\u0003XK\u001c5fC2$\b.\u001f\"s_.,'/T3ue&\u001c7\u000f\u0006\u0002\u0002~\u0005)\u0013N\\2sK6,g\u000e^+oQ\u0016\fG\u000e\u001e5z\u0005J|7.\u001a:TQV$Hm\\<o\u0007>,h\u000e\u001e\u000b\u0005\u0003{\n\u0019\nC\u0004\u0002\u0006r\u0001\r!!\u0014\u0002\u000fM$\u0018M\u001d;va\u0006A1\u000f[;uI><h.\u0001\rtK:$7i\u001c8ue>dW*\u001a;bI\u0006$\u0018MQ1uG\"$\u0002\"! \u0002\u001e\u0006}\u0015\u0011\u0016\u0005\b\u0003\u000b{\u0002\u0019AA'\u0011\u001d\t\tk\ba\u0001\u0003G\u000bQAY1uG\"\u00042ALAS\u0013\r\t9\u000b\u000b\u0002\u0015\u0007>tGO]8m\u001b\u0016$\u0018\rZ1uC\n\u000bGo\u00195\t\u0013\u0005-v\u0004%AA\u0002\u00055\u0016\u0001C2bY2\u0014\u0017mY6\u0011\u0013I\ny+a)\u00024\u0006u\u0014bAAYg\tIa)\u001e8di&|gN\r\t\u0004]\u0005U\u0016bAA\\Q\tQ2i\u001c8ue>dW*\u001a;bI\u0006$\u0018MQ1uG\"\u0014Vm];mi\u0006\u00113/\u001a8e\u0007>tGO]8m\u001b\u0016$\u0018\rZ1uC\n\u000bGo\u00195%I\u00164\u0017-\u001e7uIM*\"!!0+\u0007\u00055\u0006,A\u0005bI\u0012\u0014%o\\6feR!\u0011QPAb\u0011\u001d\t)-\ta\u0001\u0003\u000f\faA\u0019:pW\u0016\u0014\b\u0003BAe\u0003\u001fl!!a3\u000b\u0007\u00055'&A\u0004dYV\u001cH/\u001a:\n\t\u0005E\u00171\u001a\u0002\u0007\u0005J|7.\u001a:\u0002\u0019I,Wn\u001c<f\u0005J|7.\u001a:\u0015\t\u0005u\u0014q\u001b\u0005\b\u0003\u000b\u0013\u0003\u0019AA'\u00031\tG\r\u001a(fo\n\u0013xn[3s)\u0011\ti(!8\t\u000f\u0005\u00157\u00051\u0001\u0002H\u0006\u0001\"M]8lKJlU\r\u001e:jGR\u000bwm\u001d\u000b\u0005\u0003G\fi\u000f\u0005\u0004\u0002f\u0006-8hO\u0007\u0003\u0003OT1!!;@\u0003\u0011)H/\u001b7\n\t\u0005=\u0014q\u001d\u0005\b\u0003\u000b#\u0003\u0019AA'\u0003Q\u0011X-\\8wK\u0016C\u0018n\u001d;j]\u001e\u0014%o\\6feR!\u0011QPAz\u0011\u001d\t)0\na\u0001\u0003'\n1B\u0019:pW\u0016\u00148\u000b^1uK\u000612\u000f^1siJ+\u0017/^3tiN+g\u000e\u001a+ie\u0016\fG\r\u0006\u0003\u0002~\u0005m\bbBACM\u0001\u0007\u0011Q\n")
public class ControllerChannelManager
implements Logging {
    private final ControllerContext controllerContext;
    private final KafkaConfig config;
    private final Time time;
    private final Metrics metrics;
    private final StateChangeLogger stateChangeLogger;
    private final Option<String> threadNamePrefix;
    private final KafkaMetricsGroup metricsGroup;
    private final HashMap<Object, ControllerBrokerStateInfo> brokerStateInfo;
    private final Object brokerLock;
    private final scala.collection.mutable.Map<Object, UnhealthyBroker> unhealthyBrokerMap;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Option<String> $lessinit$greater$default$6() {
        return None$.MODULE$;
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    public HashMap<Object, ControllerBrokerStateInfo> brokerStateInfo() {
        return this.brokerStateInfo;
    }

    private Object brokerLock() {
        return this.brokerLock;
    }

    public scala.collection.mutable.Map<Object, UnhealthyBroker> unhealthyBrokerMap() {
        return this.unhealthyBrokerMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createUnhealthyBrokerShutdownMetric(int brokerId, String rackId) {
        String rackString = (String)Option$.MODULE$.apply((Object)rackId).getOrElse((Function0 & Serializable)() -> "");
        UnhealthyBroker unhealthyBroker = (UnhealthyBroker)this.unhealthyBrokerMap().apply((Object)BoxesRunTime.boxToInteger((int)brokerId));
        if (unhealthyBroker != null) {
            Object object = unhealthyBroker.shutdownTag().apply((Object)"rack-id");
            if (!(object == null ? rackString != null : !object.equals(rackString))) return;
            this.metricsGroup().removeMetric(ControllerChannelManager$.MODULE$.kafka$controller$ControllerChannelManager$$UnhealthyBrokerShutdownMetricName(), CollectionConverters$.MODULE$.MapHasAsJava(unhealthyBroker.shutdownTag()).asJava());
        } else {
            unhealthyBroker = new UnhealthyBroker();
            this.unhealthyBrokerMap().update((Object)BoxesRunTime.boxToInteger((int)brokerId), (Object)unhealthyBroker);
        }
        unhealthyBroker.shutdownTag_$eq((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"broker-id"), (Object)Integer.toString(brokerId)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rack-id"), (Object)rackString)}))));
        unhealthyBroker.meter_$eq(this.metricsGroup().newMeter(ControllerChannelManager$.MODULE$.kafka$controller$ControllerChannelManager$$UnhealthyBrokerShutdownMetricName(), "requests", TimeUnit.SECONDS, CollectionConverters$.MODULE$.MapHasAsJava(unhealthyBroker.shutdownTag()).asJava()));
    }

    public void cleanUpUnhealthyBrokerMetrics() {
        this.unhealthyBrokerMap().foreach((Function1 & Serializable)x0$1 -> {
            ControllerChannelManager.$anonfun$cleanUpUnhealthyBrokerMetrics$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public void incrementUnhealthyBrokerShutdownCount(int brokerId) {
        UnhealthyBroker unhealthyBroker = (UnhealthyBroker)this.unhealthyBrokerMap().apply((Object)BoxesRunTime.boxToInteger((int)brokerId));
        if (unhealthyBroker != null) {
            unhealthyBroker.meter().mark();
            return;
        }
    }

    public void startup() {
        this.controllerContext.liveOrShuttingDownBrokers().foreach((Function1 & Serializable)broker -> {
            this.addNewBroker(broker);
            return BoxedUnit.UNIT;
        });
        Object object = this.brokerLock();
        synchronized (object) {
            this.brokerStateInfo().foreach((Function1 & Serializable)brokerState -> {
                this.startRequestSendThread(brokerState._1$mcI$sp());
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public void shutdown() {
        Object object = this.brokerLock();
        synchronized (object) {
            this.brokerStateInfo().values().toList().foreach((Function1 & Serializable)brokerState -> {
                this.removeExistingBroker(brokerState);
                return BoxedUnit.UNIT;
            });
            this.cleanUpUnhealthyBrokerMetrics();
            return;
        }
    }

    public void sendControlMetadataBatch(int brokerId, ControlMetadataBatch batch, Function2<ControlMetadataBatch, ControlMetadataBatchResult, BoxedUnit> callback) {
        Object object = this.brokerLock();
        synchronized (object) {
            Option stateInfoOpt = this.brokerStateInfo().get((Object)BoxesRunTime.boxToInteger((int)brokerId));
            if (stateInfoOpt instanceof Some) {
                ((ControllerBrokerStateInfo)((Some)stateInfoOpt).value()).messageQueue().put(new QueueItem(batch, callback, this.time.milliseconds()));
            } else if (None$.MODULE$.equals(stateInfoOpt)) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(51).append("Not sending batch ").append(batch).append(" to broker ").append(brokerId).append(", since it is offline.").toString());
            } else {
                throw new MatchError((Object)stateInfoOpt);
            }
            return;
        }
    }

    public Function2<ControlMetadataBatch, ControlMetadataBatchResult, BoxedUnit> sendControlMetadataBatch$default$3() {
        return null;
    }

    public void addBroker(Broker broker) {
        Object object = this.brokerLock();
        synchronized (object) {
            if (!this.brokerStateInfo().contains((Object)BoxesRunTime.boxToInteger((int)broker.id()))) {
                this.addNewBroker(broker);
                this.startRequestSendThread(broker.id());
            }
            return;
        }
    }

    public void removeBroker(int brokerId) {
        Object object = this.brokerLock();
        synchronized (object) {
            this.removeExistingBroker((ControllerBrokerStateInfo)this.brokerStateInfo().apply((Object)BoxesRunTime.boxToInteger((int)brokerId)));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addNewBroker(Broker broker) {
        void var11_16;
        void var10_15;
        String string;
        void var8_13;
        None$ none$;
        void clientChannelBuilder_saslHandshakeRequestEnable;
        void clientChannelBuilder_time;
        void clientChannelBuilder_clientSaslMechanism;
        void clientChannelBuilder_config;
        ControlMetadataAccumulator messageQueue = new ControlMetadataAccumulator();
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(40).append("Controller ").append($this.config.brokerId()).append(" trying to connect to broker ").append(broker.id()).toString());
        ListenerName controllerToBrokerListenerName = (ListenerName)this.config.controlPlaneListenerName().getOrElse((Function0 & Serializable)() -> $this.config.interBrokerListenerName());
        SecurityProtocol controllerToBrokerSecurityProtocol = (SecurityProtocol)this.config.controlPlaneSecurityProtocol().getOrElse((Function0 & Serializable)() -> $this.config.interBrokerSecurityProtocol());
        Node brokerNode = broker.node(controllerToBrokerListenerName);
        LogContext logContext = new LogContext(new StringBuilder(34).append("[Controller id=").append(this.config.brokerId()).append(", targetBrokerId=").append(brokerNode.idString()).append("] ").toString());
        boolean bl = this.config.saslInterBrokerHandshakeRequestEnable();
        Time time = this.time;
        String string2 = this.config.saslMechanismInterBrokerProtocol();
        KafkaConfig kafkaConfig = this.config;
        JaasContext.Type clientChannelBuilder_contextType = JaasContext.Type.SERVER;
        Object var18_11 = null;
        kafkaConfig = null;
        string2 = null;
        time = null;
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder((SecurityProtocol)controllerToBrokerSecurityProtocol, (JaasContext.Type)clientChannelBuilder_contextType, (AbstractConfig)clientChannelBuilder_config, (ListenerName)controllerToBrokerListenerName, (String)clientChannelBuilder_clientSaslMechanism, (Time)clientChannelBuilder_time, (boolean)clientChannelBuilder_saslHandshakeRequestEnable, (LogContext)logContext, null, null);
        if (channelBuilder instanceof Reconfigurable) {
            this.config.addReconfigurable((Reconfigurable)channelBuilder);
            none$ = new Some((Object)channelBuilder);
        } else {
            none$ = None$.MODULE$;
        }
        None$ reconfigurableChannelBuilder = none$;
        Selector selector = new Selector(-1, -1L, this.metrics, this.time, "controller-channel", CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"broker-id"), (Object)brokerNode.idString())}))).asJava(), false, channelBuilder, logContext);
        NetworkClient networkClient = new NetworkClient((Selectable)selector, (MetadataUpdater)new ManualMetadataUpdater(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)brokerNode, (List)Nil$.MODULE$)).asJava()), Integer.toString(this.config.brokerId()), 1, 0L, 0L, -1, -1, Predef$.MODULE$.Integer2int(this.config.requestTimeoutMs()), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMs()), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMaxMs()), this.time, false, new ApiVersions(), logContext, MetadataRecoveryStrategy.NONE);
        Option reconfigurableChannelBuilder2 = (Option)var8_13;
        Option<String> option = this.threadNamePrefix;
        if (None$.MODULE$.equals(option)) {
            string = new StringBuilder(34).append("Controller-").append(this.config.brokerId()).append("-to-broker-").append(broker.id()).append("-send-thread").toString();
        } else if (option instanceof Some) {
            String name = (String)((Some)option).value();
            string = new StringBuilder(35).append(name).append(":Controller-").append(this.config.brokerId()).append("-to-broker-").append(broker.id()).append("-send-thread").toString();
        } else {
            throw new MatchError(option);
        }
        String threadName = string;
        Timer requestRateAndQueueTimeMetrics = this.metricsGroup().newTimer(ControllerChannelManager$.MODULE$.kafka$controller$ControllerChannelManager$$RequestRateAndQueueTimeMetricName(), TimeUnit.MILLISECONDS, TimeUnit.SECONDS, this.brokerMetricTags(broker.id()));
        RequestSendThread requestThread = new RequestSendThread(this.config.brokerId(), this.controllerContext, messageQueue, (NetworkClient)var10_15, brokerNode, this.config, this.time, requestRateAndQueueTimeMetrics, this.stateChangeLogger, threadName);
        requestThread.setDaemon(false);
        Gauge queueSizeGauge = this.metricsGroup().newGauge(ControllerChannelManager$.MODULE$.kafka$controller$ControllerChannelManager$$QueueSizeMetricName(), (Gauge)new Gauge<Object>(this, messageQueue){
            private final /* synthetic */ ControllerChannelManager $outer;
            private final ControlMetadataAccumulator messageQueue$1;

            public final int value() {
                return this.messageQueue$1.size();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.messageQueue$1 = messageQueue$1;
            }
        }, this.brokerMetricTags(broker.id()));
        this.brokerStateInfo().put((Object)BoxesRunTime.boxToInteger((int)broker.id()), (Object)new ControllerBrokerStateInfo((NetworkClient)var10_15, brokerNode, messageQueue, requestThread, (Gauge<Object>)queueSizeGauge, requestRateAndQueueTimeMetrics, (Option<Reconfigurable>)var11_16));
        this.createUnhealthyBrokerShutdownMetric(brokerNode.id(), brokerNode.rack());
    }

    private java.util.Map<String, String> brokerMetricTags(int brokerId) {
        return CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"broker-id"), (Object)Integer.toString(brokerId))}))).asJava();
    }

    public void removeExistingBroker(ControllerBrokerStateInfo brokerState) {
        try {
            brokerState.reconfigurableChannelBuilder().foreach((Function1 & Serializable)reconfigurable -> {
                this.config.removeReconfigurable(reconfigurable);
                return BoxedUnit.UNIT;
            });
            brokerState.requestSendThread().shutdown();
            brokerState.networkClient().close();
            brokerState.messageQueue().close();
            this.metricsGroup().removeMetric(ControllerChannelManager$.MODULE$.kafka$controller$ControllerChannelManager$$QueueSizeMetricName(), this.brokerMetricTags(brokerState.brokerNode().id()));
            this.metricsGroup().removeMetric(ControllerChannelManager$.MODULE$.kafka$controller$ControllerChannelManager$$RequestRateAndQueueTimeMetricName(), this.brokerMetricTags(brokerState.brokerNode().id()));
            this.brokerStateInfo().remove((Object)BoxesRunTime.boxToInteger((int)brokerState.brokerNode().id()));
            return;
        }
        catch (Throwable e) {
            this.error((Function0<String>)(Function0 & Serializable)() -> "Error while removing broker by the controller", (Function0<Throwable>)(Function0 & Serializable)() -> e);
            return;
        }
    }

    public void startRequestSendThread(int brokerId) {
        block7: {
            RequestSendThread requestThread;
            block6: {
                Thread.State state;
                Thread.State state2;
                block5: {
                    requestThread = ((ControllerBrokerStateInfo)this.brokerStateInfo().apply((Object)BoxesRunTime.boxToInteger((int)brokerId))).requestSendThread();
                    state2 = requestThread.getState();
                    state = Thread.State.NEW;
                    if (state2 != null) break block5;
                    if (state != null) {
                        return;
                    }
                    break block6;
                }
                if (!((Object)((Object)state2)).equals((Object)state)) break block7;
            }
            requestThread.start();
            return;
        }
    }

    public static final /* synthetic */ int $anonfun$new$2(ControllerBrokerStateInfo x$1) {
        return x$1.messageQueue().size();
    }

    public final /* synthetic */ int kafka$controller$ControllerChannelManager$$$anonfun$new$1() {
        Object object = this.brokerLock();
        synchronized (object) {
            int n = BoxesRunTime.unboxToInt((Object)this.brokerStateInfo().values().iterator().map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)ControllerChannelManager.$anonfun$new$2(x$1))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            return n;
        }
    }

    public static final /* synthetic */ void $anonfun$cleanUpUnhealthyBrokerMetrics$1(ControllerChannelManager $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            UnhealthyBroker unhealthyBroker = (UnhealthyBroker)x0$1._2();
            $this.metricsGroup().removeMetric(ControllerChannelManager$.MODULE$.kafka$controller$ControllerChannelManager$$UnhealthyBrokerShutdownMetricName(), CollectionConverters$.MODULE$.MapHasAsJava(unhealthyBroker.shutdownTag()).asJava());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ int kafka$controller$ControllerChannelManager$$$anonfun$addNewBroker$4(ControlMetadataAccumulator messageQueue$1) {
        return messageQueue$1.size();
    }

    public ControllerChannelManager(ControllerContext controllerContext, KafkaConfig config, Time time, Metrics metrics, StateChangeLogger stateChangeLogger, Option<String> threadNamePrefix) {
        this.controllerContext = controllerContext;
        this.config = config;
        this.time = time;
        this.metrics = metrics;
        this.stateChangeLogger = stateChangeLogger;
        this.threadNamePrefix = threadNamePrefix;
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.brokerStateInfo = new HashMap();
        this.brokerLock = new Object();
        this.logIdent_$eq(new StringBuilder(34).append("[Channel manager on controller ").append(config.brokerId()).append("]: ").toString());
        this.metricsGroup().newGauge("TotalQueueSize", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ ControllerChannelManager $outer;

            public final int value() {
                return this.$outer.kafka$controller$ControllerChannelManager$$$anonfun$new$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.unhealthyBrokerMap = ((scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)).withDefaultValue(null);
    }
}

