/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.PendingCompleteTxn;
import kafka.coordinator.transaction.PendingCompleteTxnAndMarkerEntry;
import kafka.coordinator.transaction.TransactionMarkerChannelManager$;
import kafka.coordinator.transaction.TransactionMarkerRequestCompletionHandler;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.coordinator.transaction.TxnMarkerQueue;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.server.KafkaConfig;
import kafka.server.MetadataCache;
import kafka.server.RequestLocal$;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.RequestCompletionHandler;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.requests.WriteTxnMarkersRequest;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.server.util.InterBrokerSendThread;
import org.apache.kafka.server.util.RequestAndCompletionHandler;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\t]v!\u0002\u00192\u0011\u0003Ad!\u0002\u001e2\u0011\u0003Y\u0004\"\u0002\"\u0002\t\u0003\u0019\u0005b\u0002#\u0002\u0005\u0004%I!\u0012\u0005\u0007\u001d\u0006\u0001\u000b\u0011\u0002$\t\u000f=\u000b!\u0019!C\u0005\u000b\"1\u0001+\u0001Q\u0001\n\u0019C\u0001\"U\u0001C\u0002\u0013\u0005\u0011G\u0015\u0005\u00077\u0006\u0001\u000b\u0011B*\t\u000bq\u000bA\u0011A/\u0007\ti\n\u0004a\u0018\u0005\tg*\u0011\t\u0011)A\u0005i\"A\u0011P\u0003B\u0001B\u0003%!\u0010\u0003\u0005~\u0015\t\u0005\t\u0015!\u0003\u007f\u0011)\tIA\u0003B\u0001B\u0003%\u00111\u0002\u0005\u000b\u0003#Q!\u0011!Q\u0001\n\u0005M\u0001B\u0002\"\u000b\t\u0003\t\t\u0003C\u0005\u0002.)\u0011\r\u0011\"\u0003\u00020!A\u0011Q\b\u0006!\u0002\u0013\t\t\u0004C\u0005\u0002@)\u0011\r\u0011\"\u0003\u0002B!A\u0011q\n\u0006!\u0002\u0013\t\u0019\u0005C\u0005\u0002R)\u0011\r\u0011\"\u0003\u0002T!A\u0011Q\u000e\u0006!\u0002\u0013\t)\u0006C\u0005\u0002p)\u0011\r\u0011\"\u0003\u0002r!A\u00111\u000f\u0006!\u0002\u0013\t9\u0007C\u0005\u0002v)\u0011\r\u0011\"\u0003\u0002x!A\u00111\u0012\u0006!\u0002\u0013\tI\bC\u0005\u0002\u000e*\u0011\r\u0011\"\u0003\u0002\u0010\"A\u00111\u0016\u0006!\u0002\u0013\t\t\nC\u0005\u0002.*\u0011\r\u0011\"\u0003\u00020\"A\u0011q\u0017\u0006!\u0002\u0013\t\t\fC\u0004\u0002:*!\t%a/\t\u000f\u0005\r'\u0002\"\u0003\u0002<\"A\u0011Q\u0019\u0006\u0005\u0002E\n9\r\u0003\u0005\u0002T*!\t!MA9\u0011!\t)N\u0003C\u0001c\u0005]\u0007bBAz\u0015\u0011%\u00111\u0018\u0005\b\u0003kTA\u0011IA|\u0011\u001d\u00119A\u0003C\u0005\u0005\u0013AqAa\u0004\u000b\t\u0003\u0011\t\u0002C\u0004\u0003<)!\tA!\u0010\t\u000f\t}\"\u0002\"\u0003\u0003B!9!1\n\u0006\u0005\u0002\t5\u0003b\u0002B*\u0015\u0011%!Q\u000b\u0005\b\u00057RA\u0011\u0001B/\u0011\u001d\u0011yH\u0003C\u0001\u0005\u0003CqAa\"\u000b\t\u0003\u0011I\t\u0003\u0007\u0003\u000e*\u0001\n\u0011!A\u0001\n\u0003\u0011y)A\u0010Ue\u0006t7/Y2uS>tW*\u0019:lKJ\u001c\u0005.\u00198oK2l\u0015M\\1hKJT!AM\u001a\u0002\u0017Q\u0014\u0018M\\:bGRLwN\u001c\u0006\u0003iU\n1bY8pe\u0012Lg.\u0019;pe*\ta'A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u0005e\nQ\"A\u0019\u0003?Q\u0013\u0018M\\:bGRLwN\\'be.,'o\u00115b]:,G.T1oC\u001e,'o\u0005\u0002\u0002yA\u0011Q\bQ\u0007\u0002})\tq(A\u0003tG\u0006d\u0017-\u0003\u0002B}\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u001d\u0002KUs7N\\8x]\u0012+7\u000f^5oCRLwN\\)vKV,7+\u001b>f\u001b\u0016$(/[2OC6,W#\u0001$\u0011\u0005\u001dcU\"\u0001%\u000b\u0005%S\u0015\u0001\u00027b]\u001eT\u0011aS\u0001\u0005U\u00064\u0018-\u0003\u0002N\u0011\n11\u000b\u001e:j]\u001e\fa%\u00168l]><h\u000eR3ti&t\u0017\r^5p]F+X-^3TSj,W*\u001a;sS\u000et\u0015-\\3!\u0003\u0005bunZ!qa\u0016tGMU3uef\fV/Z;f'&TX-T3ue&\u001cg*Y7f\u0003\tbunZ!qa\u0016tGMU3uef\fV/Z;f'&TX-T3ue&\u001cg*Y7fA\u0005YQ*\u001a;sS\u000et\u0015-\\3t+\u0005\u0019\u0006c\u0001+Z\r6\tQK\u0003\u0002W/\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u00031z\n!bY8mY\u0016\u001cG/[8o\u0013\tQVKA\u0002TKR\fA\"T3ue&\u001cg*Y7fg\u0002\nQ!\u00199qYf$RB\u0018BM\u00057\u00139K!+\u0003,\n5\u0006CA\u001d\u000b'\rQ\u0001-\u001c\t\u0003C.l\u0011A\u0019\u0006\u0003G\u0012\fA!\u001e;jY*\u0011QMZ\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005Y:'B\u00015j\u0003\u0019\t\u0007/Y2iK*\t!.A\u0002pe\u001eL!\u0001\u001c2\u0003+%sG/\u001a:Ce>\\WM]*f]\u0012$\u0006N]3bIB\u0011a.]\u0007\u0002_*\u0011\u0001/N\u0001\u0006kRLGn]\u0005\u0003e>\u0014q\u0001T8hO&tw-\u0001\u0004d_:4\u0017n\u001a\t\u0003k^l\u0011A\u001e\u0006\u0003KVJ!\u0001\u001f<\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u000e[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0011\u0005U\\\u0018B\u0001?w\u00055iU\r^1eCR\f7)Y2iK\u0006ia.\u001a;x_J\\7\t\\5f]R\u00042a`A\u0003\u001b\t\t\tAC\u0002\u0002\u0004\u0019\fqa\u00197jK:$8/\u0003\u0003\u0002\b\u0005\u0005!!\u0004(fi^|'o[\"mS\u0016tG/A\buq:\u001cF/\u0019;f\u001b\u0006t\u0017mZ3s!\rI\u0014QB\u0005\u0004\u0003\u001f\t$a\u0006+sC:\u001c\u0018m\u0019;j_:\u001cF/\u0019;f\u001b\u0006t\u0017mZ3s\u0003\u0011!\u0018.\\3\u0011\t\u0005U\u0011QD\u0007\u0003\u0003/Q1\u0001]A\r\u0015\r\tYBZ\u0001\u0007G>lWn\u001c8\n\t\u0005}\u0011q\u0003\u0002\u0005)&lW\rF\u0006_\u0003G\t)#a\n\u0002*\u0005-\u0002\"B:\u0011\u0001\u0004!\b\"B=\u0011\u0001\u0004Q\b\"B?\u0011\u0001\u0004q\bbBA\u0005!\u0001\u0007\u00111\u0002\u0005\b\u0003#\u0001\u0002\u0019AA\n\u00031iW\r\u001e:jGN<%o\\;q+\t\t\t\u0004\u0005\u0003\u00024\u0005eRBAA\u001b\u0015\r\t9\u0004Z\u0001\b[\u0016$(/[2t\u0013\u0011\tY$!\u000e\u0003#-\u000bgm[1NKR\u0014\u0018nY:He>,\b/A\u0007nKR\u0014\u0018nY:He>,\b\u000fI\u0001\u0018S:$XM\u001d\"s_.,'\u000fT5ti\u0016tWM\u001d(b[\u0016,\"!a\u0011\u0011\t\u0005\u0015\u00131J\u0007\u0003\u0003\u000fRA!!\u0013\u0002\u001a\u00059a.\u001a;x_J\\\u0017\u0002BA'\u0003\u000f\u0012A\u0002T5ti\u0016tWM\u001d(b[\u0016\f\u0001$\u001b8uKJ\u0014%o\\6fe2K7\u000f^3oKJt\u0015-\\3!\u0003Ui\u0017M]6feN\fV/Z;f!\u0016\u0014(I]8lKJ,\"!!\u0016\u0011\u0011\u0005]\u0013QLA1\u0003Oj!!!\u0017\u000b\u0007\u0005ms+\u0001\u0006d_:\u001cWO\u001d:f]RLA!a\u0018\u0002Z\t\u0019Q*\u00199\u0011\u0007u\n\u0019'C\u0002\u0002fy\u00121!\u00138u!\rI\u0014\u0011N\u0005\u0004\u0003W\n$A\u0004+y]6\u000b'o[3s#V,W/Z\u0001\u0017[\u0006\u00148.\u001a:t#V,W/\u001a)fe\n\u0013xn[3sA\u0005aR.\u0019:lKJ\u001c\u0018+^3vK\u001a{'/\u00168l]><hN\u0011:pW\u0016\u0014XCAA4\u0003ui\u0017M]6feN\fV/Z;f\r>\u0014XK\\6o_^t'I]8lKJ\u0004\u0013A\u0006;y]2{w-\u00119qK:$'+\u001a;ssF+X-^3\u0016\u0005\u0005e\u0004CBA>\u0003\u0003\u000b))\u0004\u0002\u0002~)!\u00111LA@\u0015\t\u0019'*\u0003\u0003\u0002\u0004\u0006u$a\u0005'j].,GM\u00117pG.LgnZ)vKV,\u0007cA\u001d\u0002\b&\u0019\u0011\u0011R\u0019\u0003%A+g\u000eZ5oO\u000e{W\u000e\u001d7fi\u0016$\u0006P\\\u0001\u0018ibtGj\\4BaB,g\u000e\u001a*fiJL\u0018+^3vK\u0002\na\u0004\u001e:b]N\f7\r^5p]N<\u0016\u000e\u001e5QK:$\u0017N\\4NCJ\\WM]:\u0016\u0005\u0005E\u0005\u0003CA>\u0003'\u000b9*!\"\n\t\u0005U\u0015Q\u0010\u0002\u0012\u0007>t7-\u001e:sK:$\b*Y:i\u001b\u0006\u0004\b\u0003BAM\u0003OsA!a'\u0002$B\u0019\u0011Q\u0014 \u000e\u0005\u0005}%bAAQo\u00051AH]8pizJ1!!*?\u0003\u0019\u0001&/\u001a3fM&\u0019Q*!+\u000b\u0007\u0005\u0015f(A\u0010ue\u0006t7/Y2uS>t7oV5uQB+g\u000eZ5oO6\u000b'o[3sg\u0002\nQd\u001e:ji\u0016$\u0006P\\'be.,'o\u001d*fcV,7\u000f\u001e,feNLwN\\\u000b\u0003\u0003c\u00032!PAZ\u0013\r\t)L\u0010\u0002\u0006'\"|'\u000f^\u0001\u001foJLG/\u001a+y]6\u000b'o[3sgJ+\u0017/^3tiZ+'o]5p]\u0002\n\u0001b\u001d5vi\u0012|wO\u001c\u000b\u0003\u0003{\u00032!PA`\u0013\r\t\tM\u0010\u0002\u0005+:LG/A\u0007sK6|g/Z'fiJL7m]\u0001\u000fcV,W/\u001a$pe\n\u0013xn[3s)\u0011\tI-a4\u0011\u000bu\nY-a\u001a\n\u0007\u00055gH\u0001\u0004PaRLwN\u001c\u0005\b\u0003#\f\u0003\u0019AA1\u0003!\u0011'o\\6fe&#\u0017!F9vKV,gi\u001c:V].twn\u001e8Ce>\\WM]\u0001\u0014C\u0012$W*\u0019:lKJ\u001chi\u001c:Ce>\\WM\u001d\u000b\t\u0003{\u000bI.!:\u0002j\"9\u00111\\\u0012A\u0002\u0005u\u0017A\u00022s_.,'\u000f\u0005\u0003\u0002`\u0006\u0005XBAA\r\u0013\u0011\t\u0019/!\u0007\u0003\t9{G-\u001a\u0005\b\u0003O\u001c\u0003\u0019AA1\u0003E!\bP\u001c+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\b\u0003W\u001c\u0003\u0019AAw\u0003m\u0001XM\u001c3j]\u001e\u001cu.\u001c9mKR,G\u000b\u001f8B]\u0012l\u0015M]6feB\u0019\u0011(a<\n\u0007\u0005E\u0018G\u0001\u0011QK:$\u0017N\\4D_6\u0004H.\u001a;f)bt\u0017I\u001c3NCJ\\WM]#oiJL\u0018a\u0004:fiJLHj\\4BaB,g\u000eZ:\u0002!\u001d,g.\u001a:bi\u0016\u0014V-];fgR\u001cHCAA}!\u0019\tY0!@\u0003\u00025\u0011\u0011qP\u0005\u0005\u0003\u007f\fyH\u0001\u0006D_2dWm\u0019;j_:\u00042!\u0019B\u0002\u0013\r\u0011)A\u0019\u0002\u001c%\u0016\fX/Z:u\u0003:$7i\\7qY\u0016$\u0018n\u001c8IC:$G.\u001a:\u0002%]\u0014\u0018\u000e^3Uq:\u001cu.\u001c9mKRLwN\u001c\u000b\u0005\u0003{\u0013Y\u0001C\u0004\u0003\u000e\u0019\u0002\r!!\"\u0002%A,g\u000eZ5oO\u000e{W\u000e\u001d7fi\u0016$\u0006P\\\u0001\u0014C\u0012$G\u000b\u001f8NCJ\\WM]:U_N+g\u000e\u001a\u000b\u000b\u0003{\u0013\u0019Ba\u0006\u0003(\tE\u0002b\u0002B\u000bO\u0001\u0007\u0011\u0011M\u0001\u0011G>|'\u000fZ5oCR|'/\u00129pG\"DqA!\u0007(\u0001\u0004\u0011Y\"A\u0005uq:\u0014Vm];miB!!Q\u0004B\u0012\u001b\t\u0011yB\u0003\u0003\u0003\"\u0005e\u0011\u0001\u0003:fcV,7\u000f^:\n\t\t\u0015\"q\u0004\u0002\u0012)J\fgn]1di&|gNU3tk2$\bb\u0002B\u0015O\u0001\u0007!1F\u0001\fibtW*\u001a;bI\u0006$\u0018\rE\u0002:\u0005[I1Aa\f2\u0005M!&/\u00198tC\u000e$\u0018n\u001c8NKR\fG-\u0019;b\u0011\u001d\u0011\u0019d\na\u0001\u0005k\t1B\\3x\u001b\u0016$\u0018\rZ1uCB\u0019\u0011Ha\u000e\n\u0007\te\u0012G\u0001\nUq:$&/\u00198tSRlU\r^1eCR\f\u0017!\u00078v[RChn],ji\"\u0004VM\u001c3j]\u001el\u0015M]6feN,\"!!\u0019\u00021!\f7\u000fU3oI&tw-T1sW\u0016\u00148\u000fV8Xe&$X\r\u0006\u0003\u0003D\t%\u0003cA\u001f\u0003F%\u0019!q\t \u0003\u000f\t{w\u000e\\3b]\"9!\u0011F\u0015A\u0002\t-\u0012aF7bs\n,wK]5uKRChnQ8na2,G/[8o)\u0011\tiLa\u0014\t\u000f\tE#\u00061\u0001\u0002\u0018\u0006yAO]1og\u0006\u001cG/[8oC2LE-\u0001\buef\f\u0005\u000f]3oIR{Gj\\4\u0015\t\u0005u&q\u000b\u0005\b\u00053Z\u0003\u0019AAC\u00031!\bP\u001c'pO\u0006\u0003\b/\u001a8e\u0003i\tG\r\u001a+y]6\u000b'o[3sgR{'I]8lKJ\fV/Z;f)1\tiLa\u0018\u0003j\t5$\u0011\u000fB:\u0011\u001d\u0011\t\u0007\fa\u0001\u0005G\n!\u0002\u001d:pIV\u001cWM]%e!\ri$QM\u0005\u0004\u0005Or$\u0001\u0002'p]\u001eDqAa\u001b-\u0001\u0004\t\t,A\u0007qe>$WoY3s\u000bB|7\r\u001b\u0005\b\u0005_b\u0003\u0019\u0001B\u000e\u0003\u0019\u0011Xm];mi\"9!Q\u0002\u0017A\u0002\u0005\u0015\u0005b\u0002B;Y\u0001\u0007!qO\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8ogB!A+\u0017B=!\u0011\tyNa\u001f\n\t\tu\u0014\u0011\u0004\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003\u0005\u0012X-\\8wK6\u000b'o[3sg\u001a{'\u000f\u0016=o)>\u0004\u0018n\u0019)beRLG/[8o)\u0011\tiLa!\t\u000f\t\u0015U\u00061\u0001\u0002b\u0005\u0019B\u000f\u001f8U_BL7\rU1si&$\u0018n\u001c8JI\u0006\u0019\"/Z7pm\u0016l\u0015M]6feN4uN\u001d+y]R!\u0011Q\u0018BF\u0011\u001d\u0011iA\fa\u0001\u0003\u000b\u000bQ\u0004\u001d:pi\u0016\u001cG/\u001a3%Q\u0006\u001c\u0018J\u001c$mS\u001eDGOU3rk\u0016\u001cHo\u001d\u000b\u0005\u0005#\u00139\n\u0006\u0003\u0003D\tM\u0005\"\u0003BK_\u0005\u0005\t\u0019AAo\u0003\rAH%\r\u0005\t\u0005+{\u0013\u0011!a\u0001=\")1/\u0003a\u0001i\"9\u0011qG\u0005A\u0002\tu\u0005\u0003\u0002BP\u0005Gk!A!)\u000b\t\u0005]\u0012\u0011D\u0005\u0005\u0005K\u0013\tKA\u0004NKR\u0014\u0018nY:\t\u000beL\u0001\u0019\u0001>\t\u000f\u0005%\u0011\u00021\u0001\u0002\f!9\u0011\u0011C\u0005A\u0002\u0005M\u0001b\u0002BX\u0013\u0001\u0007!\u0011W\u0001\u000bY><7i\u001c8uKb$\b\u0003BA\u000b\u0005gKAA!.\u0002\u0018\tQAj\\4D_:$X\r\u001f;")
public class TransactionMarkerChannelManager
extends InterBrokerSendThread
implements Logging {
    private final MetadataCache metadataCache;
    private final TransactionStateManager txnStateManager;
    private final Time time;
    private final KafkaMetricsGroup metricsGroup;
    private final ListenerName interBrokerListenerName;
    private final scala.collection.concurrent.Map<Object, TxnMarkerQueue> markersQueuePerBroker;
    private final TxnMarkerQueue markersQueueForUnknownBroker;
    private final LinkedBlockingQueue<PendingCompleteTxn> txnLogAppendRetryQueue;
    private final ConcurrentHashMap<String, PendingCompleteTxn> transactionsWithPendingMarkers;
    private final short writeTxnMarkersRequestVersion;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static TransactionMarkerChannelManager apply(KafkaConfig config, Metrics metrics, MetadataCache metadataCache, TransactionStateManager txnStateManager, Time time, LogContext logContext) {
        return TransactionMarkerChannelManager$.MODULE$.apply(config, metrics, metadataCache, txnStateManager, time, logContext);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public /* synthetic */ boolean protected$hasInFlightRequests(TransactionMarkerChannelManager x$1, Node x$12) {
        return x$1.hasInFlightRequests(x$12);
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    private ListenerName interBrokerListenerName() {
        return this.interBrokerListenerName;
    }

    private scala.collection.concurrent.Map<Object, TxnMarkerQueue> markersQueuePerBroker() {
        return this.markersQueuePerBroker;
    }

    private TxnMarkerQueue markersQueueForUnknownBroker() {
        return this.markersQueueForUnknownBroker;
    }

    private LinkedBlockingQueue<PendingCompleteTxn> txnLogAppendRetryQueue() {
        return this.txnLogAppendRetryQueue;
    }

    private ConcurrentHashMap<String, PendingCompleteTxn> transactionsWithPendingMarkers() {
        return this.transactionsWithPendingMarkers;
    }

    private short writeTxnMarkersRequestVersion() {
        return this.writeTxnMarkersRequestVersion;
    }

    public void shutdown() {
        try {
            super.shutdown();
            this.markersQueuePerBroker().clear();
        }
        finally {
            this.removeMetrics();
        }
    }

    private void removeMetrics() {
        TransactionMarkerChannelManager$.MODULE$.MetricNames().foreach((Function1 & Serializable)x$1 -> {
            TransactionMarkerChannelManager.$anonfun$removeMetrics$1(this, x$1);
            return BoxedUnit.UNIT;
        });
    }

    public Option<TxnMarkerQueue> queueForBroker(int brokerId) {
        return this.markersQueuePerBroker().get((Object)BoxesRunTime.boxToInteger((int)brokerId));
    }

    public TxnMarkerQueue queueForUnknownBroker() {
        return this.markersQueueForUnknownBroker();
    }

    /*
     * WARNING - void declaration
     */
    public void addMarkersForBroker(Node broker, int txnTopicPartition, PendingCompleteTxnAndMarkerEntry pendingCompleteTxnAndMarker) {
        Object object;
        void atomicGetOrUpdate_key;
        int brokerId = broker.id();
        Integer n = BoxesRunTime.boxToInteger((int)brokerId);
        scala.collection.concurrent.Map<Object, TxnMarkerQueue> atomicGetOrUpdate_map = this.markersQueuePerBroker();
        Option option = atomicGetOrUpdate_map.get((Object)atomicGetOrUpdate_key);
        if (option instanceof Some) {
            object = ((Some)option).value();
        } else if (None$.MODULE$.equals(option)) {
            TxnMarkerQueue atomicGetOrUpdate_value = TransactionMarkerChannelManager.$anonfun$addMarkersForBroker$1(this, brokerId, broker);
            object = atomicGetOrUpdate_map.putIfAbsent((Object)atomicGetOrUpdate_key, (Object)atomicGetOrUpdate_value).getOrElse(() -> CoreUtils$.$anonfun$atomicGetOrUpdate$1(atomicGetOrUpdate_value));
        } else {
            throw new MatchError((Object)option);
        }
        Object var6_6 = null;
        n = null;
        option = null;
        Object var9_8 = null;
        TxnMarkerQueue brokerRequestQueue = (TxnMarkerQueue)object;
        brokerRequestQueue.destination_$eq(broker);
        brokerRequestQueue.addMarkers(txnTopicPartition, pendingCompleteTxnAndMarker);
        this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(58).append("Added marker ").append(pendingCompleteTxnAndMarker.txnMarkerEntry()).append(" for transactional id").append(" ").append(pendingCompleteTxnAndMarker.pendingCompleteTxn().transactionalId()).append(" to destination broker ").append(brokerId).toString());
    }

    private void retryLogAppends() {
        ArrayList txnLogAppendRetries = new ArrayList();
        this.txnLogAppendRetryQueue().drainTo(txnLogAppendRetries);
        txnLogAppendRetries.forEach(txnLogAppend -> {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(32).append("Retry appending ").append(txnLogAppend).append(" transaction log").toString());
            this.tryAppendToLog((PendingCompleteTxn)txnLogAppend);
        });
    }

    public Collection<RequestAndCompletionHandler> generateRequests() {
        this.retryLogAppends();
        ArrayList pendingCompleteTxnAndMarkerEntries = new ArrayList();
        this.markersQueueForUnknownBroker().forEachTxnTopicPartition((Function2 & Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToInteger((int)x1$1.drainTo(pendingCompleteTxnAndMarkerEntries)));
        CollectionConverters$.MODULE$.ListHasAsScala(pendingCompleteTxnAndMarkerEntries).asScala().withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)TransactionMarkerChannelManager.$anonfun$generateRequests$2(check$ifrefutable$1))).foreach((Function1 & Serializable)pendingCompleteTxnAndMarker -> {
            TransactionMarkerChannelManager.$anonfun$generateRequests$3(this, pendingCompleteTxnAndMarker);
            return BoxedUnit.UNIT;
        });
        long currentTimeMs = this.time.milliseconds();
        return CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)((IterableOps)((IterableOps)((IterableOps)this.markersQueuePerBroker().values().filter((Function1 & Serializable)brokerRequestQueue -> BoxesRunTime.boxToBoolean((boolean)TransactionMarkerChannelManager.$anonfun$generateRequests$4(this, brokerRequestQueue)))).map((Function1 & Serializable)brokerRequestQueue -> {
            ArrayList pendingCompleteTxnAndMarkerEntries = new ArrayList();
            brokerRequestQueue.forEachTxnTopicPartition((Function2 & Serializable)(x0$2, x1$2) -> BoxesRunTime.boxToInteger((int)x1$2.drainTo(pendingCompleteTxnAndMarkerEntries)));
            return new Tuple2((Object)brokerRequestQueue.destination(), pendingCompleteTxnAndMarkerEntries);
        })).filter((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)TransactionMarkerChannelManager.$anonfun$generateRequests$7(x0$3)))).map((Function1 & Serializable)x0$4 -> {
            if (x0$4 != null) {
                Node node = (Node)x0$4._1();
                ArrayList entries = (ArrayList)x0$4._2();
                List markersToSend = CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala((List)entries).asScala().map((Function1 & Serializable)x$4 -> x$4.txnMarkerEntry())).asJava();
                TransactionMarkerRequestCompletionHandler requestCompletionHandler = new TransactionMarkerRequestCompletionHandler(node.id(), $this.txnStateManager, this, entries);
                WriteTxnMarkersRequest.Builder request = new WriteTxnMarkersRequest.Builder(this.writeTxnMarkersRequestVersion(), markersToSend);
                return new RequestAndCompletionHandler(currentTimeMs, node, (AbstractRequest.Builder)request, (RequestCompletionHandler)requestCompletionHandler);
            }
            throw new MatchError(null);
        })).asJavaCollection();
    }

    private void writeTxnCompletion(PendingCompleteTxn pendingCompleteTxn) {
        Option option;
        Errors errors;
        String transactionalId = pendingCompleteTxn.transactionalId();
        TransactionMetadata txnMetadata = pendingCompleteTxn.txnMetadata();
        TxnTransitMetadata newMetadata = pendingCompleteTxn.newMetadata();
        int coordinatorEpoch = pendingCompleteTxn.coordinatorEpoch();
        this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(64).append("Completed sending transaction markers for ").append(transactionalId).append("; begin transition ").append("to ").append(newMetadata.txnState()).toString());
        boolean bl = false;
        Left left = null;
        boolean bl2 = false;
        Right right = null;
        Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> either = this.txnStateManager.getTransactionState(transactionalId);
        if (either instanceof Left) {
            bl = true;
            left = (Left)either;
            Errors errors2 = (Errors)left.value();
            if (Errors.NOT_COORDINATOR.equals(errors2)) {
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(92).append("No longer the coordinator for ").append(transactionalId).append(" with coordinator epoch ").append(coordinatorEpoch).append("; cancel appending ").append(newMetadata).append(" to transaction log").toString());
                return;
            }
        }
        if (bl && Errors.COORDINATOR_LOAD_IN_PROGRESS.equals(errors = (Errors)left.value())) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(187).append("Loading the transaction partition that contains ").append(transactionalId).append(" while my ").append("current coordinator epoch is ").append(coordinatorEpoch).append("; so cancel appending ").append(newMetadata).append(" to ").append("transaction log since the loading process will continue the remaining work").toString());
            return;
        }
        if (bl) {
            Errors unexpectedError = (Errors)left.value();
            throw new IllegalStateException(new StringBuilder(56).append("Unhandled error ").append(unexpectedError).append(" when fetching current transaction state").toString());
        }
        if (either instanceof Right) {
            bl2 = true;
            right = (Right)either;
            Option option2 = (Option)right.value();
            if (option2 instanceof Some) {
                CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)option2).value();
                if (epochAndMetadata.coordinatorEpoch() == coordinatorEpoch) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(116).append("Sending ").append(transactionalId).append("'s transaction markers for ").append(txnMetadata).append(" with ").append("coordinator epoch ").append(coordinatorEpoch).append(" succeeded, trying to append complete transaction log now").toString());
                    this.tryAppendToLog(new PendingCompleteTxn(transactionalId, coordinatorEpoch, txnMetadata, newMetadata));
                    return;
                }
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(178).append("The cached metadata ").append(txnMetadata).append(" has changed to ").append(epochAndMetadata).append(" after ").append("completed sending the markers with coordinator epoch ").append(coordinatorEpoch).append("; abort ").append("transiting the metadata to ").append(newMetadata).append(" as it may have been updated by another process").toString());
                return;
            }
        }
        if (bl2 && None$.MODULE$.equals(option = (Option)right.value())) {
            String errorMsg = new StringBuilder(118).append("The coordinator still owns the transaction partition for ").append(transactionalId).append(", ").append("but there is no metadata in the cache; this is not expected").toString();
            this.fatal((Function0<String>)(Function0 & Serializable)() -> errorMsg);
            throw new IllegalStateException(errorMsg);
        }
        throw new MatchError(either);
    }

    public void addTxnMarkersToSend(int coordinatorEpoch, TransactionResult txnResult, TransactionMetadata txnMetadata, TxnTransitMetadata newMetadata) {
        String transactionalId = txnMetadata.transactionalId();
        PendingCompleteTxn pendingCompleteTxn = new PendingCompleteTxn(transactionalId, coordinatorEpoch, txnMetadata, newMetadata);
        PendingCompleteTxn prev = this.transactionsWithPendingMarkers().put(transactionalId, pendingCompleteTxn);
        if (prev != null) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(78).append("Replaced an existing pending complete txn ").append(prev).append(" with ").append(pendingCompleteTxn).append(" while adding markers to send.").toString());
        }
        this.addTxnMarkersToBrokerQueue(txnMetadata.producerId(), txnMetadata.producerEpoch(), txnResult, pendingCompleteTxn, (Set<TopicPartition>)txnMetadata.topicPartitions().toSet());
        this.maybeWriteTxnCompletion(transactionalId);
    }

    public int numTxnsWithPendingMarkers() {
        return this.transactionsWithPendingMarkers().size();
    }

    private boolean hasPendingMarkersToWrite(TransactionMetadata txnMetadata) {
        return BoxesRunTime.unboxToBoolean(txnMetadata.inLock((JFunction0.mcZ.sp & Serializable)() -> txnMetadata.topicPartitions().nonEmpty()));
    }

    public void maybeWriteTxnCompletion(String transactionalId) {
        Option$.MODULE$.apply((Object)this.transactionsWithPendingMarkers().get(transactionalId)).foreach((Function1 & Serializable)pendingCompleteTxn -> {
            TransactionMarkerChannelManager.$anonfun$maybeWriteTxnCompletion$1(this, transactionalId, pendingCompleteTxn);
            return BoxedUnit.UNIT;
        });
    }

    private void tryAppendToLog(PendingCompleteTxn txnLogAppend) {
        this.txnStateManager.appendTransactionToLog(txnLogAppend.transactionalId(), txnLogAppend.coordinatorEpoch(), txnLogAppend.newMetadata(), (Function1<Errors, BoxedUnit>)(Function1 & Serializable)error -> {
            this.appendCallback$1(error, txnLogAppend);
            return BoxedUnit.UNIT;
        }, (Function1<Errors, Object>)(Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)TransactionMarkerChannelManager.$anonfun$tryAppendToLog$7(x$5)), RequestLocal$.MODULE$.NoCaching());
    }

    public void addTxnMarkersToBrokerQueue(long producerId, short producerEpoch, TransactionResult result, PendingCompleteTxn pendingCompleteTxn, Set<TopicPartition> topicPartitions) {
        int txnTopicPartition = this.txnStateManager.partitionFor(pendingCompleteTxn.transactionalId());
        Map partitionsByDestination = topicPartitions.groupBy((Function1 & Serializable)topicPartition -> $this.metadataCache.getPartitionLeaderEndpoint(topicPartition.topic(), topicPartition.partition(), this.interBrokerListenerName()));
        int coordinatorEpoch = pendingCompleteTxn.coordinatorEpoch();
        partitionsByDestination.withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)TransactionMarkerChannelManager.$anonfun$addTxnMarkersToBrokerQueue$2(check$ifrefutable$2))).foreach((Function1 & Serializable)x$6 -> {
            if (x$6 != null) {
                Option broker = (Option)x$6._1();
                Set topicPartitions = (Set)x$6._2();
                if (broker != null && topicPartitions != null) {
                    if (broker instanceof Some) {
                        Node brokerNode = (Node)((Some)broker).value();
                        WriteTxnMarkersRequest.TxnMarkerEntry marker = new WriteTxnMarkersRequest.TxnMarkerEntry(producerId, producerEpoch, coordinatorEpoch, result, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)topicPartitions.toList()).asJava());
                        PendingCompleteTxnAndMarkerEntry pendingCompleteTxnAndMarker = new PendingCompleteTxnAndMarkerEntry(pendingCompleteTxn, marker);
                        Node node = brokerNode;
                        Node node2 = Node.noNode();
                        if (!(node != null ? !node.equals(node2) : node2 != null)) {
                            this.markersQueueForUnknownBroker().addMarkers(txnTopicPartition, pendingCompleteTxnAndMarker);
                            return BoxedUnit.UNIT;
                        }
                        this.addMarkersForBroker(brokerNode, txnTopicPartition, pendingCompleteTxnAndMarker);
                        return BoxedUnit.UNIT;
                    }
                    if (None$.MODULE$.equals(broker)) {
                        Option option;
                        String transactionalId = pendingCompleteTxn.transactionalId();
                        boolean bl = false;
                        Right right = null;
                        Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> either = $this.txnStateManager.getTransactionState(transactionalId);
                        if (either instanceof Left) {
                            Errors error = (Errors)((Left)either).value();
                            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(127).append("Encountered ").append(error).append(" trying to fetch transaction metadata for ").append(transactionalId).append(" with coordinator epoch ").append(coordinatorEpoch).append("; cancel sending markers to its partition leaders").toString());
                            return BoxesRunTime.boxToBoolean((boolean)this.transactionsWithPendingMarkers().remove(transactionalId, pendingCompleteTxn));
                        }
                        if (either instanceof Right) {
                            bl = true;
                            right = (Right)either;
                            Option option2 = (Option)right.value();
                            if (option2 instanceof Some) {
                                CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)option2).value();
                                if (epochAndMetadata.coordinatorEpoch() != coordinatorEpoch) {
                                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(144).append("The cached metadata has changed to ").append(epochAndMetadata).append(" (old coordinator epoch is ").append(coordinatorEpoch).append(") since preparing to send markers; cancel sending markers to its partition leaders").toString());
                                    return BoxesRunTime.boxToBoolean((boolean)this.transactionsWithPendingMarkers().remove(transactionalId, pendingCompleteTxn));
                                }
                                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(161).append("Couldn't find leader endpoint for partitions ").append(topicPartitions).append(" while trying to send transaction markers for ").append(transactionalId).append(", these partitions are likely deleted already and hence can be skipped").toString());
                                TransactionMetadata txnMetadata = epochAndMetadata.transactionMetadata();
                                txnMetadata.inLock((JFunction0.mcV.sp & Serializable)() -> topicPartitions.foreach((Function1 & Serializable)topicPartition -> {
                                    txnMetadata.removePartition(topicPartition);
                                    return BoxedUnit.UNIT;
                                }));
                                this.maybeWriteTxnCompletion(transactionalId);
                                return BoxedUnit.UNIT;
                            }
                        }
                        if (bl && None$.MODULE$.equals(option = (Option)right.value())) {
                            String errorMsg = new StringBuilder(118).append("The coordinator still owns the transaction partition for ").append(transactionalId).append(", but there is ").append("no metadata in the cache; this is not expected").toString();
                            this.fatal((Function0<String>)(Function0 & Serializable)() -> errorMsg);
                            throw new IllegalStateException(errorMsg);
                        }
                        throw new MatchError(either);
                    }
                    throw new MatchError((Object)broker);
                }
            }
            throw new MatchError(x$6);
        });
        this.wakeup();
    }

    public void removeMarkersForTxnTopicPartition(int txnTopicPartitionId) {
        this.markersQueueForUnknownBroker().removeMarkersForTxnTopicPartition(txnTopicPartitionId).foreach((Function1 & Serializable)queue -> {
            TransactionMarkerChannelManager.$anonfun$removeMarkersForTxnTopicPartition$1(this, txnTopicPartitionId, queue);
            return BoxedUnit.UNIT;
        });
        this.markersQueuePerBroker().foreach((Function1 & Serializable)x0$1 -> {
            TransactionMarkerChannelManager.$anonfun$removeMarkersForTxnTopicPartition$4(this, txnTopicPartitionId, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public void removeMarkersForTxn(PendingCompleteTxn pendingCompleteTxn) {
        String transactionalId = pendingCompleteTxn.transactionalId();
        if (!this.transactionsWithPendingMarkers().remove(transactionalId, pendingCompleteTxn)) {
            PendingCompleteTxn current = this.transactionsWithPendingMarkers().get(transactionalId);
            if (current != null) {
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(56).append("Failed to remove pending marker entry ").append(current).append(" trying to remove ").append(pendingCompleteTxn).toString());
                return;
            }
            return;
        }
    }

    public final /* synthetic */ int kafka$coordinator$transaction$TransactionMarkerChannelManager$$$anonfun$new$1() {
        return this.markersQueueForUnknownBroker().totalNumMarkers();
    }

    public final /* synthetic */ int kafka$coordinator$transaction$TransactionMarkerChannelManager$$$anonfun$new$2() {
        return this.txnLogAppendRetryQueue().size();
    }

    public static final /* synthetic */ void $anonfun$removeMetrics$1(TransactionMarkerChannelManager $this, String x$1) {
        $this.metricsGroup().removeMetric(x$1);
    }

    public static final /* synthetic */ TxnMarkerQueue $anonfun$addMarkersForBroker$1(TransactionMarkerChannelManager $this, int brokerId$1, Node broker$1) {
        $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(52).append("Creating new marker queue map to destination broker ").append(brokerId$1).toString());
        return new TxnMarkerQueue(broker$1);
    }

    public static final /* synthetic */ boolean $anonfun$generateRequests$2(PendingCompleteTxnAndMarkerEntry check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ void $anonfun$generateRequests$3(TransactionMarkerChannelManager $this, PendingCompleteTxnAndMarkerEntry pendingCompleteTxnAndMarker) {
        long producerId = pendingCompleteTxnAndMarker.txnMarkerEntry().producerId();
        short producerEpoch = pendingCompleteTxnAndMarker.txnMarkerEntry().producerEpoch();
        TransactionResult txnResult = pendingCompleteTxnAndMarker.txnMarkerEntry().transactionResult();
        PendingCompleteTxn pendingCompleteTxn = pendingCompleteTxnAndMarker.pendingCompleteTxn();
        Set topicPartitions = CollectionConverters$.MODULE$.ListHasAsScala(pendingCompleteTxnAndMarker.txnMarkerEntry().partitions()).asScala().toSet();
        $this.addTxnMarkersToBrokerQueue(producerId, producerEpoch, txnResult, pendingCompleteTxn, (Set<TopicPartition>)topicPartitions);
    }

    public static final /* synthetic */ boolean $anonfun$generateRequests$4(TransactionMarkerChannelManager $this, TxnMarkerQueue brokerRequestQueue) {
        return !$this.protected$hasInFlightRequests($this, brokerRequestQueue.destination());
    }

    public static final /* synthetic */ boolean $anonfun$generateRequests$7(Tuple2 x0$3) {
        if (x0$3 != null) {
            return !((ArrayList)x0$3._2()).isEmpty();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$maybeWriteTxnCompletion$1(TransactionMarkerChannelManager $this, String transactionalId$2, PendingCompleteTxn pendingCompleteTxn) {
        if (!$this.hasPendingMarkersToWrite(pendingCompleteTxn.txnMetadata()) && $this.transactionsWithPendingMarkers().remove(transactionalId$2, pendingCompleteTxn)) {
            $this.writeTxnCompletion(pendingCompleteTxn);
            return;
        }
    }

    private final void appendCallback$1(Errors error, PendingCompleteTxn txnLogAppend$2) {
        if (Errors.NONE.equals(error)) {
            this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(78).append("Completed transaction for ").append(txnLogAppend$2.transactionalId()).append(" with coordinator epoch ").append(txnLogAppend$2.coordinatorEpoch()).append(", final state after commit: ").append(txnLogAppend$2.txnMetadata().state()).toString());
            return;
        }
        if (Errors.NOT_COORDINATOR.equals(error)) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(122).append("No longer the coordinator for transactionalId: ").append(txnLogAppend$2.transactionalId()).append(" while trying to append to transaction log, skip writing to transaction log").toString());
            return;
        }
        if (Errors.COORDINATOR_NOT_AVAILABLE.equals(error)) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(76).append("Not available to append ").append(txnLogAppend$2).append(": possible causes include ").append(Errors.UNKNOWN_TOPIC_OR_PARTITION).append(", ").append(Errors.NOT_ENOUGH_REPLICAS).append(", ").append(Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND).append(" and ").append(Errors.REQUEST_TIMED_OUT).append("; retry appending").toString());
            this.txnLogAppendRetryQueue().add(txnLogAppend$2);
            return;
        }
        if (Errors.COORDINATOR_LOAD_IN_PROGRESS.equals(error)) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(149).append("Coordinator is loading the partition ").append($this.txnStateManager.partitionFor(txnLogAppend$2.transactionalId())).append(" and hence cannot complete append of ").append(txnLogAppend$2).append("; ").append("skip writing to transaction log as the loading process should complete it").toString());
            return;
        }
        if (error != null) {
            String errorMsg = new StringBuilder(57).append("Unexpected error ").append(error.exceptionName()).append(" while appending to transaction log for ").append(txnLogAppend$2.transactionalId()).toString();
            this.fatal((Function0<String>)(Function0 & Serializable)() -> errorMsg);
            throw new IllegalStateException(errorMsg);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$tryAppendToLog$7(Errors x$5) {
        Errors errors = x$5;
        Errors errors2 = Errors.COORDINATOR_NOT_AVAILABLE;
        return !(errors != null ? !errors.equals(errors2) : errors2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$addTxnMarkersToBrokerQueue$2(Tuple2 check$ifrefutable$2) {
        if (check$ifrefutable$2 != null) {
            Option broker = (Option)check$ifrefutable$2._1();
            Set topicPartitions = (Set)check$ifrefutable$2._2();
            if (broker != null && topicPartitions != null) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ void $anonfun$removeMarkersForTxnTopicPartition$2(TransactionMarkerChannelManager $this, int txnTopicPartitionId$1, PendingCompleteTxnAndMarkerEntry entry) {
        $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(53).append("Removing ").append(entry).append(" for txn partition ").append(txnTopicPartitionId$1).append(" to destination broker -1").toString());
        $this.removeMarkersForTxn(entry.pendingCompleteTxn());
    }

    public static final /* synthetic */ void $anonfun$removeMarkersForTxnTopicPartition$1(TransactionMarkerChannelManager $this, int txnTopicPartitionId$1, BlockingQueue queue) {
        CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)queue).asScala().foreach((Function1 & Serializable)entry -> {
            TransactionMarkerChannelManager.$anonfun$removeMarkersForTxnTopicPartition$2($this, txnTopicPartitionId$1, entry);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$removeMarkersForTxnTopicPartition$6(TransactionMarkerChannelManager $this, int txnTopicPartitionId$1, int brokerId$2, PendingCompleteTxnAndMarkerEntry entry) {
        $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(51).append("Removing ").append(entry).append(" for txn partition ").append(txnTopicPartitionId$1).append(" to destination broker ").append(brokerId$2).toString());
        $this.removeMarkersForTxn(entry.pendingCompleteTxn());
    }

    public static final /* synthetic */ void $anonfun$removeMarkersForTxnTopicPartition$5(TransactionMarkerChannelManager $this, int txnTopicPartitionId$1, int brokerId$2, BlockingQueue queue) {
        CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)queue).asScala().foreach((Function1 & Serializable)entry -> {
            TransactionMarkerChannelManager.$anonfun$removeMarkersForTxnTopicPartition$6($this, txnTopicPartitionId$1, brokerId$2, entry);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$removeMarkersForTxnTopicPartition$4(TransactionMarkerChannelManager $this, int txnTopicPartitionId$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            int brokerId = x0$1._1$mcI$sp();
            ((TxnMarkerQueue)x0$1._2()).removeMarkersForTxnTopicPartition(txnTopicPartitionId$1).foreach((Function1 & Serializable)queue -> {
                TransactionMarkerChannelManager.$anonfun$removeMarkersForTxnTopicPartition$5($this, txnTopicPartitionId$1, brokerId, queue);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public TransactionMarkerChannelManager(KafkaConfig config, MetadataCache metadataCache, NetworkClient networkClient, TransactionStateManager txnStateManager, Time time) {
        this.metadataCache = metadataCache;
        this.txnStateManager = txnStateManager;
        this.time = time;
        super(new StringBuilder(22).append("TxnMarkerSenderThread-").append(config.brokerId()).toString(), (KafkaClient)networkClient, Predef$.MODULE$.Integer2int(config.requestTimeoutMs()), time);
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.logIdent_$eq(new StringBuilder(39).append("[Transaction Marker Channel Manager ").append(config.brokerId()).append("]: ").toString());
        this.interBrokerListenerName = config.interBrokerListenerName();
        this.markersQueuePerBroker = CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(new ConcurrentHashMap()).asScala();
        this.markersQueueForUnknownBroker = new TxnMarkerQueue(Node.noNode());
        this.txnLogAppendRetryQueue = new LinkedBlockingQueue();
        this.transactionsWithPendingMarkers = new ConcurrentHashMap();
        this.writeTxnMarkersRequestVersion = config.interBrokerProtocolVersion().isAtLeast(MetadataVersion.IBP_2_8_IV0) ? (short)1 : 0;
        this.metricsGroup().newGauge(TransactionMarkerChannelManager$.MODULE$.kafka$coordinator$transaction$TransactionMarkerChannelManager$$UnknownDestinationQueueSizeMetricName(), (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ TransactionMarkerChannelManager $outer;

            public final int value() {
                return this.$outer.kafka$coordinator$transaction$TransactionMarkerChannelManager$$$anonfun$new$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.metricsGroup().newGauge(TransactionMarkerChannelManager$.MODULE$.kafka$coordinator$transaction$TransactionMarkerChannelManager$$LogAppendRetryQueueSizeMetricName(), (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ TransactionMarkerChannelManager $outer;

            public final int value() {
                return this.$outer.kafka$coordinator$transaction$TransactionMarkerChannelManager$$$anonfun$new$2();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

