/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import kafka.durability.DurabilityAuditActiveMirror;
import kafka.durability.DurabilityAuditFailedMirror;
import kafka.durability.DurabilityAuditPausedMirror;
import kafka.durability.DurabilityAuditPendingMirror;
import kafka.durability.DurabilityAuditPendingRepairMirror;
import kafka.durability.DurabilityAuditPendingRestoreMirror;
import kafka.durability.DurabilityAuditPendingSetupForRestoreMirror;
import kafka.durability.DurabilityAuditPendingStoppedMirror;
import kafka.durability.DurabilityAuditPendingSynchronizeMirror;
import kafka.durability.DurabilityAuditStoppedMirror;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface DurabilityAuditMirrorState {
    public static final Logger log = LoggerFactory.getLogger(DurabilityAuditMirrorState.class);
    public static final List<DurabilityAuditMirrorState> STATES = Arrays.asList(DurabilityAuditActiveMirror.INSTANCE, DurabilityAuditPausedMirror.INSTANCE, DurabilityAuditFailedMirror.INSTANCE, DurabilityAuditPendingStoppedMirror.INSTANCE, DurabilityAuditStoppedMirror.INSTANCE, DurabilityAuditPendingMirror.INSTANCE, DurabilityAuditPendingSynchronizeMirror.INSTANCE, DurabilityAuditPendingRepairMirror.INSTANCE, DurabilityAuditPendingSetupForRestoreMirror.INSTANCE, DurabilityAuditPendingRestoreMirror.INSTANCE);
    public static final DurabilityAuditMirrorState ACTIVE = DurabilityAuditActiveMirror.INSTANCE;
    public static final DurabilityAuditMirrorState PAUSED = DurabilityAuditPausedMirror.INSTANCE;
    public static final DurabilityAuditMirrorState FAILED = DurabilityAuditFailedMirror.INSTANCE;
    public static final DurabilityAuditMirrorState PENDING_STOPPED = DurabilityAuditPendingStoppedMirror.INSTANCE;
    public static final DurabilityAuditMirrorState STOPPED = DurabilityAuditStoppedMirror.INSTANCE;
    public static final DurabilityAuditMirrorState PENDING_MIRROR = DurabilityAuditPendingMirror.INSTANCE;
    public static final DurabilityAuditMirrorState PENDING_SYNCHRONIZE_MIRROR = DurabilityAuditPendingSynchronizeMirror.INSTANCE;
    public static final DurabilityAuditMirrorState PENDING_REPAIR = DurabilityAuditPendingRepairMirror.INSTANCE;
    public static final DurabilityAuditMirrorState PENDING_SETUP_FOR_RESTORE = DurabilityAuditPendingSetupForRestoreMirror.INSTANCE;
    public static final DurabilityAuditMirrorState PENDING_RESTORE = DurabilityAuditPendingRestoreMirror.INSTANCE;

    public boolean isReadOnly();

    public boolean isAppendRecordsAllowed();

    public boolean isTruncationBelowHighWatermarkAllowed();

    public String getName();

    public Integer getValue();

    public static Optional<DurabilityAuditMirrorState> fromString(Optional<String> mirrorState) {
        if (!mirrorState.isPresent()) {
            return Optional.empty();
        }
        Optional<DurabilityAuditMirrorState> mirrorStateOpt = mirrorState.flatMap(name -> STATES.stream().filter(state -> state.getName().equals(name)).findFirst());
        if (!mirrorStateOpt.isPresent()) {
            log.error("Unknown mirror state name: {}", mirrorState);
        }
        return mirrorStateOpt;
    }

    public static Optional<DurabilityAuditMirrorState> fromStateValue(Integer mirrorState) {
        if (mirrorState == 0) {
            return Optional.empty();
        }
        Optional<DurabilityAuditMirrorState> mirrorStateOpt = STATES.stream().filter(state -> state.getValue().equals(mirrorState)).findFirst();
        if (!mirrorStateOpt.isPresent()) {
            log.error("Unknown mirror state value: {}", (Object)mirrorState);
        }
        return mirrorStateOpt;
    }
}

