/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.audit.manager;

import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.OptionalLong;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import kafka.durability.Utils$;
import kafka.durability.audit.DurabilityAuditConfig;
import kafka.durability.audit.DurabilityAuditConstants$;
import kafka.durability.audit.job.ControllerAuditJob;
import kafka.durability.audit.manager.AbstractAuditManager;
import kafka.durability.audit.manager.AbstractAuditManagerTrait;
import kafka.durability.audit.manager.ControllerAuditManager$;
import kafka.durability.audit.manager.ControllerAuditManagerTrait;
import kafka.durability.audit.manager.DurabilityAuditCheck$;
import kafka.durability.audit.request.AuditManagerRequest;
import kafka.durability.audit.request.HealthCheckRequest;
import kafka.durability.audit.request.KRaftHWMChangeRequest;
import kafka.durability.audit.request.KRaftLeaderChangeRequest;
import kafka.durability.audit.request.KRaftLogSnapshotGenerationRequest;
import kafka.durability.audit.request.KRaftLogStartOffsetChangeRequest;
import kafka.durability.audit.request.KRaftNodeStartUpRequest;
import kafka.durability.events.AbstractDurabilityEvent;
import kafka.durability.events.HealthCheckEvent$;
import kafka.durability.events.controller.kraft.KRaftHWMChangeEvent$;
import kafka.durability.events.controller.kraft.KRaftLeaderChangeEvent$;
import kafka.durability.events.controller.kraft.KRaftLogSnapshotGenerationEvent$;
import kafka.durability.events.controller.kraft.KRaftLogStartOffsetChangeEvent$;
import kafka.durability.events.controller.kraft.KRaftNodeStartUpEvent$;
import kafka.durability.materialization.ControllerDurabilityEventsMaterialize;
import kafka.durability.topic.DurabilityTopicConfig;
import kafka.durability.topic.DurabilityTopicManager;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.OffsetAndEpoch;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.immutable.Set;
import scala.collection.mutable.Builder;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015d\u0001\u0002\u0010 \u0001!B\u0001\"\f\u0001\u0003\u0006\u0004%\tE\f\u0005\ng\u0001\u0011\t\u0011)A\u0005_QB\u0001\"\u000e\u0001\u0003\u0006\u0004%\tE\u000e\u0005\n\t\u0002\u0011\t\u0011)A\u0005o\u0015CQA\u0012\u0001\u0005\u0002\u001dCqa\u0013\u0001A\u0002\u0013%A\nC\u0004T\u0001\u0001\u0007I\u0011\u0002+\t\ri\u0003\u0001\u0015)\u0003N\u0011\u001dY\u0006A1A\u0005BqCaa\u0019\u0001!\u0002\u0013i\u0006\u0002\u00033\u0001\u0005\u0004%\t%I3\t\r1\u0004\u0001\u0015!\u0003g\u0011!i\u0007A1A\u0005B\u0005r\u0007B\u0002:\u0001A\u0003%q\u000eC\u0003t\u0001\u0011\u0005C\u000f\u0003\u0004v\u0001\u0011\u0005\u0011E\u001e\u0005\u000b\u0003\u0003\u0001\u0011\u0013!C\u0001C\u0005\r\u0001BCA\r\u0001E\u0005I\u0011A\u0011\u0002\u0004!Q\u00111\u0004\u0001\u0012\u0002\u0013\u0005\u0011%a\u0001\t\u000f\u0005u\u0001\u0001\"\u0003\u0002 !A\u0011\u0011\u0005\u0001\u0005B\u0005\n\u0019\u0003\u0003\u0006\u0002(\u0001\t\n\u0011\"\u0001\"\u0003\u0007A\u0001\"!\u000b\u0001\t\u0003\n\u00131\u0006\u0005\t\u0003s\u0001A\u0011A\u0011\u0002<!Q\u0011Q\n\u0001\u0012\u0002\u0013\u0005\u0011%a\u0001\t\u000f\u0005=\u0003\u0001\"\u0001\"i\u001e9\u0011\u0011K\u0010\t\u0002\u0005McA\u0002\u0010 \u0011\u0003\t)\u0006\u0003\u0004G9\u0011\u0005\u00111\r\u0002\u0017\u0007>tGO]8mY\u0016\u0014\u0018)\u001e3ji6\u000bg.Y4fe*\u0011\u0001%I\u0001\b[\u0006t\u0017mZ3s\u0015\t\u00113%A\u0003bk\u0012LGO\u0003\u0002%K\u0005QA-\u001e:bE&d\u0017\u000e^=\u000b\u0003\u0019\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001SA\u0011!fK\u0007\u0002?%\u0011Af\b\u0002\u0015\u0003\n\u001cHO]1di\u0006+H-\u001b;NC:\fw-\u001a:\u0002\r\r|gNZ5h+\u0005y\u0003C\u0001\u00192\u001b\u0005\t\u0013B\u0001\u001a\"\u0005U!UO]1cS2LG/_!vI&$8i\u001c8gS\u001e\fqaY8oM&<\u0007%\u0003\u0002.W\u0005!A/[7f+\u00059\u0004C\u0001\u001dC\u001b\u0005I$B\u0001\u001e<\u0003\u0015)H/\u001b7t\u0015\taT(\u0001\u0004d_6lwN\u001c\u0006\u0003MyR!a\u0010!\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0015aA8sO&\u00111)\u000f\u0002\u0005)&lW-A\u0003uS6,\u0007%\u0003\u00026W\u00051A(\u001b8jiz\"2\u0001S%K!\tQ\u0003\u0001C\u0003.\u000b\u0001\u0007q\u0006C\u00036\u000b\u0001\u0007q'\u0001\u000bmCN$HIY\"iK\u000e\\\u0007o\\5oiRKW.Z\u000b\u0002\u001bB\u0011a*U\u0007\u0002\u001f*\t\u0001+A\u0003tG\u0006d\u0017-\u0003\u0002S\u001f\n!Aj\u001c8h\u0003aa\u0017m\u001d;EE\u000eCWmY6q_&tG\u000fV5nK~#S-\u001d\u000b\u0003+b\u0003\"A\u0014,\n\u0005]{%\u0001B+oSRDq!W\u0004\u0002\u0002\u0003\u0007Q*A\u0002yIE\nQ\u0003\\1ti\u0012\u00137\t[3dWB|\u0017N\u001c;US6,\u0007%A\u0006nCR,'/[1mSj,W#A/\u0011\u0005y\u000bW\"A0\u000b\u0005\u0001\u001c\u0013aD7bi\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8\n\u0005\t|&!J\"p]R\u0014x\u000e\u001c7fe\u0012+(/\u00192jY&$\u00180\u0012<f]R\u001cX*\u0019;fe&\fG.\u001b>f\u00031i\u0017\r^3sS\u0006d\u0017N_3!\u0003-!x\u000e]5d\u0007>tg-[4\u0016\u0003\u0019\u0004\"a\u001a6\u000e\u0003!T!![\u0012\u0002\u000bQ|\u0007/[2\n\u0005-D'!\u0006#ve\u0006\u0014\u0017\u000e\\5usR{\u0007/[2D_:4\u0017nZ\u0001\ri>\u0004\u0018nY\"p]\u001aLw\rI\u0001\ri>\u0004\u0018nY'b]\u0006<WM]\u000b\u0002_B\u0011q\r]\u0005\u0003c\"\u0014a\u0003R;sC\nLG.\u001b;z)>\u0004\u0018nY'b]\u0006<WM]\u0001\u000ei>\u0004\u0018nY'b]\u0006<WM\u001d\u0011\u0002\r\u0011|wk\u001c:l)\u0005)\u0016\u0001\u00043p/>\u00148.Q2uk\u0006dG\u0003B+xyzDq\u0001\u001f\t\u0011\u0002\u0003\u0007\u00110\u0001\ttG\",G-\u001e7f\u0003V$\u0017\u000e\u001e&pEB\u0011aJ_\u0005\u0003w>\u0013qAQ8pY\u0016\fg\u000eC\u0004~!A\u0005\t\u0019A=\u0002\u0015\u0019dWo\u001d5CCR\u001c\u0007\u000eC\u0004\u0000!A\u0005\t\u0019A=\u0002\u0017U\u001cX\rT8dC2dunZ\u0001\u0017I><vN]6BGR,\u0018\r\u001c\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\u0001\u0016\u0004s\u0006\u001d1FAA\u0005!\u0011\tY!!\u0006\u000e\u0005\u00055!\u0002BA\b\u0003#\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005Mq*\u0001\u0006b]:|G/\u0019;j_:LA!a\u0006\u0002\u000e\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002-\u0011|wk\u001c:l\u0003\u000e$X/\u00197%I\u00164\u0017-\u001e7uII\na\u0003Z8X_J\\\u0017i\u0019;vC2$C-\u001a4bk2$HeM\u0001\u0011g\"|W\u000f\u001c3DQ\u0016\u001c7\u000e]8j]R,\u0012!_\u0001\u0012M2,8\u000f\u001b*fG>\u0014Hm])vKV,GcA+\u0002&!9q0\u0006I\u0001\u0002\u0004I\u0018a\u00074mkND'+Z2pe\u0012\u001c\u0018+^3vK\u0012\"WMZ1vYR$\u0013'\u0001\bde\u0016\fG/Z!vI&$(j\u001c2\u0015\u0005\u00055\u0002\u0003BA\u0018\u0003ki!!!\r\u000b\u0007\u0005M\u0012%A\u0002k_\nLA!a\u000e\u00022\t\u00112i\u001c8ue>dG.\u001a:Bk\u0012LGOS8c\u0003%\u0019XM\u001c3Fm\u0016tG\u000fF\u0003z\u0003{\tY\u0005C\u0004\u0002@a\u0001\r!!\u0011\u0002\u000fI,\u0017/^3tiB!\u00111IA$\u001b\t\t)EC\u0002\u0002@\u0005JA!!\u0013\u0002F\t\u0019\u0012)\u001e3ji6\u000bg.Y4feJ+\u0017/^3ti\"9q\u0010\u0007I\u0001\u0002\u0004I\u0018aE:f]\u0012,e/\u001a8uI\u0011,g-Y;mi\u0012\u0012\u0014aB2mK\u0006tW\u000f]\u0001\u0017\u0007>tGO]8mY\u0016\u0014\u0018)\u001e3ji6\u000bg.Y4feB\u0011!\u0006H\n\u00069\u0005]\u0013Q\f\t\u0004\u001d\u0006e\u0013bAA.\u001f\n1\u0011I\\=SK\u001a\u00042AKA0\u0013\r\t\tg\b\u0002\u001c\u0007>tGO]8mY\u0016\u0014\u0018)\u001e3ji6\u000bg.Y4feR\u0013\u0018-\u001b;\u0015\u0005\u0005M\u0003")
public class ControllerAuditManager
extends AbstractAuditManager {
    private long lastDbCheckpointTime;
    private final ControllerDurabilityEventsMaterialize materialize;
    private final DurabilityTopicConfig topicConfig;
    private final DurabilityTopicManager topicManager;

    public static void submitAuditRequest(AuditManagerRequest auditRequest) {
        ControllerAuditManagerTrait.submitAuditRequest$(ControllerAuditManager$.MODULE$, auditRequest);
    }

    public static boolean stopAuditManager$default$1() {
        return true;
    }

    public static void stopAuditManager(boolean shutdown) {
        ControllerAuditManagerTrait.stopAuditManager$(ControllerAuditManager$.MODULE$, shutdown);
    }

    public static Option<ControllerAuditManager> initialize(DurabilityAuditConfig config, Time time) {
        return ControllerAuditManagerTrait.initialize$(ControllerAuditManager$.MODULE$, config, time);
    }

    public static ConcurrentHashMap<TopicIdPartition, KRaftNodeStartUpRequest> pendingNodeStartUpEvents() {
        return ControllerAuditManager$.MODULE$.pendingNodeStartUpEvents();
    }

    public static void reconfigureConfigValues(String events, String checks, long ioRequestBytePerSecond) {
        AbstractAuditManagerTrait.reconfigureConfigValues$(ControllerAuditManager$.MODULE$, events, checks, ioRequestBytePerSecond);
    }

    public static void startAuditManager() {
        AbstractAuditManagerTrait.startAuditManager$(ControllerAuditManager$.MODULE$);
    }

    public static void instance_$eq(AbstractAuditManager x$1) {
        ControllerAuditManager$.MODULE$.instance_$eq(x$1);
    }

    public static AbstractAuditManager instance() {
        return ControllerAuditManager$.MODULE$.instance();
    }

    @Override
    public DurabilityAuditConfig config() {
        return super.config();
    }

    @Override
    public Time time() {
        return super.time();
    }

    private long lastDbCheckpointTime() {
        return this.lastDbCheckpointTime;
    }

    private void lastDbCheckpointTime_$eq(long x$1) {
        this.lastDbCheckpointTime = x$1;
    }

    @Override
    public ControllerDurabilityEventsMaterialize materialize() {
        return this.materialize;
    }

    @Override
    public DurabilityTopicConfig topicConfig() {
        return this.topicConfig;
    }

    @Override
    public DurabilityTopicManager topicManager() {
        return this.topicManager;
    }

    @Override
    public void doWork() {
        this.doWorkActual(false, this.doWorkActual$default$2(), this.doWorkActual$default$3());
        this.pause(DurabilityAuditConstants$.MODULE$.DURABILITY_JOB_LOOP_WAIT_MS(), TimeUnit.MILLISECONDS);
    }

    public void doWorkActual(boolean scheduleAuditJob, boolean flushBatch, boolean useLocalLog) {
        if (scheduleAuditJob && this.shouldScheduleNewAuditJob() && this.config().auditChecks().contains((Object)DurabilityAuditCheck$.MODULE$.PeriodicalAudit())) {
            this.scheduleNewAuditJob();
        }
        if (this.sendEventHealthCheck()) {
            ControllerAuditManagerTrait.submitAuditRequest$(ControllerAuditManager$.MODULE$, new HealthCheckRequest(this.healthCheckPartition(), -1, this.config().nodeId(), this.time().milliseconds()));
        }
        this.flushRecordsQueue(useLocalLog);
        if (this.shouldCheckpoint()) {
            this.lastDbCheckpointTime_$eq(this.time().milliseconds());
            this.db().checkpoint();
            return;
        }
    }

    public boolean doWorkActual$default$1() {
        return false;
    }

    public boolean doWorkActual$default$2() {
        return false;
    }

    public boolean doWorkActual$default$3() {
        return true;
    }

    private boolean shouldCheckpoint() {
        return this.time().milliseconds() - this.lastDbCheckpointTime() >= this.config().dbCheckpointFrequencyMs();
    }

    @Override
    public void flushRecordsQueue(boolean useLocalLog) {
        int count = 0;
        AuditManagerRequest record = this.auditRequestsQueue().poll();
        Queue allNonBatchedEvents = new Queue(Queue$.MODULE$.$lessinit$greater$default$1());
        HashMap lastHWMChangeRequests = new HashMap();
        while (count < DurabilityAuditConstants$.MODULE$.MAX_EVENT_PER_LOOP() && record != null) {
            if (record instanceof KRaftHWMChangeRequest) {
                KRaftHWMChangeRequest kRaftHWMChangeRequest = (KRaftHWMChangeRequest)record;
                if (lastHWMChangeRequests.put((Object)kRaftHWMChangeRequest.topicIdPartition(), (Object)kRaftHWMChangeRequest).isEmpty()) {
                    ++count;
                }
            } else {
                ++count;
            }
            allNonBatchedEvents.enqueue((Object)record);
            record = this.auditRequestsQueue().poll();
        }
        while (allNonBatchedEvents.nonEmpty()) {
            record = (AuditManagerRequest)allNonBatchedEvents.dequeue();
            if (record instanceof KRaftHWMChangeRequest) {
                KRaftHWMChangeRequest kRaftHWMChangeRequest = (KRaftHWMChangeRequest)record;
                if (lastHWMChangeRequests.apply((Object)kRaftHWMChangeRequest.topicIdPartition()) != kRaftHWMChangeRequest) continue;
                this.sendEvent(kRaftHWMChangeRequest, useLocalLog);
                continue;
            }
            this.sendEvent(record, useLocalLog);
        }
    }

    @Override
    public boolean flushRecordsQueue$default$1() {
        return false;
    }

    @Override
    public ControllerAuditJob createAuditJob() {
        return new ControllerAuditJob(this.auditJobCountdownLatch(), this.reporter(), this.currentJobId(), this.time(), this.auditChecks(), this.auditConfig(), this.db());
    }

    public boolean sendEvent(AuditManagerRequest request, boolean useLocalLog) {
        Some event;
        Some some;
        if (request instanceof KRaftLeaderChangeRequest) {
            KRaftLeaderChangeRequest kRaftLeaderChangeRequest = (KRaftLeaderChangeRequest)request;
            Map epochChain = (Map)CollectionConverters$.MODULE$.MapHasAsScala(kRaftLeaderChangeRequest.epochChainSupplier().get()).asScala().map((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    Integer epoch = (Integer)x0$1._1();
                    Long startOffset = (Long)x0$1._2();
                    return new Tuple2.mcIJ.sp(epoch.intValue(), startOffset.longValue());
                }
                throw new MatchError(null);
            });
            some = new Some((Object)KRaftLeaderChangeEvent$.MODULE$.apply(kRaftLeaderChangeRequest.topicIdPartition(), kRaftLeaderChangeRequest.logEndOffset(), kRaftLeaderChangeRequest.epoch(), (Option<Object>)(kRaftLeaderChangeRequest.hwm().isPresent() ? new Some((Object)BoxesRunTime.boxToLong((long)kRaftLeaderChangeRequest.hwm().getAsLong())) : None$.MODULE$), kRaftLeaderChangeRequest.logStartOffset(), kRaftLeaderChangeRequest.nodeId(), (Option<Map<Object, Object>>)new Some((Object)epochChain), (Set<Object>)((Set)((Builder)Predef$.MODULE$.Set().newBuilder().$plus$plus$eq((IterableOnce)CollectionConverters$.MODULE$.SetHasAsScala(kRaftLeaderChangeRequest.currentVoters()).asScala().map((Function1 & Serializable)i -> BoxesRunTime.boxToInteger((int)i)))).result()), (Set<Object>)((Set)((Builder)Predef$.MODULE$.Set().newBuilder().$plus$plus$eq((IterableOnce)CollectionConverters$.MODULE$.SetHasAsScala(kRaftLeaderChangeRequest.yesVoters()).asScala().map((Function1 & Serializable)i -> BoxesRunTime.boxToInteger((int)i)))).result())));
        } else if (request instanceof KRaftHWMChangeRequest) {
            KRaftHWMChangeRequest kRaftHWMChangeRequest = (KRaftHWMChangeRequest)request;
            some = new Some((Object)KRaftHWMChangeEvent$.MODULE$.apply(kRaftHWMChangeRequest.topicIdPartition(), kRaftHWMChangeRequest.epoch(), kRaftHWMChangeRequest.hwm(), kRaftHWMChangeRequest.logStartOffset(), kRaftHWMChangeRequest.nodeId(), (Map<Object, Object>)((Map)CollectionConverters$.MODULE$.MapHasAsScala(kRaftHWMChangeRequest.quorumFetchOffsets()).asScala().map((Function1 & Serializable)iAndL -> new Tuple2.mcIJ.sp(((Integer)iAndL._1()).intValue(), ((OptionalLong)iAndL._2()).orElse(-1L)))), (Set<Object>)((Set)((Builder)Predef$.MODULE$.Set().newBuilder().$plus$plus$eq((IterableOnce)CollectionConverters$.MODULE$.SetHasAsScala(kRaftHWMChangeRequest.currentVoters()).asScala().map((Function1 & Serializable)i -> BoxesRunTime.boxToInteger((int)i)))).result())));
        } else if (request instanceof KRaftLogStartOffsetChangeRequest) {
            KRaftLogStartOffsetChangeRequest kRaftLogStartOffsetChangeRequest = (KRaftLogStartOffsetChangeRequest)request;
            some = new Some((Object)KRaftLogStartOffsetChangeEvent$.MODULE$.apply(kRaftLogStartOffsetChangeRequest.topicIdPartition(), kRaftLogStartOffsetChangeRequest.epoch(), (Option<Object>)(kRaftLogStartOffsetChangeRequest.hwm().isPresent() ? new Some((Object)BoxesRunTime.boxToLong((long)kRaftLogStartOffsetChangeRequest.hwm().getAsLong())) : None$.MODULE$), kRaftLogStartOffsetChangeRequest.logStartOffset(), kRaftLogStartOffsetChangeRequest.logEndOffset(), kRaftLogStartOffsetChangeRequest.nodeId(), (Option<Object>)(kRaftLogStartOffsetChangeRequest.leaderId().isPresent() ? new Some((Object)BoxesRunTime.boxToInteger((int)kRaftLogStartOffsetChangeRequest.leaderId().getAsInt())) : None$.MODULE$), (Option<OffsetAndEpoch>)Option$.MODULE$.apply(kRaftLogStartOffsetChangeRequest.latestSnapshotId().orElse(null))));
        } else if (request instanceof KRaftLogSnapshotGenerationRequest) {
            KRaftLogSnapshotGenerationRequest kRaftLogSnapshotGenerationRequest = (KRaftLogSnapshotGenerationRequest)request;
            some = new Some((Object)KRaftLogSnapshotGenerationEvent$.MODULE$.apply(kRaftLogSnapshotGenerationRequest.topicIdPartition(), kRaftLogSnapshotGenerationRequest.epoch(), (Option<Object>)(kRaftLogSnapshotGenerationRequest.hwm().isPresent() ? new Some((Object)BoxesRunTime.boxToLong((long)kRaftLogSnapshotGenerationRequest.hwm().getAsLong())) : None$.MODULE$), kRaftLogSnapshotGenerationRequest.logStartOffset(), kRaftLogSnapshotGenerationRequest.logEndOffset(), kRaftLogSnapshotGenerationRequest.newSnapshotId(), kRaftLogSnapshotGenerationRequest.nodeId(), (Option<Object>)(kRaftLogSnapshotGenerationRequest.leaderId().isPresent() ? new Some((Object)BoxesRunTime.boxToInteger((int)kRaftLogSnapshotGenerationRequest.leaderId().getAsInt())) : None$.MODULE$)));
        } else if (request instanceof KRaftNodeStartUpRequest) {
            KRaftNodeStartUpRequest kRaftNodeStartUpRequest = (KRaftNodeStartUpRequest)request;
            some = new Some((Object)KRaftNodeStartUpEvent$.MODULE$.apply(kRaftNodeStartUpRequest.topicIdPartition(), kRaftNodeStartUpRequest.epoch(), (Option<Object>)(kRaftNodeStartUpRequest.hwm().isPresent() ? new Some((Object)BoxesRunTime.boxToLong((long)kRaftNodeStartUpRequest.hwm().getAsLong())) : None$.MODULE$), kRaftNodeStartUpRequest.logStartOffset(), kRaftNodeStartUpRequest.logEndOffset(), (Option<OffsetAndEpoch>)Option$.MODULE$.apply(kRaftNodeStartUpRequest.latestSnapshotId().orElse(null)), kRaftNodeStartUpRequest.nodeId(), (Option<Object>)(kRaftNodeStartUpRequest.leaderId().isPresent() ? new Some((Object)BoxesRunTime.boxToInteger((int)kRaftNodeStartUpRequest.leaderId().getAsInt())) : None$.MODULE$)));
        } else if (request instanceof HealthCheckRequest) {
            HealthCheckRequest healthCheckRequest = (HealthCheckRequest)request;
            some = new Some((Object)HealthCheckEvent$.MODULE$.apply(healthCheckRequest.topicIdPartition(), healthCheckRequest.epoch(), -1L, -1L, healthCheckRequest.nodeId(), healthCheckRequest.timeStamp()));
        } else {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(73).append("Request of unexpected type passed to sendEvent method: ").append(request).append("\nIgnoring request.").toString());
            some = event = None$.MODULE$;
        }
        if (event instanceof Some) {
            AbstractDurabilityEvent e = (AbstractDurabilityEvent)event.value();
            this.topicManager().addDurabilityEvent(e);
            return true;
        }
        return false;
    }

    public boolean sendEvent$default$2() {
        return false;
    }

    public void cleanup() {
        try {
            Instant cleanupStart = Instant.ofEpochMilli(this.time().milliseconds());
            this.flushRecordsQueue(this.flushRecordsQueue$default$1());
            this.db().checkpoint();
            this.topicManager().shutdown();
            this.metricsManager().shutdown();
            long cleanupDuration = Duration.between(cleanupStart, Instant.ofEpochMilli(this.time().milliseconds())).toMillis();
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(46).append("ControllerAuditManager cleanup complete in ").append(cleanupDuration).append(" ms").toString());
            return;
        }
        catch (Exception e) {
            this.error((Function0<String>)(Function0 & Serializable)() -> "Received error while cleaning up ControllerAuditManager", (Function0<Throwable>)(Function0 & Serializable)() -> e);
            return;
        }
    }

    public static final /* synthetic */ short $anonfun$topicConfig$1(ControllerAuditManager $this, TopicIdPartition x) {
        return (short)Utils$.MODULE$.toPartition(x.topicPartition(), $this.config().topicPartitionCount());
    }

    public ControllerAuditManager(DurabilityAuditConfig config, Time time) {
        super(config, time);
        this.lastDbCheckpointTime = time.milliseconds();
        this.materialize = new ControllerDurabilityEventsMaterialize(this.db(), this.reporter(), time);
        this.topicConfig = new DurabilityTopicConfig(config.interBrokerClientConfigs(), DurabilityAuditConstants$.MODULE$.TOPIC_NAME(), config.topicPartitionCount(), config.topicReplicationFactor(), config.brokerId(), config.clusterId(), DurabilityAuditConstants$.MODULE$.DURABILITY_CONSUMER_POLL_DURATION_MS(), Predef$.MODULE$.int2Integer(DurabilityAuditConstants$.MODULE$.DURABILITY_PRODUCER_REQUEST_TIMEOUT_MS()), DurabilityAuditConstants$.MODULE$.DURABILITY_TOPIC_RETENTION_MS(), DurabilityAuditConstants$.MODULE$.DURABILITY_TOPIC_MAX_LOOK_BACK_IN_MS(), config.idempotentProducer(), (Option<Set<Object>>)new Some((Object)config.kRaftMetadataPartitionsToMonitor().map((Function1 & Serializable)x -> BoxesRunTime.boxToShort((short)ControllerAuditManager.$anonfun$topicConfig$1(this, x))).toSet()));
        this.topicManager = this.getTopicManager();
    }
}

