/*
 * Decompiled with CFR 0.152.
 */
package kafka.metrics;

import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kafka.common.TenantHelpers;
import kafka.metrics.ConsumerLagEmitter$;
import kafka.metrics.ConsumerLagEmitterSummary;
import kafka.metrics.MemberTopicPartition;
import kafka.utils.Implicits$MapExtensionMethods$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ListOffsetsResult;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.common.ConsumerGroupState;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.NotCoordinatorException;
import org.apache.kafka.common.message.DescribeGroupsResponseData;
import org.apache.kafka.common.message.ListGroupsRequestData;
import org.apache.kafka.common.message.OffsetFetchRequestData;
import org.apache.kafka.common.message.OffsetFetchResponseData;
import org.apache.kafka.common.metrics.Gauge;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.internals.GaugeSuite;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.SchemaException;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.coordinator.group.GroupCoordinator;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.util.Scheduler;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Growable;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\rus!B+W\u0011\u0003Yf!B/W\u0011\u0003q\u0006\"B3\u0002\t\u00031\u0007\"B4\u0002\t\u0003A\u0007\"\u0003Bv\u0003E\u0005I\u0011\u0001Bw\u0011%\u0019\u0019!\u0001b\u0001\n\u0003\u0019)\u0001\u0003\u0005\u0004\f\u0005\u0001\u000b\u0011BB\u0004\u0011%\u0019i!\u0001b\u0001\n\u0003\u0019)\u0001\u0003\u0005\u0004\u0010\u0005\u0001\u000b\u0011BB\u0004\u0011%\u0019\t\"\u0001b\u0001\n\u0003\u0019)\u0001\u0003\u0005\u0004\u0014\u0005\u0001\u000b\u0011BB\u0004\u0011%\u0019)\"\u0001b\u0001\n\u0003\u0019)\u0001\u0003\u0005\u0004\u0018\u0005\u0001\u000b\u0011BB\u0004\u0011%\u0019I\"\u0001b\u0001\n\u0003\u0019)\u0001\u0003\u0005\u0004\u001c\u0005\u0001\u000b\u0011BB\u0004\u0011%\u0019i\"\u0001b\u0001\n\u0003\u0019)\u0001\u0003\u0005\u0004 \u0005\u0001\u000b\u0011BB\u0004\u0011%\u0019\t#\u0001b\u0001\n\u0003\u0019)\u0001\u0003\u0005\u0004$\u0005\u0001\u000b\u0011BB\u0004\u0011%\u0019)#\u0001b\u0001\n\u0003\u0019)\u0001\u0003\u0005\u0004(\u0005\u0001\u000b\u0011BB\u0004\u0011%\u0019I#\u0001b\u0001\n\u0003\u0019)\u0001\u0003\u0005\u0004,\u0005\u0001\u000b\u0011BB\u0004\u0011%\u0019i#\u0001b\u0001\n\u0003\u0019)\u0001\u0003\u0005\u00040\u0005\u0001\u000b\u0011BB\u0004\u0011)\u0019\t$\u0001b\u0001\n\u0003161\u0007\u0005\t\u0007\u007f\t\u0001\u0015!\u0003\u00046!I1\u0011I\u0001C\u0002\u0013%11\u0007\u0005\t\u0007\u0007\n\u0001\u0015!\u0003\u00046!I1QI\u0001C\u0002\u0013%1q\t\u0005\t\u0007+\n\u0001\u0015!\u0003\u0004J!I1qK\u0001C\u0002\u0013%1q\t\u0005\t\u00073\n\u0001\u0015!\u0003\u0004J!I11L\u0001\u0012\u0002\u0013\u0005!Q\u001e\u0004\u0005;Z\u0003!\u000e\u0003\u0005XE\t\u0015\r\u0011\"\u0001l\u0011!A(E!A!\u0002\u0013a\u0007\u0002C=#\u0005\u000b\u0007I\u0011\u0001>\t\u0013\u00055!E!A!\u0002\u0013Y\bBCA\bE\t\u0015\r\u0011\"\u0001\u0002\u0012!Q\u00111\u0005\u0012\u0003\u0002\u0003\u0006I!a\u0005\t\u0015\u0005\u0015\"E!b\u0001\n\u0003\t9\u0003\u0003\u0006\u0002:\t\u0012\t\u0011)A\u0005\u0003SA!\"a\u000f#\u0005\u000b\u0007I\u0011AA\u001f\u0011)\t)E\tB\u0001B\u0003%\u0011q\b\u0005\u000b\u0003\u000f\u0012#Q1A\u0005\u0002\u0005%\u0003BCA-E\t\u0005\t\u0015!\u0003\u0002L!1QM\tC\u0001\u00037B!\"!\u001b#\u0005\u0004%\tAVA6\u0011!\t)K\tQ\u0001\n\u00055\u0004\"CATE\u0001\u0007I\u0011BAU\u0011%\t\tL\ta\u0001\n\u0013\t\u0019\f\u0003\u0005\u0002@\n\u0002\u000b\u0015BAV\u0011%\tIM\ta\u0001\n\u0013\tI\u000bC\u0005\u0002L\n\u0002\r\u0011\"\u0003\u0002N\"A\u0011\u0011\u001b\u0012!B\u0013\tY\u000bC\u0005\u0002V\n\u0002\r\u0011\"\u0003\u0002*\"I\u0011q\u001b\u0012A\u0002\u0013%\u0011\u0011\u001c\u0005\t\u0003;\u0014\u0003\u0015)\u0003\u0002,\"I\u0011\u0011\u001d\u0012A\u0002\u0013%\u0011\u0011\u0016\u0005\n\u0003G\u0014\u0003\u0019!C\u0005\u0003KD\u0001\"!;#A\u0003&\u00111\u0016\u0005\n\u0003[\u0014\u0003\u0019!C\u0005\u0003{A\u0011\"a<#\u0001\u0004%I!!=\t\u0011\u0005U(\u0005)Q\u0005\u0003\u007fA\u0011\"!?#\u0001\u0004%I!!\u0010\t\u0013\u0005m(\u00051A\u0005\n\u0005u\b\u0002\u0003B\u0001E\u0001\u0006K!a\u0010\t\u0013\t\u0015!\u00051A\u0005\n\u0005u\u0002\"\u0003B\u0004E\u0001\u0007I\u0011\u0002B\u0005\u0011!\u0011iA\tQ!\n\u0005}\u0002\"\u0003B\tE\t\u0007I\u0011\u0002B\n\u0011!\u0011YB\tQ\u0001\n\tU\u0001\"\u0003B\u000fE\t\u0007I\u0011\u0002B\u0010\u0011!\u00119C\tQ\u0001\n\t\u0005\u0002b\u0002B\u0015E\u0011\u0005!1\u0006\u0005\b\u0005[\u0011C\u0011\u0001B\u0016\u0011\u001d\u0011yC\tC\u0001\u0005WA\u0001B!\r#\t\u00031&1\u0007\u0005\b\u0005w\u0011C\u0011\u0002B\u001f\u0011\u001d\u0011YF\tC\u0005\u0005;BqAa$#\t\u0013\u0011\t\nC\u0004\u00030\n\"IA!-\t\u000f\tU&\u0005\"\u0003\u00038\"A!\u0011\u0018\u0012\u0005\u0002Y\u0013Y,\u0001\nD_:\u001cX/\\3s\u0019\u0006<W)\\5ui\u0016\u0014(BA,Y\u0003\u001diW\r\u001e:jGNT\u0011!W\u0001\u0006W\u000647.Y\u0002\u0001!\ta\u0016!D\u0001W\u0005I\u0019uN\\:v[\u0016\u0014H*Y4F[&$H/\u001a:\u0014\u0005\u0005y\u0006C\u00011d\u001b\u0005\t'\"\u00012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\f'AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u00027\u0006)\u0011\r\u001d9msRY\u0011Na2\u0003J\n-'Q\u001aBh!\ta&e\u0005\u0002#?V\tA\u000e\u0005\u0002nm6\taN\u0003\u0002X_*\u0011\u0001/]\u0001\u0007G>lWn\u001c8\u000b\u0005e\u0013(BA:u\u0003\u0019\t\u0007/Y2iK*\tQ/A\u0002pe\u001eL!a\u001e8\u0003\u000f5+GO]5dg\u0006AQ.\u001a;sS\u000e\u001c\b%\u0001\u0005sK\u001eL7\u000f\u001e:z+\u0005Y\bc\u0001?\u0002\n5\tQP\u0003\u0002\u007f\u007f\u0006!1m\u001c:f\u0015\r9\u0016\u0011\u0001\u0006\u0005\u0003\u0007\t)!\u0001\u0004zC6lWM\u001d\u0006\u0003\u0003\u000f\t1aY8n\u0013\r\tY! \u0002\u0010\u001b\u0016$(/[2t%\u0016<\u0017n\u001d;ss\u0006I!/Z4jgR\u0014\u0018\u0010I\u0001\ng\u000eDW\rZ;mKJ,\"!a\u0005\u0011\t\u0005U\u0011qD\u0007\u0003\u0003/QA!!\u0007\u0002\u001c\u0005!Q\u000f^5m\u0015\r\ti\"]\u0001\u0007g\u0016\u0014h/\u001a:\n\t\u0005\u0005\u0012q\u0003\u0002\n'\u000eDW\rZ;mKJ\f!b]2iK\u0012,H.\u001a:!\u0003A9'o\\;q\u0007>|'\u000fZ5oCR|'/\u0006\u0002\u0002*A!\u00111FA\u001b\u001b\t\tiC\u0003\u0003\u00020\u0005E\u0012!B4s_V\u0004(bAA\u001ac\u0006Y1m\\8sI&t\u0017\r^8s\u0013\u0011\t9$!\f\u0003!\u001d\u0013x.\u001e9D_>\u0014H-\u001b8bi>\u0014\u0018!E4s_V\u00048i\\8sI&t\u0017\r^8sA\u0005qQ-\\5u\u0013:$XM\u001d<bY6\u001bXCAA !\r\u0001\u0017\u0011I\u0005\u0004\u0003\u0007\n'\u0001\u0002'p]\u001e\fq\"Z7ji&sG/\u001a:wC2l5\u000fI\u0001\u0006C\u0012l\u0017N\\\u000b\u0003\u0003\u0017\u0002B!!\u0014\u0002V5\u0011\u0011q\n\u0006\u0005\u0003\u000f\n\tFC\u0002\u0002TE\fqa\u00197jK:$8/\u0003\u0003\u0002X\u0005=#!B!e[&t\u0017AB1e[&t\u0007\u0005F\u0007j\u0003;\ny&!\u0019\u0002d\u0005\u0015\u0014q\r\u0005\u0006/>\u0002\r\u0001\u001c\u0005\u0006s>\u0002\ra\u001f\u0005\b\u0003\u001fy\u0003\u0019AA\n\u0011\u001d\t)c\fa\u0001\u0003SA\u0011\"a\u000f0!\u0003\u0005\r!a\u0010\t\u000f\u0005\u001ds\u00061\u0001\u0002L\u0005\u00112m\u001c8tk6,'\u000fT1h\u001b\u0016$(/[2t+\t\ti\u0007\u0005\u0005\u0002p\u0005e\u0014QPAJ\u001b\t\t\tH\u0003\u0003\u0002t\u0005U\u0014aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003o\n\u0017AC2pY2,7\r^5p]&!\u00111PA9\u0005\ri\u0015\r\u001d\t\u0005\u0003\u007f\niI\u0004\u0003\u0002\u0002\u0006%\u0005cAABC6\u0011\u0011Q\u0011\u0006\u0004\u0003\u000fS\u0016A\u0002\u001fs_>$h(C\u0002\u0002\f\u0006\fa\u0001\u0015:fI\u00164\u0017\u0002BAH\u0003#\u0013aa\u0015;sS:<'bAAFCBA\u0011QSAN\u0003?\u000by$\u0004\u0002\u0002\u0018*\u0019\u0011\u0011\u00148\u0002\u0013%tG/\u001a:oC2\u001c\u0018\u0002BAO\u0003/\u0013!bR1vO\u0016\u001cV/\u001b;f!\ra\u0016\u0011U\u0005\u0004\u0003G3&\u0001F'f[\n,'\u000fV8qS\u000e\u0004\u0016M\u001d;ji&|g.A\nd_:\u001cX/\\3s\u0019\u0006<W*\u001a;sS\u000e\u001c\b%\u0001\tva\u0012\fG/\u001a3He>,\boU5{KV\u0011\u00111\u0016\t\u0004A\u00065\u0016bAAXC\n\u0019\u0011J\u001c;\u0002)U\u0004H-\u0019;fI\u001e\u0013x.\u001e9TSj,w\fJ3r)\u0011\t),a/\u0011\u0007\u0001\f9,C\u0002\u0002:\u0006\u0014A!\u00168ji\"I\u0011QX\u001a\u0002\u0002\u0003\u0007\u00111V\u0001\u0004q\u0012\n\u0014!E;qI\u0006$X\rZ$s_V\u00048+\u001b>fA!\u001aA'a1\u0011\u0007\u0001\f)-C\u0002\u0002H\u0006\u0014\u0001B^8mCRLG.Z\u0001\u0015e\u0016\u0014\u0017\r\\1oG&twm\u0012:pkB\u001c\u0016N_3\u00021I,'-\u00197b]\u000eLgnZ$s_V\u00048+\u001b>f?\u0012*\u0017\u000f\u0006\u0003\u00026\u0006=\u0007\"CA_m\u0005\u0005\t\u0019AAV\u0003U\u0011XMY1mC:\u001c\u0017N\\4He>,\boU5{K\u0002B3aNAb\u0003=1\u0017-\u001b7fI\u001e\u0013x.\u001e9TSj,\u0017a\u00054bS2,Gm\u0012:pkB\u001c\u0016N_3`I\u0015\fH\u0003BA[\u00037D\u0011\"!0:\u0003\u0003\u0005\r!a+\u0002!\u0019\f\u0017\u000e\\3e\u000fJ|W\u000f]*ju\u0016\u0004\u0003f\u0001\u001e\u0002D\u0006\u0001R\r\u001f9je\u0016$wI]8vaNK'0Z\u0001\u0015Kb\u0004\u0018N]3e\u000fJ|W\u000f]*ju\u0016|F%Z9\u0015\t\u0005U\u0016q\u001d\u0005\n\u0003{c\u0014\u0011!a\u0001\u0003W\u000b\u0011#\u001a=qSJ,Gm\u0012:pkB\u001c\u0016N_3!Q\ri\u00141Y\u0001\f[\u0016$(/[2t'&TX-A\bnKR\u0014\u0018nY:TSj,w\fJ3r)\u0011\t),a=\t\u0013\u0005uv(!AA\u0002\u0005}\u0012\u0001D7fiJL7m]*ju\u0016\u0004\u0003f\u0001!\u0002D\u0006iQ\r_3dkRLwN\u001c+j[\u0016\f\u0011#\u001a=fGV$\u0018n\u001c8US6,w\fJ3r)\u0011\t),a@\t\u0013\u0005u&)!AA\u0002\u0005}\u0012AD3yK\u000e,H/[8o)&lW\r\t\u0015\u0004\u0007\u0006\r\u0017a\u00057bgR\u001cVoY2fgN4W\u000f\u001c*v]6\u001b\u0018a\u00067bgR\u001cVoY2fgN4W\u000f\u001c*v]6\u001bx\fJ3r)\u0011\t)La\u0003\t\u0013\u0005uV)!AA\u0002\u0005}\u0012\u0001\u00067bgR\u001cVoY2fgN4W\u000f\u001c*v]6\u001b\b\u0005K\u0002G\u0003\u0007\f!\"\\3nE\u0016\u00148+\u001b>f+\t\u0011)\u0002E\u0002}\u0005/I1A!\u0007~\u0005)iU\r\u001e:jG:\u000bW.Z\u0001\f[\u0016l'-\u001a:TSj,\u0007%A\nnK6\u0014WM]*ju\u0016D\u0015n\u001d;pOJ\fW.\u0006\u0002\u0003\"A\u0019APa\t\n\u0007\t\u0015RPA\u0005ISN$xn\u001a:b[\u0006!R.Z7cKJ\u001c\u0016N_3ISN$xn\u001a:b[\u0002\nQa\u001d;beR$\"!!.\u0002\u0011MDW\u000f\u001e3po:\fq\"Z7ji\u000e{gn];nKJd\u0015mZ\u0001\u0019M\u0016$8\r[(gMN,Go]!oIJ+7m\u001c:e\u0019\u0006<GC\u0001B\u001b!\ra&qG\u0005\u0004\u0005s1&!G\"p]N,X.\u001a:MC\u001e,U.\u001b;uKJ\u001cV/\\7bef\f!#\\1lKJ+\u0017/^3ti\u000e{g\u000e^3yiR!!q\bB&!\u0011\u0011\tEa\u0012\u000e\u0005\t\r#b\u0001B#_\u0006A!/Z9vKN$8/\u0003\u0003\u0003J\t\r#A\u0004*fcV,7\u000f^\"p]R,\u0007\u0010\u001e\u0005\b\u0005\u001bz\u0005\u0019\u0001B(\u0003\u0019\t\u0007/[&fsB!!\u0011\u000bB,\u001b\t\u0011\u0019FC\u0002\u0003V=\f\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u00053\u0012\u0019FA\u0004Ba&\\U-_:\u0002\u001d\u0011,7o\u0019:jE\u0016<%o\\;qgR!!q\fBC!\u0019\u0011\tGa\u001b\u0003r9!!1\rB4\u001d\u0011\t\u0019I!\u001a\n\u0003\tL1A!\u001bb\u0003\u001d\u0001\u0018mY6bO\u0016LAA!\u001c\u0003p\t!A*[:u\u0015\r\u0011I'\u0019\t\u0005\u0005g\u0012yH\u0004\u0003\u0003v\tmTB\u0001B<\u0015\r\u0011Ih\\\u0001\b[\u0016\u001c8/Y4f\u0013\u0011\u0011iHa\u001e\u00025\u0011+7o\u0019:jE\u0016<%o\\;qgJ+7\u000f]8og\u0016$\u0015\r^1\n\t\t\u0005%1\u0011\u0002\u000f\t\u0016\u001c8M]5cK\u0012<%o\\;q\u0015\u0011\u0011iHa\u001e\t\u000f\t\u001d\u0005\u000b1\u0001\u0003\n\u000611\u000f^1uKN\u0004b!a \u0003\f\u0006u\u0014\u0002\u0002BG\u0003#\u00131aU3u\u0003=1W\r^2i\u00032dwJ\u001a4tKR\u001cH\u0003\u0002BJ\u0005W\u0003\u0002\"a\u001c\u0002z\tU%Q\u0014\t\u0005\u0005/\u0013I*D\u0001p\u0013\r\u0011Yj\u001c\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o!\u0011\u0011yJ!*\u000f\t\tU$\u0011U\u0005\u0005\u0005G\u00139(A\fPM\u001a\u001cX\r\u001e$fi\u000eD'+Z:q_:\u001cX\rR1uC&!!q\u0015BU\u0005uyeMZ:fi\u001a+Go\u00195SKN\u0004xN\\:f!\u0006\u0014H/\u001b;j_:\u001c(\u0002\u0002BR\u0005oBqA!,R\u0001\u0004\ti(A\u0004he>,\b/\u00133\u0002!\r\u0014X-\u0019;f\u000f\u0006,x-Z*vSR,G\u0003BAJ\u0005gCqA!,S\u0001\u0004\ti(\u0001\ndkJ\u0014XM\u001c;NKR\u0014\u0018nY:TSj,GCAA \u00031j\u0017-\u001f2f!J,g-\u001b=U_BL7\rU1si&$\u0018n\u001c8t/&$\b\u000eV3oC:$h)\u001e8di&|g\u000e\u0006\u0003\u0003>\n\u0015\u0007c\u00021\u0003@\n\r'1Y\u0005\u0004\u0005\u0003\f'!\u0003$v]\u000e$\u0018n\u001c82!\u0019\u0011\tGa\u001b\u0003\u0016\"9!Q\u0016+A\u0002\u0005u\u0004\"B,\u0004\u0001\u0004a\u0007\"B=\u0004\u0001\u0004Y\bbBA\u0013\u0007\u0001\u0007\u0011\u0011\u0006\u0005\n\u0003w\u0019\u0001\u0013!a\u0001\u0003\u007fAqA!5\u0004\u0001\u0004\u0011\u0019.\u0001\u0006bI6Lg\u000e\u0015:paN\u0004\u0002B!6\u0003^\u0006u$q\\\u0007\u0003\u0005/TA!!\u0007\u0003Z*\u0011!1\\\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002|\t]\u0007\u0003\u0002Bq\u0005Ol!Aa9\u000b\t\t\u0015(\u0011\\\u0001\u0005Y\u0006tw-\u0003\u0003\u0003j\n\r(AB(cU\u0016\u001cG/A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011yO\u000b\u0003\u0002@\tE8F\u0001Bz!\u0011\u0011)Pa@\u000e\u0005\t](\u0002\u0002B}\u0005w\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\tu\u0018-\u0001\u0006b]:|G/\u0019;j_:LAa!\u0001\u0003x\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002+\r{gn];nKJd\u0015mZ'fiJL7MT1nKV\u00111q\u0001\t\u0005\u0005C\u001cI!\u0003\u0003\u0002\u0010\n\r\u0018AF\"p]N,X.\u001a:MC\u001elU\r\u001e:jG:\u000bW.\u001a\u0011\u0002\u001f5+GO]5d\u000fJ|W\u000f\u001d(b[\u0016\f\u0001#T3ue&\u001cwI]8va:\u000bW.\u001a\u0011\u00025U\u0003H-\u0019;fI\u001e\u0013x.\u001e9TSj,W*\u001a;sS\u000et\u0015-\\3\u00027U\u0003H-\u0019;fI\u001e\u0013x.\u001e9TSj,W*\u001a;sS\u000et\u0015-\\3!\u0003y\u0011VMY1mC:\u001c\u0017N\\4He>,\boU5{K6+GO]5d\u001d\u0006lW-A\u0010SK\n\fG.\u00198dS:<wI]8vaNK'0Z'fiJL7MT1nK\u0002\n\u0011DR1jY\u0016$wI]8vaNK'0Z'fiJL7MT1nK\u0006Qb)Y5mK\u0012<%o\\;q'&TX-T3ue&\u001cg*Y7fA\u0005QR\t\u001f9je\u0016$wI]8vaNK'0Z'fiJL7MT1nK\u0006YR\t\u001f9je\u0016$wI]8vaNK'0Z'fiJL7MT1nK\u0002\nQ#T3ue&\u001c7oU5{K6+GO]5d\u001d\u0006lW-\u0001\fNKR\u0014\u0018nY:TSj,W*\u001a;sS\u000et\u0015-\\3!\u0003])\u00050Z2vi&|g\u000eV5nK6+GO]5d\u001d\u0006lW-\u0001\rFq\u0016\u001cW\u000f^5p]RKW.Z'fiJL7MT1nK\u0002\na\u0005V5nKNKgnY3MCN$8+^2dKN\u001ch-\u001e7Sk:l5/T3ue&\u001cg*Y7f\u0003\u001d\"\u0016.\\3TS:\u001cW\rT1tiN+8mY3tg\u001a,HNU;o\u001bNlU\r\u001e:jG:\u000bW.\u001a\u0011\u0002)5+WNY3s'&TX-T3ue&\u001cg*Y7f\u0003UiU-\u001c2feNK'0Z'fiJL7MT1nK\u0002\n1BV1mS\u0012\u001cF/\u0019;fgV\u00111Q\u0007\t\u0007\u0007o\u0019ida\u0002\u000e\u0005\re\"\u0002BB\u001e\u0003k\n\u0011\"[7nkR\f'\r\\3\n\t\t55\u0011H\u0001\r-\u0006d\u0017\u000eZ*uCR,7\u000fI\u0001\u0012%\u0016\u0014\u0017\r\\1oG&twm\u0015;bi\u0016\u001c\u0018A\u0005*fE\u0006d\u0017M\\2j]\u001e\u001cF/\u0019;fg\u0002\n1\u0001\\8h+\t\u0019I\u0005\u0005\u0003\u0004L\rESBAB'\u0015\r\u0019y\u0005^\u0001\u0006g24GG[\u0005\u0005\u0007'\u001aiE\u0001\u0004M_\u001e<WM]\u0001\u0005Y><\u0007%A\u0007hCV<WmU;ji\u0016dunZ\u0001\u000fO\u0006,x-Z*vSR,Gj\\4!\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%k\u0001")
public class ConsumerLagEmitter {
    private final Metrics metrics;
    private final MetricsRegistry registry;
    private final Scheduler scheduler;
    private final GroupCoordinator groupCoordinator;
    private final long emitIntervalMs;
    private final Admin admin;
    private final scala.collection.mutable.Map<String, GaugeSuite<MemberTopicPartition, Object>> consumerLagMetrics;
    private volatile int kafka$metrics$ConsumerLagEmitter$$updatedGroupSize;
    private volatile int kafka$metrics$ConsumerLagEmitter$$rebalancingGroupSize;
    private volatile int kafka$metrics$ConsumerLagEmitter$$failedGroupSize;
    private volatile int kafka$metrics$ConsumerLagEmitter$$expiredGroupSize;
    private volatile long kafka$metrics$ConsumerLagEmitter$$metricsSize;
    private volatile long kafka$metrics$ConsumerLagEmitter$$executionTime;
    private volatile long kafka$metrics$ConsumerLagEmitter$$lastSuccessfulRunMs;
    private final MetricName memberSize;
    private final Histogram memberSizeHistogram;

    public static long $lessinit$greater$default$5() {
        return 60000L;
    }

    public static String MemberSizeMetricName() {
        return ConsumerLagEmitter$.MODULE$.MemberSizeMetricName();
    }

    public static String TimeSinceLastSuccessfulRunMsMetricName() {
        return ConsumerLagEmitter$.MODULE$.TimeSinceLastSuccessfulRunMsMetricName();
    }

    public static String ExecutionTimeMetricName() {
        return ConsumerLagEmitter$.MODULE$.ExecutionTimeMetricName();
    }

    public static String MetricsSizeMetricName() {
        return ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName();
    }

    public static String ExpiredGroupSizeMetricName() {
        return ConsumerLagEmitter$.MODULE$.ExpiredGroupSizeMetricName();
    }

    public static String FailedGroupSizeMetricName() {
        return ConsumerLagEmitter$.MODULE$.FailedGroupSizeMetricName();
    }

    public static String RebalancingGroupSizeMetricName() {
        return ConsumerLagEmitter$.MODULE$.RebalancingGroupSizeMetricName();
    }

    public static String UpdatedGroupSizeMetricName() {
        return ConsumerLagEmitter$.MODULE$.UpdatedGroupSizeMetricName();
    }

    public static String MetricGroupName() {
        return ConsumerLagEmitter$.MODULE$.MetricGroupName();
    }

    public static String ConsumerLagMetricName() {
        return ConsumerLagEmitter$.MODULE$.ConsumerLagMetricName();
    }

    public static long apply$default$4() {
        return 60000L;
    }

    public static ConsumerLagEmitter apply(Metrics metrics, MetricsRegistry registry, GroupCoordinator groupCoordinator, long emitIntervalMs, Map<String, Object> adminProps) {
        return ConsumerLagEmitter$.MODULE$.apply(metrics, registry, groupCoordinator, emitIntervalMs, adminProps);
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public MetricsRegistry registry() {
        return this.registry;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public GroupCoordinator groupCoordinator() {
        return this.groupCoordinator;
    }

    public long emitIntervalMs() {
        return this.emitIntervalMs;
    }

    public Admin admin() {
        return this.admin;
    }

    public scala.collection.mutable.Map<String, GaugeSuite<MemberTopicPartition, Object>> consumerLagMetrics() {
        return this.consumerLagMetrics;
    }

    public int kafka$metrics$ConsumerLagEmitter$$updatedGroupSize() {
        return this.kafka$metrics$ConsumerLagEmitter$$updatedGroupSize;
    }

    private void updatedGroupSize_$eq(int x$1) {
        this.kafka$metrics$ConsumerLagEmitter$$updatedGroupSize = x$1;
    }

    public int kafka$metrics$ConsumerLagEmitter$$rebalancingGroupSize() {
        return this.kafka$metrics$ConsumerLagEmitter$$rebalancingGroupSize;
    }

    private void rebalancingGroupSize_$eq(int x$1) {
        this.kafka$metrics$ConsumerLagEmitter$$rebalancingGroupSize = x$1;
    }

    public int kafka$metrics$ConsumerLagEmitter$$failedGroupSize() {
        return this.kafka$metrics$ConsumerLagEmitter$$failedGroupSize;
    }

    private void failedGroupSize_$eq(int x$1) {
        this.kafka$metrics$ConsumerLagEmitter$$failedGroupSize = x$1;
    }

    public int kafka$metrics$ConsumerLagEmitter$$expiredGroupSize() {
        return this.kafka$metrics$ConsumerLagEmitter$$expiredGroupSize;
    }

    private void expiredGroupSize_$eq(int x$1) {
        this.kafka$metrics$ConsumerLagEmitter$$expiredGroupSize = x$1;
    }

    public long kafka$metrics$ConsumerLagEmitter$$metricsSize() {
        return this.kafka$metrics$ConsumerLagEmitter$$metricsSize;
    }

    private void metricsSize_$eq(long x$1) {
        this.kafka$metrics$ConsumerLagEmitter$$metricsSize = x$1;
    }

    public long kafka$metrics$ConsumerLagEmitter$$executionTime() {
        return this.kafka$metrics$ConsumerLagEmitter$$executionTime;
    }

    private void executionTime_$eq(long x$1) {
        this.kafka$metrics$ConsumerLagEmitter$$executionTime = x$1;
    }

    public long kafka$metrics$ConsumerLagEmitter$$lastSuccessfulRunMs() {
        return this.kafka$metrics$ConsumerLagEmitter$$lastSuccessfulRunMs;
    }

    private void lastSuccessfulRunMs_$eq(long x$1) {
        this.kafka$metrics$ConsumerLagEmitter$$lastSuccessfulRunMs = x$1;
    }

    private MetricName memberSize() {
        return this.memberSize;
    }

    private Histogram memberSizeHistogram() {
        return this.memberSizeHistogram;
    }

    public void start() {
        ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().info("Consumer lag emitter starting up.");
        this.scheduler().startup();
        this.scheduler().schedule("emit-consumer-lag-", () -> this.emitConsumerLag(), this.emitIntervalMs(), this.emitIntervalMs());
    }

    public void shutdown() {
        ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().info("Consumer lag emitter shutting down.");
        this.consumerLagMetrics().foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2 & Serializable)(x$1, gaugeSuite) -> {
            gaugeSuite.close();
            return BoxedUnit.UNIT;
        }, arg_0, arg_1));
        this.metrics().removeMetric(this.metrics().metricName(ConsumerLagEmitter$.MODULE$.UpdatedGroupSizeMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()));
        this.metrics().removeMetric(this.metrics().metricName(ConsumerLagEmitter$.MODULE$.RebalancingGroupSizeMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()));
        this.metrics().removeMetric(this.metrics().metricName(ConsumerLagEmitter$.MODULE$.FailedGroupSizeMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()));
        this.metrics().removeMetric(this.metrics().metricName(ConsumerLagEmitter$.MODULE$.ExpiredGroupSizeMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()));
        this.metrics().removeMetric(this.metrics().metricName(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()));
        this.metrics().removeMetric(this.metrics().metricName(ConsumerLagEmitter$.MODULE$.ExecutionTimeMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()));
        this.metrics().removeMetric(this.metrics().metricName(ConsumerLagEmitter$.MODULE$.TimeSinceLastSuccessfulRunMsMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()));
        this.registry().removeMetric(this.memberSize());
        this.scheduler().shutdown();
        if (this.admin() != null) {
            this.admin().close();
        }
        ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().info("Consumer lag emitter shutdown complete.");
    }

    public void emitConsumerLag() {
        try {
            ConsumerLagEmitterSummary result = this.fetchOffsetsAndRecordLag();
            this.updatedGroupSize_$eq(result.updatedGroupSize());
            this.rebalancingGroupSize_$eq(result.rebalancingGroupSize());
            this.failedGroupSize_$eq(result.failedGroupSize());
            this.expiredGroupSize_$eq(result.expiredGroupSize());
            this.metricsSize_$eq(result.metricsSize());
            this.executionTime_$eq(result.executionTime());
            this.lastSuccessfulRunMs_$eq(System.currentTimeMillis());
            ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().info(new StringBuilder(113).append("Updated lag of ").append(this.kafka$metrics$ConsumerLagEmitter$$updatedGroupSize()).append(" groups, ").append("ignored ").append(this.kafka$metrics$ConsumerLagEmitter$$rebalancingGroupSize()).append(" rebalancing groups, ").append("failed to update ").append(this.kafka$metrics$ConsumerLagEmitter$$failedGroupSize()).append(" groups due to errors, ").append("and expired ").append(this.kafka$metrics$ConsumerLagEmitter$$expiredGroupSize()).append(" groups.").toString());
            return;
        }
        catch (Throwable t) {
            ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().error("Could not update consumer lag metrics.", t);
            return;
        }
    }

    public ConsumerLagEmitterSummary fetchOffsetsAndRecordLag() {
        long startTime = System.currentTimeMillis();
        scala.collection.mutable.Map groupsToCurrentOffsets = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        scala.collection.mutable.Set rebalancingGroups = (scala.collection.mutable.Set)Set$.MODULE$.empty();
        scala.collection.mutable.Set failedGroups = (scala.collection.mutable.Set)Set$.MODULE$.empty();
        List<DescribeGroupsResponseData.DescribedGroup> describedGroups = this.describeGroups(ConsumerLagEmitter$.MODULE$.ValidStates());
        this.memberSizeHistogram().clear();
        describedGroups.foreach((Function1 & Serializable)describedGroup -> {
            String groupId = describedGroup.groupId();
            if (describedGroup.errorCode() == Errors.NOT_COORDINATOR.code()) {
                ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().debug(new StringBuilder(69).append("Ignoring group ").append(groupId).append(" because it is not hosted on this coordinator anymore.").toString());
                return BoxedUnit.UNIT;
            }
            if (describedGroup.errorCode() != Errors.NONE.code()) {
                ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().debug(new StringBuilder(62).append("Could not describe group ").append(groupId).append(" due to ").append(Errors.forCode((short)describedGroup.errorCode())).append(". ").append("Will retry in the next run.").toString());
                return failedGroups.$plus$eq((Object)groupId);
            }
            this.memberSizeHistogram().update(describedGroup.members().size());
            String string = describedGroup.protocolType();
            String string2 = "consumer";
            if (string == null || !string.equals(string2)) {
                ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().debug(new StringBuilder(44).append("Group ").append(groupId).append(" is not a consumer group. Ignoring it.").toString());
                return BoxedUnit.UNIT;
            }
            if (ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$RebalancingStates().contains((Object)describedGroup.groupState())) {
                return rebalancingGroups.$plus$eq((Object)groupId);
            }
            String string3 = describedGroup.groupState();
            String string4 = ConsumerGroupState.STABLE.toString();
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                Growable growable;
                try {
                    scala.collection.mutable.Map<TopicPartition, OffsetFetchResponseData.OffsetFetchResponsePartitions> currentOffsets = this.fetchAllOffsets(groupId);
                    scala.collection.mutable.Map memberTopicPartitions = (scala.collection.mutable.Map)groupsToCurrentOffsets.getOrElse((Object)groupId, (Function0 & Serializable)() -> (scala.collection.mutable.Map)Map$.MODULE$.empty());
                    Function1<List<TopicPartition>, List<TopicPartition>> maybePrefixTopicPartitions = this.maybePrefixTopicPartitionsWithTenantFunction(groupId);
                    CollectionConverters$.MODULE$.ListHasAsScala(describedGroup.members()).asScala().foreach((Function1 & Serializable)member -> {
                        ConsumerLagEmitter.$anonfun$fetchOffsetsAndRecordLag$3(maybePrefixTopicPartitions, currentOffsets, groupId, memberTopicPartitions, member);
                        return BoxedUnit.UNIT;
                    });
                    if (!memberTopicPartitions.nonEmpty()) {
                        return BoxedUnit.UNIT;
                    }
                    growable = groupsToCurrentOffsets.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)groupId), (Object)memberTopicPartitions));
                }
                catch (NotCoordinatorException notCoordinatorException) {
                    ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().debug(new StringBuilder(69).append("Ignoring group ").append(groupId).append(" because it is not hosted on this coordinator anymore.").toString());
                    return BoxedUnit.UNIT;
                }
                catch (Throwable t) {
                    ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().debug(new StringBuilder(70).append("Could not fetch offsets of group ").append(groupId).append(" due to ").append(t.getMessage()).append(". Will retry in the next run.").toString());
                    growable = failedGroups.$plus$eq((Object)groupId);
                }
                return growable;
            }
            return BoxedUnit.UNIT;
        });
        if (groupsToCurrentOffsets.nonEmpty()) {
            Map latestOffsetSpec = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)groupsToCurrentOffsets.flatMap((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    return (scala.collection.mutable.Map)((scala.collection.mutable.Map)x0$1._2()).map((Function1 & Serializable)x0$2 -> {
                        if (x0$2 != null) {
                            MemberTopicPartition memberTopicPartition = (MemberTopicPartition)x0$2._1();
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)memberTopicPartition.topicPartition()), (Object)new OffsetSpec.LatestSpec());
                        }
                        throw new MatchError(null);
                    });
                }
                throw new MatchError(null);
            })).asJava();
            ListOffsetsResult result = this.admin().listOffsets(latestOffsetSpec);
            Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(groupId, memberTopicPartitions) -> {
                GaugeSuite groupGaugeSuite = (GaugeSuite)this.consumerLagMetrics().getOrElse(groupId, (Function0 & Serializable)() -> this.createGaugeSuite((String)groupId));
                Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(memberTopicPartition, currentOffset) -> {
                    ConsumerLagEmitter.$anonfun$fetchOffsetsAndRecordLag$9(result, groupGaugeSuite, memberTopicPartition, BoxesRunTime.unboxToLong((Object)currentOffset));
                    return BoxedUnit.UNIT;
                };
                memberTopicPartitions.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
                Object var5_5 = null;
                return (scala.collection.mutable.Map)this.consumerLagMetrics().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(groupId), (Object)groupGaugeSuite));
            };
            groupsToCurrentOffsets.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
            Object var12_8 = null;
        }
        scala.collection.immutable.Set expiredGroups = ((MapOps)this.consumerLagMetrics().filterNot((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)ConsumerLagEmitter.$anonfun$fetchOffsetsAndRecordLag$10(groupsToCurrentOffsets, rebalancingGroups, failedGroups, x0$3)))).keys().toSet();
        expiredGroups.foreach((Function1 & Serializable)groupId -> {
            ConsumerLagEmitter.$anonfun$fetchOffsetsAndRecordLag$12(this, groupId);
            return BoxedUnit.UNIT;
        });
        long executionTime = System.currentTimeMillis() - startTime;
        return new ConsumerLagEmitterSummary(groupsToCurrentOffsets.keySet().size(), rebalancingGroups.size(), failedGroups.size(), expiredGroups.size(), this.currentMetricsSize(), executionTime);
    }

    private RequestContext makeRequestContext(ApiKeys apiKey) {
        return new RequestContext(new RequestHeader(apiKey, apiKey.latestVersion(), ConsumerLagEmitter$.MODULE$.MetricGroupName(), 0), "-1", InetAddress.getLocalHost(), KafkaPrincipal.ANONYMOUS, ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), SecurityProtocol.PLAINTEXT, ClientInformation.EMPTY, null, false);
    }

    private List<DescribeGroupsResponseData.DescribedGroup> describeGroups(scala.collection.immutable.Set<String> states) {
        try {
            return (List)((CompletableFuture)this.groupCoordinator().listGroups(this.makeRequestContext(ApiKeys.LIST_GROUPS), new ListGroupsRequestData().setStatesFilter(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)states.toList()).asJava())).thenCompose(listGroupsResult -> {
                if (listGroupsResult.errorCode() != Errors.NONE.code()) {
                    CompletableFuture future = new CompletableFuture();
                    future.completeExceptionally(Errors.forCode((short)listGroupsResult.errorCode()).exception());
                    return future;
                }
                if (listGroupsResult.groups().isEmpty()) {
                    CompletableFuture<List> future = new CompletableFuture<List>();
                    future.complete(package$.MODULE$.List().empty());
                    return future;
                }
                return this.groupCoordinator().describeGroups(this.makeRequestContext(ApiKeys.DESCRIBE_GROUPS), CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(listGroupsResult.groups()).asScala().map((Function1 & Serializable)x$3 -> x$3.groupId())).asJava()).thenApply(x$4 -> CollectionConverters$.MODULE$.ListHasAsScala(x$4).asScala().toList());
            })).get(30L, TimeUnit.SECONDS);
        }
        catch (Throwable throwable) {
            ExecutionException executionException;
            if (throwable instanceof ExecutionException && (executionException = (ExecutionException)throwable).getCause() != null) {
                throw executionException.getCause();
            }
            throw throwable;
        }
    }

    private scala.collection.mutable.Map<TopicPartition, OffsetFetchResponseData.OffsetFetchResponsePartitions> fetchAllOffsets(String groupId) {
        try {
            return (scala.collection.mutable.Map)((CompletableFuture)this.groupCoordinator().fetchAllOffsets(this.makeRequestContext(ApiKeys.OFFSET_FETCH), new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId(groupId), false).thenApply(response -> {
                HashMap byTopicPartitions = new HashMap();
                response.topics().forEach(topic -> topic.partitions().forEach(partition -> {
                    TopicPartition tp = new TopicPartition(topic.name(), partition.partitionIndex());
                    byTopicPartitions.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), partition));
                }));
                return byTopicPartitions;
            })).get(30L, TimeUnit.SECONDS);
        }
        catch (Throwable throwable) {
            ExecutionException executionException;
            if (throwable instanceof ExecutionException && (executionException = (ExecutionException)throwable).getCause() != null) {
                throw executionException.getCause();
            }
            throw throwable;
        }
    }

    private GaugeSuite<MemberTopicPartition, Object> createGaugeSuite(String groupId) {
        return new GaugeSuite(ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$gaugeSuiteLog(), new StringBuilder(21).append("consumer-lag-emitter-").append(groupId).toString(), this.metrics(), memberTopicPartition -> this.metrics().metricName(ConsumerLagEmitter$.MODULE$.ConsumerLagMetricName(), "tenant-metrics", "The group member's consumer lag in offsets.", CollectionConverters$.MODULE$.MutableMapHasAsJava(memberTopicPartition.tags()).asJava()));
    }

    private long currentMetricsSize() {
        return BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.consumerLagMetrics().map((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)ConsumerLagEmitter.$anonfun$currentMetricsSize$1(x0$1)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public Function1<List<TopicPartition>, List<TopicPartition>> maybePrefixTopicPartitionsWithTenantFunction(String groupId) {
        if (TenantHelpers.isTenantPrefixed(groupId)) {
            return arg_0 -> ConsumerLagEmitter.$anonfun$maybePrefixTopicPartitionsWithTenantFunction$1(TenantHelpers.extractTenantPrefix(groupId), arg_0);
        }
        return (Function1 & Serializable)topicPartitions -> topicPartitions;
    }

    public static final /* synthetic */ void $anonfun$fetchOffsetsAndRecordLag$3(Function1 maybePrefixTopicPartitions$1, scala.collection.mutable.Map currentOffsets$1, String groupId$1, scala.collection.mutable.Map memberTopicPartitions$1, DescribeGroupsResponseData.DescribedGroupMember member) {
        try {
            ConsumerPartitionAssignor.Assignment assignment = ConsumerProtocol.deserializeAssignment((ByteBuffer)ByteBuffer.wrap(member.memberAssignment()));
            ((List)maybePrefixTopicPartitions$1.apply((Object)CollectionConverters$.MODULE$.ListHasAsScala(assignment.partitions()).asScala().toList())).foreach((Function1 & Serializable)topicPartition -> {
                Option option = currentOffsets$1.get(topicPartition);
                if (option instanceof Some) {
                    Errors error;
                    OffsetFetchResponseData.OffsetFetchResponsePartitions currentOffset = (OffsetFetchResponseData.OffsetFetchResponsePartitions)((Some)option).value();
                    Errors errors = error = Errors.forCode((short)currentOffset.errorCode());
                    Errors errors2 = Errors.NONE;
                    if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                        ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().debug(new StringBuilder(93).append("Could not get committed offset for group ").append(groupId$1).append(" and partition ").append(topicPartition).append(" due to ").append(error).append(". Will retry in the next run.").toString());
                        return BoxedUnit.UNIT;
                    }
                    MemberTopicPartition memberTopicPartition = new MemberTopicPartition(groupId$1, (Option<String>)Option$.MODULE$.apply((Object)member.groupInstanceId()), member.memberId(), member.clientId(), (TopicPartition)topicPartition);
                    return memberTopicPartitions$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)memberTopicPartition), (Object)BoxesRunTime.boxToLong((long)currentOffset.committedOffset())));
                }
                if (None$.MODULE$.equals(option)) {
                    ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().debug(new StringBuilder(72).append("Group coordinator does not have offsets for group ").append(groupId$1).append(" and topic partition ").append(topicPartition).append(".").toString());
                    return BoxedUnit.UNIT;
                }
                throw new MatchError((Object)option);
            });
            return;
        }
        catch (SchemaException e) {
            ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().debug(new StringBuilder(66).append("Failed to deserialize assignment(length=").append(member.memberAssignment().length).append(") for group ").append(groupId$1).append(" and member ").append(member.memberId()).append(": ").append(e.getMessage()).toString());
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$fetchOffsetsAndRecordLag$9(ListOffsetsResult result$1, GaugeSuite groupGaugeSuite$1, MemberTopicPartition memberTopicPartition, long currentOffset) {
        try {
            long latestOffset = ((ListOffsetsResult.ListOffsetsResultInfo)result$1.partitionResult(memberTopicPartition.topicPartition()).get()).offset();
            long consumerLag = latestOffset - currentOffset;
            if (consumerLag >= 0L) {
                groupGaugeSuite$1.update((Object)memberTopicPartition, (Object)BoxesRunTime.boxToLong((long)consumerLag));
                return;
            }
            ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().warn(new StringBuilder(115).append("Consumer lag of member ").append(memberTopicPartition).append(" is negative. Latest offset is ").append(latestOffset).append(" ").append("and committed offset is ").append(currentOffset).append(". The topic may have been recreated.").toString());
            groupGaugeSuite$1.update((Object)memberTopicPartition, (Object)BoxesRunTime.boxToLong((long)0L));
        }
        catch (ExecutionException e) {
            ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().debug(new StringBuilder(45).append("Could not list offsets for partition ").append(memberTopicPartition.topicPartition()).append(" due to ").append(e.getCause().getMessage()).toString());
            return;
        }
        catch (InterruptedException e) {
            ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().debug(new StringBuilder(45).append("Unable to list offsets for partition ").append(memberTopicPartition.topicPartition()).append(" due to ").append(e.getCause()).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$fetchOffsetsAndRecordLag$10(scala.collection.mutable.Map groupsToCurrentOffsets$1, scala.collection.mutable.Set rebalancingGroups$1, scala.collection.mutable.Set failedGroups$1, Tuple2 x0$3) {
        if (x0$3 != null) {
            String groupId = (String)x0$3._1();
            GaugeSuite groupGaugeSuite = (GaugeSuite)x0$3._2();
            if (groupsToCurrentOffsets$1.contains((Object)groupId)) {
                Set currentMemberTopicPartitions = ((MapOps)groupsToCurrentOffsets$1.apply((Object)groupId)).keySet();
                ((scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(groupGaugeSuite.keySet()).asScala().diff(currentMemberTopicPartitions)).foreach((Function1 & Serializable)x$1 -> {
                    groupGaugeSuite.remove((Object)x$1);
                    return BoxedUnit.UNIT;
                });
                groupGaugeSuite.flush();
                return groupGaugeSuite.keySet().size() != 0;
            }
            return rebalancingGroups$1.contains((Object)groupId) || failedGroups$1.contains((Object)groupId);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$fetchOffsetsAndRecordLag$12(ConsumerLagEmitter $this, String groupId) {
        $this.consumerLagMetrics().remove((Object)groupId).foreach((Function1 & Serializable)x$2 -> {
            x$2.close();
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ int $anonfun$currentMetricsSize$1(Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((GaugeSuite)x0$1._2()).keySet().size();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ List $anonfun$maybePrefixTopicPartitionsWithTenantFunction$1(String prefix$1, List topicPartitions) {
        return topicPartitions.map((Function1 & Serializable)x$5 -> TenantHelpers.prefixWithTenant(prefix$1, x$5));
    }

    public ConsumerLagEmitter(Metrics metrics, MetricsRegistry registry, Scheduler scheduler, GroupCoordinator groupCoordinator, long emitIntervalMs, Admin admin) {
        this.metrics = metrics;
        this.registry = registry;
        this.scheduler = scheduler;
        this.groupCoordinator = groupCoordinator;
        this.emitIntervalMs = emitIntervalMs;
        this.admin = admin;
        this.consumerLagMetrics = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        this.kafka$metrics$ConsumerLagEmitter$$updatedGroupSize = 0;
        metrics.addMetric(metrics.metricName(ConsumerLagEmitter$.MODULE$.UpdatedGroupSizeMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()), (MetricValueProvider)new Gauge<Object>(this){
            private final /* synthetic */ ConsumerLagEmitter $outer;

            public int value(MetricConfig config, long now) {
                return this.$outer.kafka$metrics$ConsumerLagEmitter$$updatedGroupSize();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$metrics$ConsumerLagEmitter$$rebalancingGroupSize = 0;
        metrics.addMetric(metrics.metricName(ConsumerLagEmitter$.MODULE$.RebalancingGroupSizeMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()), (MetricValueProvider)new Gauge<Object>(this){
            private final /* synthetic */ ConsumerLagEmitter $outer;

            public int value(MetricConfig config, long now) {
                return this.$outer.kafka$metrics$ConsumerLagEmitter$$rebalancingGroupSize();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$metrics$ConsumerLagEmitter$$failedGroupSize = 0;
        metrics.addMetric(metrics.metricName(ConsumerLagEmitter$.MODULE$.FailedGroupSizeMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()), (MetricValueProvider)new Gauge<Object>(this){
            private final /* synthetic */ ConsumerLagEmitter $outer;

            public int value(MetricConfig config, long now) {
                return this.$outer.kafka$metrics$ConsumerLagEmitter$$failedGroupSize();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$metrics$ConsumerLagEmitter$$expiredGroupSize = 0;
        metrics.addMetric(metrics.metricName(ConsumerLagEmitter$.MODULE$.ExpiredGroupSizeMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()), (MetricValueProvider)new Gauge<Object>(this){
            private final /* synthetic */ ConsumerLagEmitter $outer;

            public int value(MetricConfig config, long now) {
                return this.$outer.kafka$metrics$ConsumerLagEmitter$$expiredGroupSize();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$metrics$ConsumerLagEmitter$$metricsSize = 0L;
        metrics.addMetric(metrics.metricName(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()), (MetricValueProvider)new Gauge<Object>(this){
            private final /* synthetic */ ConsumerLagEmitter $outer;

            public long value(MetricConfig config, long now) {
                return this.$outer.kafka$metrics$ConsumerLagEmitter$$metricsSize();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$metrics$ConsumerLagEmitter$$executionTime = 0L;
        metrics.addMetric(metrics.metricName(ConsumerLagEmitter$.MODULE$.ExecutionTimeMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()), (MetricValueProvider)new Gauge<Object>(this){
            private final /* synthetic */ ConsumerLagEmitter $outer;

            public long value(MetricConfig config, long now) {
                return this.$outer.kafka$metrics$ConsumerLagEmitter$$executionTime();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$metrics$ConsumerLagEmitter$$lastSuccessfulRunMs = System.currentTimeMillis();
        metrics.addMetric(metrics.metricName(ConsumerLagEmitter$.MODULE$.TimeSinceLastSuccessfulRunMsMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()), (MetricValueProvider)new Gauge<Object>(this){
            private final /* synthetic */ ConsumerLagEmitter $outer;

            public long value(MetricConfig config, long now) {
                return System.currentTimeMillis() - this.$outer.kafka$metrics$ConsumerLagEmitter$$lastSuccessfulRunMs();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.memberSize = KafkaYammerMetrics.getMetricName((String)"kafka.coordinator.group", (String)ConsumerLagEmitter$.MODULE$.MetricGroupName(), (String)ConsumerLagEmitter$.MODULE$.MemberSizeMetricName(), null);
        this.memberSizeHistogram = registry.newHistogram(this.memberSize(), false);
    }
}

