/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.concurrent.DefaultEventExecutor;
import io.confluent.kafka.concurrent.EventExecutor;
import io.confluent.kafka.raft.CompositeRaftTracer;
import io.confluent.kafka.raft.RaftTracer;
import java.io.File;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import kafka.durability.audit.manager.KRaftDurabilityAuditor$;
import kafka.log.LocalLog$;
import kafka.raft.KafkaMetadataLog;
import kafka.raft.KafkaMetadataLog$;
import kafka.raft.KafkaRaftManager$;
import kafka.raft.MetadataLogConfig$;
import kafka.raft.RaftManager;
import kafka.raft.TimingWheelExpirationService;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRaftServer$;
import kafka.tier.raft.KRaftSnapshotManager;
import kafka.tier.raft.KRaftSnapshotMetrics;
import kafka.tier.store.TierObjectStore;
import kafka.utils.CoreUtils$;
import kafka.utils.FileLock;
import kafka.utils.Logging;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataRecoveryStrategy;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.ExpirationService;
import org.apache.kafka.raft.FileQuorumStateStore;
import org.apache.kafka.raft.KafkaNetworkChannel;
import org.apache.kafka.raft.KafkaRaftClient;
import org.apache.kafka.raft.KafkaRaftClientDriver;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.raft.NetworkChannel;
import org.apache.kafka.raft.QuorumConfig;
import org.apache.kafka.raft.QuorumStateStore;
import org.apache.kafka.raft.RaftClient;
import org.apache.kafka.raft.ReplicatedLog;
import org.apache.kafka.server.ProcessRole;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.util.KafkaScheduler;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.server.util.timer.SystemTimer;
import org.apache.kafka.server.util.timer.Timer;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\rUu!\u0002\"D\u0011\u0003Ae!\u0002&D\u0011\u0003Y\u0005\"\u0002*\u0002\t\u0003\u0019\u0006\"\u0002+\u0002\t\u0013)\u0006\"B7\u0002\t\u0013q\u0007\"B<\u0002\t\u0013A\bbBA\u0005\u0003\u0011\u0005\u00111\u0002\u0004\u0006\u0015\u000e\u0003\u0011Q\u0003\u0005\n\u0003w9!\u0011!Q\u0001\n\tD\u0001\"`\u0004\u0003\u0002\u0003\u0006IA \u0005\u000b\u0003{9!\u0011!Q\u0001\n\u0005}\u0002BCA+\u000f\t\u0005\t\u0015!\u0003\u0002X!Q\u0011qM\u0004\u0003\u0002\u0003\u0006I!!\u001b\t\u0015\u0005=tA!A!\u0002\u0013\ty\u0004\u0003\u0006\u0002r\u001d\u0011\t\u0011)A\u0005\u0003gB!\"! \b\u0005\u0003\u0005\u000b\u0011BA@\u0011)\tIi\u0002B\u0001B\u0003%\u00111\u0012\u0005\u000b\u0003#;!Q1A\u0005\u0002\u0005M\u0005BCAc\u000f\t\u0005\t\u0015!\u0003\u0002\u0016\"Q\u0011qY\u0004\u0003\u0002\u0003\u0006I!!3\t\u0015\u0005=wA!A!\u0002\u0013\t\t\u000e\u0003\u0006\u0002^\u001e\u0011\t\u0011)A\u0005\u0003?DaAU\u0004\u0005\u0002\u0005U\b\"\u0003B\n\u000f\t\u0007I\u0011\u0002B\u000b\u0011!\u0011\u0019c\u0002Q\u0001\n\t]\u0001\"\u0003B\u0013\u000f\t\u0007I\u0011\u0001B\u0014\u0011!\u0011)d\u0002Q\u0001\n\t%\u0002\"\u0003B\u001c\u000f\t\u0007I\u0011\u0002B\u001d\u0011!\u0011)e\u0002Q\u0001\n\tm\u0002\"\u0003B$\u000f\t\u0007I\u0011\u0002B%\u0011\u001d\u0011Ye\u0002Q\u0001\n\tD\u0011B!\u0014\b\u0005\u0004%IAa\u0014\t\u0011\t]s\u0001)A\u0005\u0005#B\u0011B!\u0017\b\u0005\u0004%IAa\u0017\t\u0011\t\u001dt\u0001)A\u0005\u0005;B\u0001B^\u0004C\u0002\u0013%!\u0011\u000e\u0005\b\u0005W:\u0001\u0015!\u0003W\u0011%\u0011ig\u0002b\u0001\n\u0013\u0011y\u0007\u0003\u0005\u0003t\u001d\u0001\u000b\u0011\u0002B9\u0011%\u0011)h\u0002b\u0001\n\u0003\u00129\b\u0003\u0005\u0003\u0000\u001d\u0001\u000b\u0011\u0002B=\u0011%\u0011\ti\u0002b\u0001\n\u0013\u0011\u0019\t\u0003\u0005\u0003\f\u001e\u0001\u000b\u0011\u0002BC\u0011%\u0011ii\u0002b\u0001\n\u0013\u0011y\t\u0003\u0005\u0003\u001e\u001e\u0001\u000b\u0011\u0002BI\u0011%\u0011yj\u0002b\u0001\n\u0013\u0011\t\u000b\u0003\u0005\u0003*\u001e\u0001\u000b\u0011\u0002BR\u0011%\u0011Yk\u0002b\u0001\n\u0003\u0012i\u000b\u0003\u0005\u00036\u001e\u0001\u000b\u0011\u0002BX\u0011%\u00119l\u0002b\u0001\n\u0013\u0011I\f\u0003\u0005\u0003B\u001e\u0001\u000b\u0011\u0002B^\u0011%\u0011\u0019m\u0002a\u0001\n\u0013\u0011)\rC\u0005\u0003\\\u001e\u0001\r\u0011\"\u0003\u0003^\"A!1]\u0004!B\u0013\u00119\rC\u0004\u0003f\u001e!\tAa:\t\u000f\t%x\u0001\"\u0001\u0003h\"9!1^\u0004\u0005B\t5\bbBB\u0001\u000f\u0011\u000531\u0001\u0005\b\u0007c9A\u0011BB\u001a\u0011\u001d\u0019\te\u0002C\u0005\u0007\u0007Bqa!\u0012\b\t\u0013\u00199\u0005C\u0004\u0004J\u001d!Iaa\u0013\t\u000f\r5s\u0001\"\u0003\u0004P!91qK\u0004\u0005\n\re\u0003bBB:\u000f\u0011\u00053Q\u000f\u0005\b\u0007{:A\u0011IB@\u0003AY\u0015MZ6b%\u00064G/T1oC\u001e,'O\u0003\u0002E\u000b\u0006!!/\u00194u\u0015\u00051\u0015!B6bM.\f7\u0001\u0001\t\u0003\u0013\u0006i\u0011a\u0011\u0002\u0011\u0017\u000647.\u0019*bMRl\u0015M\\1hKJ\u001c\"!\u0001'\u0011\u00055\u0003V\"\u0001(\u000b\u0003=\u000bQa]2bY\u0006L!!\u0015(\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0001*\u0001\nde\u0016\fG/\u001a'pO\u0012K'/Z2u_JLHc\u0001,_AB\u0011q\u000bX\u0007\u00021*\u0011\u0011LW\u0001\u0003S>T\u0011aW\u0001\u0005U\u00064\u0018-\u0003\u0002^1\n!a)\u001b7f\u0011\u0015y6\u00011\u0001W\u0003\u0019awn\u001a#je\")\u0011m\u0001a\u0001E\u0006QAn\\4ESJt\u0015-\\3\u0011\u0005\rTgB\u00013i!\t)g*D\u0001g\u0015\t9w)\u0001\u0004=e>|GOP\u0005\u0003S:\u000ba\u0001\u0015:fI\u00164\u0017BA6m\u0005\u0019\u0019FO]5oO*\u0011\u0011NT\u0001\fY>\u001c7\u000eR1uC\u0012K'\u000f\u0006\u0002pkB\u0011\u0001o]\u0007\u0002c*\u0011!/R\u0001\u0006kRLGn]\u0005\u0003iF\u0014\u0001BR5mK2{7m\u001b\u0005\u0006m\u0012\u0001\rAV\u0001\bI\u0006$\u0018\rR5s\u0003IA\u0017m\u001d#jM\u001a,'/\u001a8u\u0019><G)\u001b:\u0015\u0005ed\bCA'{\u0013\tYhJA\u0004C_>dW-\u00198\t\u000bu,\u0001\u0019\u0001@\u0002\r\r|gNZ5h!\ry\u0018QA\u0007\u0003\u0003\u0003Q1!a\u0001F\u0003\u0019\u0019XM\u001d<fe&!\u0011qAA\u0001\u0005-Y\u0015MZ6b\u0007>tg-[4\u000235\f\u0017PY3EK2,G/Z'fi\u0006$\u0017\r^1M_\u001e$\u0015N\u001d\u000b\u0005\u0003\u001b\t\u0019\u0002E\u0002N\u0003\u001fI1!!\u0005O\u0005\u0011)f.\u001b;\t\u000bu4\u0001\u0019\u0001@\u0016\t\u0005]\u00111E\n\u0007\u000f1\u000bI\"!\u000e\u0011\u000b%\u000bY\"a\b\n\u0007\u0005u1IA\u0006SC\u001a$X*\u00198bO\u0016\u0014\b\u0003BA\u0011\u0003Ga\u0001\u0001B\u0004\u0002&\u001d\u0011\r!a\n\u0003\u0003Q\u000bB!!\u000b\u00020A\u0019Q*a\u000b\n\u0007\u00055bJA\u0004O_RD\u0017N\\4\u0011\u00075\u000b\t$C\u0002\u000249\u00131!\u00118z!\r\u0001\u0018qG\u0005\u0004\u0003s\t(a\u0002'pO\u001eLgnZ\u0001\nG2,8\u000f^3s\u0013\u0012\f!#\\3uC\u0012\fG/\u0019'pO\u0012K'/V;jIB!\u0011\u0011IA)\u001b\t\t\u0019E\u0003\u0003\u0002F\u0005\u001d\u0013AB2p[6|gNC\u0002G\u0003\u0013RA!a\u0013\u0002N\u00051\u0011\r]1dQ\u0016T!!a\u0014\u0002\u0007=\u0014x-\u0003\u0003\u0002T\u0005\r#\u0001B+vS\u0012\f1B]3d_J$7+\u001a:eKB1\u0011\u0011LA2\u0003?i!!a\u0017\u000b\t\u0005u\u0013qL\u0001\u000eg\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8\u000b\t\u0005\u0015\u0013\u0011\r\u0006\u0005\u0003\u0007\t9%\u0003\u0003\u0002f\u0005m#a\u0003*fG>\u0014HmU3sI\u0016\fa\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0003\u0002B\u0005-\u0014\u0002BA7\u0003\u0007\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.A\u0004u_BL7-\u00133\u0002\tQLW.\u001a\t\u0005\u0003k\nI(\u0004\u0002\u0002x)\u0019!/a\u0011\n\t\u0005m\u0014q\u000f\u0002\u0005)&lW-A\u0004nKR\u0014\u0018nY:\u0011\t\u0005\u0005\u0015QQ\u0007\u0003\u0003\u0007SA!! \u0002D%!\u0011qQAB\u0005\u001diU\r\u001e:jGN\f1\u0003\u001e5sK\u0006$g*Y7f!J,g-\u001b=PaR\u0004B!TAGE&\u0019\u0011q\u0012(\u0003\r=\u0003H/[8o\u0003q\u0019wN\u001c;s_2dWM])v_J,XNV8uKJ\u001ch)\u001e;ve\u0016,\"!!&\u0011\r\u0005]\u0015\u0011UAS\u001b\t\tIJ\u0003\u0003\u0002\u001c\u0006u\u0015AC2p]\u000e,(O]3oi*\u0019\u0011q\u0014.\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003G\u000bIJA\tD_6\u0004H.\u001a;bE2,g)\u001e;ve\u0016\u0004\u0002\"a*\u0002*\u00065\u0016\u0011X\u0007\u0003\u0003;KA!a+\u0002\u001e\n\u0019Q*\u00199\u0011\t\u0005=\u0016QW\u0007\u0003\u0003cS1!a-[\u0003\u0011a\u0017M\\4\n\t\u0005]\u0016\u0011\u0017\u0002\b\u0013:$XmZ3s!\u0011\tY,!1\u000e\u0005\u0005u&bAA`5\u0006\u0019a.\u001a;\n\t\u0005\r\u0017Q\u0018\u0002\u0012\u0013:,GoU8dW\u0016$\u0018\t\u001a3sKN\u001c\u0018!H2p]R\u0014x\u000e\u001c7feF+xN];n->$XM]:GkR,(/\u001a\u0011\u0002!\t|w\u000e^:ue\u0006\u00048+\u001a:wKJ\u001c\bCBAT\u0003\u0017\fI,\u0003\u0003\u0002N\u0006u%AC\"pY2,7\r^5p]\u0006\tb-\u0019;bY\u001a\u000bW\u000f\u001c;IC:$G.\u001a:\u0011\t\u0005M\u0017\u0011\\\u0007\u0003\u0003+TA!a6\u0002b\u0005)a-Y;mi&!\u00111\\Ak\u000511\u0015-\u001e7u\u0011\u0006tG\r\\3s\u0003I!\u0018.\u001a:PE*,7\r^*u_J,w\n\u001d;\u0011\r\u0005\u001d\u0016\u0011]As\u0013\u0011\t\u0019/!(\u0003\u0011=\u0003H/[8oC2\u0004B!a:\u0002r6\u0011\u0011\u0011\u001e\u0006\u0005\u0003W\fi/A\u0003ti>\u0014XMC\u0002\u0002p\u0016\u000bA\u0001^5fe&!\u00111_Au\u0005=!\u0016.\u001a:PE*,7\r^*u_J,G\u0003HA|\u0003s\fY0!@\u0002\u0000\n\u0005!1\u0001B\u0003\u0005\u000f\u0011IAa\u0003\u0003\u000e\t=!\u0011\u0003\t\u0005\u0013\u001e\ty\u0002\u0003\u0004\u0002<Y\u0001\rA\u0019\u0005\u0006{Z\u0001\rA \u0005\b\u0003{1\u0002\u0019AA \u0011\u001d\t)F\u0006a\u0001\u0003/Bq!a\u001a\u0017\u0001\u0004\tI\u0007C\u0004\u0002pY\u0001\r!a\u0010\t\u000f\u0005Ed\u00031\u0001\u0002t!9\u0011Q\u0010\fA\u0002\u0005}\u0004bBAE-\u0001\u0007\u00111\u0012\u0005\b\u0003#3\u0002\u0019AAK\u0011\u001d\t9M\u0006a\u0001\u0003\u0013Dq!a4\u0017\u0001\u0004\t\t\u000eC\u0004\u0002^Z\u0001\r!a8\u0002\r\rdwn]3e+\t\u00119\u0002\u0005\u0003\u0003\u001a\t}QB\u0001B\u000e\u0015\u0011\u0011i\"!'\u0002\r\u0005$x.\\5d\u0013\u0011\u0011\tCa\u0007\u0003\u001b\u0005#x.\\5d\u0005>|G.Z1o\u0003\u001d\u0019Gn\\:fI\u0002\n1\"\u00199j-\u0016\u00148/[8ogV\u0011!\u0011\u0006\t\u0005\u0005W\u0011\t$\u0004\u0002\u0003.)!!qFA$\u0003\u001d\u0019G.[3oiNLAAa\r\u0003.\tY\u0011\t]5WKJ\u001c\u0018n\u001c8t\u00031\t\u0007/\u001b,feNLwN\\:!\u0003)\u0011\u0018M\u001a;D_:4\u0017nZ\u000b\u0003\u0005w\u0001BA!\u0010\u0003B5\u0011!q\b\u0006\u0004\t\u0006\u001d\u0013\u0002\u0002B\"\u0005\u007f\u0011A\"U;peVl7i\u001c8gS\u001e\f1B]1gi\u000e{gNZ5hA\u0005\u0001B\u000f\u001b:fC\u0012t\u0015-\\3Qe\u00164\u0017\u000e_\u000b\u0002E\u0006\tB\u000f\u001b:fC\u0012t\u0015-\\3Qe\u00164\u0017\u000e\u001f\u0011\u0002\u00151|wmQ8oi\u0016DH/\u0006\u0002\u0003RA!\u0011Q\u000fB*\u0013\u0011\u0011)&a\u001e\u0003\u00151{wmQ8oi\u0016DH/A\u0006m_\u001e\u001cuN\u001c;fqR\u0004\u0013!C:dQ\u0016$W\u000f\\3s+\t\u0011i\u0006\u0005\u0003\u0003`\t\rTB\u0001B1\u0015\u0011\ty*!\u0019\n\t\t\u0015$\u0011\r\u0002\u000f\u0017\u000647.Y*dQ\u0016$W\u000f\\3s\u0003)\u00198\r[3ek2,'\u000fI\u000b\u0002-\u0006AA-\u0019;b\t&\u0014\b%A\u0006eCR\fG)\u001b:M_\u000e\\WC\u0001B9!\u0011i\u0015QR8\u0002\u0019\u0011\fG/\u0019#je2{7m\u001b\u0011\u0002\u001bI,\u0007\u000f\\5dCR,G\rT8h+\t\u0011I\b\u0005\u0003\u0003>\tm\u0014\u0002\u0002B?\u0005\u007f\u0011QBU3qY&\u001c\u0017\r^3e\u0019><\u0017A\u0004:fa2L7-\u0019;fI2{w\rI\u0001\u000b]\u0016$8\t[1o]\u0016dWC\u0001BC!\u0011\u0011iDa\"\n\t\t%%q\b\u0002\u0014\u0017\u000647.\u0019(fi^|'o[\"iC:tW\r\\\u0001\f]\u0016$8\t[1o]\u0016d\u0007%A\bfqBL'/\u0019;j_:$\u0016.\\3s+\t\u0011\t\n\u0005\u0003\u0003\u0014\neUB\u0001BK\u0015\u0011\u00119J!\u0019\u0002\u000bQLW.\u001a:\n\t\tm%Q\u0013\u0002\f'f\u001cH/Z7US6,'/\u0001\tfqBL'/\u0019;j_:$\u0016.\\3sA\u0005\tR\r\u001f9je\u0006$\u0018n\u001c8TKJ4\u0018nY3\u0016\u0005\t\r\u0006cA%\u0003&&\u0019!qU\"\u00039QKW.\u001b8h/\",W\r\\#ya&\u0014\u0018\r^5p]N+'O^5dK\u0006\u0011R\r\u001f9je\u0006$\u0018n\u001c8TKJ4\u0018nY3!\u0003\u0019\u0019G.[3oiV\u0011!q\u0016\t\u0007\u0005{\u0011\t,a\b\n\t\tM&q\b\u0002\u0010\u0017\u000647.\u0019*bMR\u001cE.[3oi\u000691\r\\5f]R\u0004\u0013\u0001D2mS\u0016tG\u000f\u0012:jm\u0016\u0014XC\u0001B^!\u0019\u0011iD!0\u0002 %!!q\u0018B \u0005UY\u0015MZ6b%\u00064Go\u00117jK:$HI]5wKJ\fQb\u00197jK:$HI]5wKJ\u0004\u0013\u0001C3yK\u000e,Ho\u001c:\u0016\u0005\t\u001d\u0007#B'\u0002\u000e\n%\u0007\u0003\u0002Bf\u0005/l!A!4\u000b\t\u0005m%q\u001a\u0006\u0004\r\nE'\u0002\u0002Bj\u0005+\f\u0011bY8oM2,XM\u001c;\u000b\u0003eKAA!7\u0003N\niQI^3oi\u0016CXmY;u_J\fA\"\u001a=fGV$xN]0%KF$B!!\u0004\u0003`\"I!\u0011\u001d\u001b\u0002\u0002\u0003\u0007!qY\u0001\u0004q\u0012\n\u0014!C3yK\u000e,Ho\u001c:!\u0003\u001d\u0019H/\u0019:ukB$\"!!\u0004\u0002\u0011MDW\u000f\u001e3po:\f\u0001B]3hSN$XM\u001d\u000b\u0005\u0003\u001b\u0011y\u000fC\u0004\u0003rb\u0002\rAa=\u0002\u00111L7\u000f^3oKJ\u0004bA!>\u0003|\u0006}a\u0002\u0002B\u001f\u0005oLAA!?\u0003@\u0005Q!+\u00194u\u00072LWM\u001c;\n\t\tu(q \u0002\t\u0019&\u001cH/\u001a8fe*!!\u0011 B \u00035A\u0017M\u001c3mKJ+\u0017/^3tiRA1QAB\n\u0007G\u00199\u0003\u0005\u0004\u0002\u0018\u0006\u00056q\u0001\t\u0005\u0007\u0013\u0019y!\u0004\u0002\u0004\f)!1QBA\"\u0003!\u0001(o\u001c;pG>d\u0017\u0002BB\t\u0007\u0017\u0011!\"\u00119j\u001b\u0016\u001c8/Y4f\u0011\u001d\u0019)\"\u000fa\u0001\u0007/\ta\u0001[3bI\u0016\u0014\b\u0003BB\r\u0007?i!aa\u0007\u000b\t\ru\u00111I\u0001\te\u0016\fX/Z:ug&!1\u0011EB\u000e\u00055\u0011V-];fgRDU-\u00193fe\"91QE\u001dA\u0002\r\u001d\u0011a\u0002:fcV,7\u000f\u001e\u0005\b\u0007SI\u0004\u0019AB\u0016\u00035\u0019'/Z1uK\u0012$\u0016.\\3NgB\u0019Qj!\f\n\u0007\r=bJ\u0001\u0003M_:<\u0017!H7bs\n,')^5mIJ\u000bg\r^*oCB\u001c\bn\u001c;NC:\fw-\u001a:\u0015\u0005\rU\u0002#B'\u0002\u000e\u000e]\u0002\u0003BB\u001d\u0007{i!aa\u000f\u000b\u0007\u0011\u000bi/\u0003\u0003\u0004@\rm\"\u0001F&SC\u001a$8K\\1qg\"|G/T1oC\u001e,'/A\bck&dGMU1gi\u000ec\u0017.\u001a8u)\t\u0011y+A\nck&dGMT3uo>\u00148n\u00115b]:,G\u000e\u0006\u0002\u0003\u0006\u0006i1M]3bi\u0016$\u0015\r^1ESJ$\u0012AV\u0001\u0011EVLG\u000eZ'fi\u0006$\u0017\r^1M_\u001e$\"a!\u0015\u0011\u0007%\u001b\u0019&C\u0002\u0004V\r\u0013\u0001cS1gW\u0006lU\r^1eCR\fGj\\4\u0002%\t,\u0018\u000e\u001c3OKR<xN]6DY&,g\u000e\u001e\u000b\u0003\u00077\u0002r!TB/\u0007C\u001ai'C\u0002\u0004`9\u0013a\u0001V;qY\u0016\u0014\u0004\u0003BB2\u0007Sj!a!\u001a\u000b\t\r\u001d\u00141I\u0001\b]\u0016$xo\u001c:l\u0013\u0011\u0019Yg!\u001a\u0003\u00191K7\u000f^3oKJt\u0015-\\3\u0011\t\t-2qN\u0005\u0005\u0007c\u0012iCA\u0007OKR<xN]6DY&,g\u000e^\u0001\u000fY\u0016\fG-\u001a:B]\u0012,\u0005o\\2i+\t\u00199\b\u0005\u0003\u0003>\re\u0014\u0002BB>\u0005\u007f\u0011a\u0002T3bI\u0016\u0014\u0018I\u001c3Fa>\u001c\u0007.A\u0005w_R,'OT8eKR11\u0011QBE\u0007'\u0003R!TAG\u0007\u0007\u0003B!!\u0011\u0004\u0006&!1qQA\"\u0005\u0011qu\u000eZ3\t\u000f\r-\u0015\t1\u0001\u0004\u000e\u0006\u0011\u0011\u000e\u001a\t\u0004\u001b\u000e=\u0015bABI\u001d\n\u0019\u0011J\u001c;\t\u000f\tE\u0018\t1\u0001\u0004b\u0001")
public class KafkaRaftManager<T>
implements RaftManager<T>,
Logging {
    private final String clusterId;
    private final KafkaConfig config;
    private final Uuid metadataLogDirUuid;
    private final RecordSerde<T> recordSerde;
    private final TopicPartition topicPartition;
    private final Uuid topicId;
    private final Time time;
    private final Metrics metrics;
    private final CompletableFuture<java.util.Map<Integer, InetSocketAddress>> controllerQuorumVotersFuture;
    private final Collection<InetSocketAddress> bootstrapServers;
    private final Optional<TierObjectStore> tierObjectStoreOpt;
    private final AtomicBoolean closed;
    private final ApiVersions apiVersions;
    private final QuorumConfig raftConfig;
    private final String threadNamePrefix;
    private final LogContext logContext;
    private final KafkaScheduler scheduler;
    private final File dataDir;
    private final Option<FileLock> dataDirLock;
    private final ReplicatedLog replicatedLog;
    private final KafkaNetworkChannel netChannel;
    private final SystemTimer expirationTimer;
    private final TimingWheelExpirationService expirationService;
    private final KafkaRaftClient<T> client;
    private final KafkaRaftClientDriver<T> clientDriver;
    private Option<EventExecutor> executor;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static void maybeDeleteMetadataLogDir(KafkaConfig config) {
        KafkaRaftManager$.MODULE$.maybeDeleteMetadataLogDir(config);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public CompletableFuture<java.util.Map<Integer, InetSocketAddress>> controllerQuorumVotersFuture() {
        return this.controllerQuorumVotersFuture;
    }

    private AtomicBoolean closed() {
        return this.closed;
    }

    public ApiVersions apiVersions() {
        return this.apiVersions;
    }

    private QuorumConfig raftConfig() {
        return this.raftConfig;
    }

    private String threadNamePrefix() {
        return this.threadNamePrefix;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    private KafkaScheduler scheduler() {
        return this.scheduler;
    }

    private File dataDir() {
        return this.dataDir;
    }

    private Option<FileLock> dataDirLock() {
        return this.dataDirLock;
    }

    @Override
    public ReplicatedLog replicatedLog() {
        return this.replicatedLog;
    }

    private KafkaNetworkChannel netChannel() {
        return this.netChannel;
    }

    private SystemTimer expirationTimer() {
        return this.expirationTimer;
    }

    private TimingWheelExpirationService expirationService() {
        return this.expirationService;
    }

    @Override
    public KafkaRaftClient<T> client() {
        return this.client;
    }

    private KafkaRaftClientDriver<T> clientDriver() {
        return this.clientDriver;
    }

    private Option<EventExecutor> executor() {
        return this.executor;
    }

    private void executor_$eq(Option<EventExecutor> x$1) {
        this.executor = x$1;
    }

    public void startup() {
        this.client().initialize(this.controllerQuorumVotersFuture().get(), (QuorumStateStore)new FileQuorumStateStore(new File(this.dataDir(), "quorum-state")), this.metrics);
        this.netChannel().start();
        this.clientDriver().start();
    }

    public void shutdown() {
        if (!this.closed().getAndSet(true)) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.expirationService().shutdown(), this, Level.WARN);
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.expirationTimer().close(), this, Level.WARN);
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.clientDriver().shutdown(), this, Level.WARN);
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.client().close(), this, Level.WARN);
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.scheduler().shutdown(), this, Level.WARN);
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.netChannel().close(), this, Level.WARN);
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.replicatedLog().close(), this, Level.WARN);
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.dataDirLock().foreach((Function1 & Serializable)x$3 -> {
                x$3.destroy();
                return BoxedUnit.UNIT;
            }), this, Level.WARN);
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.executor().foreach((Function1 & Serializable)x$4 -> x$4.shutdown()), this, Level.WARN);
            return;
        }
    }

    @Override
    public void register(RaftClient.Listener<T> listener) {
        this.client().register(listener);
    }

    @Override
    public CompletableFuture<ApiMessage> handleRequest(RequestHeader header, ApiMessage request, long createdTimeMs) {
        return this.clientDriver().handleRequest(header, request, createdTimeMs);
    }

    private Option<KRaftSnapshotManager> maybeBuildRaftSnapshotManager() {
        if (!Predef$.MODULE$.Boolean2boolean(this.config.confluentConfig().clusterMetadataSnapshotTierUploadEnableFlag())) {
            return None$.MODULE$;
        }
        if (!this.config.processRoles().contains((Object)ProcessRole.ControllerRole)) {
            return None$.MODULE$;
        }
        if (!this.tierObjectStoreOpt.isPresent()) {
            throw new ConfigException(new StringBuilder(45).append("tier.enable is set to ").append(this.config.confluentConfig().tierEnable()).append(", should be set to true").toString());
        }
        Function<TopicIdPartition, Optional<Path>> topicIdPath = tpId -> {
            TopicIdPartition topicIdPartition = tpId;
            TopicIdPartition topicIdPartition2 = new TopicIdPartition(KafkaRaftServer$.MODULE$.MetadataTopicId(), KafkaRaftServer$.MODULE$.MetadataPartition());
            if (topicIdPartition != null && topicIdPartition.equals(topicIdPartition2)) {
                TopicPartition logDirName_topicPartition = $this.topicPartition;
                Object var3_3 = null;
                return Optional.of(new File($this.config.metadataLogDir(), LocalLog$.MODULE$.logDirName(logDirName_topicPartition)).toPath());
            }
            return Optional.empty();
        };
        int pendingTasksCapacity = 1024;
        this.executor_$eq((Option<EventExecutor>)new Some((Object)new DefaultEventExecutor(Executors.defaultThreadFactory(), pendingTasksCapacity)));
        return new Some((Object)KRaftSnapshotManager.create((EventExecutor)this.executor().get(), this.tierObjectStoreOpt.get(), new KRaftSnapshotMetrics(this.metrics), this.logContext(), topicIdPath, this.clusterId, this.config.nodeId(), () -> $this.config.confluentConfig().clusterMetadataSnapshotTierDeleteEnableFlag(), () -> $this.config.confluentConfig().clusterMetadataSnapshotTierDeleteRetentionMs(), this.time));
    }

    private KafkaRaftClient<T> buildRaftClient() {
        ObjectRef tracers = ObjectRef.create((Object)new .colon.colon((Object)KRaftDurabilityAuditor$.MODULE$, (List)Nil$.MODULE$));
        this.maybeBuildRaftSnapshotManager().foreach((Function1 & Serializable)snapshotTracer -> {
            tracers.elem = ((List)tracers.elem).$colon$colon((Object)snapshotTracer);
            return BoxedUnit.UNIT;
        });
        return new KafkaRaftClient(OptionalInt.of(this.config.nodeId()), this.metadataLogDirUuid, this.recordSerde, (NetworkChannel)this.netChannel(), this.replicatedLog(), this.time, (ExpirationService)this.expirationService(), this.logContext(), this.clusterId, this.bootstrapServers, this.raftConfig(), (RaftTracer)new CompositeRaftTracer(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((List)tracers.elem)).asJava(), this.logContext()));
    }

    /*
     * WARNING - void declaration
     */
    private KafkaNetworkChannel buildNetworkChannel() {
        void var3_3;
        void var2_2;
        Tuple2<ListenerName, NetworkClient> tuple2 = this.buildNetworkClient();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        ListenerName listenerName = (ListenerName)tuple2._1();
        NetworkClient netClient = (NetworkClient)tuple2._2();
        return new KafkaNetworkChannel(this.time, (ListenerName)var2_2, (KafkaClient)var3_3, Predef$.MODULE$.Integer2int(this.config.quorumRequestTimeoutMs()), this.threadNamePrefix());
    }

    private File createDataDir() {
        TopicPartition logDirName_topicPartition = this.topicPartition;
        Object var2_1 = null;
        String logDirName = LocalLog$.MODULE$.logDirName(logDirName_topicPartition);
        return KafkaRaftManager$.MODULE$.kafka$raft$KafkaRaftManager$$createLogDirectory(new File(this.config.metadataLogDir()), logDirName);
    }

    private KafkaMetadataLog buildMetadataLog() {
        return KafkaMetadataLog$.MODULE$.apply(this.topicPartition, this.topicId, this.dataDir(), this.time, this.metrics, (Scheduler)this.scheduler(), MetadataLogConfig$.MODULE$.apply(this.config, 0x800000, 0x800000), x$6 -> this.client().traceLogStartOffsetChange(), x$7 -> this.client().traceLogSnapshotGeneration());
    }

    /*
     * WARNING - void declaration
     */
    private Tuple2<ListenerName, NetworkClient> buildNetworkClient() {
        void clientChannelBuilder_logContext;
        void clientChannelBuilder_saslHandshakeRequestEnable;
        void clientChannelBuilder_time;
        void clientChannelBuilder_clientSaslMechanism;
        void clientChannelBuilder_config;
        ListenerName controllerListenerName = new ListenerName((String)this.config.controllerListenerNames().head());
        SecurityProtocol controllerSecurityProtocol = (SecurityProtocol)this.config.effectiveListenerSecurityProtocolMap().getOrElse((Object)controllerListenerName, (Function0 & Serializable)() -> SecurityProtocol.forName((String)controllerListenerName.value()));
        LogContext logContext = this.logContext();
        boolean bl = this.config.saslInterBrokerHandshakeRequestEnable();
        Time time = this.time;
        String string = this.config.saslMechanismControllerProtocol();
        KafkaConfig kafkaConfig = this.config;
        JaasContext.Type clientChannelBuilder_contextType = JaasContext.Type.SERVER;
        Object var13_8 = null;
        kafkaConfig = null;
        string = null;
        time = null;
        logContext = null;
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder((SecurityProtocol)controllerSecurityProtocol, (JaasContext.Type)clientChannelBuilder_contextType, (AbstractConfig)clientChannelBuilder_config, (ListenerName)controllerListenerName, (String)clientChannelBuilder_clientSaslMechanism, (Time)clientChannelBuilder_time, (boolean)clientChannelBuilder_saslHandshakeRequestEnable, (LogContext)clientChannelBuilder_logContext, null, null);
        String metricGroupPrefix = "raft-channel";
        boolean collectPerConnectionMetrics = false;
        Selector selector = new Selector(-1, Predef$.MODULE$.Long2long(this.config.connectionsMaxIdleMs()), this.metrics, this.time, metricGroupPrefix, CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().empty()).asJava(), collectPerConnectionMetrics, channelBuilder, this.logContext());
        String clientId = new StringBuilder(12).append("raft-client-").append(this.config.nodeId()).toString();
        int maxInflightRequestsPerConnection = 1;
        int reconnectBackoffMs = 50;
        int reconnectBackoffMsMs = 500;
        boolean discoverBrokerVersions = true;
        NetworkClient networkClient = new NetworkClient((Selectable)selector, (MetadataUpdater)new ManualMetadataUpdater(), clientId, maxInflightRequestsPerConnection, Int$.MODULE$.int2long(reconnectBackoffMs), Int$.MODULE$.int2long(reconnectBackoffMsMs), -1, Predef$.MODULE$.Integer2int(this.config.socketReceiveBufferBytes()), Predef$.MODULE$.Integer2int(this.config.quorumRequestTimeoutMs()), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMs()), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMaxMs()), this.time, discoverBrokerVersions, this.apiVersions(), this.logContext(), MetadataRecoveryStrategy.NONE);
        return new Tuple2((Object)controllerListenerName, (Object)networkClient);
    }

    @Override
    public LeaderAndEpoch leaderAndEpoch() {
        return this.client().leaderAndEpoch();
    }

    @Override
    public Option<Node> voterNode(int id, ListenerName listener) {
        return OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(this.client().voterNode(id, listener)));
    }

    public KafkaRaftManager(String clusterId, KafkaConfig config, Uuid metadataLogDirUuid, RecordSerde<T> recordSerde, TopicPartition topicPartition, Uuid topicId, Time time, Metrics metrics, Option<String> threadNamePrefixOpt, CompletableFuture<java.util.Map<Integer, InetSocketAddress>> controllerQuorumVotersFuture, Collection<InetSocketAddress> bootstrapServers, FaultHandler fatalFaultHandler, Optional<TierObjectStore> tierObjectStoreOpt) {
        this.clusterId = clusterId;
        this.config = config;
        this.metadataLogDirUuid = metadataLogDirUuid;
        this.recordSerde = recordSerde;
        this.topicPartition = topicPartition;
        this.topicId = topicId;
        this.time = time;
        this.metrics = metrics;
        this.controllerQuorumVotersFuture = controllerQuorumVotersFuture;
        this.bootstrapServers = bootstrapServers;
        this.tierObjectStoreOpt = tierObjectStoreOpt;
        this.closed = new AtomicBoolean(false);
        this.apiVersions = new ApiVersions();
        this.raftConfig = new QuorumConfig((AbstractConfig)config);
        this.threadNamePrefix = (String)threadNamePrefixOpt.getOrElse((Function0 & Serializable)() -> "kafka-raft");
        this.logContext = new LogContext(new StringBuilder(18).append("[RaftManager id=").append(config.nodeId()).append("] ").toString());
        this.logIdent_$eq(this.logContext().logPrefix());
        this.scheduler = new KafkaScheduler(1, true, new StringBuilder(10).append(this.threadNamePrefix()).append("-scheduler").toString(), false);
        this.scheduler().startup();
        this.dataDir = this.createDataDir();
        boolean differentMetadataLogDir = KafkaRaftManager$.MODULE$.kafka$raft$KafkaRaftManager$$hasDifferentLogDir(config);
        Set<ProcessRole> set = config.processRoles();
        Object object = Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ProcessRole[]{ProcessRole.ControllerRole}));
        boolean isOnlyController = !(set != null ? !set.equals(object) : object != null);
        this.dataDirLock = differentMetadataLogDir || isOnlyController ? new Some((Object)KafkaRaftManager$.MODULE$.kafka$raft$KafkaRaftManager$$lockDataDir(new File(config.metadataLogDir()))) : None$.MODULE$;
        this.replicatedLog = this.buildMetadataLog();
        this.netChannel = this.buildNetworkChannel();
        this.expirationTimer = new SystemTimer("raft-expiration-executor");
        this.expirationService = new TimingWheelExpirationService((Timer)this.expirationTimer());
        this.client = this.buildRaftClient();
        this.clientDriver = new KafkaRaftClientDriver(this.client(), this.threadNamePrefix(), fatalFaultHandler, this.logContext());
        this.executor = None$.MODULE$;
    }
}

