/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.net.SocketTimeoutException;
import kafka.cluster.BrokerEndPoint;
import kafka.server.BlockingSend;
import kafka.server.BrokerBlockingSender$;
import kafka.server.KafkaConfig;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.NetworkClientUtils;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005mx!B\u000f\u001f\u0011\u0003\u0019c!B\u0013\u001f\u0011\u00031\u0003\"B\u0017\u0002\t\u0003q\u0003\"B\u0018\u0002\t\u0003\u0001\u0004\"CA]\u0003E\u0005I\u0011AA^\u0011\u001d\t\t.\u0001C\u0001\u0003'D\u0011\"a=\u0002#\u0003%\t!a/\t\u0013\u0005U\u0018!%A\u0005\u0002\u0005]h\u0001B\u0013\u001f\u0001IB\u0001B\u000e\u0005\u0003\u0002\u0003\u0006Ia\u000e\u0005\t{!\u0011\t\u0011)A\u0005}!A\u0011\t\u0003B\u0001B\u0003%!\t\u0003\u0005F\u0011\t\u0005\t\u0015!\u0003G\u0011!\u0019\u0006B!A!\u0002\u0013\u0011\u0005\u0002\u0003+\t\u0005\u0003\u0007I\u0011A+\t\u0011qC!\u00111A\u0005\u0002uC\u0001b\u0019\u0005\u0003\u0002\u0003\u0006KA\u0016\u0005\tI\"\u0011\t\u0019!C\u0001K\"AQ\u000e\u0003BA\u0002\u0013\u0005a\u000e\u0003\u0005q\u0011\t\u0005\t\u0015)\u0003g\u0011\u0015i\u0003\u0002\"\u0001r\u0011\u001dI\bB1A\u0005\u0002iDaA \u0005!\u0002\u0013Y\b\"B\u0017\t\t\u0003y\bbBA \u0011\u0011\u0005\u0013\u0011\t\u0005\b\u0003\u0007BA\u0011IA#\u0011\u001d\t\t\n\u0003C!\u0003'Cq!!&\t\t\u0003\n\u0019\nC\u0004\u0002\u0018\"!\t%!'\u0002)\t\u0013xn[3s\u00052|7m[5oON+g\u000eZ3s\u0015\ty\u0002%\u0001\u0004tKJ4XM\u001d\u0006\u0002C\u0005)1.\u00194lC\u000e\u0001\u0001C\u0001\u0013\u0002\u001b\u0005q\"\u0001\u0006\"s_.,'O\u00117pG.LgnZ*f]\u0012,'o\u0005\u0002\u0002OA\u0011\u0001fK\u0007\u0002S)\t!&A\u0003tG\u0006d\u0017-\u0003\u0002-S\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u0012\u0002\u000b\u0005\u0004\b\u000f\\=\u0015#E\nY*!(\u0002 \u0006\u0005\u00161UAS\u0003O\u000bI\u000b\u0005\u0002%\u0011M\u0019\u0001bJ\u001a\u0011\u0005\u0011\"\u0014BA\u001b\u001f\u00051\u0011En\\2lS:<7+\u001a8e\u00031\u0019x.\u001e:dK\n\u0013xn[3s!\tA4(D\u0001:\u0015\tQ\u0004%A\u0004dYV\u001cH/\u001a:\n\u0005qJ$A\u0004\"s_.,'/\u00128e!>Lg\u000e^\u0001\rEJ|7.\u001a:D_:4\u0017n\u001a\t\u0003I}J!\u0001\u0011\u0010\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u000eg>\u001c7.\u001a;US6,w.\u001e;\u0011\u0005!\u001a\u0015B\u0001#*\u0005\rIe\u000e^\u0001\u0005i&lW\r\u0005\u0002H#6\t\u0001J\u0003\u0002J\u0015\u0006)Q\u000f^5mg*\u00111\nT\u0001\u0007G>lWn\u001c8\u000b\u0005\u0005j%B\u0001(P\u0003\u0019\t\u0007/Y2iK*\t\u0001+A\u0002pe\u001eL!A\u0015%\u0003\tQKW.Z\u0001\nM\u0016$8\r[3s\u0013\u0012\fQB\\3uo>\u00148n\u00117jK:$X#\u0001,\u0011\u0005]SV\"\u0001-\u000b\u0005ec\u0015aB2mS\u0016tGo]\u0005\u00037b\u00131bS1gW\u0006\u001cE.[3oi\u0006\tb.\u001a;x_J\\7\t\\5f]R|F%Z9\u0015\u0005y\u000b\u0007C\u0001\u0015`\u0013\t\u0001\u0017F\u0001\u0003V]&$\bb\u00022\u0010\u0003\u0003\u0005\rAV\u0001\u0004q\u0012\n\u0014A\u00048fi^|'o[\"mS\u0016tG\u000fI\u0001\u001de\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0007\"\fgN\\3m\u0005VLG\u000eZ3s+\u00051\u0007c\u0001\u0015hS&\u0011\u0001.\u000b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005)\\W\"\u0001&\n\u00051T%A\u0004*fG>tg-[4ve\u0006\u0014G.Z\u0001!e\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0007\"\fgN\\3m\u0005VLG\u000eZ3s?\u0012*\u0017\u000f\u0006\u0002__\"9!MEA\u0001\u0002\u00041\u0017!\b:fG>tg-[4ve\u0006\u0014G.Z\"iC:tW\r\u001c\"vS2$WM\u001d\u0011\u0015\u0011E\u00128\u000f^;wobDQA\u000e\u000bA\u0002]BQ!\u0010\u000bA\u0002yBQ!\u0011\u000bA\u0002\tCQ!\u0012\u000bA\u0002\u0019CQa\u0015\u000bA\u0002\tCQ\u0001\u0016\u000bA\u0002YCQ\u0001\u001a\u000bA\u0002\u0019\f!b]8ve\u000e,gj\u001c3f+\u0005Y\bC\u00016}\u0013\ti(J\u0001\u0003O_\u0012,\u0017aC:pkJ\u001cWMT8eK\u0002\"\u0012#MA\u0001\u0003\u0007\t)!a\u0005\u0002\u0016\u0005]\u0011\u0011GA\u001e\u0011\u00151t\u00031\u00018\u0011\u0015it\u00031\u0001?\u0011\u001d\t9a\u0006a\u0001\u0003\u0013\tq!\\3ue&\u001c7\u000f\u0005\u0003\u0002\f\u0005=QBAA\u0007\u0015\r\t9AS\u0005\u0005\u0003#\tiAA\u0004NKR\u0014\u0018nY:\t\u000b\u0015;\u0002\u0019\u0001$\t\u000bM;\u0002\u0019\u0001\"\t\u000f\u0005eq\u00031\u0001\u0002\u001c\u0005A1\r\\5f]RLE\r\u0005\u0003\u0002\u001e\u0005-b\u0002BA\u0010\u0003O\u00012!!\t*\u001b\t\t\u0019CC\u0002\u0002&\t\na\u0001\u0010:p_Rt\u0014bAA\u0015S\u00051\u0001K]3eK\u001aLA!!\f\u00020\t11\u000b\u001e:j]\u001eT1!!\u000b*\u0011\u001d\t\u0019d\u0006a\u0001\u0003k\t!\u0002\\8h\u0007>tG/\u001a=u!\r9\u0015qG\u0005\u0004\u0003sA%A\u0003'pO\u000e{g\u000e^3yi\"9\u0011QH\fA\u0002\u0005m\u0011aD7fiJL7m\u0012:q!J,g-\u001b=\u0002\u001d\t\u0014xn[3s\u000b:$\u0007k\\5oiR\tq'A\u0006tK:$'+Z9vKN$H\u0003BA$\u0003\u001b\u00022aVA%\u0013\r\tY\u0005\u0017\u0002\u000f\u00072LWM\u001c;SKN\u0004xN\\:f\u0011\u001d\ty%\u0007a\u0001\u0003#\naB]3rk\u0016\u001cHOQ;jY\u0012,'\u000f\r\u0003\u0002T\u0005u\u0004CBA+\u0003g\nIH\u0004\u0003\u0002X\u00055d\u0002BA-\u0003SrA!a\u0017\u0002h9!\u0011QLA3\u001d\u0011\ty&a\u0019\u000f\t\u0005\u0005\u0012\u0011M\u0005\u0002!&\u0011ajT\u0005\u0003C5K!a\u0013'\n\u0007\u0005-$*\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\ty'!\u001d\u0002\u001f\u0005\u00137\u000f\u001e:bGR\u0014V-];fgRT1!a\u001bK\u0013\u0011\t)(a\u001e\u0003\u000f\t+\u0018\u000e\u001c3fe*!\u0011qNA9!\u0011\tY(! \r\u0001\u0011a\u0011qPA'\u0003\u0003\u0005\tQ!\u0001\u0002\u0002\n\u0019q\fJ\u001a\u0012\t\u0005\r\u0015\u0011\u0012\t\u0004Q\u0005\u0015\u0015bAADS\t9aj\u001c;iS:<\u0007\u0003BAF\u0003\u001bk!!!\u001d\n\t\u0005=\u0015\u0011\u000f\u0002\u0010\u0003\n\u001cHO]1diJ+\u0017/^3ti\u0006i\u0011N\\5uS\u0006$Xm\u00117pg\u0016$\u0012AX\u0001\u0006G2|7/Z\u0001\ti>\u001cFO]5oOR\u0011\u00111\u0004\u0005\u0006m\r\u0001\ra\u000e\u0005\u0006{\r\u0001\rA\u0010\u0005\b\u0003\u000f\u0019\u0001\u0019AA\u0005\u0011\u0015)5\u00011\u0001G\u0011\u0015\u00196\u00011\u0001C\u0011\u001d\tIb\u0001a\u0001\u00037Aq!a\r\u0004\u0001\u0004\t)\u0004C\u0005\u0002,\u000e\u0001\n\u00111\u0001\u0002.\u0006yQ\r\u001f;sC6+GO]5d)\u0006<7\u000f\u0005\u0005\u00020\u0006U\u00161DA\u000e\u001b\t\t\tLC\u0002\u00024&\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t9,!-\u0003\u00075\u000b\u0007/A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00139+\t\tiL\u000b\u0003\u0002.\u0006}6FAAa!\u0011\t\u0019-!4\u000e\u0005\u0005\u0015'\u0002BAd\u0003\u0013\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005-\u0017&\u0001\u0006b]:|G/\u0019;j_:LA!a4\u0002F\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002e\r\u0014X-\u0019;f\u001d\u0016$xo\u001c:l\u00072LWM\u001c;B]\u0012\u0014VmY8oM&<WO]1cY\u0016\u001c\u0005.\u00198oK2\u0014U/\u001b7eKJ$B#!6\u0002b\u0006\r\u0018Q]At\u0003S\fY/!<\u0002p\u0006E\bC\u0002\u0015\u0002X\u0006mg-C\u0002\u0002Z&\u0012a\u0001V;qY\u0016\u0014\u0004cA,\u0002^&\u0019\u0011q\u001c-\u0003\u001b9+Go^8sW\u000ec\u0017.\u001a8u\u0011\u00151T\u00011\u00018\u0011\u0015iT\u00011\u0001?\u0011\u001d\t9!\u0002a\u0001\u0003\u0013AQ!R\u0003A\u0002\u0019CQaU\u0003A\u0002\tCq!!\u0007\u0006\u0001\u0004\tY\u0002C\u0004\u00024\u0015\u0001\r!!\u000e\t\u0013\u0005-V\u0001%AA\u0002\u00055\u0006\"CA\u001f\u000bA\u0005\t\u0019AA\u000e\u0003q\u001a'/Z1uK:+Go^8sW\u000ec\u0017.\u001a8u\u0003:$'+Z2p]\u001aLw-\u001e:bE2,7\t[1o]\u0016d')^5mI\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001d\u0002y\r\u0014X-\u0019;f\u001d\u0016$xo\u001c:l\u00072LWM\u001c;B]\u0012\u0014VmY8oM&<WO]1cY\u0016\u001c\u0005.\u00198oK2\u0014U/\u001b7eKJ$C-\u001a4bk2$H%O\u000b\u0003\u0003sTC!a\u0007\u0002@\u0002")
public class BrokerBlockingSender
implements BlockingSend {
    private final BrokerEndPoint sourceBroker;
    private final KafkaConfig brokerConfig;
    private final int socketTimeout;
    private final Time time;
    private final int fetcherId;
    private KafkaClient networkClient;
    private Option<Reconfigurable> reconfigurableChannelBuilder;
    private final Node sourceNode;

    public static String createNetworkClientAndReconfigurableChannelBuilder$default$9() {
        return "replica-fetcher";
    }

    public static Map<String, String> createNetworkClientAndReconfigurableChannelBuilder$default$8() {
        return (Map)Map$.MODULE$.empty();
    }

    public static Tuple2<NetworkClient, Option<Reconfigurable>> createNetworkClientAndReconfigurableChannelBuilder(BrokerEndPoint sourceBroker, KafkaConfig brokerConfig, Metrics metrics, Time time, int fetcherId, String clientId, LogContext logContext, Map<String, String> extraMetricTags, String metricGrpPrefix) {
        return BrokerBlockingSender$.MODULE$.createNetworkClientAndReconfigurableChannelBuilder(sourceBroker, brokerConfig, metrics, time, fetcherId, clientId, logContext, extraMetricTags, metricGrpPrefix);
    }

    public static Map<String, String> apply$default$8() {
        return (Map)Map$.MODULE$.empty();
    }

    public static BrokerBlockingSender apply(BrokerEndPoint sourceBroker, KafkaConfig brokerConfig, Metrics metrics, Time time, int fetcherId, String clientId, LogContext logContext, Map<String, String> extraMetricTags) {
        return BrokerBlockingSender$.MODULE$.apply(sourceBroker, brokerConfig, metrics, time, fetcherId, clientId, logContext, extraMetricTags);
    }

    public KafkaClient networkClient() {
        return this.networkClient;
    }

    public void networkClient_$eq(KafkaClient x$1) {
        this.networkClient = x$1;
    }

    public Option<Reconfigurable> reconfigurableChannelBuilder() {
        return this.reconfigurableChannelBuilder;
    }

    public void reconfigurableChannelBuilder_$eq(Option<Reconfigurable> x$1) {
        this.reconfigurableChannelBuilder = x$1;
    }

    public Node sourceNode() {
        return this.sourceNode;
    }

    @Override
    public BrokerEndPoint brokerEndPoint() {
        return this.sourceBroker;
    }

    @Override
    public ClientResponse sendRequest(AbstractRequest.Builder<? extends AbstractRequest> requestBuilder) {
        try {
            if (!NetworkClientUtils.awaitReady((KafkaClient)this.networkClient(), (Node)this.sourceNode(), (Time)this.time, (long)this.socketTimeout)) {
                throw new SocketTimeoutException(new StringBuilder(28).append("Failed to connect within ").append(this.socketTimeout).append(" ms").toString());
            }
            ClientRequest clientRequest = this.networkClient().newClientRequest(Integer.toString(this.sourceBroker.id()), requestBuilder, this.time.milliseconds(), true);
            return NetworkClientUtils.sendAndReceive((KafkaClient)this.networkClient(), (ClientRequest)clientRequest, (Time)this.time);
        }
        catch (Throwable e) {
            this.networkClient().close(Integer.toString(this.sourceBroker.id()));
            throw e;
        }
    }

    @Override
    public void initiateClose() {
        this.reconfigurableChannelBuilder().foreach((Function1 & Serializable)reconfigurable -> {
            this.brokerConfig.removeReconfigurable(reconfigurable);
            return BoxedUnit.UNIT;
        });
        this.networkClient().initiateClose();
    }

    @Override
    public void close() {
        this.networkClient().close();
    }

    public String toString() {
        return new StringBuilder(47).append("BrokerBlockingSender(sourceBroker=").append(this.sourceBroker).append(", fetcherId=").append(this.fetcherId).append(")").toString();
    }

    public BrokerBlockingSender(BrokerEndPoint sourceBroker, KafkaConfig brokerConfig, int socketTimeout, Time time, int fetcherId, KafkaClient networkClient, Option<Reconfigurable> reconfigurableChannelBuilder) {
        this.sourceBroker = sourceBroker;
        this.brokerConfig = brokerConfig;
        this.socketTimeout = socketTimeout;
        this.time = time;
        this.fetcherId = fetcherId;
        this.networkClient = networkClient;
        this.reconfigurableChannelBuilder = reconfigurableChannelBuilder;
        this.sourceNode = new Node(sourceBroker.id(), sourceBroker.host(), sourceBroker.port());
    }

    /*
     * WARNING - void declaration
     */
    public BrokerBlockingSender(BrokerEndPoint sourceBroker, KafkaConfig brokerConfig, Metrics metrics, Time time, int fetcherId, String clientId, LogContext logContext, String metricGrpPrefix) {
        this(sourceBroker, brokerConfig, Predef$.MODULE$.Integer2int(brokerConfig.replicaSocketTimeoutMs()), time, fetcherId, null, null);
        void var12_12;
        void var11_11;
        Map x$9 = (Map)Map$.MODULE$.empty();
        Tuple2<NetworkClient, Option<Reconfigurable>> tuple2 = BrokerBlockingSender$.MODULE$.createNetworkClientAndReconfigurableChannelBuilder(sourceBroker, brokerConfig, metrics, time, fetcherId, clientId, logContext, (Map<String, String>)x$9, metricGrpPrefix);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        NetworkClient networkClient = (NetworkClient)tuple2._1();
        Option reconfigurableChannelBuilder = (Option)tuple2._2();
        this.networkClient_$eq((KafkaClient)var11_11);
        this.reconfigurableChannelBuilder_$eq((Option<Reconfigurable>)var12_12);
    }
}

