/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import io.confluent.k2.kafka.K2ControllerHandler;
import io.confluent.k2.kafka.K2TopicMetadata;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import kafka.network.RequestChannel;
import kafka.server.AuthHelper;
import kafka.server.K2ControllerApis$ErrorDetermination$;
import kafka.server.KafkaConfig;
import kafka.server.QuotaFactory;
import kafka.server.RequestHandlerHelper;
import kafka.utils.Logging;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.TopicDeletionDisabledException;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.message.DeleteTopicsRequestData;
import org.apache.kafka.common.message.DeleteTopicsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.CreateTopicsResponse;
import org.apache.kafka.common.requests.DeleteTopicsRequest;
import org.apache.kafka.common.requests.DeleteTopicsResponse;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.authorizer.Authorizer;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.MapOps;
import scala.collection.immutable.Seq;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\r\u0005d\u0001B\u001d;\u0001}B\u0001\u0002\u0014\u0001\u0003\u0002\u0003\u0006I!\u0014\u0005\t'\u0002\u0011\t\u0011)A\u0005)\"Aq\u000b\u0001B\u0001B\u0003%\u0001\f\u0003\u0005]\u0001\t\u0005\t\u0015!\u0003^\u0011!Y\u0007A!A!\u0002\u0013a\u0007\u0002\u0003>\u0001\u0005\u0003\u0005\u000b\u0011B>\t\u0015\u0005\u0015\u0001A!A!\u0002\u0013\t9\u0001\u0003\u0006\u0002\u001e\u0001\u0011\t\u0011)A\u0005\u0003?Aq!a\r\u0001\t\u0003\t)\u0004C\u0005\u0002J\u0001\u0011\r\u0011\"\u0001\u0002L!A\u00111\u000b\u0001!\u0002\u0013\ti\u0005C\u0005\u0002V\u0001\u0011\r\u0011\"\u0001\u0002X!A\u0011q\f\u0001!\u0002\u0013\tIF\u0002\u0004\u0002b\u0001!\u00111\r\u0005\u000b\u0003Kr!\u0011!Q\u0001\n\u0005\u001d\u0004BCA:\u001d\t\u0005\t\u0015!\u0003\u0002v!9\u00111\u0007\b\u0005\u0002\u0005\u0005\u0005\"CAF\u001d\u0001\u0007I\u0011BAG\u0011%\t9J\u0004a\u0001\n\u0013\tI\n\u0003\u0005\u0002&:\u0001\u000b\u0015BAH\u0011\u001d\t9K\u0004C\u0001\u0003S3a!a+\u0001\t\u00065\u0006BCAd-\tU\r\u0011\"\u0001\u0002J\"Q\u0011\u0011\u001d\f\u0003\u0012\u0003\u0006I!a3\t\u0015\u0005\rhC!f\u0001\n\u0003\t)\u000f\u0003\u0006\u0002nZ\u0011\t\u0012)A\u0005\u0003OD!\"a<\u0017\u0005+\u0007I\u0011AAy\u0011)\t\u0019P\u0006B\tB\u0003%\u00111\u001c\u0005\b\u0003g1B\u0011AA{\u0011%\tyPFA\u0001\n\u0003\u0011\t\u0001C\u0005\u0003\nY\t\n\u0011\"\u0001\u0003\f!I!\u0011\u0005\f\u0012\u0002\u0013\u0005!1\u0005\u0005\n\u0005O1\u0012\u0013!C\u0001\u0005SA\u0011B!\f\u0017\u0003\u0003%\tEa\f\t\u0013\tmb#!A\u0005\u0002\tu\u0002\"\u0003B -\u0005\u0005I\u0011\u0001B!\u0011%\u0011YEFA\u0001\n\u0003\u0012i\u0005C\u0005\u0003\\Y\t\t\u0011\"\u0001\u0003^!I!\u0011\r\f\u0002\u0002\u0013\u0005#1\r\u0005\n\u0005O2\u0012\u0011!C!\u0005SB\u0011Ba\u001b\u0017\u0003\u0003%\tE!\u001c\t\u0013\t=d#!A\u0005B\tEt!\u0003B;\u0001\u0005\u0005\t\u0012\u0002B<\r%\tY\u000bAA\u0001\u0012\u0013\u0011I\bC\u0004\u000241\"\tAa$\t\u0013\t-D&!A\u0005F\t5\u0004\"\u0003BIY\u0005\u0005I\u0011\u0011BJ\u0011%\u0011Y\nLA\u0001\n\u0003\u0013i\nC\u0004\u0003,\u0002!\tA!,\t\u000f\t\u0005\u0007\u0001\"\u0001\u0003D\"9!q\u0019\u0001\u0005\u0002\t%\u0007b\u0002Bg\u0001\u0011%!q\u001a\u0005\b\u0005'\u0004A\u0011\u0002Bk\u0011\u001d\u00119\u0010\u0001C\u0005\u0005sDqAa@\u0001\t\u0013\u0019\t\u0001C\u0004\u0004J\u0001!Iaa\u0013\u0003!-\u00134i\u001c8ue>dG.\u001a:Ba&\u001c(BA\u001e=\u0003\u0019\u0019XM\u001d<fe*\tQ(A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001\u0001e\t\u0005\u0002B\t6\t!IC\u0001D\u0003\u0015\u00198-\u00197b\u0013\t)%I\u0001\u0004B]f\u0014VM\u001a\t\u0003\u000f*k\u0011\u0001\u0013\u0006\u0003\u0013r\nQ!\u001e;jYNL!a\u0013%\u0003\u000f1{wmZ5oO\u0006q!/Z9vKN$8\t[1o]\u0016d\u0007C\u0001(R\u001b\u0005y%B\u0001)=\u0003\u001dqW\r^<pe.L!AU(\u0003\u001dI+\u0017/^3ti\u000eC\u0017M\u001c8fY\u0006A!M]8lKJLE\r\u0005\u0002B+&\u0011aK\u0011\u0002\u0004\u0013:$\u0018AB2p]\u001aLw\r\u0005\u0002Z56\t!(\u0003\u0002\\u\tY1*\u00194lC\u000e{gNZ5h\u0003)\tW\u000f\u001e5pe&TXM\u001d\t\u0004\u0003z\u0003\u0017BA0C\u0005\u0019y\u0005\u000f^5p]B\u0011\u0011-[\u0007\u0002E*\u0011Al\u0019\u0006\u0003w\u0011T!!P3\u000b\u0005\u0019<\u0017AB1qC\u000eDWMC\u0001i\u0003\ry'oZ\u0005\u0003U\n\u0014!\"Q;uQ>\u0014\u0018N_3s\u0003\u0019\tXo\u001c;bgB\u0011Qn\u001e\b\u0003]Vt!a\u001c;\u000f\u0005A\u001cX\"A9\u000b\u0005It\u0014A\u0002\u001fs_>$h(C\u0001>\u0013\tYD(\u0003\u0002wu\u0005a\u0011+^8uC\u001a\u000b7\r^8ss&\u0011\u00010\u001f\u0002\u000e#V|G/Y'b]\u0006<WM]:\u000b\u0005YT\u0014\u0001\u0002;j[\u0016\u00042\u0001`A\u0001\u001b\u0005i(BA%\u007f\u0015\tyH-\u0001\u0004d_6lwN\\\u0005\u0004\u0003\u0007i(\u0001\u0002+j[\u0016\f\u0001dY8oiJ|G\u000e\\3s%\u0016\fX/Z:u\u0011\u0006tG\r\\3s!\u0011\tI!!\u0007\u000e\u0005\u0005-!bA\u001f\u0002\u000e)!\u0011qBA\t\u0003\tY'G\u0003\u0003\u0002\u0014\u0005U\u0011!C2p]\u001adW/\u001a8u\u0015\t\t9\"\u0001\u0002j_&!\u00111DA\u0006\u0005MY%gQ8oiJ|G\u000e\\3s\u0011\u0006tG\r\\3s\u0003!)\u00070Z2vi>\u0014\b\u0003BA\u0011\u0003_i!!a\t\u000b\t\u0005\u0015\u0012qE\u0001\u000bG>t7-\u001e:sK:$(\u0002BA\u0015\u0003W\tA!\u001e;jY*\u0011\u0011QF\u0001\u0005U\u00064\u0018-\u0003\u0003\u00022\u0005\r\"\u0001C#yK\u000e,Ho\u001c:\u0002\rqJg.\u001b;?)I\t9$!\u000f\u0002<\u0005u\u0012qHA!\u0003\u0007\n)%a\u0012\u0011\u0005e\u0003\u0001\"\u0002'\n\u0001\u0004i\u0005\"B*\n\u0001\u0004!\u0006\"B,\n\u0001\u0004A\u0006\"\u0002/\n\u0001\u0004i\u0006\"B6\n\u0001\u0004a\u0007\"\u0002>\n\u0001\u0004Y\bbBA\u0003\u0013\u0001\u0007\u0011q\u0001\u0005\b\u0003;I\u0001\u0019AA\u0010\u00035\u0011X-];fgRDU\r\u001c9feV\u0011\u0011Q\n\t\u00043\u0006=\u0013bAA)u\t!\"+Z9vKN$\b*\u00198eY\u0016\u0014\b*\u001a7qKJ\faB]3rk\u0016\u001cH\u000fS3ma\u0016\u0014\b%\u0001\u0006bkRD\u0007*\u001a7qKJ,\"!!\u0017\u0011\u0007e\u000bY&C\u0002\u0002^i\u0012!\"Q;uQ\"+G\u000e]3s\u0003-\tW\u000f\u001e5IK2\u0004XM\u001d\u0011\u0003#\rcWo\u001d;fe\u0006+H\u000f[8sSj,'o\u0005\u0002\u000f\u0001\u0006q!/Z9vKN$8i\u001c8uKb$\b\u0003BA5\u0003_j!!a\u001b\u000b\u0007\u00055d0\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\t\t(a\u001b\u0003\u001dI+\u0017/^3ti\u000e{g\u000e^3yi\u0006Iq\u000e]3sCRLwN\u001c\t\u0005\u0003o\ni(\u0004\u0002\u0002z)\u0019\u00111\u0010@\u0002\u0007\u0005\u001cG.\u0003\u0003\u0002\u0000\u0005e$\u0001D!dY>\u0003XM]1uS>tGCBAB\u0003\u000f\u000bI\tE\u0002\u0002\u0006:i\u0011\u0001\u0001\u0005\b\u0003K\n\u0002\u0019AA4\u0011\u001d\t\u0019(\u0005a\u0001\u0003k\nq\u0003[1t\u00072,8\u000f^3s\u0003V$\bn\u001c:ju\u0006$\u0018n\u001c8\u0016\u0005\u0005=\u0005\u0003B!_\u0003#\u00032!QAJ\u0013\r\t)J\u0011\u0002\b\u0005>|G.Z1o\u0003mA\u0017m]\"mkN$XM]!vi\"|'/\u001b>bi&|gn\u0018\u0013fcR!\u00111TAQ!\r\t\u0015QT\u0005\u0004\u0003?\u0013%\u0001B+oSRD\u0011\"a)\u0014\u0003\u0003\u0005\r!a$\u0002\u0007a$\u0013'\u0001\riCN\u001cE.^:uKJ\fU\u000f\u001e5pe&T\u0018\r^5p]\u0002\nA\"[:BkRDwN]5{K\u0012,\"!!%\u0003%\u0015\u0013(o\u001c:EKR,'/\\5oCRLwN\\\n\u0007-\u0001\u000by+!.\u0011\u0007\u0005\u000b\t,C\u0002\u00024\n\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0003\u00028\u0006\u0005g\u0002BA]\u0003{s1\u0001]A^\u0013\u0005\u0019\u0015bAA`\u0005\u00069\u0001/Y2lC\u001e,\u0017\u0002BAb\u0003\u000b\u0014AbU3sS\u0006d\u0017N_1cY\u0016T1!a0C\u0003)!x\u000e]5d\u001d\u0006lWm]\u000b\u0003\u0003\u0017\u0004b!!4\u0002V\u0006mg\u0002BAh\u0003#\u0004\"\u0001\u001d\"\n\u0007\u0005M')\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003/\fINA\u0002TKRT1!a5C!\u0011\ti-!8\n\t\u0005}\u0017\u0011\u001c\u0002\u0007'R\u0014\u0018N\\4\u0002\u0017Q|\u0007/[2OC6,7\u000fI\u0001\nKJ\u0014xN]\"pI\u0016,\"!a:\u0011\u0007\u0005\u000bI/C\u0002\u0002l\n\u0013Qa\u00155peR\f!\"\u001a:s_J\u001cu\u000eZ3!\u00031)'O]8s\u001b\u0016\u001c8/Y4f+\t\tY.A\u0007feJ|'/T3tg\u0006<W\r\t\u000b\t\u0003o\fI0a?\u0002~B\u0019\u0011Q\u0011\f\t\u000f\u0005\u001dW\u00041\u0001\u0002L\"9\u00111]\u000fA\u0002\u0005\u001d\bbBAx;\u0001\u0007\u00111\\\u0001\u0005G>\u0004\u0018\u0010\u0006\u0005\u0002x\n\r!Q\u0001B\u0004\u0011%\t9M\bI\u0001\u0002\u0004\tY\rC\u0005\u0002dz\u0001\n\u00111\u0001\u0002h\"I\u0011q\u001e\u0010\u0011\u0002\u0003\u0007\u00111\\\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011iA\u000b\u0003\u0002L\n=1F\u0001B\t!\u0011\u0011\u0019B!\b\u000e\u0005\tU!\u0002\u0002B\f\u00053\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\tm!)\u0001\u0006b]:|G/\u0019;j_:LAAa\b\u0003\u0016\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!Q\u0005\u0016\u0005\u0003O\u0014y!\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\t-\"\u0006BAn\u0005\u001f\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXC\u0001B\u0019!\u0011\u0011\u0019D!\u000f\u000e\u0005\tU\"\u0002\u0002B\u001c\u0003W\tA\u0001\\1oO&!\u0011q\u001cB\u001b\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\u0005!\u0016A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0005\u0007\u0012I\u0005E\u0002B\u0005\u000bJ1Aa\u0012C\u0005\r\te.\u001f\u0005\t\u0003G#\u0013\u0011!a\u0001)\u0006y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003PA1!\u0011\u000bB,\u0005\u0007j!Aa\u0015\u000b\u0007\tU#)\u0001\u0006d_2dWm\u0019;j_:LAA!\u0017\u0003T\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t\tJa\u0018\t\u0013\u0005\rf%!AA\u0002\t\r\u0013A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$BA!\r\u0003f!A\u00111U\u0014\u0002\u0002\u0003\u0007A+\u0001\u0005iCND7i\u001c3f)\u0005!\u0016\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\tE\u0012AB3rk\u0006d7\u000f\u0006\u0003\u0002\u0012\nM\u0004\"CARU\u0005\u0005\t\u0019\u0001B\"\u0003I)%O]8s\t\u0016$XM]7j]\u0006$\u0018n\u001c8\u0011\u0007\u0005\u0015EfE\u0003-\u0005w\u00129\t\u0005\u0007\u0003~\t\r\u00151ZAt\u00037\f90\u0004\u0002\u0003\u0000)\u0019!\u0011\u0011\"\u0002\u000fI,h\u000e^5nK&!!Q\u0011B@\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\t\u0005\u0005\u0013\u0013i)\u0004\u0002\u0003\f*!\u0011qCA\u0016\u0013\u0011\t\u0019Ma#\u0015\u0005\t]\u0014!B1qa2LH\u0003CA|\u0005+\u00139J!'\t\u000f\u0005\u001dw\u00061\u0001\u0002L\"9\u00111]\u0018A\u0002\u0005\u001d\bbBAx_\u0001\u0007\u00111\\\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011yJa*\u0011\t\u0005s&\u0011\u0015\t\n\u0003\n\r\u00161ZAt\u00037L1A!*C\u0005\u0019!V\u000f\u001d7fg!I!\u0011\u0016\u0019\u0002\u0002\u0003\u0007\u0011q_\u0001\u0004q\u0012\u0002\u0014!\u00075b]\u0012dWm\u0011:fCR,Gk\u001c9jGN\u0014V-];fgR$B!a'\u00030\"9!\u0011W\u0019A\u0002\tM\u0016a\u0002:fcV,7\u000f\u001e\t\u0005\u0005k\u0013YLD\u0002O\u0005oK1A!/P\u00039\u0011V-];fgR\u001c\u0005.\u00198oK2LAA!0\u0003@\n9!+Z9vKN$(b\u0001B]\u001f\u0006I\u0002.\u00198eY\u0016$U\r\\3uKR{\u0007/[2t%\u0016\fX/Z:u)\u0011\tYJ!2\t\u000f\tE&\u00071\u0001\u00034\u0006i\u0002.\u00198eY\u0016\u001c%/Z1uKB\u000b'\u000f^5uS>t7OU3rk\u0016\u001cH\u000f\u0006\u0003\u0002\u001c\n-\u0007b\u0002BYg\u0001\u0007!1W\u0001\u001cG>tg-\u001b:n)>\u0004\u0018n\u0019#fY\u0016$\u0018n\u001c8F]\u0006\u0014G.\u001a3\u0015\t\u0005m%\u0011\u001b\u0005\b\u0005c#\u0004\u0019\u0001BZ\u0003\u0005:W\r\u001e(p]j+'o\u001c+pa&\u001c\u0017\nZ:U_>\u001b7-\u001e:sK:\u001cW-T1q)\u0011\u00119N!<\u0011\u0011\te'1\u001cBp\u0005Ol!!a\n\n\t\tu\u0017q\u0005\u0002\b\u0011\u0006\u001c\b.T1q!\u0011\u0011\tOa9\u000e\u0003yL1A!:\u007f\u0005\u0011)V/\u001b3\u0011\t\tM\"\u0011^\u0005\u0005\u0005W\u0014)DA\u0004J]R,w-\u001a:\t\u000f\t=X\u00071\u0001\u0003r\u0006\u0019B-\u001a7fi\u0016$v\u000e]5dgJ+\u0017/^3tiB!\u0011\u0011\u000eBz\u0013\u0011\u0011)0a\u001b\u0003'\u0011+G.\u001a;f)>\u0004\u0018nY:SKF,Xm\u001d;\u0002G\u001d,GOT8o\u001dVdG\u000eV8qS\u000et\u0015-\\3t)>|5mY;se\u0016t7-Z'baR!!1 B\u007f!!\u0011INa7\u0002\\\n\u001d\bb\u0002Bxm\u0001\u0007!\u0011_\u0001%CV$\bn\u001c:ju\u0016\fe\u000e\u001a)paVd\u0017\r^3UK:$\u0018\r^5wKJ+7/\u001e7ugRQ11AB\u0005\u0007\u0017\u0019)ba\b\u0011\r\te7QAAn\u0013\u0011\u00199!a\n\u0003\u000f!\u000b7\u000f[*fi\"9\u0011QM\u001cA\u0002\u0005\u001d\u0004bBB\u0007o\u0001\u00071qB\u0001\u0014GJ,\u0017\r^3U_BL7m\u001d*fcV,7\u000f\u001e\t\u0005\u0003S\u001a\t\"\u0003\u0003\u0004\u0014\u0005-$aE\"sK\u0006$X\rV8qS\u000e\u001c(+Z9vKN$\bbBB\fo\u0001\u00071\u0011D\u0001\u000fa>\u001c8/\u001b2mK\u0016\u0013(o\u001c:t!\u0019\u0011Ina\u0007\u0002x&!1QDA\u0014\u0005%\t%O]1z\u0019&\u001cH\u000fC\u0004\u0004\"]\u0002\raa\t\u0002\u000fI,7/\u001e7ugB!1QEB\"\u001d\u0011\u00199c!\u0010\u000f\t\r%2\u0011\b\b\u0005\u0007W\u00199D\u0004\u0003\u0004.\rUb\u0002BB\u0018\u0007gq1\u0001]B\u0019\u0013\u0005A\u0017B\u00014h\u0013\tiT-\u0003\u0002\u0000I&\u001911\b@\u0002\u000f5,7o]1hK&!1qHB!\u0003a\u0019%/Z1uKR{\u0007/[2t%\u0016\u001c\bo\u001c8tK\u0012\u000bG/\u0019\u0006\u0004\u0007wq\u0018\u0002BB#\u0007\u000f\u0012ad\u0011:fCR\f'\r\\3U_BL7MU3tk2$8i\u001c7mK\u000e$\u0018n\u001c8\u000b\t\r}2\u0011I\u0001\u000eO\u0016$h)\u001b7uKJ,GMQ=\u0015\r\r531LB/!\u0011\u0019ye!\u0016\u000f\t\r\u001d2\u0011K\u0005\u0005\u0007'\u001a\t%A\fDe\u0016\fG/\u001a+pa&\u001c7OU3rk\u0016\u001cH\u000fR1uC&!1qKB-\u0005a\u0019%/Z1uC\ndW\rV8qS\u000e\u001cu\u000e\u001c7fGRLwN\u001c\u0006\u0005\u0007'\u001a\t\u0005C\u0004\u0004\u000ea\u0002\raa\u0004\t\u000f\r}\u0003\b1\u0001\u0004\u0004\u00059Bo\u001c9jG:\u000bW.Z:U_R\u0013\u0018\u0010V8De\u0016\fG/\u001a")
public class K2ControllerApis
implements Logging {
    private volatile K2ControllerApis$ErrorDetermination$ ErrorDetermination$module;
    private final KafkaConfig config;
    private final K2ControllerHandler controllerRequestHandler;
    private final Executor executor;
    private final RequestHandlerHelper requestHelper;
    private final AuthHelper authHelper;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private K2ControllerApis$ErrorDetermination$ ErrorDetermination() {
        if (this.ErrorDetermination$module == null) {
            this.ErrorDetermination$lzycompute$1();
        }
        return this.ErrorDetermination$module;
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public RequestHandlerHelper requestHelper() {
        return this.requestHelper;
    }

    public AuthHelper authHelper() {
        return this.authHelper;
    }

    public void handleCreateTopicsRequest(RequestChannel.Request request) {
        None$ maybeTopicNamesToCreate;
        CreateTopicsRequest createTopicsRequest = (CreateTopicsRequest)request.body(ClassTag$.MODULE$.apply(CreateTopicsRequest.class));
        Iterable topics = CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)createTopicsRequest.data().topics()).asScala();
        scala.collection.immutable.Set topicNameSet = ((Iterable)topics.map((Function1 & Serializable)x$1 -> x$1.name())).toSet();
        boolean validateOnly = createTopicsRequest.data().validateOnly();
        ArrayList<ErrorDetermination> possibleErrors = new ArrayList<ErrorDetermination>();
        possibleErrors.add(new ErrorDetermination(this, (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"__cluster_metadata"}))), Errors.INVALID_REQUEST.code(), "Cannot create a topic with name __cluster_metadata."));
        scala.collection.immutable.Set mirroredTopicsUnsupportedInK2 = ((IterableOnceOps)((IterableOps)topics.filter((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)K2ControllerApis.$anonfun$handleCreateTopicsRequest$2(t)))).map((Function1 & Serializable)x$2 -> x$2.name())).toSet();
        possibleErrors.add(new ErrorDetermination(this, (scala.collection.immutable.Set<String>)mirroredTopicsUnsupportedInK2, Errors.INVALID_REQUEST.code(), "Mirror topics are not supported."));
        scala.collection.immutable.Set duplicatedTopicNames = ((MapOps)((IterableOps)topics.filter((Function1 & Serializable)topic -> BoxesRunTime.boxToBoolean((boolean)topicNameSet.contains((Object)topic.name())))).groupBy((Function1 & Serializable)x$3 -> x$3.name()).filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)K2ControllerApis.$anonfun$handleCreateTopicsRequest$6(x0$1)))).keySet();
        possibleErrors.add(new ErrorDetermination(this, (scala.collection.immutable.Set<String>)duplicatedTopicNames, Errors.INVALID_REQUEST.code(), "Found multiple entries for this topic."));
        CreateTopicsResponseData.CreatableTopicResultCollection results = new CreateTopicsResponseData.CreatableTopicResultCollection(createTopicsRequest.data().topics().size());
        HashSet<String> topicNamesToTryToCreate = this.authorizeAndPopulateTentativeResults(request.context(), createTopicsRequest, possibleErrors, results);
        Object object = maybeTopicNamesToCreate = topicNamesToTryToCreate.isEmpty() ? None$.MODULE$ : new Some((Object)this.getFilteredBy(createTopicsRequest, topicNamesToTryToCreate));
        if (maybeTopicNamesToCreate instanceof Some) {
            CreateTopicsRequestData.CreatableTopicCollection topics2 = (CreateTopicsRequestData.CreatableTopicCollection)((Some)maybeTopicNamesToCreate).value();
            this.controllerRequestHandler.createTopics(topics2, validateOnly).whenCompleteAsyncRaw((createResult, throwable) -> this.sendResponse$1((CreateTopicsResponseData.CreatableTopicResultCollection)createResult, (Throwable)throwable, createTopicsRequest, results, request), this.executor);
            return;
        }
        if (None$.MODULE$.equals(maybeTopicNamesToCreate)) {
            this.sendResponse$1(new CreateTopicsResponseData.CreatableTopicResultCollection(), null, createTopicsRequest, results, request);
            return;
        }
        throw new MatchError((Object)maybeTopicNamesToCreate);
    }

    public void handleDeleteTopicsRequest(RequestChannel.Request request) {
        this.confirmTopicDeletionEnabled(request);
        DeleteTopicsRequest deleteTopicsRequest = (DeleteTopicsRequest)request.body(ClassTag$.MODULE$.apply(DeleteTopicsRequest.class));
        HashMap<String, Integer> nonNullTopicNamesToOccurrenceMap = this.getNonNullTopicNamesToOccurrenceMap(deleteTopicsRequest);
        HashSet nonNullNonRepeatedTopicNames = new HashSet();
        nonNullTopicNamesToOccurrenceMap.entrySet().stream().filter(entry -> BoxesRunTime.equals(entry.getValue(), (Object)BoxesRunTime.boxToInteger((int)1))).forEach(entry -> nonNullNonRepeatedTopicNames.add(entry.getKey()));
        HashMap<Uuid, Integer> nonZeroTopicIdsToOccurrenceMap = this.getNonZeroTopicIdsToOccurrenceMap(deleteTopicsRequest);
        HashSet nonZeroNonRepeatedTopicIds = new HashSet();
        nonZeroTopicIdsToOccurrenceMap.entrySet().stream().filter(entry -> BoxesRunTime.equals(entry.getValue(), (Object)BoxesRunTime.boxToInteger((int)1))).forEach(entry -> nonZeroNonRepeatedTopicIds.add(entry.getKey()));
        if (nonNullNonRepeatedTopicNames.isEmpty() && nonZeroNonRepeatedTopicIds.isEmpty()) {
            this.maybeTryToDeleteTopicsAndSendResponse$1(Collections.emptySet(), null, request, deleteTopicsRequest, nonNullTopicNamesToOccurrenceMap, nonZeroTopicIdsToOccurrenceMap);
            return;
        }
        this.controllerRequestHandler.getTopicMetadata(nonNullNonRepeatedTopicNames, nonZeroNonRepeatedTopicIds).whenCompleteAsyncRaw((topicMetadataForDeletions, throwable) -> this.maybeTryToDeleteTopicsAndSendResponse$1((Set)topicMetadataForDeletions, (Throwable)throwable, request, deleteTopicsRequest, nonNullTopicNamesToOccurrenceMap, nonZeroTopicIdsToOccurrenceMap), this.executor);
    }

    public void handleCreatePartitionsRequest(RequestChannel.Request request) {
        throw new UnsupportedOperationException("Create Partitions is not yet supported in K2");
    }

    private void confirmTopicDeletionEnabled(RequestChannel.Request request) {
        if (!Predef$.MODULE$.Boolean2boolean(this.config.deleteTopicEnable())) {
            this.info((Function0<String>)(Function0 & Serializable)() -> "K2 DELETE_TOPICS disabled");
            if (request.header().apiVersion() < 3) {
                throw new InvalidRequestException("Topic deletion is disabled.");
            }
            throw new TopicDeletionDisabledException();
        }
    }

    private HashMap<Uuid, Integer> getNonZeroTopicIdsToOccurrenceMap(DeleteTopicsRequest deleteTopicsRequest) {
        HashMap<Uuid, Integer> topicIdsToOccurrences = new HashMap<Uuid, Integer>();
        deleteTopicsRequest.topics().stream().filter(topic -> !topic.topicId().equals((Object)Uuid.ZERO_UUID)).forEach(topic -> topicIdsToOccurrences.put(topic.topicId(), Predef$.MODULE$.int2Integer(1 + Predef$.MODULE$.Integer2int(topicIdsToOccurrences.getOrDefault(topic.topicId(), Predef$.MODULE$.int2Integer(0))))));
        return topicIdsToOccurrences;
    }

    private HashMap<String, Integer> getNonNullTopicNamesToOccurrenceMap(DeleteTopicsRequest deleteTopicsRequest) {
        HashMap<String, Integer> topicNamesToOccurrences = new HashMap<String, Integer>();
        deleteTopicsRequest.topics().stream().filter(topic -> topic.name() != null).forEach(topic -> topicNamesToOccurrences.put(topic.name(), Predef$.MODULE$.int2Integer(1 + Predef$.MODULE$.Integer2int(topicNamesToOccurrences.getOrDefault(topic.name(), Predef$.MODULE$.int2Integer(0))))));
        return topicNamesToOccurrences;
    }

    private HashSet<String> authorizeAndPopulateTentativeResults(RequestContext requestContext, CreateTopicsRequest createTopicsRequest, ArrayList<ErrorDetermination> possibleErrors, CreateTopicsResponseData.CreatableTopicResultCollection results) {
        ClusterAuthorizer clusterAuthorizer = new ClusterAuthorizer(this, requestContext, AclOperation.CREATE);
        HashSet<String> topicNamesToTryToCreate = new HashSet<String>();
        createTopicsRequest.data().topics().forEach(topic -> {
            CreateTopicsResponseData.CreatableTopicResult resultForTopicSoFar = new CreateTopicsResponseData.CreatableTopicResult().setName(topic.name()).setErrorCode(Errors.NONE.code());
            Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(possibleErrors.stream().filter(x$6 -> x$6.topicNames().contains((Object)topic.name())).findFirst()));
            if (option instanceof Some) {
                ErrorDetermination determinedError = (ErrorDetermination)((Some)option).value();
                resultForTopicSoFar.setErrorCode(determinedError.errorCode()).setErrorMessage(determinedError.errorMessage());
            } else if (None$.MODULE$.equals(option)) {
                if (clusterAuthorizer.isAuthorized() || this.authHelper().authorize(requestContext, AclOperation.CREATE, ResourceType.TOPIC, topic.name(), this.authHelper().authorize$default$5(), this.authHelper().authorize$default$6(), this.authHelper().authorize$default$7())) {
                    topicNamesToTryToCreate.add(topic.name());
                } else {
                    resultForTopicSoFar.setErrorCode(Errors.TOPIC_AUTHORIZATION_FAILED.code()).setErrorMessage("Authorization failed.");
                }
            } else {
                throw new MatchError((Object)option);
            }
            results.add((ImplicitLinkedHashCollection.Element)resultForTopicSoFar);
        });
        return topicNamesToTryToCreate;
    }

    private CreateTopicsRequestData.CreatableTopicCollection getFilteredBy(CreateTopicsRequest createTopicsRequest, HashSet<String> topicNamesToTryToCreate) {
        CreateTopicsRequestData.CreatableTopicCollection creatableTopicsFiltered = new CreateTopicsRequestData.CreatableTopicCollection(topicNamesToTryToCreate.size());
        Integer defaultNumPartitions = this.config.numPartitions();
        createTopicsRequest.data().topics().stream().filter(topic -> topicNamesToTryToCreate.contains(topic.name())).forEach(topic -> {
            if (!creatableTopicsFiltered.add((ImplicitLinkedHashCollection.Element)(topic.numPartitions() == -1 ? topic.duplicate().setNumPartitions(Predef$.MODULE$.Integer2int(defaultNumPartitions)) : topic.duplicate()))) {
                throw new IllegalStateException(new StringBuilder(93).append("Unable to create topic with name = ").append(topic.name()).append(" due to failure to add to collection (should never happen)").toString());
            }
        });
        return creatableTopicsFiltered;
    }

    private final void ErrorDetermination$lzycompute$1() {
        synchronized (this) {
            if (this.ErrorDetermination$module == null) {
                this.ErrorDetermination$module = new K2ControllerApis$ErrorDetermination$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$handleCreateTopicsRequest$2(CreateTopicsRequestData.CreatableTopic t) {
        return t.linkName() != null && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(t.linkName()));
    }

    public static final /* synthetic */ boolean $anonfun$handleCreateTopicsRequest$6(Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((Iterable)x0$1._2()).size() > 1;
        }
        throw new MatchError(null);
    }

    private final void sendResponse$1(CreateTopicsResponseData.CreatableTopicResultCollection createResult, Throwable throwable, CreateTopicsRequest createTopicsRequest$1, CreateTopicsResponseData.CreatableTopicResultCollection results$1, RequestChannel.Request request$1) {
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(80).append("Processed CreateTopicsRequest ").append(createTopicsRequest$1).append(" via K2 topic metadata store. result: ").append(createResult).append(" throwable: ").append(throwable).toString());
        createResult.stream().forEach(creatableTopicResult -> {
            CreateTopicsResponseData.CreatableTopicResult originalResultForTopic = results$1.find(creatableTopicResult.name());
            originalResultForTopic.setErrorCode(throwable == null ? creatableTopicResult.errorCode() : Errors.forException((Throwable)throwable).code()).setErrorMessage(throwable == null ? creatableTopicResult.errorMessage() : throwable.getMessage());
            boolean errored = creatableTopicResult.errorCode() != Errors.NONE.code();
            originalResultForTopic.setTopicId(creatableTopicResult.topicId()).setNumPartitions(errored ? -1 : creatableTopicResult.numPartitions()).setReplicationFactor(errored ? (short)-1 : (short)creatableTopicResult.replicationFactor()).setConfigs(creatableTopicResult.configs()).setTopicConfigErrorCode(errored ? Errors.NONE.code() : creatableTopicResult.topicConfigErrorCode());
        });
        CreateTopicsResponse response = new CreateTopicsResponse(new CreateTopicsResponseData().setTopics(results$1));
        this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(63).append("Sending create topics response ").append(response).append(" for correlation id ").append(request$1.header().correlationId()).append(" to client ").append(request$1.header().clientId()).append(".").toString());
        this.requestHelper().sendResponseMaybeThrottle(request$1, (Function1<Object, AbstractResponse>)(Function1 & Serializable)x$4 -> response);
    }

    private static final boolean hasTopicName$1(DeleteTopicsRequestData.DeleteTopicState topic) {
        return topic.name() != null;
    }

    private static final boolean hasTopicId$1(DeleteTopicsRequestData.DeleteTopicState topic) {
        return !topic.topicId().equals((Object)Uuid.ZERO_UUID);
    }

    public static final /* synthetic */ boolean $anonfun$handleDeleteTopicsRequest$6(K2TopicMetadata k2tm) {
        K2TopicMetadata.K2TopicLifecycleState k2TopicLifecycleState = k2tm.k2TopicLifecycleState();
        K2TopicMetadata.K2TopicLifecycleState k2TopicLifecycleState2 = K2TopicMetadata.K2TopicLifecycleState.ONLINE;
        return !(k2TopicLifecycleState != null ? !k2TopicLifecycleState.equals(k2TopicLifecycleState2) : k2TopicLifecycleState2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$handleDeleteTopicsRequest$8(K2TopicMetadata k2tm) {
        K2TopicMetadata.K2TopicLifecycleState k2TopicLifecycleState = k2tm.k2TopicLifecycleState();
        K2TopicMetadata.K2TopicLifecycleState k2TopicLifecycleState2 = K2TopicMetadata.K2TopicLifecycleState.ONLINE;
        return !(k2TopicLifecycleState != null ? !k2TopicLifecycleState.equals(k2TopicLifecycleState2) : k2TopicLifecycleState2 != null);
    }

    private static final void addResponse$1(String name, Uuid id, ApiError error, HashSet responses$1) {
        responses$1.add(new DeleteTopicsResponseData.DeletableTopicResult().setName(name).setTopicId(id).setErrorCode(error.error().code()).setErrorMessage(error.message()));
    }

    private final void sendResponses$1(HashSet responses$1, RequestChannel.Request request$2) {
        DeleteTopicsResponseData.DeletableTopicResultCollection collection = new DeleteTopicsResponseData.DeletableTopicResultCollection();
        responses$1.forEach(x$1 -> collection.add((ImplicitLinkedHashCollection.Element)x$1));
        DeleteTopicsResponse responseToSend = new DeleteTopicsResponse(new DeleteTopicsResponseData().setResponses(collection));
        this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(63).append("Sending delete topics response ").append(responseToSend).append(" for correlation id ").append(request$2.header().correlationId()).append(" to client ").append(request$2.header().clientId()).append(".").toString());
        this.requestHelper().sendResponseMaybeThrottle(request$2, (Function1<Object, AbstractResponse>)(Function1 & Serializable)x$5 -> responseToSend);
    }

    private final void maybeTryToDeleteTopicsAndSendResponse$1(Set topicMetadataForDeletions, Throwable throwable2, RequestChannel.Request request$2, DeleteTopicsRequest deleteTopicsRequest$1, HashMap nonNullTopicNamesToOccurrenceMap$1, HashMap nonZeroTopicIdsToOccurrenceMap$1) {
        Map topicMetadataByName = ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.SetHasAsScala(topicMetadataForDeletions).asScala().filter((Function1 & Serializable)k2tm -> BoxesRunTime.boxToBoolean((boolean)K2ControllerApis.$anonfun$handleDeleteTopicsRequest$6(k2tm)))).map((Function1 & Serializable)k2tm -> new Tuple2((Object)k2tm.topicName(), k2tm))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Map topicMetadataById = ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.SetHasAsScala(topicMetadataForDeletions).asScala().filter((Function1 & Serializable)k2tm -> BoxesRunTime.boxToBoolean((boolean)K2ControllerApis.$anonfun$handleDeleteTopicsRequest$8(k2tm)))).map((Function1 & Serializable)k2tm -> new Tuple2((Object)k2tm.topicId(), k2tm))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        HashSet responses = new HashSet();
        HashSet potentiallyAuthorizeTopicNames = new HashSet();
        HashSet potentiallyAuthorizeTopicIds = new HashSet();
        deleteTopicsRequest$1.topics().forEach(topic -> {
            if (!K2ControllerApis.hasTopicName$1(topic) && !K2ControllerApis.hasTopicId$1(topic)) {
                K2ControllerApis.addResponse$1(null, Uuid.ZERO_UUID, new ApiError(Errors.INVALID_REQUEST, "Neither topic name nor id were specified."), responses);
                return;
            }
            if (K2ControllerApis.hasTopicName$1(topic) && K2ControllerApis.hasTopicId$1(topic)) {
                K2ControllerApis.addResponse$1(topic.name(), topic.topicId(), new ApiError(Errors.INVALID_REQUEST, "You may not specify both topic name and topic id."), responses);
                return;
            }
            if (K2ControllerApis.hasTopicName$1(topic) && Predef$.MODULE$.Integer2int((Integer)nonNullTopicNamesToOccurrenceMap$1.get(topic.name())) > 1) {
                K2ControllerApis.addResponse$1(topic.name(), Uuid.ZERO_UUID, new ApiError(Errors.INVALID_REQUEST, "Duplicate topic name."), responses);
                return;
            }
            if (K2ControllerApis.hasTopicId$1(topic) && Predef$.MODULE$.Integer2int((Integer)nonZeroTopicIdsToOccurrenceMap$1.get(topic.topicId())) > 1) {
                K2ControllerApis.addResponse$1(null, topic.topicId(), new ApiError(Errors.INVALID_REQUEST, "Duplicate topic id."), responses);
                return;
            }
            if (K2ControllerApis.hasTopicName$1(topic)) {
                if (throwable2 == null && !topicMetadataByName.contains((Object)topic.name())) {
                    K2ControllerApis.addResponse$1(topic.name(), Uuid.ZERO_UUID, new ApiError(Errors.UNKNOWN_TOPIC_OR_PARTITION), responses);
                    return;
                }
                potentiallyAuthorizeTopicNames.add(topic.name());
                return;
            }
            if (throwable2 == null && !topicMetadataById.contains((Object)topic.topicId())) {
                K2ControllerApis.addResponse$1(null, topic.topicId(), new ApiError(Errors.UNKNOWN_TOPIC_ID), responses);
                return;
            }
            potentiallyAuthorizeTopicIds.add(topic.topicId());
        });
        if (throwable2 != null) {
            ApiError apiError = ApiError.fromThrowable((Throwable)throwable2);
            potentiallyAuthorizeTopicNames.forEach(topicName -> K2ControllerApis.addResponse$1(topicName, Uuid.ZERO_UUID, apiError, responses));
            potentiallyAuthorizeTopicIds.forEach(topicId -> K2ControllerApis.addResponse$1(null, topicId, apiError, responses));
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(121).append("Received exception during processing of DeleteTopicsRequest while retrieving K2 topic metadata for topics: {").append(String.join((CharSequence)",", topicMetadataForDeletions.toString())).append("} throwable: ").append(throwable2).toString());
            this.sendResponses$1(responses, request$2);
            return;
        }
        ClusterAuthorizer clusterAuthorizer = new ClusterAuthorizer(this, request$2.context(), AclOperation.DELETE);
        HashSet authorizedTopicMetadata = new HashSet();
        potentiallyAuthorizeTopicNames.forEach(topicName -> {
            if (!(clusterAuthorizer.isAuthorized() || this.authHelper().authorize(request$2.context(), AclOperation.DESCRIBE, ResourceType.TOPIC, (String)topicName, this.authHelper().authorize$default$5(), this.authHelper().authorize$default$6(), this.authHelper().authorize$default$7()))) {
                K2ControllerApis.addResponse$1(topicName, Uuid.ZERO_UUID, new ApiError(Errors.TOPIC_AUTHORIZATION_FAILED), responses);
                return;
            }
            if (!(clusterAuthorizer.isAuthorized() || this.authHelper().authorize(request$2.context(), AclOperation.DELETE, ResourceType.TOPIC, (String)topicName, this.authHelper().authorize$default$5(), this.authHelper().authorize$default$6(), this.authHelper().authorize$default$7()))) {
                K2ControllerApis.addResponse$1(topicName, Uuid.ZERO_UUID, new ApiError(Errors.TOPIC_AUTHORIZATION_FAILED), responses);
                return;
            }
            K2TopicMetadata topicMetadata = (K2TopicMetadata)topicMetadataByName.apply(topicName);
            Uuid topicId = topicMetadata.topicId();
            if (potentiallyAuthorizeTopicIds.contains(topicId)) {
                K2ControllerApis.addResponse$1(topicName, topicId, new ApiError(Errors.INVALID_REQUEST, "The provided topic name maps to an ID that was already supplied."), responses);
                return;
            }
            authorizedTopicMetadata.add(topicMetadata);
        });
        potentiallyAuthorizeTopicIds.forEach(topicId -> {
            K2TopicMetadata topicMetadata = (K2TopicMetadata)topicMetadataById.apply(topicId);
            String topicName = topicMetadata.topicName();
            if (!(clusterAuthorizer.isAuthorized() || this.authHelper().authorize(request$2.context(), AclOperation.DESCRIBE, ResourceType.TOPIC, topicName, this.authHelper().authorize$default$5(), this.authHelper().authorize$default$6(), this.authHelper().authorize$default$7()))) {
                K2ControllerApis.addResponse$1(null, topicId, new ApiError(Errors.TOPIC_AUTHORIZATION_FAILED), responses);
                return;
            }
            if (!(clusterAuthorizer.isAuthorized() || this.authHelper().authorize(request$2.context(), AclOperation.DELETE, ResourceType.TOPIC, topicName, this.authHelper().authorize$default$5(), this.authHelper().authorize$default$6(), this.authHelper().authorize$default$7()))) {
                K2ControllerApis.addResponse$1(topicName, topicId, new ApiError(Errors.TOPIC_AUTHORIZATION_FAILED), responses);
                return;
            }
            if (!potentiallyAuthorizeTopicNames.contains(topicName)) {
                authorizedTopicMetadata.add(topicMetadata);
                return;
            }
        });
        if (authorizedTopicMetadata.isEmpty()) {
            this.sendResponses$1(responses, request$2);
            return;
        }
        this.controllerRequestHandler.deleteTopics(authorizedTopicMetadata).whenCompleteAsyncRaw((deleteResult, throwable) -> {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(104).append("Processed DeleteTopicsRequest for authorized topics {").append(String.join((CharSequence)",", authorizedTopicMetadata.toString())).append("} via K2 topic metadata store. result: ").append(deleteResult).append(" throwable: ").append(throwable).toString());
            ApiError apiError = throwable != null ? ApiError.fromThrowable((Throwable)throwable) : ApiError.NONE;
            authorizedTopicMetadata.forEach(k2TopicMetadata -> K2ControllerApis.addResponse$1(k2TopicMetadata.topicName(), k2TopicMetadata.topicId(), apiError, responses));
            this.sendResponses$1(responses, request$2);
        }, this.executor);
    }

    public K2ControllerApis(RequestChannel requestChannel, int brokerId, KafkaConfig config, Option<Authorizer> authorizer, QuotaFactory.QuotaManagers quotas, Time time, K2ControllerHandler controllerRequestHandler, Executor executor) {
        this.config = config;
        this.controllerRequestHandler = controllerRequestHandler;
        this.executor = executor;
        this.logIdent_$eq(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("[K2ControllerApis-%d] "), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)brokerId)})));
        this.requestHelper = new RequestHandlerHelper(requestChannel, quotas, time);
        this.authHelper = new AuthHelper(authorizer);
    }

    private class ClusterAuthorizer {
        private final RequestContext requestContext;
        private final AclOperation operation;
        private Option<Object> hasClusterAuthorization;
        public final /* synthetic */ K2ControllerApis $outer;

        private Option<Object> hasClusterAuthorization() {
            return this.hasClusterAuthorization;
        }

        private void hasClusterAuthorization_$eq(Option<Object> x$1) {
            this.hasClusterAuthorization = x$1;
        }

        public boolean isAuthorized() {
            Option<Object> option = this.hasClusterAuthorization();
            if (option instanceof Some) {
                return BoxesRunTime.unboxToBoolean((Object)((Some)option).value());
            }
            if (None$.MODULE$.equals(option)) {
                RequestContext x$1 = this.requestContext;
                AclOperation x$2 = this.operation;
                boolean x$6 = this.kafka$server$K2ControllerApis$ClusterAuthorizer$$$outer().authHelper().authorize$default$5();
                int x$7 = this.kafka$server$K2ControllerApis$ClusterAuthorizer$$$outer().authHelper().authorize$default$7();
                boolean authorized = this.kafka$server$K2ControllerApis$ClusterAuthorizer$$$outer().authHelper().authorize(x$1, x$2, ResourceType.CLUSTER, "kafka-cluster", x$6, false, x$7);
                this.hasClusterAuthorization_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)authorized)));
                return authorized;
            }
            throw new MatchError(option);
        }

        public /* synthetic */ K2ControllerApis kafka$server$K2ControllerApis$ClusterAuthorizer$$$outer() {
            return this.$outer;
        }

        public ClusterAuthorizer(K2ControllerApis $outer, RequestContext requestContext, AclOperation operation) {
            this.requestContext = requestContext;
            this.operation = operation;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.hasClusterAuthorization = None$.MODULE$;
        }
    }

    private class ErrorDetermination
    implements Product,
    Serializable {
        private final scala.collection.immutable.Set<String> topicNames;
        private final short errorCode;
        private final String errorMessage;
        public final /* synthetic */ K2ControllerApis $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public scala.collection.immutable.Set<String> topicNames() {
            return this.topicNames;
        }

        public short errorCode() {
            return this.errorCode;
        }

        public String errorMessage() {
            return this.errorMessage;
        }

        public ErrorDetermination copy(scala.collection.immutable.Set<String> topicNames, short errorCode, String errorMessage) {
            return new ErrorDetermination(this.kafka$server$K2ControllerApis$ErrorDetermination$$$outer(), topicNames, errorCode, errorMessage);
        }

        public scala.collection.immutable.Set<String> copy$default$1() {
            return this.topicNames();
        }

        public short copy$default$2() {
            return this.errorCode();
        }

        public String copy$default$3() {
            return this.errorMessage();
        }

        public String productPrefix() {
            return "ErrorDetermination";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.topicNames();
                }
                case 1: {
                    return BoxesRunTime.boxToShort((short)this.errorCode());
                }
                case 2: {
                    return this.errorMessage();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ErrorDetermination;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "topicNames";
                }
                case 1: {
                    return "errorCode";
                }
                case 2: {
                    return "errorMessage";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)this.productPrefix().hashCode()), (int)Statics.anyHash(this.topicNames())), (int)this.errorCode()), (int)Statics.anyHash((Object)this.errorMessage())), (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof ErrorDetermination && ((ErrorDetermination)x$1).kafka$server$K2ControllerApis$ErrorDetermination$$$outer() == this.kafka$server$K2ControllerApis$ErrorDetermination$$$outer())) break block3;
                    ErrorDetermination errorDetermination = (ErrorDetermination)x$1;
                    if (this.errorCode() != errorDetermination.errorCode()) break block3;
                    scala.collection.immutable.Set<String> set = this.topicNames();
                    scala.collection.immutable.Set<String> set2 = errorDetermination.topicNames();
                    if (set != null ? !set.equals(set2) : set2 != null) break block3;
                    String string = this.errorMessage();
                    String string2 = errorDetermination.errorMessage();
                    if ((string != null ? !string.equals(string2) : string2 != null) || !errorDetermination.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ K2ControllerApis kafka$server$K2ControllerApis$ErrorDetermination$$$outer() {
            return this.$outer;
        }

        public ErrorDetermination(K2ControllerApis $outer, scala.collection.immutable.Set<String> topicNames, short errorCode, String errorMessage) {
            this.topicNames = topicNames;
            this.errorCode = errorCode;
            this.errorMessage = errorMessage;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

