/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import io.confluent.k2.kafka.K2MetadataStore;
import io.confluent.k2.kafka.K2Node;
import io.confluent.k2.kafka.K2Stack;
import io.confluent.k2.kafka.K2TopicMetadata;
import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import kafka.server.metadata.K2MetadataCache;
import kafka.utils.Logging;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.KafkaScheduler;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dd\u0001B\n\u0015\u0001eA\u0001B\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\tg\u0001\u0011\t\u0011)A\u0005i!Aq\b\u0001B\u0001B\u0003%\u0001\t\u0003\u0005G\u0001\t\u0005\t\u0015!\u0003H\u0011!Q\u0005A!A!\u0002\u0013Y\u0005\"\u0002*\u0001\t\u0003\u0019\u0006\"B.\u0001\t#b\u0006b\u00025\u0001\u0005\u0004%I!\u001b\u0005\u0007c\u0002\u0001\u000b\u0011\u00026\t\u000fI\u0004\u0001\u0019!C\u0005g\"I\u0011q\u0003\u0001A\u0002\u0013%\u0011\u0011\u0004\u0005\b\u0003\u000f\u0001\u0001\u0015)\u0003u\u0011\u001d\ty\u0003\u0001C\u0001\u0003cA\u0001\"a\r\u0001\t\u0003!\u0012\u0011\u0007\u0005\b\u0003k\u0001A\u0011BA\u001c\u0011\u001d\ty\u0005\u0001C\u0005\u0003#Bq!!\u0018\u0001\t\u0013\ty\u0006C\u0004\u0002f\u0001!\t!!\r\u00031-\u0013T*\u001a;bI\u0006$\u0018mQ1dQ\u0016\u0004v\u000e];mCR|'O\u0003\u0002\u0016-\u000511/\u001a:wKJT\u0011aF\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001!\u0004\t\t\u00037yi\u0011\u0001\b\u0006\u0002;\u0005)1oY1mC&\u0011q\u0004\b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0005\r2\u0012!B;uS2\u001c\u0018BA\u0013#\u0005\u001daunZ4j]\u001e\fab[1gW\u0006\u001c6\r[3ek2,'\u000f\u0005\u0002)c5\t\u0011F\u0003\u0002+W\u0005!Q\u000f^5m\u0015\t)BF\u0003\u0002\u0018[)\u0011afL\u0001\u0007CB\f7\r[3\u000b\u0003A\n1a\u001c:h\u0013\t\u0011\u0014F\u0001\bLC\u001a\\\u0017mU2iK\u0012,H.\u001a:\u0002\u000bM$\u0018mY6\u0011\u0005UjT\"\u0001\u001c\u000b\u0005]9$B\u0001\u001d:\u0003\tY'G\u0003\u0002;w\u0005I1m\u001c8gYV,g\u000e\u001e\u0006\u0002y\u0005\u0011\u0011n\\\u0005\u0003}Y\u0012qa\u0013\u001aTi\u0006\u001c7.A\ble5,G/\u00193bi\u0006\u001c\u0015m\u00195f!\t\tE)D\u0001C\u0015\t\u0019E#\u0001\u0005nKR\fG-\u0019;b\u0013\t)%IA\bLe5+G/\u00193bi\u0006\u001c\u0015m\u00195f\u0003M\u0011XM\u001a:fg\"\u0004VM]5pI6KG\u000e\\5t!\tY\u0002*\u0003\u0002J9\t!Aj\u001c8h\u0003\u0011!\u0018.\\3\u0011\u00051\u0003V\"A'\u000b\u0005\rr%BA(-\u0003\u0019\u0019w.\\7p]&\u0011\u0011+\u0014\u0002\u0005)&lW-\u0001\u0004=S:LGO\u0010\u000b\u0007)Z;\u0006,\u0017.\u0011\u0005U\u0003Q\"\u0001\u000b\t\u000b\u00192\u0001\u0019A\u0014\t\u000bM2\u0001\u0019\u0001\u001b\t\u000b}2\u0001\u0019\u0001!\t\u000b\u00193\u0001\u0019A$\t\u000b)3\u0001\u0019A&\u0002\u00151|wmZ3s\u001d\u0006lW-F\u0001^!\tqVM\u0004\u0002`GB\u0011\u0001\rH\u0007\u0002C*\u0011!\rG\u0001\u0007yI|w\u000e\u001e \n\u0005\u0011d\u0012A\u0002)sK\u0012,g-\u0003\u0002gO\n11\u000b\u001e:j]\u001eT!\u0001\u001a\u000f\u0002'Q|\u0007/[2SK\u001a\u0014Xm\u001d5US6,w.\u001e;\u0016\u0003)\u0004\"a[8\u000e\u00031T!AS7\u000b\u00039\fAA[1wC&\u0011\u0001\u000f\u001c\u0002\t\tV\u0014\u0018\r^5p]\u0006!Bo\u001c9jGJ+gM]3tQRKW.Z8vi\u0002\nAd\u001b\u001aNKR\fG-\u0019;b\u0007\u0006\u001c\u0007.Z+qI\u0006$XM\u001d$viV\u0014X-F\u0001u!\rYRo^\u0005\u0003mr\u0011aa\u00149uS>t\u0007g\u0001=\u0002\u0004A\u0019\u00110`@\u000e\u0003iT!a\u001f?\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002+[&\u0011aP\u001f\u0002\u0010'\u000eDW\rZ;mK\u00124U\u000f^;sKB!\u0011\u0011AA\u0002\u0019\u0001!1\"!\u0002\r\u0003\u0003\u0005\tQ!\u0001\u0002\n\t\u0019q\fJ\u0019\u0002;-\u0014T*\u001a;bI\u0006$\u0018mQ1dQ\u0016,\u0006\u000fZ1uKJ4U\u000f^;sK\u0002\nB!a\u0003\u0002\u0012A\u00191$!\u0004\n\u0007\u0005=ADA\u0004O_RD\u0017N\\4\u0011\u0007m\t\u0019\"C\u0002\u0002\u0016q\u00111!\u00118z\u0003\u0001Z''T3uC\u0012\fG/Y\"bG\",W\u000b\u001d3bi\u0016\u0014h)\u001e;ve\u0016|F%Z9\u0015\t\u0005m\u0011\u0011\u0005\t\u00047\u0005u\u0011bAA\u00109\t!QK\\5u\u0011%\t\u0019cCA\u0001\u0002\u0004\t)#A\u0002yIE\u0002BaG;\u0002(A\"\u0011\u0011FA\u0017!\u0011IX0a\u000b\u0011\t\u0005\u0005\u0011Q\u0006\u0003\r\u0003\u000b\t\t#!A\u0001\u0002\u000b\u0005\u0011\u0011B\u0001\bgR\f'\u000f^;q)\t\tY\"A\fe_B{\u0007/\u001e7bi\u0016lU\r^1eCR\f7)Y2iK\u0006aBO]1og&$\u0018n\u001c8EK2,G/\u001b8h\u001fJ\u001c%/Z1uS:<GCBA\u000e\u0003s\ti\u0004\u0003\u0004\u0002<=\u0001\raR\u0001\fgR\f'\u000f^'jY2L7\u000fC\u0004\u0002@=\u0001\r!!\u0011\u00021\u0011,G.\u001a;j]\u001e|%o\u0011:fCRLgn\u001a+pa&\u001c7\u000f\u0005\u0004\u0002D\u0005\u0015\u0013\u0011J\u0007\u0002y&\u0019\u0011q\t?\u0003\t1K7\u000f\u001e\t\u0004k\u0005-\u0013bAA'm\ty1J\r+pa&\u001cW*\u001a;bI\u0006$\u0018-A\u000eta2LGo\u00148mS:,\u0017I\u001c3Ue\u0006t7/\u001b;j_:Lgn\u001a\u000b\u0005\u0003'\nI\u0006E\u0004\u001c\u0003+\n\t%!\u0011\n\u0007\u0005]CD\u0001\u0004UkBdWM\r\u0005\b\u00037\u0002\u0002\u0019AA!\u0003%\tG\u000e\u001c+pa&\u001c7/\u0001\ntKR,\b/T3uC\u0012\fG/Y\"bG\",G\u0003BA\u000e\u0003CBq!a\u0019\u0012\u0001\u0004\t\t%\u0001\fp]2Lg.Z(s\u0007J,\u0017\r^5oOR{\u0007/[2t\u0003\u0015\u0019Gn\\:f\u0001")
public class K2MetadataCachePopulator
implements Logging {
    private final KafkaScheduler kafkaScheduler;
    private final K2Stack stack;
    private final K2MetadataCache k2metadataCache;
    private final long refreshPeriodMillis;
    private final Time time;
    private final Duration topicRefreshTimeout;
    private Option<ScheduledFuture<?>> k2MetadataCacheUpdaterFuture;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return this.getClass().getName();
    }

    private Duration topicRefreshTimeout() {
        return this.topicRefreshTimeout;
    }

    private Option<ScheduledFuture<?>> k2MetadataCacheUpdaterFuture() {
        return this.k2MetadataCacheUpdaterFuture;
    }

    private void k2MetadataCacheUpdaterFuture_$eq(Option<ScheduledFuture<?>> x$1) {
        this.k2MetadataCacheUpdaterFuture = x$1;
    }

    public void startup() {
        this.k2MetadataCacheUpdaterFuture_$eq((Option<ScheduledFuture<?>>)new Some((Object)this.kafkaScheduler.schedule("k2metadatacacheupdater", () -> this.doPopulateMetadataCache(), 0L, this.refreshPeriodMillis)));
    }

    /*
     * WARNING - void declaration
     */
    public void doPopulateMetadataCache() {
        long startMillis = this.time.milliseconds();
        this.info((Function0<String>)(Function0 & Serializable)() -> "Querying topic metadata store for all topics for K2 metadata cache update");
        try {
            void var6_5;
            void var5_4;
            List allTopics = (List)this.stack.topicMetadata().listTopics(K2MetadataStore.Filter.NONE).block(Duration.ofMillis(this.refreshPeriodMillis));
            Tuple2<List<K2TopicMetadata>, List<K2TopicMetadata>> tuple2 = this.splitOnlineAndTransitioning(allTopics);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            List onlineOrCreating = (List)tuple2._1();
            List deletingOrCreatingTopics = (List)tuple2._2();
            this.setupMetadataCache((List<K2TopicMetadata>)var5_4);
            this.transitionDeletingOrCreating(startMillis, (List<K2TopicMetadata>)var6_5);
            return;
        }
        catch (Throwable t) {
            this.error((Function0<String>)(Function0 & Serializable)() -> "Error refreshing partition assignments", (Function0<Throwable>)(Function0 & Serializable)() -> t);
            return;
        }
    }

    private void transitionDeletingOrCreating(long startMillis, List<K2TopicMetadata> deletingOrCreatingTopics) {
        Object object = new Object();
        try {
            Collections.shuffle(deletingOrCreatingTopics);
            CollectionConverters$.MODULE$.ListHasAsScala(deletingOrCreatingTopics).asScala().foreach((Function1 & Serializable)topic -> {
                K2MetadataCachePopulator.$anonfun$transitionDeletingOrCreating$1(this, startMillis, object, topic);
                return BoxedUnit.UNIT;
            });
            return;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
                return;
            }
            throw ex;
        }
    }

    private Tuple2<List<K2TopicMetadata>, List<K2TopicMetadata>> splitOnlineAndTransitioning(List<K2TopicMetadata> allTopics) {
        ArrayList onlineOrCreatingTopics = new ArrayList();
        ArrayList deletingOrCreatingTopics = new ArrayList();
        IntRef numCreatingTopics = IntRef.create((int)0);
        allTopics.forEach(topic -> {
            K2TopicMetadata.K2TopicLifecycleState k2TopicLifecycleState = topic.k2TopicLifecycleState();
            K2TopicMetadata.K2TopicLifecycleState k2TopicLifecycleState2 = K2TopicMetadata.K2TopicLifecycleState.DELETING;
            if (!(k2TopicLifecycleState != null ? !k2TopicLifecycleState.equals(k2TopicLifecycleState2) : k2TopicLifecycleState2 != null)) {
                deletingOrCreatingTopics.add(topic);
                return;
            }
            K2TopicMetadata.K2TopicLifecycleState k2TopicLifecycleState3 = topic.k2TopicLifecycleState();
            K2TopicMetadata.K2TopicLifecycleState k2TopicLifecycleState4 = K2TopicMetadata.K2TopicLifecycleState.CREATING;
            if (!(k2TopicLifecycleState3 != null ? !k2TopicLifecycleState3.equals(k2TopicLifecycleState4) : k2TopicLifecycleState4 != null)) {
                deletingOrCreatingTopics.add(topic);
                onlineOrCreatingTopics.add(topic);
                ++numCreatingTopics$1.elem;
                return;
            }
            onlineOrCreatingTopics.add(topic);
        });
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(113).append("Updating K2 metadata cache with all online/creating topics from queried topics with size = ").append(onlineOrCreatingTopics.size()).append(", of which ").append(numCreatingTopics$1.elem).append(" are online").toString());
        if (onlineOrCreatingTopics.size() < 20) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(55).append("Updating K2 metadata cache with online/creating topics ").append(onlineOrCreatingTopics).toString());
        } else {
            this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(55).append("Updating K2 metadata cache with online/creating topics ").append(onlineOrCreatingTopics).toString());
        }
        return new Tuple2(onlineOrCreatingTopics, deletingOrCreatingTopics);
    }

    private void setupMetadataCache(List<K2TopicMetadata> onlineOrCreatingTopics) {
        try {
            Map assignment = (Map)this.stack.partitionMapper().assignments(onlineOrCreatingTopics, new ArrayList<K2Node>(this.k2metadataCache.k2NodesEligibleForAssignment().keySet())).block(this.topicRefreshTimeout());
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(30).append("Generated partition mappings: ").append(assignment).toString());
            this.k2metadataCache.setTopicsAndAssignments(onlineOrCreatingTopics, assignment);
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(71).append("Updated K2 metadata cache with ").append($this.k2metadataCache.topicIdsToNames().size()).append(" online/creating topics plus assignments").toString());
            return;
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)(Function0 & Serializable)() -> "Error updating topic assignments", (Function0<Throwable>)(Function0 & Serializable)() -> throwable);
            return;
        }
    }

    public void close() {
        this.k2MetadataCacheUpdaterFuture().foreach((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.cancel(true)));
    }

    public static final /* synthetic */ void $anonfun$transitionDeletingOrCreating$1(K2MetadataCachePopulator $this, long startMillis$1, Object nonLocalReturnKey1$1, K2TopicMetadata topic) {
        if ($this.time.milliseconds() - startMillis$1 < $this.refreshPeriodMillis) {
            K2TopicMetadata.K2TopicLifecycleState k2TopicLifecycleState = topic.k2TopicLifecycleState();
            K2TopicMetadata.K2TopicLifecycleState k2TopicLifecycleState2 = K2TopicMetadata.K2TopicLifecycleState.CREATING;
            if (!(k2TopicLifecycleState != null ? !k2TopicLifecycleState.equals(k2TopicLifecycleState2) : k2TopicLifecycleState2 != null)) {
                try {
                    Boolean finishedCreating = (Boolean)$this.stack.k2ControllerHandler().tryToFinishTopicCreation(topic).block(Duration.ofMillis($this.refreshPeriodMillis));
                    if (!Predef$.MODULE$.Boolean2boolean(finishedCreating)) {
                        $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(42).append("Unsuccessful moving topic ").append(topic.topicName()).append(" with id=").append(topic.topicId()).append(" online").toString());
                        return;
                    }
                    $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(41).append("Successfully moved topic ").append(topic.topicName()).append(" with id=").append(topic.topicId()).append(" online").toString());
                }
                catch (Throwable t) {
                    $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(31).append("Couldn't finish creating topic ").append(topic).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
                    throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
                }
                return;
            }
            try {
                $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(35).append("Trying to finish deletion of topic ").append(topic).toString());
                Boolean finishedDeleting = (Boolean)$this.stack.k2ControllerHandler().tryToFinishTopicDeletion(topic).block(Duration.ofMillis($this.refreshPeriodMillis));
                if (!Predef$.MODULE$.Boolean2boolean(finishedDeleting)) {
                    $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(70).append("Unsuccessful finishing deletion of topic ").append(topic).append(" (probably due to a conflict)").toString());
                    return;
                }
                $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(40).append("Successfully finished deletion of topic ").append(topic).toString());
            }
            catch (Throwable t) {
                $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(31).append("Couldn't finish deleting topic ").append(topic).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
                throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
            }
            return;
        }
    }

    public K2MetadataCachePopulator(KafkaScheduler kafkaScheduler, K2Stack stack, K2MetadataCache k2metadataCache, long refreshPeriodMillis, Time time) {
        this.kafkaScheduler = kafkaScheduler;
        this.stack = stack;
        this.k2metadataCache = k2metadataCache;
        this.refreshPeriodMillis = refreshPeriodMillis;
        this.time = time;
        this.topicRefreshTimeout = Duration.ofMillis(60000L);
        this.k2MetadataCacheUpdaterFuture = None$.MODULE$;
    }
}

