/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import io.confluent.kafka.replication.push.ReplicationConfig;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import kafka.server.KafkaConfig;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataRecoveryStrategy;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;

public class NetworkUtils {
    public static NetworkClient buildNetworkClient(String prefix, KafkaConfig config, Metrics metrics, Time time, LogContext logContext) {
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder((SecurityProtocol)config.interBrokerSecurityProtocol(), (JaasContext.Type)JaasContext.Type.SERVER, (AbstractConfig)config, (ListenerName)config.interBrokerListenerName(), (String)config.saslMechanismInterBrokerProtocol(), (Time)time, (boolean)config.saslInterBrokerHandshakeRequestEnable(), (LogContext)logContext);
        if (channelBuilder instanceof Reconfigurable) {
            config.addReconfigurable((Reconfigurable)channelBuilder);
        }
        String metricGroupPrefix = prefix + "-channel";
        Selector selector = new Selector(-1, config.connectionsMaxIdleMs().longValue(), metrics, time, metricGroupPrefix, Collections.emptyMap(), false, channelBuilder, logContext);
        String clientId = prefix + "-client-" + config.nodeId();
        return new NetworkClient((Selectable)selector, (MetadataUpdater)new ManualMetadataUpdater(), clientId, 1, 50L, 50L, -1, config.socketReceiveBufferBytes().intValue(), config.requestTimeoutMs().intValue(), config.connectionSetupTimeoutMs().longValue(), config.connectionSetupTimeoutMaxMs().longValue(), time, true, new ApiVersions(), logContext, MetadataRecoveryStrategy.NONE);
    }

    public static NetworkClient buildPushManagerNetworkClient(Integer threadId, KafkaConfig config, ReplicationConfig replicationConfig, Metrics metrics, Time time, LogContext logContext) {
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder((SecurityProtocol)config.interBrokerSecurityProtocol(), (JaasContext.Type)JaasContext.Type.SERVER, (AbstractConfig)config, (ListenerName)config.interBrokerListenerName(), (String)config.saslMechanismInterBrokerProtocol(), (Time)time, (boolean)config.saslInterBrokerHandshakeRequestEnable(), (LogContext)logContext);
        if (channelBuilder instanceof Reconfigurable) {
            config.addReconfigurable((Reconfigurable)channelBuilder);
        }
        String metricGroupPrefix = "pusher-thread";
        Selector selector = new Selector(-1, config.connectionsMaxIdleMs().longValue(), metrics, time, metricGroupPrefix, Collections.singletonMap(metricGroupPrefix, threadId.toString()), false, channelBuilder, logContext);
        String clientId = String.format("%s-%d-%d", metricGroupPrefix, config.nodeId(), threadId);
        return new NetworkClient((Selectable)selector, (MetadataUpdater)new ManualMetadataUpdater(), clientId, replicationConfig.maxInFlightRequests(), 50L, TimeUnit.SECONDS.toMillis(1L), replicationConfig.socketSendBufferBytes(), -1, replicationConfig.requestTimeoutMs(), config.connectionSetupTimeoutMs().longValue(), config.connectionSetupTimeoutMaxMs().longValue(), time, false, new ApiVersions(), logContext, MetadataRecoveryStrategy.NONE);
    }
}

