/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.cluster.EndPoint;
import kafka.metrics.BrokerLoad;
import kafka.server.AbstractQuotaChannelManager;
import kafka.server.ActiveTenantsManager;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaMetricsReporter;
import kafka.server.ClientQuotaMetricsReporterConfig;
import kafka.server.ClientRequestQuotaManager;
import kafka.server.ClusterLinkReplicationConfig;
import kafka.server.ClusterLinkReplicationQuotaManager;
import kafka.server.ClusterLinkRequestQuotaManager;
import kafka.server.ClusterLinkRequestQuotaManagerConfig;
import kafka.server.ControllerMutationQuotaManager;
import kafka.server.DiskThrottleListenerManager;
import kafka.server.DiskUsageBasedThrottler$;
import kafka.server.DynamicQuotaReportingRequestThread;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.ProducerIdQuotaManager;
import kafka.server.ProducerIdQuotaManagerConfig;
import kafka.server.QueueSizePercentiles;
import kafka.server.QuotaFactory;
import kafka.server.QuotaFactory$QuotaManagers$;
import kafka.server.QuotaType;
import kafka.server.QuotaType$;
import kafka.server.QuotaType$AlterLogDirsReplication$;
import kafka.server.QuotaType$ClusterLinkRequest$;
import kafka.server.QuotaType$Fetch$;
import kafka.server.QuotaType$FollowerReplication$;
import kafka.server.QuotaType$LeaderReplication$;
import kafka.server.QuotaType$Produce$;
import kafka.server.QuotaType$Request$;
import kafka.server.ReplicationQuotaManager;
import kafka.server.RequestQueueSizePercentiles$;
import kafka.utils.Logging;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.config.BrokerBackpressureConfig;
import org.apache.kafka.server.config.ClientQuotaManagerConfig;
import org.apache.kafka.server.config.DiskUsageBasedThrottlingConfig;
import org.apache.kafka.server.config.ReplicationQuotaManagerConfig;
import org.apache.kafka.server.quota.ClientQuotaCallback;
import org.apache.kafka.server.util.Csv;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class QuotaFactory$
implements Logging {
    public static final QuotaFactory$ MODULE$ = new QuotaFactory$();
    private static volatile boolean quotaConsumptionReportingEnabled = false;
    private static volatile boolean brokerLoadConsumptionReportingEnabled = false;
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public boolean quotaConsumptionReportingEnabled() {
        return quotaConsumptionReportingEnabled;
    }

    public void quotaConsumptionReportingEnabled_$eq(boolean x$1) {
        quotaConsumptionReportingEnabled = x$1;
    }

    public boolean brokerLoadConsumptionReportingEnabled() {
        return brokerLoadConsumptionReportingEnabled;
    }

    public void brokerLoadConsumptionReportingEnabled_$eq(boolean x$1) {
        brokerLoadConsumptionReportingEnabled = x$1;
    }

    public void updateQuotaConsumptionReportingEnabled(boolean consumptionReportingEnabled) {
        this.quotaConsumptionReportingEnabled_$eq(consumptionReportingEnabled);
    }

    public QuotaFactory.QuotaManagers instantiate(KafkaConfig cfg, Metrics metrics, Time time, String threadNamePrefix, Option<AbstractQuotaChannelManager> dynamicQuotaChannelManagerOpt, Option<BrokerLoad> brokerLoadOpt) {
        Long consumptionReportingIntervalMs = cfg.getLong("confluent.quota.dynamic.reporting.interval.ms");
        this.quotaConsumptionReportingEnabled_$eq(dynamicQuotaChannelManagerOpt.isDefined() && Predef$.MODULE$.Long2long(consumptionReportingIntervalMs) > 0L);
        this.brokerLoadConsumptionReportingEnabled_$eq(brokerLoadOpt.isDefined() && Predef$.MODULE$.Long2long(consumptionReportingIntervalMs) > 0L);
        Option clientQuotaCallback = Option$.MODULE$.apply(cfg.getConfiguredInstance("client.quota.callback.class", ClientQuotaCallback.class));
        None$ activeTenantsManager = this.isMultiTenant(cfg) ? new Some((Object)new ActiveTenantsManager(metrics, time, BrokerBackpressureConfig.DEFAULT_ACTIVE_WINDOW_MS)) : None$.MODULE$;
        clientQuotaCallback.foreach((Function1 & Serializable)callback -> {
            callback.enableDynamicQuota(Predef$.MODULE$.Boolean2boolean(cfg.getBoolean(KafkaConfig$.MODULE$.DynamicQuotaEnabledProp())));
            return BoxedUnit.UNIT;
        });
        ClientQuotaManagerConfig fetchClientConfig = this.clientConfig(cfg, QuotaType$Fetch$.MODULE$);
        ClientQuotaManager fetchQuotaManager = new ClientQuotaManager(fetchClientConfig, metrics, QuotaType$Fetch$.MODULE$, time, threadNamePrefix, (Option<ClientQuotaCallback>)clientQuotaCallback, (Option<ActiveTenantsManager>)activeTenantsManager);
        QuotaFactory$QuotaManagers$.MODULE$.setBrokerQuotaLimitByType(QuotaType$.MODULE$.toClientQuotaType(QuotaType$Fetch$.MODULE$), fetchClientConfig.brokerQuotaLimit);
        ClientQuotaManagerConfig produceClientConfig = this.clientConfig(cfg, QuotaType$Produce$.MODULE$);
        ClientQuotaManager produceQuotaManager = new ClientQuotaManager(produceClientConfig, metrics, QuotaType$Produce$.MODULE$, time, threadNamePrefix, (Option<ClientQuotaCallback>)clientQuotaCallback, (Option<ActiveTenantsManager>)activeTenantsManager);
        QuotaFactory$QuotaManagers$.MODULE$.setBrokerQuotaLimitByType(QuotaType$.MODULE$.toClientQuotaType(QuotaType$Produce$.MODULE$), produceClientConfig.brokerQuotaLimit);
        ClientRequestQuotaManager requestQuotaManager = new ClientRequestQuotaManager(this.clientConfig(cfg, QuotaType$Request$.MODULE$), metrics, time, threadNamePrefix, (Option<ClientQuotaCallback>)clientQuotaCallback, (Option<ActiveTenantsManager>)activeTenantsManager);
        None$ producerIdQuotaManager = Predef$.MODULE$.Boolean2boolean(cfg.producerIdQuotaManagerEnable()) ? new Some((Object)new ProducerIdQuotaManager(this.producerIdQuotaConfig(cfg), this.clientProducerIdQuotaConfig(cfg), metrics, time, threadNamePrefix, (Option<ClientQuotaCallback>)clientQuotaCallback)) : None$.MODULE$;
        cfg.listeners().foreach((Function1 & Serializable)listener -> {
            requestQuotaManager.addListenerMetrics(listener.listenerName().value());
            return BoxedUnit.UNIT;
        });
        ReplicationQuotaManager followerQuotaManager = new ReplicationQuotaManager(this.replicationConfig(cfg, QuotaType$FollowerReplication$.MODULE$), metrics, QuotaType$FollowerReplication$.MODULE$, time);
        ClusterLinkReplicationQuotaManager clusterLinkReplicationQuotaManager = new ClusterLinkReplicationQuotaManager(this.clusterLinkReplicationConfig(cfg), produceQuotaManager, metrics, time);
        ClusterLinkRequestQuotaManager clusterLinkRequestQuotaManager = new ClusterLinkRequestQuotaManager(this.clusterLinkRequestQuotaManagerConfig(cfg), metrics, time, threadNamePrefix, (Option<ClientQuotaCallback>)clientQuotaCallback, (Option<ActiveTenantsManager>)activeTenantsManager);
        DiskThrottleListenerManager.registerListener$(DiskUsageBasedThrottler$.MODULE$, produceQuotaManager);
        DiskThrottleListenerManager.registerListener$(DiskUsageBasedThrottler$.MODULE$, followerQuotaManager);
        if (Predef$.MODULE$.Boolean2boolean(cfg.clusterLinkEnable())) {
            DiskThrottleListenerManager.registerListener$(DiskUsageBasedThrottler$.MODULE$, clusterLinkReplicationQuotaManager);
        }
        produceQuotaManager.initThrottler();
        new ClientQuotaMetricsReporter(this.clientQuotaMetricsReporterConfig(cfg), metrics, fetchQuotaManager, produceQuotaManager, (Option<ActiveTenantsManager>)activeTenantsManager, (Option<DynamicQuotaReportingRequestThread>)dynamicQuotaChannelManagerOpt.map((Function1 & Serializable)x$3 -> x$3.getReportRequestThread()), brokerLoadOpt).init();
        return new QuotaFactory.QuotaManagers(fetchQuotaManager, produceQuotaManager, requestQuotaManager, new ControllerMutationQuotaManager(this.clientControllerMutationConfig(cfg), metrics, time, threadNamePrefix, (Option<ClientQuotaCallback>)clientQuotaCallback), (Option<ProducerIdQuotaManager>)producerIdQuotaManager, new ReplicationQuotaManager(this.replicationConfig(cfg, QuotaType$LeaderReplication$.MODULE$), metrics, QuotaType$LeaderReplication$.MODULE$, time), followerQuotaManager, new ReplicationQuotaManager(this.alterLogDirsReplicationConfig(cfg), metrics, QuotaType$AlterLogDirsReplication$.MODULE$, time), clusterLinkReplicationQuotaManager, clusterLinkRequestQuotaManager, (Option<ClientQuotaCallback>)clientQuotaCallback);
    }

    public Option<AbstractQuotaChannelManager> instantiate$default$5() {
        return None$.MODULE$;
    }

    public Option<BrokerLoad> instantiate$default$6() {
        return None$.MODULE$;
    }

    public DiskUsageBasedThrottlingConfig diskThrottleConfig(KafkaConfig cfg) {
        Long freeDiskThresholdBytes = cfg.backPressureDiskThresholdBytes();
        Long throttledProduceThroughput = cfg.getLong("confluent.backpressure.disk.produce.bytes.per.second");
        Boolean enableDiskThrottling = cfg.getBoolean("confluent.backpressure.disk.enable");
        Double recoveryFactor = cfg.getDouble("confluent.backpressure.disk.threshold.recovery.factor");
        return new DiskUsageBasedThrottlingConfig(Predef$.MODULE$.Long2long(freeDiskThresholdBytes), Predef$.MODULE$.Long2long(throttledProduceThroughput), CollectionConverters$.MODULE$.SeqHasAsJava(cfg.logDirs()).asJava(), Predef$.MODULE$.Boolean2boolean(enableDiskThrottling), Predef$.MODULE$.Double2double(recoveryFactor), Predef$.MODULE$.Boolean2boolean(cfg.clusterLinkEnable()));
    }

    public ClientQuotaManagerConfig clientConfig(KafkaConfig cfg, QuotaType quotaType) {
        double brokerQuotaLimit;
        DiskUsageBasedThrottlingConfig diskThrottlingConfig;
        if (!new .colon.colon((Object)QuotaType$Produce$.MODULE$, (List)new .colon.colon((Object)QuotaType$Fetch$.MODULE$, (List)new .colon.colon((Object)QuotaType$Request$.MODULE$, (List)new .colon.colon((Object)QuotaType$ClusterLinkRequest$.MODULE$, (List)Nil$.MODULE$)))).contains((Object)quotaType)) {
            throw new IllegalArgumentException(new StringBuilder(23).append("Unexpected quota type: ").append(quotaType).toString());
        }
        QuotaType quotaType2 = quotaType;
        QuotaType$Produce$ quotaType$Produce$ = QuotaType$Produce$.MODULE$;
        DiskUsageBasedThrottlingConfig diskUsageBasedThrottlingConfig = diskThrottlingConfig = quotaType2 != null && quotaType2.equals(quotaType$Produce$) ? this.diskThrottleConfig(cfg) : new DiskUsageBasedThrottlingConfig();
        double d = QuotaType$Produce$.MODULE$.equals(quotaType) ? (double)Predef$.MODULE$.Long2long(cfg.confluentConfig().brokerLimitProducerConfig()) : (brokerQuotaLimit = QuotaType$Fetch$.MODULE$.equals(quotaType) ? (double)Predef$.MODULE$.Long2long(cfg.confluentConfig().brokerLimitConsumerConfig()) : 9.223372036854776E18);
        Integer quotaSamples = QuotaType$Produce$.MODULE$.equals(quotaType) ? cfg.numThroughputQuotaSamples() : (QuotaType$Fetch$.MODULE$.equals(quotaType) ? cfg.numThroughputQuotaSamples() : cfg.numQuotaSamples());
        return new ClientQuotaManagerConfig(Predef$.MODULE$.Integer2int(quotaSamples), Predef$.MODULE$.Integer2int(cfg.quotaWindowSizeSeconds()), this.brokerBackpressureConfig(cfg, quotaType), diskThrottlingConfig, brokerQuotaLimit, Predef$.MODULE$.Long2long(cfg.getLong("confluent.quota.dynamic.reporting.interval.ms")), Predef$.MODULE$.Integer2int(cfg.getInt("confluent.quota.dynamic.reporting.min.usage")), Predef$.MODULE$.Long2long(cfg.clientQuotaMaxThrottleTimeMs()));
    }

    public ReplicationQuotaManagerConfig replicationConfig(KafkaConfig cfg, QuotaType quotaType) {
        long throttleRate;
        long l = QuotaType$LeaderReplication$.MODULE$.equals(quotaType) ? cfg.ReplicationLeaderThrottleRate() : (throttleRate = QuotaType$FollowerReplication$.MODULE$.equals(quotaType) ? cfg.ReplicationFollowerThrottleRate() : Long.MAX_VALUE);
        boolean replicasAreThrottled = QuotaType$LeaderReplication$.MODULE$.equals(quotaType) ? cfg.ReplicationLeaderReplicasAreThrottled() : (QuotaType$FollowerReplication$.MODULE$.equals(quotaType) ? cfg.ReplicationFollowerReplicasAreThrottled() : false);
        return new ReplicationQuotaManagerConfig(throttleRate, Predef$.MODULE$.Integer2int(cfg.numReplicationQuotaSamples()), Predef$.MODULE$.Integer2int(cfg.replicationQuotaWindowSizeSeconds()), replicasAreThrottled);
    }

    private ClientQuotaManagerConfig clientControllerMutationConfig(KafkaConfig cfg) {
        return new ClientQuotaManagerConfig(Predef$.MODULE$.Integer2int(cfg.numControllerQuotaSamples()), Predef$.MODULE$.Integer2int(cfg.controllerQuotaWindowSizeSeconds()), Predef$.MODULE$.Long2long(cfg.clientQuotaMaxThrottleTimeMs()));
    }

    public ReplicationQuotaManagerConfig replicationConfig(KafkaConfig cfg) {
        return new ReplicationQuotaManagerConfig(Predef$.MODULE$.Integer2int(cfg.numReplicationQuotaSamples()), Predef$.MODULE$.Integer2int(cfg.replicationQuotaWindowSizeSeconds()));
    }

    private ReplicationQuotaManagerConfig alterLogDirsReplicationConfig(KafkaConfig cfg) {
        return new ReplicationQuotaManagerConfig(Predef$.MODULE$.Integer2int(cfg.numAlterLogDirsReplicationQuotaSamples()), Predef$.MODULE$.Integer2int(cfg.alterLogDirsReplicationQuotaWindowSizeSeconds()));
    }

    private ClusterLinkRequestQuotaManagerConfig clusterLinkRequestQuotaManagerConfig(KafkaConfig cfg) {
        return new ClusterLinkRequestQuotaManagerConfig(this.clientConfig(cfg, QuotaType$ClusterLinkRequest$.MODULE$), (Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> Predef$.MODULE$.Boolean2boolean(cfg.clusterLinkEnable()), (Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> Predef$.MODULE$.Boolean2boolean(cfg.clusterLinkTenantRequestQuotaEnable()), (Function0<Object>)(JFunction0.mcI.sp & Serializable)() -> Predef$.MODULE$.Integer2int(cfg.clusterLinkRequestQuotaCapacity()));
    }

    public ClusterLinkReplicationConfig clusterLinkReplicationConfig(KafkaConfig cfg) {
        Long bytesPerSecond = cfg.getLong(KafkaConfig$.MODULE$.ClusterLinkIoMaxBytesPerSecondProp());
        ReplicationQuotaManagerConfig replicationQuotaManagerConfig = new ReplicationQuotaManagerConfig(Predef$.MODULE$.Long2long(bytesPerSecond), Predef$.MODULE$.Integer2int(cfg.numClusterLinkReplicationQuotaSamples()), Predef$.MODULE$.Integer2int(cfg.clusterLinkReplicationQuotaWindowSizeSeconds()), !BoxesRunTime.equalsNumObject((Number)bytesPerSecond, (Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)));
        return new ClusterLinkReplicationConfig(replicationQuotaManagerConfig, (Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> Predef$.MODULE$.Boolean2boolean(cfg.clusterLinkEnable()), (Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> Predef$.MODULE$.Boolean2boolean(cfg.clusterLinkTenantReplicationQuotaEnable()), (Function0<ConfluentConfigs.ClusterLinkQuotaMode>)(Function0 & Serializable)() -> cfg.clusterLinkQuotaMode(), (Function0<Map<String, ConfluentConfigs.ClusterLinkQuotaMode>>)(Function0 & Serializable)() -> cfg.clusterLinkQuotaModePerTenantOverrides());
    }

    public ClientQuotaManagerConfig clientProducerIdQuotaConfig(KafkaConfig cfg) {
        return new ClientQuotaManagerConfig(Predef$.MODULE$.Integer2int(cfg.numProducerIdQuotaSamples()), Predef$.MODULE$.Integer2int(cfg.producerIdQuotaWindowSizeSeconds()), Predef$.MODULE$.Long2long(cfg.clientQuotaMaxThrottleTimeMs()));
    }

    public ProducerIdQuotaManagerConfig producerIdQuotaConfig(KafkaConfig cfg) {
        return new ProducerIdQuotaManagerConfig(Predef$.MODULE$.Integer2int(cfg.producerIdCacheLimit()), Predef$.MODULE$.Integer2int(cfg.producerIdThrottleEnableThresholdPercentage()));
    }

    public ClientQuotaMetricsReporterConfig clientQuotaMetricsReporterConfig(KafkaConfig cfg) {
        return new ClientQuotaMetricsReporterConfig(Predef$.MODULE$.Long2long(cfg.getLong("confluent.quota.dynamic.reporting.interval.ms")), Predef$.MODULE$.Integer2int(cfg.getInt("confluent.quota.dynamic.reporting.min.usage")), Predef$.MODULE$.Boolean2boolean(cfg.confluentConfig().elasticCkuEnabled()));
    }

    public boolean isMultiTenant(KafkaConfig cfg) {
        return ((String)Option$.MODULE$.apply((Object)cfg.originalsStrings().get("client.quota.callback.class")).map((Function1 & Serializable)x$4 -> x$4.toString()).getOrElse((Function0 & Serializable)() -> "")).contains("io.confluent.kafka.multitenant.quota.TenantQuotaCallback");
    }

    public boolean backpressureEnabledInConfig(KafkaConfig cfg, QuotaType quotaType) {
        return this.isMultiTenant(cfg) && Option$.MODULE$.apply((Object)cfg.getString("confluent.backpressure.types")).exists((Function1 & Serializable)backpressureTypeProp -> BoxesRunTime.boxToBoolean((boolean)QuotaFactory$.$anonfun$backpressureEnabledInConfig$1(quotaType, backpressureTypeProp)));
    }

    public BrokerBackpressureConfig brokerBackpressureConfig(KafkaConfig cfg, QuotaType quotaType) {
        String string;
        Nil$ nil$;
        boolean backpressureEnabled = this.backpressureEnabledInConfig(cfg, quotaType);
        if (QuotaType$Request$.MODULE$.equals(quotaType)) {
            scala.collection.immutable.Seq listeners = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(ConfluentConfigs.multitenantListenerNames((AbstractConfig)cfg, (ListenerName)cfg.interBrokerListenerName())).asScala().filter((Function1 & Serializable)listenerName -> BoxesRunTime.boxToBoolean((boolean)QuotaFactory$.$anonfun$brokerBackpressureConfig$1(cfg, listenerName)))).toSeq();
            if (listeners.isEmpty() && backpressureEnabled && this.logger().underlying().isWarnEnabled()) {
                String msgWithLogIdent_msg = "Invalid multitenant listener names provided in config. Request backpressure will be disabled";
                Object var9_5 = null;
                this.logger().underlying().warn(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            nil$ = listeners;
        } else {
            nil$ = Nil$.MODULE$;
        }
        Nil$ tenantListenerNames = nil$;
        java.util.List list = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)tenantListenerNames).asJava();
        double d = Predef$.MODULE$.Integer2int(cfg.queuedMaxRequests());
        double minRequestQuota = Predef$.MODULE$.Long2long(cfg.getLong("confluent.backpressure.request.min.broker.limit"));
        double d2 = package$.MODULE$.max(minRequestQuota, 10.0);
        String percentileStr = cfg.getString("confluent.backpressure.request.queue.size.percentile");
        if (QueueSizePercentiles.valid$(RequestQueueSizePercentiles$.MODULE$, percentileStr)) {
            string = percentileStr;
        } else {
            if (this.logger().underlying().isWarnEnabled()) {
                String msgWithLogIdent_msg = QuotaFactory$.$anonfun$brokerBackpressureConfig$4(percentileStr);
                Object var10_9 = null;
                this.logger().underlying().warn(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            string = "p95";
        }
        return new BrokerBackpressureConfig(backpressureEnabled, list, d, d2, string);
    }

    public static final /* synthetic */ boolean $anonfun$backpressureEnabledInConfig$2(QuotaType quotaType$1, String backpressureType) {
        String string = backpressureType;
        String string2 = quotaType$1.toString().toLowerCase();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$backpressureEnabledInConfig$1(QuotaType quotaType$1, String backpressureTypeProp) {
        java.util.List backressureTypesList = Csv.parseCsvList((String)backpressureTypeProp);
        return CollectionConverters$.MODULE$.ListHasAsScala(backressureTypesList).asScala().exists((Function1 & Serializable)backpressureType -> BoxesRunTime.boxToBoolean((boolean)QuotaFactory$.$anonfun$backpressureEnabledInConfig$2(quotaType$1, backpressureType)));
    }

    public static final /* synthetic */ boolean $anonfun$brokerBackpressureConfig$2(String listenerName$1, EndPoint endpoint) {
        String string = endpoint.listenerName().value();
        return !(string != null ? !string.equals(listenerName$1) : listenerName$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$brokerBackpressureConfig$1(KafkaConfig cfg$4, String listenerName) {
        return cfg$4.effectiveAdvertisedListeners().exists((Function1 & Serializable)endpoint -> BoxesRunTime.boxToBoolean((boolean)QuotaFactory$.$anonfun$brokerBackpressureConfig$2(listenerName, endpoint)));
    }

    public static final /* synthetic */ String $anonfun$brokerBackpressureConfig$3() {
        return "Invalid multitenant listener names provided in config. Request backpressure will be disabled";
    }

    public static final /* synthetic */ String $anonfun$brokerBackpressureConfig$4(String percentileStr$1) {
        return new StringBuilder(85).append("Invalid ").append("confluent.backpressure.request.queue.size.percentile").append("=`").append(percentileStr$1).append("`. Using default `").append("p95").append("`.").toString();
    }

    private QuotaFactory$() {
    }
}

