/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import kafka.server.ClusterLinkRequestQuota;
import kafka.server.link.ActiveClusterLink$;
import kafka.server.link.AuthenticationTaskErrorCode$;
import kafka.server.link.AuthorizationTaskErrorCode$;
import kafka.server.link.ClusterLinkBatchAdmin;
import kafka.server.link.ClusterLinkCheckAvailabilityTaskType$;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConnectionChecker$;
import kafka.server.link.ClusterLinkConnectionCheckerResult;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkTask$;
import kafka.server.link.ClusterLinkUtils$;
import kafka.server.link.InternalTaskErrorCode$;
import kafka.server.link.InvalidBootstrapInternalEndpointUnavailableLinkReason;
import kafka.server.link.LinkState;
import kafka.server.link.RemoteLinkState;
import kafka.server.link.TaskDescription;
import kafka.server.link.TaskErrorCodeAndMsg;
import kafka.server.link.UnauthorizedBootstrapFailedLinkReason$;
import kafka.server.link.UnavailableLinkReason;
import kafka.server.link.UnavailableLinkReason$;
import org.apache.kafka.clients.admin.ClusterLinkDescription;
import org.apache.kafka.clients.admin.ClusterLinkListing;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.kafka.common.ClusterLinkError;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.RetriableException;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005Mh\u0001B\u000f\u001f\u0001\u0015B\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\tq\u0001\u0011\t\u0011)A\u0005s!AA\b\u0001B\u0001B\u0003%Q\bC\u0005A\u0001\t\u0005\t\u0015!\u0003B\t\"Aa\t\u0001BC\u0002\u0013\u0005q\tC\u0005L\u0001\t\u0005\t\u0015!\u0003I\u0019\"Aa\n\u0001BC\u0002\u0013\u0005q\n\u0003\u0005\\\u0001\t\u0005\t\u0015!\u0003Q\u0011!a\u0006A!A!\u0002\u0013i\u0006\u0002\u00031\u0001\u0005\u0003\u0005\u000b\u0011B/\t\u0013\u0005\u0004!\u0011!Q\u0001\n\t|\u0007\"\u00039\u0001\u0005\u0003\u0005\u000b\u0011B9v\u0011\u00151\b\u0001\"\u0001x\u0011%\t9\u0001\u0001a\u0001\n\u0013\tI\u0001C\u0005\u0002\f\u0001\u0001\r\u0011\"\u0003\u0002\u000e!9\u0011\u0011\u0004\u0001!B\u0013\t\u0005\"CA\u000e\u0001\u0001\u0007I\u0011BA\u000f\u0011%\tY\u0003\u0001a\u0001\n\u0013\ti\u0003\u0003\u0005\u00022\u0001\u0001\u000b\u0015BA\u0010\u0011!\tY\u0004\u0001C)=\u0005u\u0002bBA*\u0001\u0011%\u0011Q\u000b\u0005\b\u0003;\u0002A\u0011BA0\u0011\u001d\t9\b\u0001C\u0005\u0003sBq!!+\u0001\t#\nY\u000bC\u0004\u00028\u0002!\t%!/\t\u000f\u0005m\u0006\u0001\"\u0003\u0002>\"9\u0011\u0011\u0019\u0001\u0005\n\u0005\r\u0007bBAk\u0001\u0011%\u0011q\u001b\u0002!\u00072,8\u000f^3s\u0019&t7n\u00115fG.d\u0015N\\6Bm\u0006LG.\u00192jY&$\u0018P\u0003\u0002 A\u0005!A.\u001b8l\u0015\t\t#%\u0001\u0004tKJ4XM\u001d\u0006\u0002G\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001'!\t93F\u0004\u0002)S5\ta$\u0003\u0002+=\u0005!2\t\\;ti\u0016\u0014H*\u001b8l'\u000eDW\rZ;mKJL!\u0001L\u0017\u0003\u0019A+'/[8eS\u000e$\u0016m]6\u000b\u0005)r\u0012A\u00037j].\u001cuN\u001c4jOB\u0019\u0001gM\u001b\u000e\u0003ER\u0011AM\u0001\u0006g\u000e\fG.Y\u0005\u0003iE\u0012\u0011BR;oGRLwN\u001c\u0019\u0011\u0005!2\u0014BA\u001c\u001f\u0005E\u0019E.^:uKJd\u0015N\\6D_:4\u0017nZ\u0001\b[\u0016$(/[2t!\tA#(\u0003\u0002<=\t\u00112\t\\;ti\u0016\u0014H*\u001b8l\u001b\u0016$(/[2t\u0003I\u0019G.^:uKJd\u0015N\\6NC:\fw-\u001a:\u0011\u0005!r\u0014BA \u001f\u0005I\u0019E.^:uKJd\u0015N\\6NC:\fw-\u001a:\u0002\u0015%tG/\u001a:wC2l5\u000f\u0005\u00021\u0005&\u00111)\r\u0002\u0004\u0013:$\u0018BA#,\u0003E\u0011Xm]2iK\u0012,H.\u001a#fY\u0006LXj]\u0001\fG2\u001c6\r[3ek2,'/F\u0001I!\tA\u0013*\u0003\u0002K=\t!2\t\\;ti\u0016\u0014H*\u001b8l'\u000eDW\rZ;mKJ\fAb\u00197TG\",G-\u001e7fe\u0002J!!T\u0016\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014\u0018\u0001\u00037j].t\u0015-\\3\u0016\u0003A\u0003\"!\u0015-\u000f\u0005I3\u0006CA*2\u001b\u0005!&BA+%\u0003\u0019a$o\\8u}%\u0011q+M\u0001\u0007!J,G-\u001a4\n\u0005eS&AB*ue&twM\u0003\u0002Xc\u0005IA.\u001b8l\u001d\u0006lW\rI\u0001\fe\u0016lw\u000e^3BI6Lg\u000e\u0005\u0002)=&\u0011qL\b\u0002\u0016\u00072,8\u000f^3s\u0019&t7NQ1uG\"\fE-\\5o\u0003)awnY1m\u0003\u0012l\u0017N\\\u0001\u0005i&lW\r\u0005\u0002d[6\tAM\u0003\u0002fM\u0006)Q\u000f^5mg*\u0011q\r[\u0001\u0007G>lWn\u001c8\u000b\u0005\rJ'B\u00016l\u0003\u0019\t\u0007/Y2iK*\tA.A\u0002pe\u001eL!A\u001c3\u0003\tQKW.Z\u0005\u0003C.\nQ!];pi\u0006\u0004\"A]:\u000e\u0003\u0001J!\u0001\u001e\u0011\u0003/\rcWo\u001d;fe2Kgn\u001b*fcV,7\u000f^)v_R\f\u0017B\u00019,\u0003\u0019a\u0014N\\5u}Qq\u00010\u001f>|yvtx0!\u0001\u0002\u0004\u0005\u0015\u0001C\u0001\u0015\u0001\u0011\u0015qS\u00021\u00010\u0011\u0015AT\u00021\u0001:\u0011\u0015aT\u00021\u0001>\u0011\u0015\u0001U\u00021\u0001B\u0011\u00151U\u00021\u0001I\u0011\u0015qU\u00021\u0001Q\u0011\u0015aV\u00021\u0001^\u0011\u0015\u0001W\u00021\u0001^\u0011\u0015\tW\u00021\u0001c\u0011\u0015\u0001X\u00021\u0001r\u0003%1\u0017-\u001b7D_VtG/F\u0001B\u000351\u0017-\u001b7D_VtGo\u0018\u0013fcR!\u0011qBA\u000b!\r\u0001\u0014\u0011C\u0005\u0004\u0003'\t$\u0001B+oSRD\u0001\"a\u0006\u0010\u0003\u0003\u0005\r!Q\u0001\u0004q\u0012\n\u0014A\u00034bS2\u001cu.\u001e8uA\u0005AA/Y:l\t\u0016\u001c8-\u0006\u0002\u0002 A)\u0001'!\t\u0002&%\u0019\u00111E\u0019\u0003\r=\u0003H/[8o!\rA\u0013qE\u0005\u0004\u0003Sq\"a\u0004+bg.$Um]2sSB$\u0018n\u001c8\u0002\u0019Q\f7o\u001b#fg\u000e|F%Z9\u0015\t\u0005=\u0011q\u0006\u0005\n\u0003/\u0011\u0012\u0011!a\u0001\u0003?\t\u0011\u0002^1tW\u0012+7o\u0019\u0011)\u0007M\t)\u0004E\u00021\u0003oI1!!\u000f2\u0005!1x\u000e\\1uS2,\u0017a\u0001:v]R\u0011\u0011q\b\t\u0005\u0003\u0003\nyED\u0002\u0002D%rA!!\u0012\u0002N9!\u0011qIA&\u001d\r\u0019\u0016\u0011J\u0005\u0002G%\u0011\u0011EI\u0005\u0003?\u0001J1!!\u0015.\u0005)!\u0016m]6SKN,H\u000e^\u0001\u001cg.L\u0007OU3n_R,\u0017I^1jY\u0006\u0014\u0017\u000e\\5us\u000eCWmY6\u0016\u0005\u0005]\u0003c\u0001\u0019\u0002Z%\u0019\u00111L\u0019\u0003\u000f\t{w\u000e\\3b]\u0006Y\u0002.\u00198eY\u0016$Um]2sS\n,7\t\\;ti\u0016\u0014(+Z:vYR$b!a\u0010\u0002b\u0005-\u0004bBA2-\u0001\u0007\u0011QM\u0001\fi\u0006\u001c8nQ8oi\u0016DH\u000f\u0005\u0003\u0002B\u0005\u001d\u0014bAA5[\tYA+Y:l\u0007>tG/\u001a=u\u0011\u001d\tiG\u0006a\u0001\u0003_\nq%\\1zE\u0016\u001cE.^:uKJd\u0015N\\6D_:tWm\u0019;j_:\u001c\u0005.Z2lKJ\u0014Vm];miB)\u0001'!\t\u0002rA\u0019\u0001&a\u001d\n\u0007\u0005UdD\u0001\u0012DYV\u001cH/\u001a:MS:\\7i\u001c8oK\u000e$\u0018n\u001c8DQ\u0016\u001c7.\u001a:SKN,H\u000e^\u0001&Q\u0006tG\r\\3M_\u000e\fG\u000eR3tGJL'-Z\"mkN$XM\u001d'j].\u001c(+Z:vYR$b!a\u0010\u0002|\u0005u\u0004bBA2/\u0001\u0007\u0011Q\r\u0005\b\u0003\u007f:\u0002\u0019AAA\u0003M!Wm]2sS\n,G*\u001b8lg\u001a+H/\u001e:f!\u0019\t\u0019)!\"\u0002\n6\ta-C\u0002\u0002\b\u001a\u00141bS1gW\u00064U\u000f^;sKB1\u00111RAK\u00033k!!!$\u000b\t\u0005=\u0015\u0011S\u0001\u0005kRLGN\u0003\u0002\u0002\u0014\u0006!!.\u0019<b\u0013\u0011\t9*!$\u0003\u0015\r{G\u000e\\3di&|g\u000e\u0005\u0003\u0002\u001c\u0006\u0015VBAAO\u0015\u0011\ty*!)\u0002\u000b\u0005$W.\u001b8\u000b\u0007\u0005\r\u0006.A\u0004dY&,g\u000e^:\n\t\u0005\u001d\u0016Q\u0014\u0002\u0017\u00072,8\u000f^3s\u0019&t7\u000eR3tGJL\u0007\u000f^5p]\u0006aqN\\\"p[BdW\r^5p]R!\u0011qBAW\u0011\u001d\ty\u000b\u0007a\u0001\u0003c\u000baA]3tk2$\bcA\u0014\u00024&\u0019\u0011QW\u0017\u0003'\r{W\u000e\u001d7fi\u0016$G+Y:l%\u0016\u001cX\u000f\u001c;\u0002\u001fQ\f7o\u001b#fg\u000e\u0014\u0018\u000e\u001d;j_:$\"!a\b\u0002+1L7\u000f\u001e*f[>$Xm\u00117vgR,'\u000fT5oWR!\u0011qHA`\u0011\u001d\t\u0019G\u0007a\u0001\u0003K\nA\u0003[1oI2,G*[:u\u0019&t7NU3tk2$HCBA \u0003\u000b\f9\rC\u0004\u0002dm\u0001\r!!\u001a\t\u000f\u0005%7\u00041\u0001\u0002L\u00061a-\u001e;ve\u0016\u0004b!a!\u0002\u0006\u00065\u0007CBAF\u0003+\u000by\r\u0005\u0003\u0002\u001c\u0006E\u0017\u0002BAj\u0003;\u0013!c\u00117vgR,'\u000fT5oW2K7\u000f^5oO\u0006!Bn\\4MS:\\G)Z:de&\u0014W-\u0012:s_J$b!a\u0004\u0002Z\u0006=\bbBAn9\u0001\u0007\u0011Q\\\u0001\u0002KB!\u0011q\\Au\u001d\u0011\t\t/!:\u000f\u0007M\u000b\u0019/C\u00013\u0013\r\t9/M\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tY/!<\u0003\u0013QC'o\\<bE2,'bAAtc!1\u0011\u0011\u001f\u000fA\u0002A\u000b\u0001\u0002\\5oW\u0012+7o\u0019")
public class ClusterLinkCheckLinkAvailability
extends ClusterLinkScheduler.PeriodicTask {
    private final Function0<ClusterLinkConfig> linkConfig;
    private final ClusterLinkMetrics metrics;
    private final ClusterLinkManager clusterLinkManager;
    private final String linkName;
    private final ClusterLinkBatchAdmin remoteAdmin;
    private final ClusterLinkBatchAdmin localAdmin;
    private int failCount;
    private volatile Option<TaskDescription> taskDesc;

    public ClusterLinkScheduler clScheduler() {
        return super.scheduler();
    }

    public String linkName() {
        return this.linkName;
    }

    private int failCount() {
        return this.failCount;
    }

    private void failCount_$eq(int x$1) {
        this.failCount = x$1;
    }

    private Option<TaskDescription> taskDesc() {
        return this.taskDesc;
    }

    private void taskDesc_$eq(Option<TaskDescription> x$1) {
        this.taskDesc = x$1;
    }

    @Override
    public ClusterLinkScheduler.TaskResult run() {
        ClusterLinkScheduler.TaskContext taskContext = new ClusterLinkScheduler.TaskContext((Seq<TaskErrorCodeAndMsg>)((Seq)package$.MODULE$.Seq().empty()));
        if (this.skipRemoteAvailabilityCheck()) {
            KafkaFuture describeLinksFuture = this.localAdmin.describeClusterLink(this.linkName()).result();
            this.scheduleWhenComplete(describeLinksFuture, new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> this.handleLocalDescribeClusterLinksResult((ClusterLinkScheduler.TaskContext)tc, (KafkaFuture<Collection<ClusterLinkDescription>>)describeLinksFuture), new ClusterLinkScheduler.TaskContext((Seq<TaskErrorCodeAndMsg>)((Seq)package$.MODULE$.Seq().empty()))));
            Seq<TaskErrorCodeAndMsg> inProgressTask_errs = taskContext.errs();
            return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
        }
        ClusterLinkBatchAdmin doBasicDescribeCluster_admin = this.remoteAdmin;
        Object var6_4 = null;
        DescribeClusterResult describeClusterResult = doBasicDescribeCluster_admin.describeCluster();
        this.scheduleWhenComplete(describeClusterResult.clusterId(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> this.handleDescribeClusterResult((ClusterLinkScheduler.TaskContext)tc, ClusterLinkConnectionChecker$.MODULE$.check(describeClusterResult, (ClusterLinkConfig)((Object)((Object)$this.linkConfig.apply())), (Option<ClusterLinkFactory.LinkMetrics>)Option$.MODULE$.apply((Object)$this.metrics), true)), new ClusterLinkScheduler.TaskContext((Seq<TaskErrorCodeAndMsg>)((Seq)package$.MODULE$.Seq().empty()))));
        Seq<TaskErrorCodeAndMsg> inProgressTask_errs = taskContext.errs();
        return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
    }

    private boolean skipRemoteAvailabilityCheck() {
        ConfluentConfigs.ClusterLinkAvailabilityCheckMode clusterLinkAvailabilityCheckMode = this.clusterLinkManager.brokerConfig().clusterLinkAvailabilityCheckMode();
        ConfluentConfigs.ClusterLinkAvailabilityCheckMode clusterLinkAvailabilityCheckMode2 = ConfluentConfigs.ClusterLinkAvailabilityCheckMode.LINK_COORDINATOR;
        return !(clusterLinkAvailabilityCheckMode != null ? !clusterLinkAvailabilityCheckMode.equals(clusterLinkAvailabilityCheckMode2) : clusterLinkAvailabilityCheckMode2 != null) && !this.clusterLinkManager.metadataManager().isLinkCoordinator(this.linkName());
    }

    private ClusterLinkScheduler.TaskResult handleDescribeClusterResult(ClusterLinkScheduler.TaskContext taskContext, Option<ClusterLinkConnectionCheckerResult> maybeClusterLinkConnectionCheckerResult) {
        if (Predef$.MODULE$.Boolean2boolean(((ClusterLinkConfig)((Object)this.linkConfig.apply())).clusterLinkPaused())) {
            Seq completedTask_errs = (Seq)package$.MODULE$.Seq().empty();
            return new ClusterLinkScheduler.TaskResult(true, (Seq<TaskErrorCodeAndMsg>)completedTask_errs);
        }
        String linkName = this.metrics.linkName();
        if (None$.MODULE$.equals(maybeClusterLinkConnectionCheckerResult)) {
            this.failCount_$eq(0);
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(34).append("Link ").append(linkName).append(" availability check succeeded").toString());
            this.clusterLinkManager.reportAvailableLink(linkName);
        } else if (maybeClusterLinkConnectionCheckerResult instanceof Some) {
            ClusterLinkConnectionCheckerResult linkUnavailableResult = (ClusterLinkConnectionCheckerResult)((Some)maybeClusterLinkConnectionCheckerResult).value();
            this.failCount_$eq(this.failCount() + 1);
            this.metrics.linkUnavailableSensor().record();
            if (linkUnavailableResult.unavailableLinkReason() instanceof InvalidBootstrapInternalEndpointUnavailableLinkReason) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(56).append("Link ").append(linkName).append(" availability check failed with authorization error").toString());
                this.clusterLinkManager.failClusterLink(linkName, linkUnavailableResult.throwable(), UnauthorizedBootstrapFailedLinkReason$.MODULE$, (ClusterLinkConfig)((Object)this.linkConfig.apply()));
            } else {
                LinkState linkState;
                if (this.failCount() >= Predef$.MODULE$.Integer2int(((ClusterLinkConfig)((Object)this.linkConfig.apply())).availabilityCheckConsecutiveFailureThreshold())) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(64).append("Reporting ").append(linkName).append(" as unavailable with exception ").append(linkUnavailableResult.throwable().getCause()).append(" and reason ").append(linkUnavailableResult.unavailableLinkReason()).append(" failCount ").append(this.failCount()).toString());
                    this.clusterLinkManager.reportUnavailableLink(linkName, linkUnavailableResult.unavailableLinkReason());
                }
                LinkState linkState2 = linkState = this.clusterLinkManager.linkState(linkName);
                ActiveClusterLink$ activeClusterLink$ = ActiveClusterLink$.MODULE$;
                if (linkState2 != null && linkState2.equals(activeClusterLink$)) {
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(38).append("Link ").append(linkName).append(" availability check failed ").append(this.failCount()).append(" times").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> linkUnavailableResult.throwable());
                } else {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(81).append("Link ").append(linkName).append(" availability check in state ").append(linkState).append(" failed ").append(this.failCount()).append(" times with exception ").append(linkUnavailableResult.throwable().getCause()).append(" ").append("and reason code ").append(linkUnavailableResult.unavailableLinkReason()).toString());
                }
            }
        } else {
            throw new MatchError(maybeClusterLinkConnectionCheckerResult);
        }
        if (!((ClusterLinkConfig)((Object)this.linkConfig.apply())).remoteIsUnmanaged()) {
            if (this.failCount() == 0) {
                return this.listRemoteClusterLink(taskContext);
            }
            this.clusterLinkManager.updateRemoteLinkState(linkName, new RemoteLinkState(ClusterLinkDescription.LinkState.UNKNOWN, ClusterLinkError.UNKNOWN, (Option<String>)new Some((Object)"Failed to obtain remote link state since cluster link is unavailable"), super.time().milliseconds()));
            Seq<TaskErrorCodeAndMsg> completedTask_errs = taskContext.errs();
            return new ClusterLinkScheduler.TaskResult(true, completedTask_errs);
        }
        Seq<TaskErrorCodeAndMsg> completedTask_errs = taskContext.errs();
        return new ClusterLinkScheduler.TaskResult(true, completedTask_errs);
    }

    /*
     * WARNING - void declaration
     */
    private ClusterLinkScheduler.TaskResult handleLocalDescribeClusterLinksResult(ClusterLinkScheduler.TaskContext taskContext, KafkaFuture<Collection<ClusterLinkDescription>> describeLinksFuture) {
        void var5_6;
        void var4_5;
        if (Predef$.MODULE$.Boolean2boolean(((ClusterLinkConfig)((Object)this.linkConfig.apply())).clusterLinkPaused())) {
            Seq completedTask_errs = (Seq)package$.MODULE$.Seq().empty();
            return new ClusterLinkScheduler.TaskResult(true, (Seq<TaskErrorCodeAndMsg>)completedTask_errs);
        }
        Tuple2 tuple2 = this.liftedTree1$1(describeLinksFuture);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Collection links = (Collection)tuple2._1();
        Option errOpt = (Option)tuple2._2();
        var4_5.forEach(link -> {
            if (!$this.clusterLinkManager.metadataManager().isLinkCoordinator(link.linkName())) {
                RemoteLinkState remoteLinkState = new RemoteLinkState(link.remoteLinkState(), link.remoteLinkError(), (Option<String>)Option$.MODULE$.apply((Object)link.remoteLinkErrorMessage()), link.remoteLinkStateTimeMs());
                ClusterLinkDescription.LinkState linkState = link.linkState();
                if (ClusterLinkDescription.LinkState.ACTIVE.equals(linkState)) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(17).append("Link ").append(link.linkName()).append("(").append(link.clusterLinkId()).append(") is active").toString());
                    $this.clusterLinkManager.reportAvailableLink(link.linkName());
                } else if (ClusterLinkDescription.LinkState.UNAVAILABLE.equals(linkState)) {
                    UnavailableLinkReason reason = UnavailableLinkReason$.MODULE$.fromError(link.clusterLinkError(), link.linkErrorMessage());
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(31).append("Link ").append(link.linkName()).append("(").append(link.clusterLinkId()).append(") is unavailable, reason ").append(reason).toString());
                    $this.metrics.linkUnavailableSensor().record();
                    $this.clusterLinkManager.reportUnavailableLink(link.linkName(), reason);
                } else {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(29).append("Link ").append(link.linkName()).append("(").append(link.clusterLinkId()).append(") has state ").append(linkState).append(", ignoring.").toString());
                }
                $this.clusterLinkManager.updateRemoteLinkState(link.linkName(), remoteLinkState);
                return;
            }
            this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(93).append("Ignoring link state of ").append(link.linkName()).append(" since this broker has already processed the state as link coordinator").toString());
        });
        if (var5_6 instanceof Some) {
            TaskErrorCodeAndMsg err = (TaskErrorCodeAndMsg)((Some)var5_6).value();
            Seq completedTask_errs = (Seq)taskContext.errs().$plus$plus((IterableOnce)new .colon.colon((Object)err, (List)Nil$.MODULE$));
            return new ClusterLinkScheduler.TaskResult(true, (Seq<TaskErrorCodeAndMsg>)completedTask_errs);
        }
        if (None$.MODULE$.equals(var5_6)) {
            Seq<TaskErrorCodeAndMsg> completedTask_errs = taskContext.errs();
            return new ClusterLinkScheduler.TaskResult(true, completedTask_errs);
        }
        throw new MatchError((Object)var5_6);
    }

    @Override
    public void onCompletion(ClusterLinkScheduler.CompletedTaskResult result) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(27).append("Completed with task result ").append(result).toString());
        this.taskDesc_$eq(ClusterLinkTask$.MODULE$.handleResult(result, this.metrics, ClusterLinkCheckAvailabilityTaskType$.MODULE$, "run the availability check task"));
    }

    @Override
    public Option<TaskDescription> taskDescription() {
        return this.taskDesc();
    }

    private ClusterLinkScheduler.TaskResult listRemoteClusterLink(ClusterLinkScheduler.TaskContext taskContext) {
        KafkaFuture listLinkResult = this.remoteAdmin.listClusterLink(this.linkName()).result();
        this.scheduleWhenComplete(listLinkResult, new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> this.handleListLinkResult((ClusterLinkScheduler.TaskContext)tc, (KafkaFuture<Collection<ClusterLinkListing>>)listLinkResult), taskContext));
        Seq<TaskErrorCodeAndMsg> inProgressTask_errs = taskContext.errs();
        return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
    }

    /*
     * WARNING - void declaration
     */
    private ClusterLinkScheduler.TaskResult handleListLinkResult(ClusterLinkScheduler.TaskContext taskContext, KafkaFuture<Collection<ClusterLinkListing>> future) {
        .colon.colon colon2;
        void var6_6;
        void var7_7;
        block9: {
            Tuple2 tuple2;
            block8: {
                if (Predef$.MODULE$.Boolean2boolean(((ClusterLinkConfig)((Object)this.linkConfig.apply())).clusterLinkPaused())) {
                    Seq completedTask_errs = (Seq)package$.MODULE$.Seq().empty();
                    return new ClusterLinkScheduler.TaskResult(true, (Seq<TaskErrorCodeAndMsg>)completedTask_errs);
                }
                long now = super.time().milliseconds();
                tuple2 = this.liftedTree2$1(future, now);
                if (tuple2 == null) break block8;
                Option errOpt = (Option)tuple2._1();
                RemoteLinkState remoteLinkState = (RemoteLinkState)tuple2._2();
                if (errOpt != null && remoteLinkState != null) break block9;
            }
            throw new MatchError((Object)tuple2);
        }
        this.clusterLinkManager.updateRemoteLinkState(this.linkName(), (RemoteLinkState)var7_7);
        if (var6_6 instanceof Some) {
            TaskErrorCodeAndMsg err = (TaskErrorCodeAndMsg)((Some)var6_6).value();
            colon2 = new .colon.colon((Object)err, (List)Nil$.MODULE$);
        } else if (None$.MODULE$.equals(var6_6)) {
            colon2 = (Seq)package$.MODULE$.Seq().empty();
        } else {
            throw new MatchError((Object)var6_6);
        }
        .colon.colon errs = colon2;
        Seq completedTask_errs = (Seq)taskContext.errs().$plus$plus((IterableOnce)errs);
        return new ClusterLinkScheduler.TaskResult(true, (Seq<TaskErrorCodeAndMsg>)completedTask_errs);
    }

    private void logLinkDescribeError(Throwable e, String linkDesc) {
        Throwable cause;
        Throwable throwable = cause = e.getCause() == null ? e : e.getCause();
        if (this.failCount() == 0 && !(cause instanceof RetriableException)) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(53).append(linkDesc).append(" link state could not be determined for cluster link ").append(this.linkName()).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
            return;
        }
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(53).append(linkDesc).append(" link state could not be determined for cluster link ").append(this.linkName()).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
    }

    private final /* synthetic */ Tuple2 liftedTree1$1(KafkaFuture describeLinksFuture$2) {
        try {
            return new Tuple2(describeLinksFuture$2.get(), (Object)None$.MODULE$);
        }
        catch (Throwable e) {
            this.logLinkDescribeError(e, "Local");
            TaskErrorCodeAndMsg err = new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, "Failed to obtain local link state from the link coordinator.");
            return new Tuple2(Collections.emptySet(), (Object)new Some((Object)err));
        }
    }

    private final /* synthetic */ Tuple2 liftedTree2$1(KafkaFuture future$1, long now$1) {
        Tuple2 tuple2;
        try {
            Collection listing = (Collection)future$1.get();
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(23).append("handleListLinkResult ").append(this.linkName()).append(": ").append(listing).toString());
            if (!listing.isEmpty()) {
                ClusterLinkListing remoteLink = (ClusterLinkListing)listing.iterator().next();
                return new Tuple2((Object)None$.MODULE$, (Object)new RemoteLinkState(remoteLink.linkState(), remoteLink.clusterLinkError(), (Option<String>)Option$.MODULE$.apply((Object)remoteLink.linkErrorMessage()), now$1));
            }
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Remote link state is empty for cluster link ").append(this.linkName()).toString());
            None$ x$4 = None$.MODULE$;
            Tuple2 tuple22 = new Tuple2((Object)None$.MODULE$, (Object)new RemoteLinkState(ClusterLinkDescription.LinkState.REMOTE_LINK_NOT_FOUND, ClusterLinkError.NO_ERROR, (Option<String>)x$4, now$1));
            tuple2 = tuple22;
        }
        catch (Throwable ex) {
            ApiException e = ClusterLinkUtils$.MODULE$.apiException(ex, new StringBuilder(59).append("Remote link state could not be determined for cluster link ").append(this.linkName()).toString());
            this.logLinkDescribeError(e, "Remote");
            if (e instanceof AuthenticationException) {
                String errMsg = "Failed to obtain remote link state due to authentication failure. This failure may impact functioning of this link until credentials are updated.";
                return new Tuple2((Object)new Some((Object)new TaskErrorCodeAndMsg(AuthenticationTaskErrorCode$.MODULE$, errMsg)), (Object)new RemoteLinkState(ClusterLinkDescription.LinkState.UNKNOWN, ClusterLinkError.AUTHENTICATION_ERROR, (Option<String>)new Some((Object)errMsg), now$1));
            }
            if (e instanceof ClusterAuthorizationException) {
                String errMsg = "Failed to obtain remote link state due to Describe:Cluster authorization failure. This failure may impact functioning of this link until appropriate access is granted.";
                return new Tuple2((Object)new Some((Object)new TaskErrorCodeAndMsg(AuthorizationTaskErrorCode$.MODULE$, errMsg)), (Object)new RemoteLinkState(ClusterLinkDescription.LinkState.UNKNOWN, ClusterLinkError.AUTHORIZATION_ERROR, (Option<String>)new Some((Object)errMsg), now$1));
            }
            if (e != null) {
                String errMsg = "Failed to obtain remote link state for an unknown reason.";
                return new Tuple2((Object)new Some((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg)), (Object)new RemoteLinkState(ClusterLinkDescription.LinkState.UNKNOWN, ClusterLinkError.UNKNOWN, (Option<String>)new Some((Object)errMsg), now$1));
            }
            throw new MatchError(null);
        }
        return tuple2;
    }

    public ClusterLinkCheckLinkAvailability(Function0<ClusterLinkConfig> linkConfig, ClusterLinkMetrics metrics, ClusterLinkManager clusterLinkManager, int intervalMs, ClusterLinkScheduler clScheduler, String linkName, ClusterLinkBatchAdmin remoteAdmin, ClusterLinkBatchAdmin localAdmin, Time time, ClusterLinkRequestQuota quota) {
        this.linkConfig = linkConfig;
        this.metrics = metrics;
        this.clusterLinkManager = clusterLinkManager;
        this.linkName = linkName;
        this.remoteAdmin = remoteAdmin;
        this.localAdmin = localAdmin;
        super(clScheduler, "ClusterLinkCheckLinkAvailability", intervalMs, time, quota);
        this.failCount = 0;
        this.taskDesc = None$.MODULE$;
    }
}

