/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.net.BindException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import kafka.server.link.AuthenticationErrorUnavailableLinkReason;
import kafka.server.link.BootstrapTcpConnectionFailedUnavailableLinkReason;
import kafka.server.link.ClusterLinkBatchAdmin;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConnectionCheckerResult;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkUtils$;
import kafka.server.link.InvalidBootstrapInternalEndpointUnavailableLinkReason;
import kafka.server.link.LinkType;
import kafka.server.link.LinkType$Cloud$;
import kafka.server.link.TimeoutUnavailableLinkReason;
import kafka.server.link.UnavailableLinkReason;
import kafka.server.link.UnknownUnavailableLinkReason;
import kafka.server.link.UnresolvableBootstrapUnavailableLinkReason;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientDnsLookup;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.kafka.common.ClusterLinkError;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.errors.TimeoutException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ClusterLinkConnectionChecker$
implements Logging {
    public static final ClusterLinkConnectionChecker$ MODULE$ = new ClusterLinkConnectionChecker$();
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public Option<ClusterLinkConnectionCheckerResult> check(DescribeClusterResult describeClusterResult, ClusterLinkConfig config, Option<ClusterLinkFactory.LinkMetrics> linkMetrics, boolean connectionToRemoteCluster) {
        try {
            describeClusterResult.clusterId().get();
            return Option$.MODULE$.empty();
        }
        catch (Throwable ex) {
            ApiException apiException = ClusterLinkUtils$.MODULE$.apiException(ex, "Basic describeCluster check failed");
            if (this.logger().underlying().isWarnEnabled()) {
                String msgWithLogIdent_msg = ClusterLinkConnectionChecker$.$anonfun$check$1(ex, apiException);
                Object var9_7 = null;
                this.logger().underlying().warn(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            if (apiException instanceof AuthenticationException) {
                return Option$.MODULE$.apply((Object)new ClusterLinkConnectionCheckerResult(ex, new AuthenticationErrorUnavailableLinkReason(config)));
            }
            if (apiException instanceof AuthorizationException) {
                return Option$.MODULE$.apply((Object)new ClusterLinkConnectionCheckerResult(ex, new InvalidBootstrapInternalEndpointUnavailableLinkReason(config)));
            }
            UnavailableLinkReason reason = this.checkBasicNetworking(config);
            ClusterLinkError clusterLinkError = reason.clusterLinkError();
            ClusterLinkError clusterLinkError2 = ClusterLinkError.UNKNOWN;
            if (!(clusterLinkError != null ? !clusterLinkError.equals(clusterLinkError2) : clusterLinkError2 != null) && apiException instanceof TimeoutException) {
                if (this.isSecuritySettingsMissingForCloudLink(config, linkMetrics, connectionToRemoteCluster)) {
                    return Option$.MODULE$.apply((Object)new ClusterLinkConnectionCheckerResult(ex, new AuthenticationErrorUnavailableLinkReason(config)));
                }
                return Option$.MODULE$.apply((Object)new ClusterLinkConnectionCheckerResult(ex, new TimeoutUnavailableLinkReason(config)));
            }
            return Option$.MODULE$.apply((Object)new ClusterLinkConnectionCheckerResult(ex, reason));
        }
    }

    public DescribeClusterResult doBasicDescribeCluster(ClusterLinkBatchAdmin admin) {
        return admin.describeCluster();
    }

    public boolean isSecuritySettingsMissingForCloudLink(ClusterLinkConfig config, Option<ClusterLinkFactory.LinkMetrics> linkMetrics, boolean connectionToRemoteCluster) {
        boolean bl;
        ClusterLinkFactory.LinkMetrics clusterLinkMetrics;
        if (linkMetrics instanceof Some && (clusterLinkMetrics = (ClusterLinkFactory.LinkMetrics)((Some)linkMetrics).value()) instanceof ClusterLinkMetrics) {
            LinkType linkType = ((ClusterLinkMetrics)clusterLinkMetrics).linkType();
            LinkType$Cloud$ linkType$Cloud$ = LinkType$Cloud$.MODULE$;
            bl = linkType != null && linkType.equals(linkType$Cloud$);
        } else {
            bl = false;
        }
        return bl && connectionToRemoteCluster && (this.isSecurityConfigNull(config, "security.protocol", false) || this.isSecurityConfigNull(config, "sasl.mechanism", false) || this.isSecurityConfigNull(config, "sasl.jaas.config", true));
    }

    private boolean isSecurityConfigNull(ClusterLinkConfig config, String securityConfig, boolean isPasswordConfig) {
        boolean configIsNull;
        boolean bl = configIsNull = securityConfig == null;
        if (!configIsNull) {
            String string = isPasswordConfig ? config.getPassword(securityConfig).value() : config.getString(securityConfig);
            String string2 = "null";
            return string != null && string.equals(string2);
        }
        return configIsNull;
    }

    private boolean isSecurityConfigNull$default$3() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private UnavailableLinkReason checkBasicNetworking(ClusterLinkConfig config) {
        void var4_4;
        void var3_3;
        Tuple2<Option<UnavailableLinkReason>, List<InetSocketAddress>> tuple2 = this.checkAddresses(config);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option dnsErr = (Option)tuple2._1();
        List validatedAddresses = (List)tuple2._2();
        return (UnavailableLinkReason)var3_3.getOrElse(() -> ClusterLinkConnectionChecker$.$anonfun$checkBasicNetworking$1((List)var4_4, config));
    }

    public Option<UnavailableLinkReason> checkTcpConnection(List<InetSocketAddress> validatedAddresses, ClusterLinkConfig config) {
        try {
            this.tryTcpConnectionToBootstrapServers(validatedAddresses);
            return None$.MODULE$;
        }
        catch (ConnectException ex) {
            if (this.logger().underlying().isWarnEnabled()) {
                String msgWithLogIdent_msg = ClusterLinkConnectionChecker$.$anonfun$checkTcpConnection$1(ex);
                Object var7_4 = null;
                this.logger().underlying().warn(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            return Option$.MODULE$.apply((Object)new BootstrapTcpConnectionFailedUnavailableLinkReason(config));
        }
        catch (SocketTimeoutException ex) {
            if (this.logger().underlying().isWarnEnabled()) {
                String msgWithLogIdent_msg = ClusterLinkConnectionChecker$.$anonfun$checkTcpConnection$2(ex);
                Object var8_6 = null;
                this.logger().underlying().warn(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            return Option$.MODULE$.apply((Object)new BootstrapTcpConnectionFailedUnavailableLinkReason(config));
        }
        catch (BindException ex) {
            if (this.logger().underlying().isWarnEnabled()) {
                String msgWithLogIdent_msg = ClusterLinkConnectionChecker$.$anonfun$checkTcpConnection$3(ex);
                Object var9_8 = null;
                this.logger().underlying().warn(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            return Option$.MODULE$.apply((Object)new BootstrapTcpConnectionFailedUnavailableLinkReason(config));
        }
        catch (Throwable ex) {
            if (this.logger().underlying().isWarnEnabled()) {
                String msgWithLogIdent_msg = ClusterLinkConnectionChecker$.$anonfun$checkTcpConnection$4(ex);
                Object var10_10 = null;
                this.logger().underlying().warn(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            return Option$.MODULE$.apply((Object)new UnknownUnavailableLinkReason(config));
        }
    }

    public Tuple2<Option<UnavailableLinkReason>, List<InetSocketAddress>> checkAddresses(ClusterLinkConfig config) {
        List list;
        List<String> bootstrapServers = config.bootstrapServersToConnect();
        String dnsLookupConfig = config.getString("client.dns.lookup");
        ClientDnsLookup dnsLookup = dnsLookupConfig == null ? ClientDnsLookup.USE_ALL_DNS_IPS : ClientDnsLookup.forConfig((String)dnsLookupConfig);
        ArrayList invalidAddresses = new ArrayList();
        try {
            list = ClientUtils.parseAndValidateAddresses(bootstrapServers, (ClientDnsLookup)dnsLookup);
        }
        catch (ConfigException ex) {
            if (this.logger().underlying().isWarnEnabled()) {
                String msgWithLogIdent_msg = ClusterLinkConnectionChecker$.$anonfun$checkAddresses$1(ex);
                Object var9_7 = null;
                this.logger().underlying().warn(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            return new Tuple2((Object)Option$.MODULE$.apply((Object)new UnresolvableBootstrapUnavailableLinkReason(config)), null);
        }
        catch (Throwable ex) {
            if (this.logger().underlying().isWarnEnabled()) {
                String msgWithLogIdent_msg = ClusterLinkConnectionChecker$.$anonfun$checkAddresses$2(ex);
                Object var10_9 = null;
                this.logger().underlying().warn(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            return new Tuple2((Object)Option$.MODULE$.apply((Object)new UnknownUnavailableLinkReason(config)), null);
        }
        List validatedAddresses = list;
        CollectionConverters$.MODULE$.ListHasAsScala(validatedAddresses).asScala().foreach((Function1 & Serializable)inetSocketAddress -> {
            if (ClusterLinkUtils$.MODULE$.isInternalNetworkOrPort((InetSocketAddress)inetSocketAddress)) {
                return BoxesRunTime.boxToBoolean((boolean)invalidAddresses.add(inetSocketAddress));
            }
            return BoxedUnit.UNIT;
        });
        if (!invalidAddresses.isEmpty()) {
            if (this.logger().underlying().isWarnEnabled()) {
                String msgWithLogIdent_msg = ClusterLinkConnectionChecker$.$anonfun$checkAddresses$4(invalidAddresses);
                Object var11_11 = null;
                this.logger().underlying().warn(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            return new Tuple2((Object)Option$.MODULE$.apply((Object)new InvalidBootstrapInternalEndpointUnavailableLinkReason(config)), null);
        }
        return new Tuple2((Object)None$.MODULE$, (Object)validatedAddresses);
    }

    private void tryTcpConnectionToBootstrapServers(List<InetSocketAddress> validatedAddresses) {
        CollectionConverters$.MODULE$.ListHasAsScala(validatedAddresses).asScala().withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkConnectionChecker$.$anonfun$tryTcpConnectionToBootstrapServers$1(check$ifrefutable$1))).foreach((Function1 & Serializable)endpoint -> {
            ClusterLinkConnectionChecker$.$anonfun$tryTcpConnectionToBootstrapServers$2(endpoint);
            return BoxedUnit.UNIT;
        });
    }

    public int tcpConnectionTimeoutsMs() {
        return 5000;
    }

    public static final /* synthetic */ String $anonfun$check$1(Throwable ex$1, ApiException apiException$1) {
        return new StringBuilder(67).append("Failed to contact remote cluster with exception ").append(ex$1).append(" and api exception ").append(apiException$1).toString();
    }

    public static final /* synthetic */ UnavailableLinkReason $anonfun$checkBasicNetworking$1(List validatedAddresses$1, ClusterLinkConfig config$1) {
        return (UnavailableLinkReason)MODULE$.checkTcpConnection(validatedAddresses$1, config$1).getOrElse((Function0 & Serializable)() -> new UnknownUnavailableLinkReason(config$1));
    }

    public static final /* synthetic */ String $anonfun$checkTcpConnection$1(ConnectException ex$2) {
        return new StringBuilder(30).append("Failed to connect to endpoint ").append(ex$2).toString();
    }

    public static final /* synthetic */ String $anonfun$checkTcpConnection$2(SocketTimeoutException ex$3) {
        return new StringBuilder(30).append("Failed to connect to endpoint ").append(ex$3).toString();
    }

    public static final /* synthetic */ String $anonfun$checkTcpConnection$3(BindException ex$4) {
        return new StringBuilder(27).append("Failed to bind to endpoint ").append(ex$4).toString();
    }

    public static final /* synthetic */ String $anonfun$checkTcpConnection$4(Throwable ex$5) {
        return new StringBuilder(53).append("Failed to connect to endpoint with unknown exception ").append(ex$5).toString();
    }

    public static final /* synthetic */ String $anonfun$checkAddresses$1(ConfigException ex$6) {
        return new StringBuilder(23).append("Failed to validate DNS ").append((Object)ex$6).toString();
    }

    public static final /* synthetic */ String $anonfun$checkAddresses$2(Throwable ex$7) {
        return new StringBuilder(49).append("Failed to validate DNS with an unknown exception ").append(ex$7).toString();
    }

    public static final /* synthetic */ String $anonfun$checkAddresses$4(ArrayList invalidAddresses$1) {
        return new StringBuilder(95).append("Invalid bootstrap addresses or ports that cannot be used for cluster links on Confluent Cloud: ").append(invalidAddresses$1).toString();
    }

    public static final /* synthetic */ boolean $anonfun$tryTcpConnectionToBootstrapServers$1(InetSocketAddress check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ void $anonfun$tryTcpConnectionToBootstrapServers$2(InetSocketAddress endpoint) {
        try (Socket clientSocket = new Socket();){
            clientSocket.connect(endpoint, 5000);
        }
    }

    private ClusterLinkConnectionChecker$() {
    }
}

