/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.server.KafkaConfig;
import kafka.server.MetadataCache;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkControllerRequestCompletionHandler;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkTopicState$;
import kafka.server.metadata.KRaftImageMetadataCache;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ClusterLinkNotFoundException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.message.AlterMirrorTopicsRequestData;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterMirrorTopicsRequest;
import org.apache.kafka.common.requests.AlterMirrorTopicsResponse;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.metadata.ClusterLink;
import org.apache.kafka.metadata.MirrorTopic;
import org.apache.kafka.server.ControllerRequestCompletionHandler;
import org.apache.kafka.server.NodeToControllerChannelManager;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.apache.kafka.server.immutable.ImmutableMap;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t\rg\u0001B\u0015+\u0001EB\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\tw\u0001\u0011\t\u0011)A\u0005y!Iq\b\u0001B\u0001B\u0003%\u0001I\u0012\u0005\n\u000f\u0002\u0011\t\u0011)A\u0005\u0011JC\u0001b\u0015\u0001\u0003\u0002\u0003\u0006I\u0001\u0016\u0005\tE\u0002\u0011\t\u0011)A\u0005G\")\u0011\u000e\u0001C\u0001U\")!\u000f\u0001C!g\"9\u00111\u0003\u0001\u0005\n\u0005U\u0001bBA\n\u0001\u0011%\u0011Q\u0007\u0005\b\u0003\u000f\u0002A\u0011IA%\u0011\u001d\ty\u0005\u0001C!\u0003#Bq!a\u0014\u0001\t\u0003\n)\u0006C\u0004\u0002P\u0001!\t%!\u0017\t\u000f\u0005m\u0003\u0001\"\u0011\u0002^!9\u00111\f\u0001\u0005B\u0005\u0005\u0004bBA.\u0001\u0011\u0005\u0013\u0011\f\u0005\b\u0003K\u0002A\u0011IA4\u0011\u001d\tI\u0007\u0001C!\u0003WBq!!\u001e\u0001\t\u0003\n9\bC\u0004\u0002\u0002\u0002!\t%a!\t\u000f\u0005\u001d\u0005\u0001\"\u0011\u0002\n\"9\u0011q\u0011\u0001\u0005\u0002\u0005m\u0005bBAQ\u0001\u0011\u0005\u00131\u0015\u0005\b\u0003o\u0003A\u0011IA]\u0011\u001d\ti\f\u0001C!\u0003\u007fCq!a5\u0001\t\u0003\n)\u000eC\u0004\u0002d\u0002!\t%!:\t\u000f\u0005=\b\u0001\"\u0011\u0002r\"9\u0011Q\u001f\u0001\u0005B\u0005]\b\"\u0003B\f\u0001E\u0005I\u0011\u0001B\r\u0011%\u0011y\u0003AI\u0001\n\u0003\u0011I\u0002C\u0005\u00032\u0001\t\n\u0011\"\u0001\u00034!I!q\u0007\u0001\u0012\u0002\u0013\u0005!\u0011\b\u0005\b\u0005{\u0001A\u0011\tB \u0011\u001d\u0011\u0019\u0005\u0001C\u0005\u0005\u000bBqAa\u0019\u0001\t\u0013\u0011)\u0007C\u0004\u0003 \u0002!\tE!)\t\u000f\tU\u0006\u0001\"\u0011\u00038\"i!\u0011\u0018\u0001\u0011\u0002\u0007\u0005\t\u0011\"\u0003\u0003<\u001a\u0013!f\u00117vgR,'\u000fT5oW6+G/\u00193bi\u0006l\u0015M\\1hKJ<\u0016\u000e\u001e5L%\u00064GoU;qa>\u0014HO\u0003\u0002,Y\u0005!A.\u001b8l\u0015\tic&\u0001\u0004tKJ4XM\u001d\u0006\u0002_\u0005)1.\u00194lC\u000e\u00011C\u0001\u00013!\t\u0019D'D\u0001+\u0013\t)$F\u0001\u000eDYV\u001cH/\u001a:MS:\\W*\u001a;bI\u0006$\u0018-T1oC\u001e,'/\u0001\u0007ce>\\WM]\"p]\u001aLw\r\u0005\u00029s5\tA&\u0003\u0002;Y\tY1*\u00194lC\u000e{gNZ5h\u0003%\u00198\r[3ek2,'\u000f\u0005\u00024{%\u0011aH\u000b\u0002\u0015\u00072,8\u000f^3s\u0019&t7nU2iK\u0012,H.\u001a:\u0002\u001b5,G/\u00193bi\u0006\u001c\u0015m\u00195f!\t\tE)D\u0001C\u0015\t\u0019E&\u0001\u0005nKR\fG-\u0019;b\u0013\t)%IA\fL%\u00064G/S7bO\u0016lU\r^1eCR\f7)Y2iK&\u0011q\bN\u0001\u0019G>tGO]8mY\u0016\u00148\t[1o]\u0016dW*\u00198bO\u0016\u0014\bCA%Q\u001b\u0005Q%BA\u0017L\u0015\tyCJ\u0003\u0002N\u001d\u00061\u0011\r]1dQ\u0016T\u0011aT\u0001\u0004_J<\u0017BA)K\u0005yqu\u000eZ3U_\u000e{g\u000e\u001e:pY2,'o\u00115b]:,G.T1oC\u001e,'/\u0003\u0002Hi\u0005\tBn\\2bY\u0006#W.\u001b8GC\u000e$xN]=\u0011\u0007UC&,D\u0001W\u0015\u00059\u0016!B:dC2\f\u0017BA-W\u0005%1UO\\2uS>t\u0007\u0007\u0005\u0002\\A6\tAL\u0003\u0002^=\u0006)\u0011\rZ7j]*\u0011qlS\u0001\bG2LWM\u001c;t\u0013\t\tGLA\u0003BI6Lg.\u0001\u0006tKJ4XM]%oM>\u0004\"\u0001Z4\u000e\u0003\u0015T!A\u001a&\u0002\u0015\u0005,H\u000f[8sSj,'/\u0003\u0002iK\n!\u0012)\u001e;i_JL'0\u001a:TKJ4XM]%oM>\fa\u0001P5oSRtDcB6m[:|\u0007/\u001d\t\u0003g\u0001AQAN\u0004A\u0002]BQaO\u0004A\u0002qBQaP\u0004A\u0002\u0001CQaR\u0004A\u0002!CQaU\u0004A\u0002QCQAY\u0004A\u0002\r\f1\"\\5se>\u0014Hk\u001c9jGR\u0011A\u000f \t\u0004+V<\u0018B\u0001<W\u0005\u0019y\u0005\u000f^5p]B\u0011\u0001P_\u0007\u0002s*\u00111iS\u0005\u0003wf\u00141\"T5se>\u0014Hk\u001c9jG\")Q\u0010\u0003a\u0001}\u0006)Ao\u001c9jGB\u0019q0!\u0004\u000f\t\u0005\u0005\u0011\u0011\u0002\t\u0004\u0003\u00071VBAA\u0003\u0015\r\t9\u0001M\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005-a+\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u001f\t\tB\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u00171\u0016!E7jeJ|'\u000fV8qS\u000e\u001cF/\u0019;fgR!\u0011qCA\u0015!\u001d\tI\"a\b\u007f\u0003Gi!!a\u0007\u000b\u0007\u0005ua+\u0001\u0006d_2dWm\u0019;j_:LA!!\t\u0002\u001c\t\u0019Q*\u00199\u0011\u0007M\n)#C\u0002\u0002()\u0012Qc\u00117vgR,'\u000fT5oWR{\u0007/[2Ti\u0006$X\rC\u0004\u0002,%\u0001\r!!\f\u0002\u0013Q|\u0007/[2t\u001fB$\b\u0003B+v\u0003_\u0001Ba`A\u0019}&!\u00111GA\t\u0005\r\u0019V\r\u001e\u000b\u0005\u0003/\t9\u0004C\u0004\u0002:)\u0001\r!a\u000f\u0002\r1Lgn[%e!\u0011\ti$a\u0011\u000e\u0005\u0005}\"bAA!\u0017\u000611m\\7n_:LA!!\u0012\u0002@\t!Q+^5e\u0003\tj\u0017N\u001d:peR{\u0007/[2Ti\u0006$Xm\u001d$s_6lU\r^1eCR\f7\u000b^8sKR!\u0011qCA&\u0011\u001d\tie\u0003a\u0001\u0003_\ta\u0001^8qS\u000e\u001c\u0018AI7jeJ|'\u000fV8qS\u000e\u001cF/\u0019;fg\u001a\u0013x.\\'fi\u0006$\u0017\r^1DC\u000eDW\r\u0006\u0003\u0002\u0018\u0005M\u0003bBA\u001d\u0019\u0001\u0007\u00111\b\u000b\u0005\u0003/\t9\u0006C\u0004\u0002N5\u0001\r!a\f\u0015\u0005\u0005]\u0011AJ7jeJ|'\u000fV8qS\u000e\u001cF/\u0019;fg\u001a\u0013x.\\\"p]R\u0014x\u000e\u001c7fe\u000e{g\u000e^3yiR!\u0011qCA0\u0011\u001d\tId\u0004a\u0001\u0003w!B!a\u0006\u0002d!9\u0011Q\n\tA\u0002\u0005=\u0012!F4fi\u0006cG\u000eV8qS\u000e\u001c\u0018J\\\"mkN$XM\u001d\u000b\u0003\u0003_\t!$[:U_BL7-U;fk\u0016$W\u000b\u001d$pe\u0012+G.\u001a;j_:$B!!\u001c\u0002tA\u0019Q+a\u001c\n\u0007\u0005EdKA\u0004C_>dW-\u00198\t\u000bu\u001c\u0002\u0019\u0001@\u0002/\u0015t7/\u001e:f\u00072,8\u000f^3s\u0019&t7.\u0012=jgR\u001cH\u0003BA=\u0003\u007f\u00022!VA>\u0013\r\tiH\u0016\u0002\u0005+:LG\u000fC\u0004\u0002:Q\u0001\r!a\u000f\u0002#\rdWo\u001d;fe2Kgn[#ySN$8\u000f\u0006\u0003\u0002n\u0005\u0015\u0005bBA\u001d+\u0001\u0007\u00111H\u0001\u0013O\u0016$8\t\\;ti\u0016\u0014H*\u001b8l\t\u0006$\u0018\r\u0006\u0003\u0002\f\u0006e\u0005\u0003B+v\u0003\u001b\u0003B!a$\u0002\u00166\u0011\u0011\u0011\u0013\u0006\u0004\u0003's\u0013A\u0001>l\u0013\u0011\t9*!%\u0003\u001f\rcWo\u001d;fe2Kgn\u001b#bi\u0006Dq!!\u000f\u0017\u0001\u0004\tY\u0004\u0006\u0003\u0002\f\u0006u\u0005BBAP/\u0001\u0007a0\u0001\u0005mS:\\g*Y7f\u0003e9W\r^\"mkN$XM\u001d'j].\u001cuN\u001c4jOB\u0013x\u000e]:\u0015\t\u0005\u0015\u0016Q\u0017\t\u0005\u0003O\u000b\t,\u0004\u0002\u0002**!\u00111VAW\u0003\u0011)H/\u001b7\u000b\u0005\u0005=\u0016\u0001\u00026bm\u0006LA!a-\u0002*\nQ\u0001K]8qKJ$\u0018.Z:\t\u000f\u0005e\u0002\u00041\u0001\u0002<\u0005qq-\u001a;U_BL7mQ8oM&<G\u0003BAS\u0003wCQ!`\rA\u0002y\f1$\u00197uKJ\u001cE.^:uKJd\u0015N\\6D_:4\u0017n\u001a.O_\u0012,GCCA=\u0003\u0003\f\u0019-!2\u0002J\"9\u0011\u0011\b\u000eA\u0002\u0005m\u0002BBAP5\u0001\u0007a\u0010C\u0004\u0002Hj\u0001\r!!*\u0002\u001fA,'o]5ti\u0016tG\u000f\u0015:paNDq!a3\u001b\u0001\u0004\ti-\u0001\u0006mS:\\7i\u001c8gS\u001e\u00042aMAh\u0013\r\t\tN\u000b\u0002\u0012\u00072,8\u000f^3s\u0019&t7nQ8oM&<\u0017\u0001I7bs\n,'+Z3oGJL\b\u000f^\"mkN$XM\u001d'j].\u001cuN\u001c4jON$B!!\u001f\u0002X\"9\u0011\u0011\\\u000eA\u0002\u0005m\u0017!E2p]\u001aLw\r\u0016:b]N4wN]7feB9Q+!8\u0002&\u0006\u0005\u0018bAAp-\nIa)\u001e8di&|g.\r\t\u0005+V\f)+\u0001\fde\u0016\fG/Z\"mkN$XM\u001d'j].Tfj\u001c3f)\u0019\tI(a:\u0002l\"9\u0011\u0011\u001e\u000fA\u0002\u00055\u0015aD2mkN$XM\u001d'j].$\u0015\r^1\t\u000f\u00055H\u00041\u0001\u0002&\u0006)\u0001O]8qg\u0006\u00192/\u001a;DYV\u001cH/\u001a:MS:\\'LT8eKR!\u0011\u0011PAz\u0011\u001d\tI/\ba\u0001\u0003\u001b\u000bQ#\u00197uKJl\u0015N\u001d:peR{\u0007/[2Ti\u0006$X\r\u0006\t\u0002z\u0005e\u00181 B\u0002\u0005\u000f\u0011YAa\u0004\u0003\u0014!)QP\ba\u0001}\"9\u0011Q \u0010A\u0002\u0005}\u0018\u0001D:uCR,W\u000b\u001d3bi\u0016\u0014\bcB+\u0002^\u0006\r\"\u0011\u0001\t\u0005+V\f\u0019\u0003C\u0004\u0003\u0006y\u0001\r!!\u001c\u0002\u0019Y\fG.\u001b3bi\u0016|e\u000e\\=\t\u0013\t%a\u0004%AA\u0002\u00055\u0014a\u00044bS2LeMT8u\u001b&\u0014(o\u001c:\t\u0013\t5a\u0004%AA\u0002\u00055\u0014\u0001G5t\u0007>tg/\u001a:u)>\u0004VM\u001c3j]\u001el\u0015N\u001d:pe\"A!\u0011\u0003\u0010\u0011\u0002\u0003\u0007a0A\bt_V\u00148-\u001a+pa&\u001cg*Y7f\u0011%\u0011)B\bI\u0001\u0002\u0004\tY$\u0001\u000bfqB,7\r^3e\u0019>\u001c\u0017\r\u001c+pa&\u001c\u0017\nZ\u0001 C2$XM]'jeJ|'\u000fV8qS\u000e\u001cF/\u0019;fI\u0011,g-Y;mi\u0012\"TC\u0001B\u000eU\u0011\tiG!\b,\u0005\t}\u0001\u0003\u0002B\u0011\u0005Wi!Aa\t\u000b\t\t\u0015\"qE\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!\u000bW\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005[\u0011\u0019CA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fq$\u00197uKJl\u0015N\u001d:peR{\u0007/[2Ti\u0006$X\r\n3fM\u0006,H\u000e\u001e\u00136\u0003}\tG\u000e^3s\u001b&\u0014(o\u001c:U_BL7m\u0015;bi\u0016$C-\u001a4bk2$HEN\u000b\u0003\u0005kQ3A B\u000f\u0003}\tG\u000e^3s\u001b&\u0014(o\u001c:U_BL7m\u0015;bi\u0016$C-\u001a4bk2$HeN\u000b\u0003\u0005wQC!a\u000f\u0003\u001e\u00051B-\u001a7fi\u0016\u001cE.^:uKJd\u0015N\\6[\u001d>$W\r\u0006\u0003\u0002z\t\u0005\u0003bBA\u001dG\u0001\u0007\u00111H\u0001\u0011C2$XM]'jeJ|'\u000fV8qS\u000e$\"Ba\u0012\u0003Z\tm#q\fB1!\u0019\tiD!\u0013\u0003N%!!1JA \u0005-Y\u0015MZ6b\rV$XO]3\u0011\t\t=#QK\u0007\u0003\u0005#RAAa\u0015\u0002.\u0006!A.\u00198h\u0013\u0011\u00119F!\u0015\u0003\tY{\u0017\u000e\u001a\u0005\u0006{\u0012\u0002\rA \u0005\b\u0005;\"\u0003\u0019AA\u0012\u0003Ai\u0017N\u001d:peR{\u0007/[2Ti\u0006$X\r\u0003\u0004\u0003\u0012\u0011\u0002\rA \u0005\b\u0005+!\u0003\u0019AA\u001e\u0003m\u0019XM\u001c3BYR,'/T5se>\u0014Hk\u001c9jGJ+\u0017/^3tiR1\u0011\u0011\u0010B4\u0005\u001fCqAa\u0011&\u0001\u0004\u0011I\u0007\u0005\u0003\u0003l\t%e\u0002\u0002B7\u0005\u0007sAAa\u001c\u0003\u00009!!\u0011\u000fB?\u001d\u0011\u0011\u0019Ha\u001f\u000f\t\tU$\u0011\u0010\b\u0005\u0003\u0007\u00119(C\u0001P\u0013\tie*\u0003\u00020\u0019&\u0019\u0011\u0011I&\n\t\t\u0005\u0015qH\u0001\b[\u0016\u001c8/Y4f\u0013\u0011\u0011)Ia\"\u00029\u0005cG/\u001a:NSJ\u0014xN\u001d+pa&\u001c7OU3rk\u0016\u001cH\u000fR1uC*!!\u0011QA \u0013\u0011\u0011YI!$\u0003!\u0005cG/\u001a:NSJ\u0014xN\u001d+pa&\u001c'\u0002\u0002BC\u0005\u000fCqA!%&\u0001\u0004\u0011\u0019*\u0001\u0004sKN,H\u000e\u001e\t\u0007\u0005+\u0013YJ!\u0014\u000e\u0005\t]%\u0002\u0002BM\u0003\u007f\t\u0011\"\u001b8uKJt\u0017\r\\:\n\t\tu%q\u0013\u0002\u0010\u0017\u000647.\u0019$viV\u0014X-S7qY\u00069r-\u001a;BY2d\u0015N\\6t\rJ|W.T3uC\u0012\fG/\u0019\u000b\u0003\u0005G\u0003bA!*\u00030\u00065e\u0002\u0002BT\u0005WsA!a\u0001\u0003*&\tq+C\u0002\u0003.Z\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u00032\nM&aA*fc*\u0019!Q\u0016,\u00021%\u001cH*\u001b8l\u0007>|'\u000fZ5oCR|'/\u00128bE2,G-\u0006\u0002\u0002n\u0005\u00192/\u001e9fe\u0012jW\r^1eCR\f7)Y2iKV\u0011!Q\u0018\t\u0004q\t}\u0016b\u0001BaY\tiQ*\u001a;bI\u0006$\u0018mQ1dQ\u0016\u0004")
public class ClusterLinkMetadataManagerWithKRaftSupport
extends ClusterLinkMetadataManager {
    private final Function0<Admin> localAdminFactory;

    private /* synthetic */ MetadataCache super$metadataCache() {
        return super.metadataCache();
    }

    @Override
    public Option<MirrorTopic> mirrorTopic(String topic) {
        return Option$.MODULE$.apply((Object)((KRaftImageMetadataCache)super.metadataCache()).currentImage().topics().getTopic(topic)).flatMap((Function1 & Serializable)x$1 -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(x$1.mirrorTopic())));
    }

    private Map<String, ClusterLinkTopicState> mirrorTopicStates(Option<Set<String>> topicsOpt) {
        Set set;
        MetadataImage image = ((KRaftImageMetadataCache)super.metadataCache()).currentImage();
        if (topicsOpt instanceof Some) {
            set = (Set)((Set)((Some)topicsOpt).value()).map((Function1 & Serializable)topic -> Option$.MODULE$.apply((Object)image.topics().getTopic(topic)).flatMap((Function1 & Serializable)x$2 -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(x$2.mirrorTopic()))));
        } else if (None$.MODULE$.equals(topicsOpt)) {
            set = ((IterableOnceOps)CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)image.topics().topicsByName()).asScala().values().map((Function1 & Serializable)x$3 -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(x$3.mirrorTopic())))).toSet();
        } else {
            throw new MatchError(topicsOpt);
        }
        return ((IterableOnceOps)((IterableOps)set.filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isDefined()))).map((Function1 & Serializable)stateOpt -> {
            MirrorTopic state = (MirrorTopic)stateOpt.get();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)state.topicName()), (Object)ClusterLinkTopicState$.MODULE$.apply(state));
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private Map<String, ClusterLinkTopicState> mirrorTopicStates(Uuid linkId) {
        ImmutableMap mirrorTopics = ((KRaftImageMetadataCache)super.metadataCache()).currentImage().topics().topicsByLinkId(linkId);
        return ((MapOps)CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)mirrorTopics).asScala().filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkMetadataManagerWithKRaftSupport.$anonfun$mirrorTopicStates$6(x$5)))).map((Function1 & Serializable)entry -> {
            ClusterLinkTopicState state = ClusterLinkTopicState$.MODULE$.apply((MirrorTopic)((TopicImage)entry._2()).mirrorTopic().get());
            return new Tuple2((Object)((TopicImage)entry._2()).name(), (Object)state);
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @Override
    public Map<String, ClusterLinkTopicState> mirrorTopicStatesFromMetadataStore(Set<String> topics) {
        return this.mirrorTopicStates((Option<Set<String>>)new Some(topics));
    }

    @Override
    public Map<String, ClusterLinkTopicState> mirrorTopicStatesFromMetadataCache(Uuid linkId) {
        return this.mirrorTopicStates(linkId);
    }

    @Override
    public Map<String, ClusterLinkTopicState> mirrorTopicStatesFromMetadataCache(Set<String> topics) {
        return this.mirrorTopicStates((Option<Set<String>>)new Some(topics));
    }

    @Override
    public Map<String, ClusterLinkTopicState> mirrorTopicStatesFromMetadataCache() {
        return this.mirrorTopicStates((Option<Set<String>>)None$.MODULE$);
    }

    @Override
    public Map<String, ClusterLinkTopicState> mirrorTopicStatesFromControllerContext(Uuid linkId) {
        return this.mirrorTopicStates(linkId);
    }

    @Override
    public Map<String, ClusterLinkTopicState> mirrorTopicStatesFromControllerContext(Set<String> topics) {
        return this.mirrorTopicStates((Option<Set<String>>)new Some(topics));
    }

    @Override
    public Map<String, ClusterLinkTopicState> mirrorTopicStatesFromControllerContext() {
        return this.mirrorTopicStates((Option<Set<String>>)None$.MODULE$);
    }

    @Override
    public Set<String> getAllTopicsInCluster() {
        return CollectionConverters$.MODULE$.SetHasAsScala(((KRaftImageMetadataCache)super.metadataCache()).currentImage().topics().topicsByName().keySet()).asScala().toSet();
    }

    @Override
    public boolean isTopicQueuedUpForDeletion(String topic) {
        return false;
    }

    @Override
    public void ensureClusterLinkExists(Uuid linkId) {
        if (!this.clusterLinkExists(linkId)) {
            throw new ClusterLinkNotFoundException(new StringBuilder(39).append("Cluster link with ID '").append(linkId).append("' does not exist.").toString());
        }
    }

    @Override
    public boolean clusterLinkExists(Uuid linkId) {
        return ((KRaftImageMetadataCache)super.metadataCache()).currentImage().clusterLinks().linksById().containsKey(linkId);
    }

    @Override
    public Option<ClusterLinkData> getClusterLinkData(Uuid linkId) {
        java.util.Map clusterLinks = ((KRaftImageMetadataCache)super.metadataCache()).currentImage().clusterLinks().linksById();
        if (clusterLinks.containsKey(linkId)) {
            ClusterLink clusterLink = (ClusterLink)clusterLinks.get(linkId);
            return new Some((Object)new ClusterLinkData(clusterLink.linkName(), linkId, (Option<String>)new Some((Object)clusterLink.remoteClusterId()), (Option<String>)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(clusterLink.tenantPrefix())), false));
        }
        return None$.MODULE$;
    }

    @Override
    public Option<ClusterLinkData> getClusterLinkData(String linkName) {
        java.util.Map clusterLinks = ((KRaftImageMetadataCache)super.metadataCache()).currentImage().clusterLinks().linksByName();
        if (clusterLinks.containsKey(linkName)) {
            ClusterLink clusterLink = (ClusterLink)clusterLinks.get(linkName);
            return new Some((Object)new ClusterLinkData(clusterLink.linkName(), clusterLink.linkId(), (Option<String>)new Some((Object)clusterLink.remoteClusterId()), (Option<String>)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(clusterLink.tenantPrefix())), false));
        }
        return None$.MODULE$;
    }

    @Override
    public Properties getClusterLinkConfigProps(Uuid linkId) {
        this.ensureClusterLinkExists(linkId);
        return ((KRaftImageMetadataCache)super.metadataCache()).config(new ConfigResource(ConfigResource.Type.CLUSTER_LINK, linkId.toString()));
    }

    @Override
    public Properties getTopicConfig(String topic) {
        return ((KRaftImageMetadataCache)super.metadataCache()).config(new ConfigResource(ConfigResource.Type.TOPIC, topic));
    }

    @Override
    public void alterClusterLinkConfigZNode(Uuid linkId, String linkName, Properties persistentProps, ClusterLinkConfig linkConfig) {
        throw new IllegalStateException("Altering link configs in the ZNode is not supported in KRaft mode.");
    }

    @Override
    public void maybeReencryptClusterLinkConfigs(Function1<Properties, Option<Properties>> configTransformer) {
        scala.collection.mutable.Map clusterLinks = CollectionConverters$.MODULE$.MapHasAsScala(((KRaftImageMetadataCache)super.metadataCache()).currentImage().clusterLinks().linksById()).asScala();
        HashMap alterConfigRequestMap = new HashMap(clusterLinks.size());
        clusterLinks.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                Uuid linkId = (Uuid)x0$1._1();
                ClusterLink clusterLink = (ClusterLink)x0$1._2();
                ConfigResource configResourceLinkId = new ConfigResource(ConfigResource.Type.CLUSTER_LINK, linkId.toString());
                Option newEncodedProps = (Option)configTransformer.apply((Object)((KRaftImageMetadataCache)this.super$metadataCache()).config(configResourceLinkId));
                if (newEncodedProps instanceof Some) {
                    Properties props = (Properties)((Some)newEncodedProps).value();
                    HashSet newConfigs = new HashSet();
                    CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala().foreach((Function1 & Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)newConfigs.add(new AlterConfigOp(new ConfigEntry((String)entry._1(), (String)entry._2()), AlterConfigOp.OpType.SET))));
                    ConfigResource configResourceLinkName = new ConfigResource(ConfigResource.Type.CLUSTER_LINK, clusterLink.linkName());
                    return alterConfigRequestMap.put(configResourceLinkName, newConfigs);
                }
                if (None$.MODULE$.equals(newEncodedProps)) {
                    return BoxedUnit.UNIT;
                }
                throw new MatchError((Object)newEncodedProps);
            }
            throw new MatchError(null);
        });
        if (!alterConfigRequestMap.isEmpty()) {
            if (this.localAdmin() == null) {
                this.localAdmin_$eq((Admin)this.localAdminFactory.apply());
            }
            this.localAdmin().incrementalAlterConfigs(alterConfigRequestMap).all().get();
            return;
        }
    }

    @Override
    public void createClusterLinkZNode(ClusterLinkData clusterLinkData, Properties props) {
        throw new IllegalStateException("Creating a cluster link ZNode is not supported in KRaft mode.");
    }

    @Override
    public void setClusterLinkZNode(ClusterLinkData clusterLinkData) {
        throw new IllegalStateException("Setting a cluster link ZNode is not supported in KRaft mode.");
    }

    @Override
    public void alterMirrorTopicState(String topic, Function1<ClusterLinkTopicState, Option<ClusterLinkTopicState>> stateUpdater, boolean validateOnly, boolean failIfNotMirror, boolean isConvertToPendingMirror, String sourceTopicName, Uuid expectedLocalTopicId) {
        Option currentState = this.mirrorTopicStatesFromMetadataStore((Set<String>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})))).get((Object)topic);
        if (currentState.isEmpty() && failIfNotMirror && !isConvertToPendingMirror) {
            throw new InvalidRequestException(new StringBuilder(28).append("Topic ").append(topic).append(" is not a mirror topic").toString());
        }
        if (currentState.isEmpty() && isConvertToPendingMirror && !validateOnly) {
            ((Option)stateUpdater.apply(null)).filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkMetadataManagerWithKRaftSupport.$anonfun$alterMirrorTopicState$2(x$6))).foreach((Function1 & Serializable)newState -> {
                if (!validateOnly) {
                    try {
                        return this.alterMirrorTopic(topic, (ClusterLinkTopicState)newState, sourceTopicName, expectedLocalTopicId).get();
                    }
                    catch (ExecutionException executionException) {
                        throw executionException.getCause();
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                return BoxedUnit.UNIT;
            });
        }
        currentState.foreach((Function1 & Serializable)state -> {
            this.applyState$1(state, stateUpdater, validateOnly, topic, sourceTopicName, expectedLocalTopicId);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void deleteClusterLinkZNode(Uuid linkId) {
        throw new IllegalStateException("Deleting a cluster link ZNode is not supported in KRaft mode.");
    }

    private KafkaFuture<Void> alterMirrorTopic(String topic, ClusterLinkTopicState mirrorTopicState, String sourceTopicName, Uuid expectedLocalTopicId) {
        AlterMirrorTopicsRequestData.AlterMirrorTopic alterMirrorTopic = new AlterMirrorTopicsRequestData.AlterMirrorTopic().setTopic(topic);
        KafkaFutureImpl result = new KafkaFutureImpl();
        if (mirrorTopicState instanceof ClusterLinkTopicState.Mirror) {
            alterMirrorTopic.setMirrorTopicState(MirrorTopic.State.MIRROR.stateName());
        } else if (mirrorTopicState instanceof ClusterLinkTopicState.PausedMirror) {
            ClusterLinkTopicState.PausedMirror pausedMirror = (ClusterLinkTopicState.PausedMirror)mirrorTopicState;
            alterMirrorTopic.setMirrorTopicState(MirrorTopic.State.PAUSED.stateName()).setLinkLevelPause(pausedMirror.linkLevel()).setTopicLevelPause(pausedMirror.topicLevel()).setMirrorTopicError(pausedMirror.mirrorTopicError().code());
        } else if (mirrorTopicState instanceof ClusterLinkTopicState.FailedMirror) {
            ClusterLinkTopicState.FailedMirror failedMirror = (ClusterLinkTopicState.FailedMirror)mirrorTopicState;
            alterMirrorTopic.setMirrorTopicState(MirrorTopic.State.FAILED.stateName()).setMirrorTopicError(failedMirror.mirrorTopicError().code());
        } else if (mirrorTopicState instanceof ClusterLinkTopicState.PendingStoppedMirror) {
            ClusterLinkTopicState.PendingStoppedMirror pendingStoppedMirror = (ClusterLinkTopicState.PendingStoppedMirror)mirrorTopicState;
            alterMirrorTopic.setMirrorTopicState(MirrorTopic.State.PENDING_STOPPED.stateName()).setPromoted(pendingStoppedMirror.synchronize());
        } else if (mirrorTopicState instanceof ClusterLinkTopicState.StoppedMirror) {
            ClusterLinkTopicState.StoppedMirror stoppedMirror = (ClusterLinkTopicState.StoppedMirror)mirrorTopicState;
            alterMirrorTopic.setMirrorTopicState(MirrorTopic.State.STOPPED.stateName()).setStoppedLogEndOffsets(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)stoppedMirror.logEndOffsets().map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToLong((Object)x$1))).asJava()).setStoppedEpochs(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)stoppedMirror.stoppedEpochs().map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).asJava());
        } else if (mirrorTopicState instanceof ClusterLinkTopicState.PendingMirror) {
            ClusterLinkTopicState.PendingMirror pendingMirror = (ClusterLinkTopicState.PendingMirror)mirrorTopicState;
            alterMirrorTopic.setMirrorTopicState(MirrorTopic.State.PENDING_MIRROR.stateName()).setLinkId(pendingMirror.linkId()).setSourceTopicId(pendingMirror.sourceTopicId()).setSourceTopicName(sourceTopicName).setExpectedLocalTopicId(expectedLocalTopicId).setNextState(pendingMirror.nextState());
        } else if (mirrorTopicState instanceof ClusterLinkTopicState.PendingSynchronizeMirror) {
            ClusterLinkTopicState.PendingSynchronizeMirror pendingSynchronizeMirror = (ClusterLinkTopicState.PendingSynchronizeMirror)mirrorTopicState;
            alterMirrorTopic.setMirrorTopicState(MirrorTopic.State.PENDING_SYNCHRONIZE.stateName()).setNextState(pendingSynchronizeMirror.remoteMirrorNextState().name());
        } else if (mirrorTopicState instanceof ClusterLinkTopicState.PendingRepairMirror) {
            ClusterLinkTopicState.PendingRepairMirror pendingRepairMirror = (ClusterLinkTopicState.PendingRepairMirror)mirrorTopicState;
            alterMirrorTopic.setMirrorTopicState(MirrorTopic.State.PENDING_REPAIR.stateName()).setMirrorTopicError(pendingRepairMirror.mirrorTopicError().code());
        } else {
            if (mirrorTopicState instanceof ClusterLinkTopicState.PendingRestoreMirror ? true : mirrorTopicState instanceof ClusterLinkTopicState.PendingSetupForRestoreMirror) {
                throw new InvalidRequestException(new StringBuilder(41).append("Unsupported operation on topic ").append(topic).append(" in state ").append(mirrorTopicState.state().name()).toString());
            }
            throw new MatchError((Object)mirrorTopicState);
        }
        alterMirrorTopic.setMirrorStartOffsets(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)mirrorTopicState.mirrorStartOffsets().map((Function1 & Serializable)x -> ClusterLinkMetadataManagerWithKRaftSupport.$anonfun$alterMirrorTopic$3(BoxesRunTime.unboxToLong((Object)x)))).asJava());
        this.sendAlterMirrorTopicRequest(alterMirrorTopic, (KafkaFutureImpl<Void>)result);
        return result;
    }

    @Override
    public boolean alterMirrorTopicState$default$4() {
        return true;
    }

    @Override
    public boolean alterMirrorTopicState$default$5() {
        return false;
    }

    @Override
    public String alterMirrorTopicState$default$6() {
        return "";
    }

    @Override
    public Uuid alterMirrorTopicState$default$7() {
        return Uuid.ZERO_UUID;
    }

    private void sendAlterMirrorTopicRequest(AlterMirrorTopicsRequestData.AlterMirrorTopic alterMirrorTopic, KafkaFutureImpl<Void> result) {
        AlterMirrorTopicsRequest.Builder builder = new AlterMirrorTopicsRequest.Builder(alterMirrorTopic, false, this.requestTimeoutMs());
        ClusterLinkControllerRequestCompletionHandler requestHandler = new ClusterLinkControllerRequestCompletionHandler(null, alterMirrorTopic, result){
            private final AlterMirrorTopicsRequestData.AlterMirrorTopic alterMirrorTopic$1;
            private final KafkaFutureImpl result$1;

            public void handleResponse(AbstractResponse response) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(this.msgWithLogIdent("Received response for alterMirrorTopicRequest"));
                }
                ((AlterMirrorTopicsResponse)response).complete(Collections.singletonMap(this.alterMirrorTopic$1.topic(), this.result$1));
            }

            public void onFailure(Throwable ex) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(this.msgWithLogIdent("alterMirrorTopic request failed with exception"), ex);
                }
                this.result$1.completeExceptionally(ex);
            }

            public static final /* synthetic */ String $anonfun$handleResponse$1() {
                return "Received response for alterMirrorTopicRequest";
            }

            public static final /* synthetic */ String $anonfun$onFailure$1() {
                return "alterMirrorTopic request failed with exception";
            }

            public static final /* synthetic */ Throwable $anonfun$onFailure$2(Throwable ex$1) {
                return ex$1;
            }
            {
                this.alterMirrorTopic$1 = alterMirrorTopic$1;
                this.result$1 = result$1;
            }
        };
        super.controllerChannelManager().sendRequest((AbstractRequest.Builder)builder, (ControllerRequestCompletionHandler)requestHandler);
    }

    @Override
    public scala.collection.immutable.Seq<ClusterLinkData> getAllLinksFromMetadata() {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.MapHasAsScala(((KRaftImageMetadataCache)super.metadataCache()).currentImage().clusterLinks().linksById()).asScala().values().map((Function1 & Serializable)clusterLink -> new ClusterLinkData(clusterLink.linkName(), clusterLink.linkId(), (Option<String>)new Some((Object)clusterLink.remoteClusterId()), (Option<String>)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(clusterLink.tenantPrefix())), false))).toSeq();
    }

    @Override
    public boolean isLinkCoordinatorEnabled() {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$mirrorTopicStates$6(Tuple2 x$5) {
        return ((TopicImage)x$5._2()).mirrorTopic().isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$alterMirrorTopicState$2(ClusterLinkTopicState x$6) {
        return x$6 != null;
    }

    private final void applyState$1(ClusterLinkTopicState state, Function1 stateUpdater$1, boolean validateOnly$1, String topic$1, String sourceTopicName$1, Uuid expectedLocalTopicId$1) {
        ((Option)stateUpdater$1.apply((Object)state)).filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkMetadataManagerWithKRaftSupport.$anonfun$alterMirrorTopicState$2(x$6))).foreach((Function1 & Serializable)newState -> {
            if (!validateOnly) {
                try {
                    return this.alterMirrorTopic(topic, (ClusterLinkTopicState)newState, sourceTopicName, expectedLocalTopicId).get();
                }
                catch (ExecutionException executionException) {
                    throw executionException.getCause();
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ Long $anonfun$alterMirrorTopic$3(long x) {
        return BoxesRunTime.boxToLong((long)x);
    }

    public ClusterLinkMetadataManagerWithKRaftSupport(KafkaConfig brokerConfig, ClusterLinkScheduler scheduler, KRaftImageMetadataCache metadataCache, NodeToControllerChannelManager controllerChannelManager, Function0<Admin> localAdminFactory, AuthorizerServerInfo serverInfo) {
        this.localAdminFactory = localAdminFactory;
        super(brokerConfig, scheduler, metadataCache, controllerChannelManager, localAdminFactory, serverInfo);
    }
}

